joo.classLoader.prepare("package net.jangaroo.net",/* {*/

/**
 * A class implementing resolving and relativizing URIs
 * generic URI syntax as specified in <a href="http://www.rfc-editor.org/rfc/rfc3986.txt">RFC 3986</a>.
 *
 */
"public class URIUtils",1,function($$private){var $1=net.jangaroo.net;return[ 

  // regular expression for uris as given in rfc2396:
  "private static const",{ URI_PATTERN/*:RegExp*/ : /^(([^:/?#]+):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/},
  // regular expression groups:               12            3  4            5       6  7        8 9
  "private static const",{ URI_PATTERN_GROUP_SCHEME_PRESENT/*:int*/ : 1},
  "private static const",{ URI_PATTERN_GROUP_SCHEME/*:int*/ : 2},
  "private static const",{ URI_PATTERN_GROUP_AUTHORITY_PRESENT/*:int*/ : 4},
  "private static const",{ URI_PATTERN_GROUP_AUTHORITY/*:int*/ : 4},
  "private static const",{ URI_PATTERN_GROUP_PATH/*:int*/ : 5},
  "private static const",{ URI_PATTERN_GROUP_QUERY/*:int*/ : 7},
  "private static const",{ URI_PATTERN_GROUP_QUERY_PRESENT/*:int*/ : 6},
  "private static const",{ URI_PATTERN_GROUP_FRAGMENT/*:int*/ : 9},
  "private static const",{ URI_PATTERN_GROUP_FRAGMENT_PRESENT/*:int*/ : 8},


  // pure utility class with static functions only
  "function URIUtils",function URIUtils() {
  },

  /**
   * Create an URI from its components
   */
  "public function create",function create(scheme/*:String = null*/, authority/*:String = null*/, path/*:String = ""*/, query/*:String = null*/, fragment/*:String = null*/)/*:URI*/ {switch(arguments.length){case 0:scheme=null;case 1:authority=null;case 2:path="";case 3:query=null;case 4:fragment=null;}
    return new $1.URIImpl(scheme, authority, path, query, fragment);
  },

  /**
   * Parses the string into a {@link URI} instance.
   * @throws URIError if the syntax does not conform to <a href="http://www.rfc-editor.org/rfc/rfc3986.txt">RFC 3986</a>
   */
  "public static function parse",function parse(source/*:String*/)/*:URI*/ {
    if (!source.match($$private.URI_PATTERN)) {
      throw new Error("invalid URI syntax: " + source);
    }
    var match/*:Array*/ = $$private.URI_PATTERN.exec(source);
    return new $1.URIImpl(
            $$private.ifPresentOrNull(match, $$private.URI_PATTERN_GROUP_SCHEME, $$private.URI_PATTERN_GROUP_SCHEME_PRESENT),
            $$private.ifPresentOrNull(match, $$private.URI_PATTERN_GROUP_AUTHORITY, $$private.URI_PATTERN_GROUP_AUTHORITY_PRESENT),
            $$private.ifPresentOrNull(match, $$private.URI_PATTERN_GROUP_PATH, $$private.URI_PATTERN_GROUP_PATH, ""),
            $$private.ifPresentOrNull(match, $$private.URI_PATTERN_GROUP_QUERY, $$private.URI_PATTERN_GROUP_QUERY_PRESENT),
            $$private.ifPresentOrNull(match, $$private.URI_PATTERN_GROUP_FRAGMENT, $$private.URI_PATTERN_GROUP_FRAGMENT_PRESENT));
  },

  "private static function ifPresentOrNull",function ifPresentOrNull(match/*:Array*/, valueGroup/*:int*/, presentGroup/*:int*/, defaultValue/*:String = null*/)/*:String*/ {if(arguments.length<=3)defaultValue=null;/*
    const*/var present/*:String*/ = match[presentGroup];
    return present ? match[valueGroup] : defaultValue;
  },

  /**
   * Relativize a reference uri against a base URI according to RFC 3986.
   * If both scheme and authority are equal, this method always returns a URI with a relative path,
   * even it an absolute path would be shorter.
   *
   * @param base the base URI. Must be an absolute URI.
   * @param reference the URI to relativize. Must be an absolute URI.
   * @return an URI which yields the reference URI when resolved against the given base URI
   * @throws URIError if base or reference is a relative URI
   */
  "public static function relativize",function relativize(base/*:String*/, reference/*:String*/)/*:String*/ {
    return net.jangaroo.net.URIUtils.parse(base).relativize(net.jangaroo.net.URIUtils.parse(reference)).toString();
  },

  /**
   * Resolve a uri against a base URI according to RFC 3986.
   * @param base the base uri
   * @param reference the uri to resolve
   * @return an absolute URI
   * @throws URIError if base is not an absolute URI
   */
  "public static function resolve",function resolve(base/*:String*/, reference/*:String*/)/*:String*/ {
    return net.jangaroo.net.URIUtils.parse(base).resolve(net.jangaroo.net.URIUtils.parse(reference)).toString();
  },

undefined];},["parse","relativize","resolve"],["net.jangaroo.net.URIImpl","Error"], "0.8.0", "0.9.14"
);