package net.jangaroo.net {

/**
 * A class implementing parsing, formatting, resolving and relativizing URIs in
 * generic URI syntax as specified in <a href="http://www.rfc-editor.org/rfc/rfc3986.txt">RFC 3986</a>.
 *
 */
class URIImpl implements net.jangaroo.net.URI {

  // we will transform these into getters with internal slots as soon as Jangaroo supports getter/setter on all target platforms
  public var scheme:String;
  public var authority:String;
  public var path:String;
  public var query:String;
  public var fragment:String;

  public var isRelative:Boolean;
  public var isAbsolute:Boolean;

  /**
   * Construct a new URIImpl instance.
   * None of the parameters may be undefined.
   * Use null to mark 'not defined' in RFC sense.
   * @param path must neither be undefined nor null, but might be the empty string
   */
  public native function URIImpl(scheme:String, authority:String, path:String, query:String, fragment:String);

  /**
   * Return the string representation of this URI
   */
  public native function toString():String;

  /**
   * Relativize a reference uri against this URI according to RFC 3986.
   * If both scheme and authority are equal, this method always returns a URI with a relative path,
   * even it an absolute path would be shorter.
   *
   * @param reference the URI to relativize. Must be an absolute URI.
   * @return an URI which yields the reference URI when resolved against the given base URI
   * @throws Error (todo IllegalArgumentException) if base or reference are relative URIs
   */
  public native function relativize(reference:URI):URI;

  /**
   * Resolve a uri against this as a base URI according to RFC 3986.
   * @requires this.isAbsolute()
   * @param reference     the uri to resolve
   * @return an absolute URI
   */
  public native function resolve(reference:URI):URI;
}
}