/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

abstract class AbstractLinkPackagesMojo
extends AbstractSenchaMojo {
    private static final Object lock = new Object();

    AbstractLinkPackagesMojo() {
    }

    void createSymbolicLinkToPackage(Path packagesPath, String packageName, Path targetPath) throws MojoExecutionException {
        Path link = packagesPath.resolve(packageName);
        if (link.toFile().exists()) {
            return;
        }
        Path target = packagesPath.relativize(targetPath);
        if (target.toString().equals(packageName)) {
            return;
        }
        this.getLog().debug((CharSequence)("Linking " + link + " -> " + target));
        try {
            FileHelper.createSymbolicLink(link, target);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Creating directory link for package " + packageName + " failed.", (Exception)e);
        }
    }

    static Map<Artifact, Path> findReactorProjectPackages(MavenProject project) {
        HashMap<Artifact, Path> reactorProjectPackagePaths = new HashMap<Artifact, Path>();
        HashSet<MavenProject> referencedProjects = new HashSet<MavenProject>();
        AbstractLinkPackagesMojo.collectReferencedProjects(project, referencedProjects);
        for (MavenProject projectInReactor : referencedProjects) {
            String packageType = projectInReactor.getPackaging();
            if (!"swc".equals(packageType) && !"pkg".equals(packageType)) continue;
            String senchaPackageName = SenchaUtils.getSenchaPackageName(projectInReactor);
            reactorProjectPackagePaths.put(projectInReactor.getArtifact(), Paths.get(projectInReactor.getBuild().getDirectory() + "/packages/" + senchaPackageName, new String[0]));
        }
        return reactorProjectPackagePaths;
    }

    private static void collectReferencedProjects(MavenProject project, Set<MavenProject> referencedProjects) {
        if (!referencedProjects.contains(project)) {
            referencedProjects.add(project);
            for (MavenProject referencedProject : project.getProjectReferences().values()) {
                AbstractLinkPackagesMojo.collectReferencedProjects(referencedProject, referencedProjects);
            }
        }
    }

    void createSymbolicLinksForArtifacts(Set<Artifact> artifacts, Path packagesPath, File remotePackagesDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Linking package directories for %d artifacts into package path %s", artifacts.size(), packagesPath));
        Map<Artifact, Path> reactorProjectPackagePaths = AbstractLinkPackagesMojo.findReactorProjectPackages(this.project);
        for (Artifact artifact : artifacts) {
            String senchaPackageName = SenchaUtils.getSenchaPackageName(artifact.getGroupId(), artifact.getArtifactId());
            Path pkgDir = this.getPkgDir(artifact, remotePackagesDir, reactorProjectPackagePaths);
            this.createSymbolicLinkToPackage(packagesPath, senchaPackageName, pkgDir);
        }
    }

    Path getPkgDir(Artifact artifact, File remotePackagesDir, Map<Artifact, Path> reactorProjectPackagePaths) throws MojoExecutionException {
        Path pkgDir = reactorProjectPackagePaths.get(artifact);
        return pkgDir != null ? pkgDir : this.unpackPkg(artifact, remotePackagesDir).toPath();
    }

    File unpackPkg(Artifact artifact, File remotePackagesDir) throws MojoExecutionException {
        File jarFile = artifact.getFile();
        String targetDirName = String.format("%s__%s__%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        File targetDir = new File(remotePackagesDir, targetDirName);
        this.unpackPkg(jarFile.exists() ? jarFile : jarFile, artifact, targetDir);
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPkg(File pkgFile, Artifact artifact, File targetDir) throws MojoExecutionException {
        Object object = lock;
        synchronized (object) {
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            String version = artifact.getVersion();
            File mavenStampFile = this.mavenStampFile(targetDir, groupId, artifactId, version);
            long artifactLastModified = pkgFile.lastModified();
            if (mavenStampFile.exists() && mavenStampFile.lastModified() == artifactLastModified) {
                this.getLog().debug((CharSequence)String.format("Already unpacked %s to %s, skipping", artifact, targetDir.getName()));
                return;
            }
            if (targetDir.exists()) {
                this.getLog().debug((CharSequence)String.format("Cleaning %s", targetDir));
                this.clean(targetDir);
            }
            this.getLog().info((CharSequence)String.format("Extracting %s to %s", artifact, targetDir));
            SenchaUtils.extractPkg(pkgFile, targetDir);
            this.touch(mavenStampFile, artifactLastModified);
        }
    }

    private void clean(File dir) throws MojoExecutionException {
        try {
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to clean directory " + dir.getAbsolutePath(), (Exception)e);
        }
    }

    private void touch(File file, long timestamp) throws MojoExecutionException {
        try {
            FileUtils.touch((File)file);
            if (!file.setLastModified(timestamp)) {
                throw new MojoExecutionException("unable to set last-modified on timestamp file " + file.getPath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to create timestamp file " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private File mavenStampFile(File packageTargetDir, String groupId, String artifactId, String version) {
        String fileName = "." + groupId + '_' + artifactId + '_' + version + "-timestamp";
        return new File(packageTargetDir, fileName);
    }

    Set<Artifact> onlyRequiredSenchaDependencies(Set<Artifact> artifacts, boolean includeTestDependencies) {
        return artifacts.stream().filter(artifact -> !this.isExtFrameworkArtifact((Artifact)artifact) && SenchaUtils.isRequiredSenchaDependency(MavenDependencyHelper.fromArtifact(artifact), includeTestDependencies)).collect(Collectors.toSet());
    }
}

