/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.mvnplugin.AbstractCompilerMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/joo")
    private File generatedTestSourcesDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter(defaultValue="${project.build.directory}/temp/jangaroo-test-output/classes")
    private File tempTestClassesOutputDirectory;
    @Parameter(defaultValue="${maven.test.skip}")
    protected boolean skip;

    @Override
    protected File getApiOutputDirectory() {
        return null;
    }

    @Override
    protected List<File> getCompileSourceRoots() {
        return Arrays.asList(this.testSourceDirectory, this.generatedTestSourcesDirectory);
    }

    @Override
    protected File getOutputDirectory() {
        return this.testOutputDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.testIncludes;
    }

    @Override
    protected Set<String> getExcludes() {
        return this.testExcludes;
    }

    @Override
    protected List<File> getActionScriptCompilePath() {
        List<File> actionScriptCompilePath = this.getMavenPluginHelper().getActionScriptCompilePath(true);
        actionScriptCompilePath.add(0, this.getSourceDirectory());
        actionScriptCompilePath.add(0, this.getGeneratedSourcesDirectory());
        actionScriptCompilePath.add(this.getCatalogOutputDirectory());
        return actionScriptCompilePath;
    }

    @Override
    protected List<File> getActionScriptClassPath() {
        ArrayList<File> classPath = new ArrayList<File>(this.getMavenPluginHelper().getActionScriptClassPath(true));
        classPath.add(0, this.getSourceDirectory());
        classPath.add(0, this.getGeneratedSourcesDirectory());
        classPath.add(this.getCatalogOutputDirectory());
        return classPath;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            super.execute();
        }
    }

    @Override
    protected boolean findUnusedDependencies(int staleMillis) {
        return false;
    }

    @Override
    protected void printDependencyWarnings(JoocConfiguration joocConfiguration, Map<String, Object> dependencyWarnings) {
        if (joocConfiguration.isFindUnusedDependencies() && dependencyWarnings.get("unusedDependencies") instanceof List) {
            this.printUnusedDependencyWarnings(joocConfiguration, (List)dependencyWarnings.get("unusedDependencies"));
        }
        if (dependencyWarnings.get("undeclaredDependencies") instanceof List) {
            this.printUndeclaredDependencyWarnings(joocConfiguration, (List)dependencyWarnings.get("undeclaredDependencies"), "test-");
        }
    }

    @Override
    protected List<String> createUsedUndeclaredDependencyWarning(Artifact dependency) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<dependency>");
        lines.add(String.format("  <groupId>%s</groupId>", dependency.getGroupId()));
        lines.add(String.format("  <artifactId>%s</artifactId>", dependency.getArtifactId()));
        lines.add(String.format("  <version>%s</version>", dependency.getVersion()));
        lines.add("  <type>swc</type>");
        lines.add("  <scope>test</scope>");
        lines.add("</dependency>");
        return lines;
    }
}

