/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.jangaroo.jooc.AbstractCompileLog;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.mvnplugin.AbstractJangarooMojo;
import net.jangaroo.jooc.mvnplugin.SearchAndReplaceConfiguration;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.ConversionUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractCompilerMojo
extends AbstractJangarooMojo {
    private static final String JANGAROO_GROUP_ID = "net.jangaroo";
    private static final String EXML_CONFIG_URI_PREFIX = "exml:";
    private static final String EXML_MAVEN_PLUGIN_ARTIFACT_ID = "exml-maven-plugin";
    protected static final String USED_UNDECLARED_DEPENDENCIES_WARNING = "Used undeclared %sdependencies found:";
    protected static final String UNUSED_DEPENDENCIES_KEY = "unusedDependencies";
    protected static final String UNDECLARED_DEPENDENCIES_KEY = "undeclaredDependencies";
    protected static final String UNUSED_DECLARED_DEPENDENCIES_WARNING = "Unused declared dependencies found:";
    @Parameter(property="maven.compiler.failOnError")
    private boolean failOnError = true;
    @Parameter(property="maven.compiler.failOnDependencyError")
    private boolean failOnDependencyError = true;
    @Parameter(property="enforcer.skip")
    private boolean skipDependencyChecks = false;
    @Parameter(property="maven.compile.ea")
    private boolean enableAssertions;
    @Parameter(property="maven.compiler.allowDuplicateLocalVariables")
    private boolean allowDuplicateLocalVariables;
    @Parameter(property="maven.compiler.publicApiViolations")
    private String publicApiViolations = PublicApiViolationsMode.WARN.toString().toLowerCase();
    @Parameter(property="maven.compiler.excludeClassByDefault")
    private boolean excludeClassByDefault;
    @Parameter(property="maven.compiler.generateSourceMaps")
    private boolean generateSourceMaps;
    @Parameter(property="maven.compiler.verbose")
    private boolean verbose;
    @Parameter(property="lastModGranularityMs")
    private int staleMillis;
    @Parameter(property="maven.compiler.debuglevel")
    private String debuglevel = DebugMode.SOURCE.toString().toLowerCase();
    @Parameter(property="maven.compiler.autoSemicolon")
    private String autoSemicolon = SemicolonInsertionMode.WARN.toString().toLowerCase();
    @Parameter(defaultValue="${project.build.directory}/generated-sources/joo")
    private File generatedSourcesDirectory;
    @Parameter
    private File keepGeneratedActionScriptDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File catalogOutputDirectory;
    @Parameter(property="maven.compiler.migrateToTypeScript")
    private boolean migrateToTypeScript = false;
    @Parameter(property="maven.compiler.typeScriptTargetSourceFormatFeatures")
    private long typeScriptTargetSourceFormatFeatures = 0L;
    @Parameter(property="extNamespace")
    private String extNamespace;
    @Parameter(property="extNamespaceRequired")
    private boolean extNamespaceRequired;
    @Parameter(property="extSassNamespace")
    private String extSassNamespace;
    @Parameter(defaultValue="${project.basedir}/src/main/sencha")
    private File senchaSrcDir;
    @Parameter(property="maven.compiler.useEcmaParameterInitializerSemantics")
    private boolean useEcmaParameterInitializerSemantics = false;
    @Parameter(property="maven.compiler.suppressCommentedActionScriptCode")
    private boolean suppressCommentedActionScriptCode = false;
    @Parameter
    private List<SearchAndReplaceConfiguration> npmPackageNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="maven.compiler.dependencyWarningsOutputFile")
    private String dependencyWarningsOutputFile = "target/dependencyReports/dependencyWarnings.txt";

    protected abstract List<File> getCompileSourceRoots();

    protected abstract File getOutputDirectory();

    protected File getClassesOutputDirectory() {
        return new File(this.getOutputDirectory(), "src");
    }

    private File getLocalizedOutputDirectory() {
        return new File(this.getOutputDirectory(), "locale");
    }

    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    @Nullable
    protected abstract File getApiOutputDirectory();

    public boolean isMigrateToTypeScript() {
        return this.migrateToTypeScript;
    }

    public boolean isSuppressCommentedActionScriptCode() {
        return this.suppressCommentedActionScriptCode;
    }

    protected File getCatalogOutputDirectory() {
        return this.catalogOutputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        final Log log = this.getLog();
        if (this.extNamespace == null) {
            if (this.extNamespaceRequired) {
                throw new MojoExecutionException("Flag 'extNamespaceRequired' was enabled but no 'extNamespace' was provided.");
            }
            this.extNamespace = "";
        }
        if (".".equals(this.extNamespace)) {
            this.extNamespace = "";
        }
        if (".".equals(this.extSassNamespace)) {
            this.extSassNamespace = "";
        }
        if (this.getCompileSourceRoots().isEmpty()) {
            log.info((CharSequence)"No sources to compile");
            return;
        }
        JoocConfiguration configuration = this.createJoocConfiguration(log);
        if (configuration == null) {
            return;
        }
        Jooc jooc = new Jooc(configuration, (CompileLog)new AbstractCompileLog(){

            protected void doLogError(String msg) {
                log.error((CharSequence)msg);
            }

            public void warning(String msg) {
                log.warn((CharSequence)msg);
            }
        });
        int result = this.compile(jooc);
        if (configuration.getDependencyReportOutputFile() == null && !this.failOnDependencyError) {
            log.warn((CharSequence)"No directory for dependency warnings specified, ignoring dependency warnings.");
        } else {
            File dependencyWarningsFile = new File(configuration.getDependencyReportOutputFile());
            if (dependencyWarningsFile.exists()) {
                try {
                    Map dependencyWarnings = (Map)SenchaUtils.getObjectMapper().readValue(FileUtils.readFileToString((File)dependencyWarningsFile), Map.class);
                    this.printDependencyWarnings(configuration, dependencyWarnings);
                    List undeclaredDependencies = (List)dependencyWarnings.get(UNDECLARED_DEPENDENCIES_KEY);
                    if (this.failOnDependencyError && undeclaredDependencies != null && !undeclaredDependencies.isEmpty()) {
                        throw new MojoExecutionException("There were dependency errors detected, compilation failed. Fix the dependency errors or disable fail on dependency errors by setting the \"failOnDependencyError\"-option to \"false\".");
                    }
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)String.format("There was an error while reading file %s", dependencyWarningsFile.getPath()));
                }
                finally {
                    new File(configuration.getDependencyReportOutputFile()).delete();
                }
            }
        }
        if (result != 0 && this.failOnError) {
            log.info((CharSequence)"-------------------------------------------------------------");
            if (result == 1) {
                log.error((CharSequence)"There were compile errors (see log above).");
            } else {
                log.error((CharSequence)("Internal Jangaroo compiler error: " + result + "\nSee log for error details."));
            }
            log.info((CharSequence)"-------------------------------------------------------------");
            throw new MojoFailureException("Compilation failed");
        }
    }

    protected JoocConfiguration createJoocConfiguration(Log log) throws MojoExecutionException, MojoFailureException {
        String configClassPackage;
        JoocConfiguration configuration = new JoocConfiguration();
        configuration.setEnableAssertions(this.enableAssertions);
        configuration.setAllowDuplicateLocalVariables(this.allowDuplicateLocalVariables);
        configuration.setVerbose(this.verbose);
        configuration.setExcludeClassByDefault(this.excludeClassByDefault);
        configuration.setGenerateSourceMaps(this.generateSourceMaps);
        configuration.setKeepGeneratedActionScriptDirectory(this.keepGeneratedActionScriptDirectory);
        configuration.setMigrateToTypeScript(this.migrateToTypeScript);
        configuration.setTypeScriptTargetSourceFormatFeatures(this.typeScriptTargetSourceFormatFeatures);
        configuration.setExtNamespace(this.extNamespace);
        configuration.setExtSassNamespace(this.extSassNamespace != null ? this.extSassNamespace : this.extNamespace);
        configuration.setUseEcmaParameterInitializerSemantics(this.useEcmaParameterInitializerSemantics);
        configuration.setSuppressCommentedActionScriptCode(this.suppressCommentedActionScriptCode);
        configuration.setNpmPackageName(ConversionUtils.getNpmPackageName(this.getProject().getGroupId(), this.getProject().getArtifactId(), ConversionUtils.getSearchAndReplace(this.npmPackageNameReplacers)));
        if (StringUtils.isNotEmpty((String)this.debuglevel)) {
            try {
                configuration.setDebugMode(DebugMode.valueOf((String)this.debuglevel.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified debug level: '" + this.debuglevel + "' is unsupported. Legal values are 'none', 'lines', and 'source'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.autoSemicolon)) {
            try {
                configuration.setSemicolonInsertionMode(SemicolonInsertionMode.valueOf((String)this.autoSemicolon.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified semicolon insertion mode: '" + this.autoSemicolon + "' is unsupported. Legal values are 'error', 'warn', and 'quirks'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.publicApiViolations)) {
            try {
                configuration.setPublicApiViolationsMode(PublicApiViolationsMode.valueOf((String)this.publicApiViolations.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified public API violations mode: '" + this.publicApiViolations + "' is unsupported. Legal values are 'error', 'warn', and 'allow'.");
            }
        }
        HashSet<File> sources = new HashSet<File>();
        log.debug((CharSequence)"starting source inclusion scanner");
        sources.addAll(this.computeStaleSources(this.staleMillis));
        HashMap<String, File> sassSourcePathByType = new HashMap<String, File>();
        HashMap<String, File> sassOutputDirectoryByType = new HashMap<String, File>();
        HashMap<String, List<File>> sassSourceFilesByType = new HashMap<String, List<File>>();
        for (String sassType : Lists.newArrayList((Object[])new String[]{"var", "src"})) {
            File sassSourceFolder = this.senchaSrcDir.toPath().resolve("sass").resolve(sassType).toFile();
            sassSourcePathByType.put(sassType, sassSourceFolder);
            sassSourceFilesByType.put(sassType, AbstractCompilerMojo.listFilesRecursive(sassSourceFolder));
            sassOutputDirectoryByType.put(sassType, this.getOutputDirectory().toPath().resolve("sass").resolve(sassType).toFile());
        }
        if (sources.isEmpty() && sassSourceFilesByType.values().stream().mapToInt(List::size).sum() == 0) {
            log.info((CharSequence)"Nothing to compile - all classes are up to date");
            return null;
        }
        configuration.setSourceFiles(new ArrayList(sources));
        try {
            configuration.setSourcePath(this.getCompileSourceRoots());
        }
        catch (IOException e) {
            throw new MojoFailureException("could not canonicalize source paths: " + this.getCompileSourceRoots(), (Throwable)e);
        }
        configuration.setClassPath(this.getActionScriptClassPath());
        if (!this.skipDependencyChecks) {
            configuration.setCompilePath(this.getActionScriptCompilePath());
        }
        configuration.setOutputDirectory(this.getClassesOutputDirectory());
        configuration.setLocalizedOutputDirectory(this.getLocalizedOutputDirectory());
        configuration.setApiOutputDirectory(this.getApiOutputDirectory());
        configuration.setFindUnusedDependencies(this.findUnusedDependencies(this.staleMillis));
        configuration.setDependencyReportOutputFile(this.dependencyWarningsOutputFile);
        configuration.setSassSourceFilesByType(sassSourceFilesByType);
        try {
            configuration.setSassSourcePathByType(sassSourcePathByType);
        }
        catch (IOException e) {
            throw new MojoFailureException("could not canonicalize sass source paths: " + sassSourcePathByType, (Throwable)e);
        }
        try {
            configuration.setSassOutputDirectoryByType(sassOutputDirectoryByType);
        }
        catch (IOException e) {
            throw new MojoFailureException("could not canonicalize sass output directories: " + sassOutputDirectoryByType, (Throwable)e);
        }
        ArrayList<NamespaceConfiguration> allNamespaces = new ArrayList<NamespaceConfiguration>();
        if (this.getNamespaces() != null) {
            allNamespaces.addAll(Arrays.asList(this.getNamespaces()));
        }
        if ((configClassPackage = this.findConfigClassPackageInExmlPluginConfiguration()) != null) {
            String namespace = EXML_CONFIG_URI_PREFIX + configClassPackage;
            this.getLog().info((CharSequence)String.format("Adding namespace %s derived from %s configuration.", namespace, EXML_MAVEN_PLUGIN_ARTIFACT_ID));
            allNamespaces.add(new NamespaceConfiguration(namespace, null));
        }
        configuration.setNamespaces(allNamespaces);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Source path: " + configuration.getSourcePath().toString().replace(',', '\n')));
            log.debug((CharSequence)("Class path: " + configuration.getClassPath().toString().replace(',', '\n')));
            log.debug((CharSequence)("Output directory: " + configuration.getOutputDirectory()));
            if (configuration.getApiOutputDirectory() != null) {
                log.debug((CharSequence)("API output directory: " + configuration.getApiOutputDirectory()));
            }
        }
        return configuration;
    }

    protected boolean findUnusedDependencies(int staleMillis) {
        return staleMillis < 0 || !this.getClassesOutputDirectory().exists();
    }

    private String findConfigClassPackageInExmlPluginConfiguration() {
        Xpp3Dom configClassPackageElement;
        Object exmlPluginConfiguration;
        Plugin plugin;
        String configClassPackage = null;
        List plugins = this.getProject().getBuildPlugins();
        Iterator iterator = plugins.iterator();
        while (!(!iterator.hasNext() || JANGAROO_GROUP_ID.equals((plugin = (Plugin)iterator.next()).getGroupId()) && EXML_MAVEN_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId()) && (exmlPluginConfiguration = plugin.getConfiguration()) instanceof Xpp3Dom && (configClassPackageElement = ((Xpp3Dom)exmlPluginConfiguration).getChild("configClassPackage")) != null && (configClassPackage = configClassPackageElement.getValue()) != null && !(configClassPackage = configClassPackage.trim()).isEmpty())) {
        }
        return configClassPackage;
    }

    protected abstract List<File> getActionScriptCompilePath();

    protected abstract List<File> getActionScriptClassPath();

    protected abstract void printDependencyWarnings(JoocConfiguration var1, Map<String, Object> var2);

    protected void printUnusedDependencyWarnings(JoocConfiguration joocConfiguration, List<String> unusedDependencies) {
        if (joocConfiguration.isFindUnusedDependencies() && !unusedDependencies.isEmpty()) {
            this.getLog().warn((CharSequence)UNUSED_DECLARED_DEPENDENCIES_WARNING);
            for (String unusedDeclaredDependency : unusedDependencies) {
                this.resolveDependency(unusedDeclaredDependency).ifPresent(dependency -> this.getLog().warn((CharSequence)("    " + this.formatDependency((Artifact)dependency))));
            }
        }
    }

    private String formatDependency(Artifact dependency) {
        return String.format("%s:%s:%s:%s:%s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getVersion(), dependency.getScope());
    }

    protected void printUndeclaredDependencyWarnings(JoocConfiguration joocConfiguration, List<String> undeclaredDependencies, String dependencyNamePrefix) {
        if (!undeclaredDependencies.isEmpty()) {
            this.getLog().error((CharSequence)String.format(USED_UNDECLARED_DEPENDENCIES_WARNING, dependencyNamePrefix));
            undeclaredDependencies.forEach(dependency -> {
                Optional<Artifact> resolvedDependency = this.resolveDependency((String)dependency);
                if (resolvedDependency.isPresent()) {
                    this.getLog().error((CharSequence)this.formatDependency(resolvedDependency.get()));
                    ArrayList<String> lines = new ArrayList<String>(this.createUsedUndeclaredDependencyWarning(resolvedDependency.get()));
                    this.getLog().error((CharSequence)("Add the following to your pom:\n" + String.join((CharSequence)"\n", lines)));
                }
            });
        }
    }

    protected Optional<Artifact> resolveDependency(String combinedDependencyName) {
        return this.getProject().getArtifacts().stream().filter(artifact -> artifact.getFile().getPath().equals(combinedDependencyName)).distinct().findFirst();
    }

    protected abstract List<String> createUsedUndeclaredDependencyWarning(Artifact var1);

    private int compile(Jooc jooc) throws MojoExecutionException {
        File outputDirectory = jooc.getConfig().getOutputDirectory();
        FileHelper.ensureDirectory(outputDirectory);
        File apiOutputDirectory = this.getApiOutputDirectory();
        if (apiOutputDirectory != null) {
            FileHelper.ensureDirectory(apiOutputDirectory);
        }
        List sources = jooc.getConfig().getSourceFiles();
        Log log = this.getLog();
        log.info((CharSequence)("Compiling " + sources.size() + " joo source file" + (sources.size() == 1 ? "" : "s") + " to " + outputDirectory));
        return jooc.run().getResultCode();
    }

    private List<File> computeStaleSources(int staleMillis) throws MojoExecutionException {
        File outputDirectory = this.getApiOutputDirectory();
        String outputFileSuffix = ".as";
        if (outputDirectory == null) {
            outputDirectory = this.getClassesOutputDirectory();
            outputFileSuffix = Jooc.getOutputSuffix((boolean)this.isMigrateToTypeScript());
        }
        List<File> compileSourceRoots = this.getCompileSourceRoots();
        ArrayList<File> staleFiles = new ArrayList<File>();
        staleFiles.addAll(this.getMavenPluginHelper().computeStaleSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), outputDirectory, ".as", outputFileSuffix, staleMillis));
        staleFiles.addAll(this.getMavenPluginHelper().computeStaleSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), outputDirectory, ".mxml", outputFileSuffix, staleMillis));
        staleFiles.addAll(this.getMavenPluginHelper().computeStalePropertiesSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), this.getLocalizedOutputDirectory(), staleMillis));
        return staleFiles;
    }

    private static List<File> listFilesRecursive(File folder) throws MojoExecutionException {
        ArrayList<File> recursiveFolderContents = new ArrayList<File>();
        if (!folder.exists()) {
            return recursiveFolderContents;
        }
        if (!folder.isDirectory()) {
            throw new MojoExecutionException("Not a directory: " + folder);
        }
        File[] folderContents = folder.listFiles();
        if (folderContents == null) {
            throw new MojoExecutionException("Could not read directory: " + folder);
        }
        for (File file : folderContents) {
            if (file.isDirectory()) {
                recursiveFolderContents.addAll(AbstractCompilerMojo.listFilesRecursive(file));
                continue;
            }
            recursiveFolderContents.add(file);
        }
        return recursiveFolderContents;
    }

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();
}

