/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MergeHelper {
    @SafeVarargs
    private static <S, T> Map<S, T> mergeMaps(MergeOptions mergeOptions, Map<S, T> ... maps) {
        HashMap result = new HashMap();
        for (Map<S, T> map : maps) {
            MergeHelper.mergeMapIntoBaseMap(result, map, mergeOptions);
        }
        return result;
    }

    public static <S, T> void mergeMapIntoBaseMap(Map<S, T> baseMap, Map<S, T> mapToMerge, MergeOptions mergeOptions) {
        for (S key : mapToMerge.keySet()) {
            baseMap.put(key, MergeHelper.mergeValues(baseMap.get(key), mapToMerge.get(key), mergeOptions));
        }
    }

    @SafeVarargs
    private static <S> List<S> mergeLists(MergeOptions mergeOptions, List<S> ... lists) {
        ArrayList result = new ArrayList();
        for (List<S> list : lists) {
            MergeHelper.mergeListIntoBaseList(result, list, mergeOptions);
        }
        return result;
    }

    private static <S> void mergeListIntoBaseList(List<S> baseList, List<S> listToMerge, MergeOptions mergeOptions) {
        for (int i = 0; i < listToMerge.size(); ++i) {
            while (i >= baseList.size()) {
                baseList.add(null);
            }
            baseList.set(i, MergeHelper.mergeValues(baseList.get(i), listToMerge.get(i), mergeOptions));
        }
    }

    private static <S, T, U, V> T mergeValues(S value1, T value2, MergeOptions mergeOptions) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Map) {
            if (mergeOptions.mapStrategy == MapStrategy.MERGE && value1 instanceof Map) {
                return (T)MergeHelper.mergeMaps(mergeOptions, (Map)value1, (Map)value2);
            }
            return (T)MergeHelper.mergeMaps(mergeOptions, (Map)value2);
        }
        if (value2 instanceof List) {
            if (!(value1 instanceof List)) {
                return (T)MergeHelper.mergeLists(mergeOptions, (List)value2);
            }
            if (mergeOptions.listStrategy == ListStrategy.MERGE) {
                return (T)MergeHelper.mergeLists(mergeOptions, (List)value1, (List)value2);
            }
            ArrayList list = new ArrayList();
            if (mergeOptions.listStrategy == ListStrategy.APPEND) {
                list.addAll((List)value1);
            }
            list.addAll((List)value2);
            return (T)MergeHelper.mergeLists(mergeOptions, list);
        }
        return value2;
    }

    public static class MergeOptions {
        public final ListStrategy listStrategy;
        public final MapStrategy mapStrategy;

        public MergeOptions() {
            this.listStrategy = ListStrategy.REPLACE;
            this.mapStrategy = MapStrategy.REPLACE;
        }

        public MergeOptions(ListStrategy listStrategy, MapStrategy mapStrategy) {
            this.listStrategy = listStrategy;
            this.mapStrategy = mapStrategy;
        }
    }

    public static enum MapStrategy {
        REPLACE,
        MERGE;

    }

    public static enum ListStrategy {
        REPLACE,
        MERGE,
        APPEND;

    }
}

