/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.jangaroo.jooc.CompressorImpl;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-ext", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class PackageExtMojo
extends AbstractSenchaMojo {
    private static final String FILE_LIST_FILE_NAME = "filenames.txt";
    @Parameter(defaultValue="${project.build.directory}/unzip", readonly=true)
    private File extFrameworkDir;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Execute sencha package Ext mojo");
        this.packageExtAll();
        this.packagePackage("charts");
        this.packageTheme("theme-neptune");
        this.packageTheme("theme-triton");
    }

    private void packageExtAll() throws MojoExecutionException {
        File classicPackageDir = new File(this.extFrameworkDir, "classic/classic");
        File fileList = new File(classicPackageDir, FILE_LIST_FILE_NAME);
        File extBuildDirectory = new File(this.extFrameworkDir, "build");
        File extPackageFile = new File(extBuildDirectory, "ext-all-rtl-debug-sourcemap.js");
        String arguments = "compile meta -filenames -tpl \"{0}\"  -out filenames.txt";
        this.getLog().info((CharSequence)"Generating Ext classic file list");
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(classicPackageDir, arguments, this.getSenchaJvmArgs(), this.getLog(), null);
        senchaCmdExecutor.execute();
        this.getLog().info((CharSequence)String.format("Compressing Ext to %s", extPackageFile.getPath()));
        this.compressJsFiles(fileList, extPackageFile);
    }

    private void packagePackage(String pkg) throws MojoExecutionException {
        File packageDir = new File(this.extFrameworkDir, "packages/" + pkg);
        File classicDir = new File(packageDir, "classic");
        File packageFile = new File(classicDir, "src/ext-" + pkg + "-sourcemap.js");
        File sourceMapDir = new File(packageDir, "sourcemap");
        try {
            this.moveToSourceMapDir(packageDir, sourceMapDir);
            this.moveToSourceMapDir(classicDir, new File(sourceMapDir, "classic"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot move Ext source files to " + sourceMapDir, (Exception)e);
        }
        List<File> sources = this.findAndCompressSources(sourceMapDir, packageFile);
        this.addDefines(packageFile.toPath(), sources);
    }

    private List<File> findAndCompressSources(File sourceMapDir, File packageFile) throws MojoExecutionException {
        ArrayList<File> sources = new ArrayList<File>();
        this.scanSources(sourceMapDir, sources);
        packageFile.getParentFile().mkdirs();
        this.getLog().info((CharSequence)String.format("Compressing %s to %s", sourceMapDir.getPath(), packageFile.getPath()));
        try {
            new CompressorImpl().compress(sources, packageFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while packaging JavaScript sources.", (Exception)e);
        }
        return sources;
    }

    private void moveToSourceMapDir(File srcRootDir, File sourceMapDir) throws IOException {
        sourceMapDir.mkdirs();
        this.moveSubDir(srcRootDir, sourceMapDir, "src");
        this.moveSubDir(srcRootDir, sourceMapDir, "overrides");
    }

    private void moveSubDir(File srcRootDir, File sourceMapDir, String src) throws IOException {
        File srcDir = new File(srcRootDir, src);
        if (srcDir.exists()) {
            Files.move(srcDir.toPath(), new File(sourceMapDir, src).toPath(), new CopyOption[0]);
        }
    }

    private void addDefines(Path packageFilePath, List<File> sources) throws MojoExecutionException {
        ArrayList defines = new ArrayList();
        for (File srcFile : sources) {
            try (BufferedReader reader = new BufferedReader(new FileReader(srcFile));){
                List fileDefines = reader.lines().filter(line -> line.startsWith("// @define")).collect(Collectors.toList());
                defines.addAll(fileDefines);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception while scanning source file " + srcFile.getPath() + " for @define.", (Exception)e);
            }
        }
        if (!defines.isEmpty()) {
            try {
                List lines = Files.lines(packageFilePath).collect(Collectors.toCollection(ArrayList::new));
                lines.addAll(lines.size() - 1, defines);
                Files.write(packageFilePath, (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception while adding @defines to minified package file.", (Exception)e);
            }
        }
    }

    private void packageTheme(String theme) throws MojoExecutionException {
        File themeDir = new File(this.extFrameworkDir, "classic/" + theme);
        File overridesDir = new File(themeDir, "overrides");
        File packageFile = new File(overridesDir, theme + "-overrides.js");
        File sourceMapDir = new File(themeDir, "sourcemap");
        try {
            this.moveToSourceMapDir(themeDir, sourceMapDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot move Ext theme sources " + themeDir + " to " + sourceMapDir, (Exception)e);
        }
        this.findAndCompressSources(sourceMapDir, packageFile);
    }

    private void compressJsFiles(File fileList, File packageFile) throws MojoExecutionException {
        try {
            new CompressorImpl().compressFileList(fileList, packageFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while packaging JavaScript sources", (Exception)e);
        }
    }

    private void scanSources(File dir, List<File> sources) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.scanSources(child, sources);
                    continue;
                }
                if (!child.getName().endsWith(".js")) continue;
                sources.add(child);
            }
        }
    }
}

