/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.jangaroo.jooc.config.SearchAndReplace;
import net.jangaroo.jooc.mvnplugin.SearchAndReplaceConfiguration;
import net.jangaroo.jooc.mvnplugin.Type;
import net.jangaroo.jooc.mvnplugin.converter.AdditionalPackageJsonEntries;
import net.jangaroo.jooc.mvnplugin.converter.JangarooConfig;
import net.jangaroo.jooc.mvnplugin.converter.MavenModule;
import net.jangaroo.jooc.mvnplugin.converter.ModuleType;
import net.jangaroo.jooc.mvnplugin.converter.Package;
import net.jangaroo.jooc.mvnplugin.converter.PackageJson;
import net.jangaroo.jooc.mvnplugin.converter.PackageJsonPrettyPrinter;
import net.jangaroo.jooc.mvnplugin.converter.WorkspaceRoot;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.ConversionUtils;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="convert-workspace", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class WorkspaceConverterMojo
extends AbstractMojo {
    private static final Pattern EXTENSION_POINT_PATTERN = Pattern.compile("^(.+)-extension-dependencies$");
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceConverterMojo.class);
    @Parameter(property="convertedWorkspaceTarget", required=true)
    private String convertedWorkspaceTarget;
    @Parameter(property="npmPackageNameReplacers")
    private List<SearchAndReplaceConfiguration> npmPackageNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="npmPackageFolderNameReplacers")
    private List<SearchAndReplaceConfiguration> npmPackageFolderNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="npmPackageVersionReplacers")
    private List<SearchAndReplaceConfiguration> npmPackageVersionReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="npmDependencyVersionOverride")
    private List<SearchAndReplaceConfiguration> npmDependencyOverrides = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="projectExtensionWorkspacePath")
    private File projectExtensionWorkspacePath;
    @Parameter(property="relativeProjectExtensionsPath", defaultValue="modules/extensions")
    private String relativeProjectExtensionsPath;
    @Parameter(property="relativeProjectExtensionPointsPath", defaultValue="modules/extension-config")
    private String relativeProjectExtensionPointsPath;
    @Parameter(property="relativeNpmProjectExtensionWorkspacePath", defaultValue="")
    private String relativeNpmProjectExtensionWorkspacePath;
    @Parameter(property="jangarooNpmVersion", defaultValue="1.0.0")
    private String jangarooNpmVersion;
    @Parameter(property="extJsVersion", defaultValue="1.0.0")
    private String extJsVersion;
    @Parameter
    private String packageType = "code";
    @Parameter
    private String theme;
    @Parameter
    private String applicationClass;
    @Parameter
    private String rootApp;
    @Parameter
    private String testSuite;
    @Parameter
    private Integer jooUnitTestExecutionTimeout;
    @Parameter
    private String extNamespace;
    @Parameter(property="extNamespaceRequired")
    private boolean extNamespaceRequired;
    @Parameter
    private String extSassNamespace;
    @Parameter
    private List<String> additionalLocales;
    @Parameter
    private List<String> additionalCssNonBundle;
    @Parameter
    private List<String> additionalJsNonBundle;
    @Parameter
    private List<String> additionalCssIncludeInBundle;
    @Parameter
    private List<String> additionalJsIncludeInBundle;
    @Parameter
    private Map<String, String> globalResourcesMap;
    private List<SearchAndReplace> resolvedNpmPackageNameReplacers;
    private List<SearchAndReplace> resolvedNpmPackageFolderNameReplacers;
    private List<SearchAndReplace> resolvedNpmPackageVersionReplacers;
    private List<SearchAndReplace> resolvedNpmDependencyOverrides;
    private ObjectMapper jsonObjectMapper;
    private ObjectMapper yamlObjectMapper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    private Map<String, Package> packagesByOriginalName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        Object scripts;
        TreeMap<String, String> devDependencies;
        CopyFromMavenResult copyFromMavenResult;
        ArrayList<String> ignoreFromSencha;
        HashMap<String, ImmutableMap> publishConfigExports;
        TreeMap<String, Object> exports;
        LinkedHashMap<String, String> scripts2;
        TreeMap<String, String> devDependencies2;
        TreeMap<String, String> dependencies;
        Package dependencyPackage;
        MavenModule mavenModule = new MavenModule(this.project.getFile().getPath().replace("pom.xml", ""), this.project.getModel(), this.project.getArtifact());
        ModuleType moduleType = MavenModule.calculateModuleType(this.project.getPackaging());
        if (ModuleType.IGNORE.equals((Object)moduleType)) {
            logger.info("Skipping conversion of current Maven project as packaging cannot be handled.");
            return;
        }
        if (ModuleType.AGGREGATOR.equals((Object)moduleType) && this.getProjectExtensionPoint(mavenModule) == null) {
            logger.info("Skipping conversion of current Maven project as it is an aggregator. Dependencies of aggregators are moved to every package depending on the former aggregator as long as they are not marked as extension points.");
            return;
        }
        if (this.extNamespace == null) {
            if (this.extNamespaceRequired && Arrays.asList("pkg", "swc", "jangaroo-app").contains(this.project.getPackaging())) {
                throw new MojoExecutionException("Flag 'extNamespaceRequired' was enabled but no 'extNamespace' was provided.");
            }
            this.extNamespace = "";
        }
        if (".".equals(this.extNamespace)) {
            this.extNamespace = "";
        }
        if (".".equals(this.extSassNamespace)) {
            this.extSassNamespace = "";
        }
        if (this.relativeNpmProjectExtensionWorkspacePath == null || ".".equals(this.relativeNpmProjectExtensionWorkspacePath)) {
            this.relativeNpmProjectExtensionWorkspacePath = "";
        }
        PackageJsonPrettyPrinter prettyPrinter = new PackageJsonPrettyPrinter();
        this.jsonObjectMapper = new ObjectMapper().setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR));
        this.resolvedNpmPackageNameReplacers = ConversionUtils.getSearchAndReplace(this.npmPackageNameReplacers);
        this.resolvedNpmPackageFolderNameReplacers = ConversionUtils.getSearchAndReplace(this.npmPackageFolderNameReplacers);
        this.resolvedNpmPackageVersionReplacers = ConversionUtils.getSearchAndReplace(this.npmPackageVersionReplacers);
        this.resolvedNpmDependencyOverrides = ConversionUtils.getSearchAndReplace(this.npmDependencyOverrides);
        this.packagesByOriginalName = Stream.of(new AbstractMap.SimpleEntry<String, String>("@coremedia/sencha-ext-charts", this.extJsVersion), new AbstractMap.SimpleEntry<String, String>("@coremedia/sencha-ext", this.extJsVersion), new AbstractMap.SimpleEntry<String, String>("@coremedia/sencha-ext-classic", this.extJsVersion), new AbstractMap.SimpleEntry<String, String>("@coremedia/sencha-ext-classic-locale", this.extJsVersion), new AbstractMap.SimpleEntry<String, String>("@coremedia/sencha-ext-classic-theme-triton", this.extJsVersion), new AbstractMap.SimpleEntry<String, String>("@jangaroo/core", this.jangarooNpmVersion), new AbstractMap.SimpleEntry<String, String>("@jangaroo/build", this.jangarooNpmVersion), new AbstractMap.SimpleEntry<String, String>("@jangaroo/joounit", this.jangarooNpmVersion), new AbstractMap.SimpleEntry<String, String>("@jangaroo/run", this.jangarooNpmVersion), new AbstractMap.SimpleEntry<String, String>("@jangaroo/publish", this.jangarooNpmVersion), new AbstractMap.SimpleEntry<String, String>("@jangaroo/runtime", this.jangarooNpmVersion), new AbstractMap.SimpleEntry<String, String>("rimraf", "^3.0.2"), new AbstractMap.SimpleEntry<String, String>("eslint", "7.27.0")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, item -> {
            Map.Entry<String, String> overriddenPackageNameAndDependencyVersion = this.getOverriddenPackageNameAndDependencyVersion((Map.Entry<String, String>)item);
            return new Package(overriddenPackageNameAndDependencyVersion.getKey(), (String)item.getValue(), overriddenPackageNameAndDependencyVersion.getValue());
        }));
        Package aPackage = this.readPackageFromMavenModule(mavenModule);
        if (!new File(this.convertedWorkspaceTarget).exists()) {
            new File(this.convertedWorkspaceTarget).mkdirs();
        }
        String projectExtensionFor = this.getProjectExtensionFor(mavenModule);
        String projectExtensionPoint = this.getProjectExtensionPoint(mavenModule);
        String relativePackageFolderName = this.getPackageFolderName(aPackage.getName(), mavenModule);
        JangarooConfig jangarooConfig = new JangarooConfig();
        AdditionalPackageJsonEntries additionalJsonEntries = new AdditionalPackageJsonEntries();
        String targetPackageDir = this.convertedWorkspaceTarget + "/" + relativePackageFolderName;
        logger.info(String.format("Generating npm workspace for module %s to directory %s", mavenModule.getData().getArtifactId(), new File(targetPackageDir).getPath()));
        String targetPackageJson = targetPackageDir + "/package.json";
        if (moduleType == ModuleType.SWC) {
            jangarooConfig.setType(this.packageType);
            jangarooConfig.setExtName(String.format("%s__%s", mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId()));
            jangarooConfig.setExtNamespace(this.extNamespace);
            jangarooConfig.setExtSassNamespace(this.extSassNamespace);
            if (this.theme != null) {
                dependencyPackage = this.getDependencyPackageByRef(this.theme);
                if (dependencyPackage == null) {
                    this.getLog().warn((CharSequence)String.format("Could not find theme dependency for %s which is configured in the jangaroo-maven-plugin configuration.", this.theme));
                } else {
                    jangarooConfig.setTheme(dependencyPackage.getName());
                }
            }
            jangarooConfig.setAdditionalCssIncludeInBundle(this.additionalCssIncludeInBundle);
            jangarooConfig.setAdditionalCssNonBundle(this.additionalCssNonBundle);
            jangarooConfig.setAdditionalJsIncludeInBundle(this.additionalJsIncludeInBundle);
            jangarooConfig.setAdditionalJsNonBundle(this.additionalJsNonBundle);
            if (aPackage.getClassMapping().containsKey((!this.extNamespace.equals("") ? this.extNamespace + "." : "") + "init")) {
                WorkspaceConverterMojo.addAutoLoadEntry(jangarooConfig, "./src/init");
            }
            if (this.globalResourcesMap != null && this.globalResourcesMap.size() > 0) {
                WorkspaceConverterMojo.addAutoLoadEntry(jangarooConfig, "./src/packageConfig");
            }
            if (this.testSuite != null) {
                File testSourceDir = Paths.get(this.project.getBasedir().getPath(), "target", "test-classes", "src").toFile();
                Map<String, String> testClassMapping = SenchaUtils.getClassMapping(testSourceDir, this.extNamespace, testSourceDir);
                String testSuiteImport = testClassMapping.containsKey(this.testSuite) ? "./joounit/" + testClassMapping.get(this.testSuite) : (aPackage.getClassMapping().containsKey(this.testSuite) ? "./src/" + aPackage.getClassMapping().get(this.testSuite) : this.findClassImportInDependencies(aPackage, this.testSuite, true));
                if (testSuiteImport != null) {
                    WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "joounit", "testSuite", testSuiteImport.replaceFirst("[.]ts$", ""));
                }
                if (this.jooUnitTestExecutionTimeout != null && this.jooUnitTestExecutionTimeout != 30000) {
                    WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "joounit", "testExecutionTimeout", this.jooUnitTestExecutionTimeout);
                }
            }
            if (new File(mavenModule.getDirectory().getPath() + "/package.json").exists()) {
                try {
                    jangarooConfig.setSencha(this.jsonObjectMapper.readValue(FileUtils.readFileToString((File)new File(mavenModule.getDirectory().getPath() + "/package.json")), Map.class));
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), e.getCause());
                }
            }
            dependencies = new TreeMap();
            this.addManagedDependency(dependencies, "@jangaroo/runtime");
            if (jangarooConfig.getTheme() != null && !jangarooConfig.getTheme().isEmpty()) {
                this.addManagedDependency(dependencies, jangarooConfig.getTheme());
            }
            additionalJsonEntries.setDependencies(dependencies);
            devDependencies2 = new TreeMap();
            this.addManagedDependency(devDependencies2, "@jangaroo/core");
            this.addManagedDependency(devDependencies2, "@jangaroo/build");
            this.addManagedDependency(devDependencies2, "@jangaroo/publish");
            this.addManagedDependency(devDependencies2, "rimraf");
            if (WorkspaceConverterMojo.getCommandMapEntry(jangarooConfig, "joounit", "testSuite") != null) {
                this.addManagedDependency(devDependencies2, "@jangaroo/joounit");
                this.addManagedDependency(devDependencies2, "@coremedia/sencha-ext");
                this.addManagedDependency(devDependencies2, "@coremedia/sencha-ext-classic");
                this.addManagedDependency(devDependencies2, "@coremedia/sencha-ext-classic-locale");
            }
            additionalJsonEntries.setDevDependencies(devDependencies2);
            scripts2 = new LinkedHashMap();
            scripts2.put("clean", "rimraf ./dist && rimraf ./build");
            scripts2.put("build", "jangaroo build");
            scripts2.put("watch", "jangaroo watch");
            scripts2.put("publish", "jangaroo publish");
            if (WorkspaceConverterMojo.getCommandMapEntry(jangarooConfig, "joounit", "testSuite") != null) {
                scripts2.put("test", "jangaroo joounit");
            }
            additionalJsonEntries.setScripts(scripts2);
            additionalJsonEntries.addPublishConfig("directory", "dist");
            exports = new TreeMap();
            exports.put("./*", ImmutableMap.of((Object)"types", (Object)"./src/*.ts", (Object)"default", (Object)"./dist/src/*.js"));
            additionalJsonEntries.setExports(exports);
            publishConfigExports = new HashMap();
            publishConfigExports.put("./*", ImmutableMap.of((Object)"types", (Object)"./src/*.d.ts", (Object)"default", (Object)"./src/*.js"));
            additionalJsonEntries.addPublishConfig("exports", publishConfigExports);
            ignoreFromSencha = new ArrayList();
            ignoreFromSencha.add("package.json");
            copyFromMavenResult = null;
            try {
                copyFromMavenResult = this.copyCodeFromMaven(mavenModule.getDirectory().getPath(), Paths.get("target", "packages", String.format("%s__%s", mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId())).toString(), ignoreFromSencha, targetPackageDir);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
            if (copyFromMavenResult.hasSourceTsFiles || copyFromMavenResult.hasJooUnitTsFiles) {
                WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "build", "ignoreTypeErrors", true);
                this.addManagedDependency(devDependencies2, "eslint");
                ArrayList<String> eslintPatterns = new ArrayList<String>();
                if (copyFromMavenResult.hasSourceTsFiles) {
                    eslintPatterns.add("\"src/**/*.ts\"");
                }
                if (copyFromMavenResult.hasJooUnitTsFiles) {
                    eslintPatterns.add("\"joounit/**/*.ts\"");
                }
                scripts2.put("lint", "eslint --fix " + String.join((CharSequence)" ", eslintPatterns));
            }
            if (Paths.get(targetPackageDir, "src", "index.d.ts").toFile().exists()) {
                additionalJsonEntries.setTypes("./src/index.d.ts");
                additionalJsonEntries.addPublishConfig("types", "./src/index.d.ts");
                additionalJsonEntries.getExports().put(".", ImmutableMap.of((Object)"types", (Object)"./src/index.d.ts"));
                ((Map)additionalJsonEntries.getPublishConfig().get("exports")).put(".", ImmutableMap.of((Object)"types", (Object)"./src/index.d.ts"));
            }
            if (projectExtensionFor != null) {
                LinkedHashMap<String, Object> coremedia = new LinkedHashMap<String, Object>();
                coremedia.put("projectExtensionFor", this.renameLegacyProjectExtensionPoint(projectExtensionFor));
                additionalJsonEntries.setCoremedia(coremedia);
            }
        } else if (moduleType == ModuleType.JANGAROO_APP) {
            String applicationClassImport;
            jangarooConfig.setType("app");
            WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "run", "proxyTargetUri", "http://localhost:41080");
            WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
            jangarooConfig.setExtNamespace(this.extNamespace);
            jangarooConfig.setExtSassNamespace(this.extSassNamespace);
            if (this.theme != null) {
                dependencyPackage = this.getDependencyPackageByRef(this.theme);
                if (dependencyPackage == null) {
                    this.getLog().warn((CharSequence)String.format("Could not find theme dependency for %s which is configured in the jangaroo-maven-plugin configuration.", this.theme));
                } else {
                    jangarooConfig.setTheme(dependencyPackage.getName());
                }
            }
            if (this.applicationClass != null && (applicationClassImport = aPackage.getClassMapping().containsKey(this.applicationClass) ? "./src/" + aPackage.getClassMapping().get(this.applicationClass) : this.findClassImportInDependencies(aPackage, this.applicationClass, false)) != null) {
                jangarooConfig.setApplicationClass(applicationClassImport.replaceFirst("[.]ts$", ""));
            }
            jangarooConfig.setAdditionalLocales(this.additionalLocales);
            jangarooConfig.setAdditionalCssIncludeInBundle(this.additionalCssIncludeInBundle);
            jangarooConfig.setAdditionalCssNonBundle(this.additionalCssNonBundle);
            jangarooConfig.setAdditionalJsIncludeInBundle(this.additionalJsIncludeInBundle);
            jangarooConfig.setAdditionalJsNonBundle(this.additionalJsNonBundle);
            if (new File(mavenModule.getDirectory().getPath() + "/app.json").exists()) {
                try {
                    jangarooConfig.setSencha(this.jsonObjectMapper.readValue(FileUtils.readFileToString((File)new File(mavenModule.getDirectory().getPath() + "/app.json")), Map.class));
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), e.getCause());
                }
            }
            dependencies = new TreeMap<String, String>();
            this.addManagedDependency(dependencies, "@coremedia/sencha-ext");
            this.addManagedDependency(dependencies, "@coremedia/sencha-ext-classic");
            this.addManagedDependency(dependencies, "@coremedia/sencha-ext-classic-locale");
            this.addManagedDependency(dependencies, "@jangaroo/runtime");
            if (jangarooConfig.getTheme() != null && !jangarooConfig.getTheme().isEmpty()) {
                this.addManagedDependency(dependencies, jangarooConfig.getTheme());
            }
            additionalJsonEntries.setDependencies(dependencies);
            devDependencies2 = new TreeMap<String, String>();
            this.addManagedDependency(devDependencies2, "@jangaroo/core");
            this.addManagedDependency(devDependencies2, "@jangaroo/build");
            this.addManagedDependency(devDependencies2, "@jangaroo/publish");
            this.addManagedDependency(devDependencies2, "@jangaroo/run");
            this.addManagedDependency(devDependencies2, "rimraf");
            additionalJsonEntries.setDevDependencies(devDependencies2);
            scripts2 = new LinkedHashMap<String, String>();
            scripts2.put("clean", "rimraf ./dist && rimraf ./build");
            scripts2.put("build", "jangaroo build");
            scripts2.put("watch", "jangaroo watch");
            scripts2.put("start", "jangaroo run");
            scripts2.put("publish", "jangaroo publish");
            additionalJsonEntries.setScripts(scripts2);
            additionalJsonEntries.addPublishConfig("directory", "build");
            exports = new TreeMap<String, Object>();
            exports.put("./*", ImmutableMap.of((Object)"types", (Object)"./src/*.ts", (Object)"default", (Object)"./build/src/*.js"));
            additionalJsonEntries.setExports(exports);
            publishConfigExports = new HashMap<String, ImmutableMap>();
            publishConfigExports.put("./*", ImmutableMap.of((Object)"types", (Object)"./src/*.d.ts", (Object)"default", (Object)"./src/*.js"));
            additionalJsonEntries.addPublishConfig("exports", publishConfigExports);
            ignoreFromSencha = new ArrayList<String>();
            ignoreFromSencha.add("app.json");
            copyFromMavenResult = null;
            try {
                copyFromMavenResult = this.copyCodeFromMaven(mavenModule.getDirectory().getPath(), Paths.get("target", "app").toString(), ignoreFromSencha, targetPackageDir);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
            if (copyFromMavenResult.hasSourceTsFiles) {
                WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "build", "ignoreTypeErrors", true);
                this.addManagedDependency(devDependencies2, "eslint");
                scripts2.put("lint", "eslint --fix \"src/**/*.ts\"");
            }
        } else if (moduleType == ModuleType.JANGAROO_APP_OVERLAY) {
            jangarooConfig.setType("app-overlay");
            WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "run", "proxyTargetUri", "http://localhost:41080");
            WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
            devDependencies = new TreeMap();
            this.addManagedDependency(devDependencies, "@jangaroo/core");
            this.addManagedDependency(devDependencies, "@jangaroo/build");
            this.addManagedDependency(devDependencies, "@jangaroo/publish");
            this.addManagedDependency(devDependencies, "@jangaroo/run");
            this.addManagedDependency(devDependencies, "rimraf");
            additionalJsonEntries.setDevDependencies(devDependencies);
            scripts = new LinkedHashMap();
            scripts.put("clean", "rimraf ./dist");
            scripts.put("build", "jangaroo build");
            scripts.put("watch", "jangaroo watch");
            scripts.put((String)"start", (String)"jangaroo run");
            scripts.put((String)"publish", (String)"jangaroo publish");
            additionalJsonEntries.setScripts((Map<String, String>)scripts);
            additionalJsonEntries.addPublishConfig("directory", "dist");
        } else if (moduleType == ModuleType.JANGAROO_APPS) {
            jangarooConfig.setType("apps");
            WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "run", "proxyTargetUri", "http://localhost:41080");
            WorkspaceConverterMojo.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
            if (this.rootApp != null) {
                dependencyPackage = this.getDependencyPackageByRef(this.rootApp);
                if (dependencyPackage == null) {
                    this.getLog().warn((CharSequence)String.format("Could not find rootApp dependency for %s which is configured in the jangaroo-maven-plugin configuration.", this.theme));
                } else {
                    jangarooConfig.addAppPath(dependencyPackage.getName(), "");
                }
            }
            devDependencies = new TreeMap();
            this.addManagedDependency(devDependencies, "@jangaroo/core");
            this.addManagedDependency(devDependencies, "@jangaroo/build");
            this.addManagedDependency(devDependencies, "@jangaroo/publish");
            this.addManagedDependency(devDependencies, "@jangaroo/run");
            this.addManagedDependency(devDependencies, "rimraf");
            additionalJsonEntries.setDevDependencies(devDependencies);
            scripts = new LinkedHashMap();
            scripts.put("clean", "rimraf ./dist");
            scripts.put("build", "jangaroo build");
            scripts.put((String)"watch", (String)"jangaroo watch");
            scripts.put((String)"start", (String)"jangaroo run");
            scripts.put((String)"package", (String)"jangaroo package");
            scripts.put((String)"publish", (String)"jangaroo publish");
            additionalJsonEntries.setScripts((Map<String, String>)scripts);
            additionalJsonEntries.addPublishConfig("directory", "dist");
        } else if (moduleType == ModuleType.AGGREGATOR) {
            jangarooConfig.setType("code");
            devDependencies = new TreeMap<String, String>();
            this.addManagedDependency(devDependencies, "@jangaroo/core");
            this.addManagedDependency(devDependencies, "@jangaroo/build");
            this.addManagedDependency(devDependencies, "@jangaroo/publish");
            this.addManagedDependency(devDependencies, "rimraf");
            additionalJsonEntries.setDevDependencies(devDependencies);
            scripts = new LinkedHashMap<String, String>();
            scripts.put("clean", "rimraf ./dist && rimraf ./build");
            scripts.put("build", "jangaroo build");
            scripts.put("watch", "jangaroo watch");
            scripts.put("publish", "jangaroo publish");
            additionalJsonEntries.setScripts((Map<String, String>)scripts);
            additionalJsonEntries.addPublishConfig("directory", "dist");
            if (projectExtensionPoint != null) {
                LinkedHashMap<String, Object> coremedia = new LinkedHashMap<String, Object>();
                coremedia.put("projectExtensionPoint", this.renameLegacyProjectExtensionPoint(projectExtensionPoint));
                additionalJsonEntries.setCoremedia(coremedia);
            }
        } else {
            throw new MojoExecutionException("Unknown maven module type: " + (Object)((Object)moduleType));
        }
        List<String> appManifestPaths = this.match("glob:/**/app-manifest-fragment*.json", mavenModule.getDirectory().getPath());
        if (!appManifestPaths.isEmpty()) {
            for (String appManifestPath : appManifestPaths) {
                Matcher matcher;
                String fileName = new File(appManifestPath).getName();
                if ("app-manifest-fragment.json".equals(fileName)) {
                    fileName = "app-manifest-fragment-en.json";
                }
                if ((matcher = Pattern.compile("app-manifest-fragment-([^.]+).json").matcher(fileName)).find()) {
                    String locale = matcher.group(1);
                    try {
                        jangarooConfig.addAppManifest(locale, this.jsonObjectMapper.readValue(new File(appManifestPath), Map.class));
                    }
                    catch (IOException ioException) {
                        logger.error("error while reading manifest file: " + appManifestPath);
                    }
                    continue;
                }
                logger.error("Could not detect locale for manifest file: " + appManifestPath);
            }
        }
        try {
            String jangarooConfigDocument = "/** @type { import('" + this.packagesByOriginalName.get("@jangaroo/core").getName() + "').IJangarooConfig } */\nmodule.exports = ".concat(this.convertJangarooConfig(this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jangarooConfig).concat(";\n")));
            FileUtils.writeStringToFile((File)Paths.get(targetPackageDir, "jangaroo.config.js").toFile(), (String)jangarooConfigDocument);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
        PackageJson packageJson = new PackageJson(additionalJsonEntries);
        packageJson.setName(aPackage.getName());
        packageJson.setVersion(aPackage.getVersion());
        if (mavenModule.getData().getOrganization() != null) {
            packageJson.setAuthor(mavenModule.getData().getOrganization().getName());
        }
        packageJson.setPrivat(true);
        aPackage.getDependencies().stream().collect(Collectors.toMap(Package::getName, Package::getDependencyVersion)).forEach(packageJson::addDependency);
        aPackage.getDevDependencies().stream().collect(Collectors.toMap(Package::getName, Package::getDependencyVersion)).forEach(packageJson::addDevDependency);
        TreeMap<String, String> sortedDependencies = new TreeMap<String, String>();
        if (packageJson.getDependencies() != null) {
            packageJson.getDependencies().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sortedDependencies.put((String)entry.getKey(), (String)entry.getValue()));
        }
        packageJson.setDependencies(sortedDependencies);
        TreeMap<String, String> sortedDevDependencies = new TreeMap<String, String>();
        if (packageJson.getDevDependencies() != null) {
            packageJson.getDevDependencies().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sortedDevDependencies.put((String)entry.getKey(), (String)entry.getValue()));
        }
        packageJson.setDevDependencies(sortedDevDependencies);
        try {
            FileUtils.write((File)new File(targetPackageJson), (CharSequence)this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)packageJson).concat("\n"));
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
        MavenExecutionRequest e = this.session.getRequest();
        synchronized (e) {
            WorkspaceRoot workspaceRoot = new WorkspaceRoot(this.jsonObjectMapper, this.yamlObjectMapper, this.convertedWorkspaceTarget);
            try {
                workspaceRoot.writePackageJson(projectExtensionFor != null || projectExtensionPoint != null ? Collections.singletonList(this.relativeNpmProjectExtensionWorkspacePath) : Collections.emptyList());
                workspaceRoot.writeWorkspacePackages(Collections.singletonList(relativePackageFolderName));
            }
            catch (IOException e2) {
                throw new MojoFailureException(e2.getMessage(), e2.getCause());
            }
        }
        try {
            this.loadAndCopyResource("eslintrc.js", ".eslintrc.js");
            this.loadAndCopyResource("gitignore", ".gitignore");
        }
        catch (IOException e2) {
            throw new MojoFailureException(e2.getMessage(), e2.getCause());
        }
    }

    private String getProjectExtensionPoint(MavenModule mavenModule) {
        String projectExtensionPoint;
        Matcher extensionPointMatcher = EXTENSION_POINT_PATTERN.matcher(mavenModule.getData().getArtifactId());
        String string = projectExtensionPoint = extensionPointMatcher.matches() ? extensionPointMatcher.group(1) : null;
        if (this.projectExtensionWorkspacePath == null && projectExtensionPoint != null) {
            logger.warn("Maven project is marked as extension point but projectExtensionWorkspacePath is missing. Ignoring marker...");
            return null;
        }
        return projectExtensionPoint;
    }

    private String getProjectExtensionFor(MavenModule mavenModule) {
        String projectExtensionFor = mavenModule.getData().getProperties().getProperty("coremedia.project.extension.for");
        if (this.projectExtensionWorkspacePath == null && projectExtensionFor != null) {
            logger.warn("Maven project is marked as extension but projectExtensionWorkspacePath is missing. Ignoring marker...");
            return null;
        }
        return projectExtensionFor;
    }

    private String renameLegacyProjectExtensionPoint(String projectExtensionPointName) {
        if ("studio".equals(projectExtensionPointName) || "studio-client".equals(projectExtensionPointName)) {
            return "studio-client.main-static";
        }
        if ("studio-dynamic".equals(projectExtensionPointName) || "studio-client-dynamic".equals(projectExtensionPointName)) {
            return "studio-client.main";
        }
        return projectExtensionPointName;
    }

    private boolean isProjectExtensionPointDependency(Dependency dependency) {
        boolean result;
        boolean bl = result = "pom".equals(dependency.getType()) && EXTENSION_POINT_PATTERN.matcher(dependency.getArtifactId()).matches();
        if (this.projectExtensionWorkspacePath == null && result) {
            logger.warn(String.format("Dependency %s is marked as project extension point but configuration 'projectExtensionWorkspacePath' is missing. Ignoring marker...", dependency));
            return false;
        }
        return result;
    }

    private Path getRelativePathBelowRoot(Path rootPath, Path absolutePathBelowRoot) {
        Path relativePath = rootPath.relativize(absolutePathBelowRoot).normalize();
        int depth = relativePath.getNameCount();
        if (depth >= 1 && !"..".equals(relativePath.getName(0).toString())) {
            return relativePath;
        }
        return null;
    }

    private void loadAndCopyResource(String resourceName, String fileName) throws IOException {
        Path filePath = Paths.get(this.convertedWorkspaceTarget, fileName);
        try (InputStream fileResource = ((Object)((Object)this)).getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/" + resourceName);){
            if (fileResource != null) {
                try {
                    Files.copy(fileResource, filePath, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
        }
    }

    private String getPackageFolderName(String packageName, MavenModule mavenModule) throws MojoExecutionException {
        if (this.projectExtensionWorkspacePath != null) {
            Path projectExtensionsPath = this.projectExtensionWorkspacePath.toPath().resolve(this.relativeProjectExtensionsPath);
            Path relativeProjectExtensionPath = this.getRelativePathBelowRoot(projectExtensionsPath, mavenModule.getDirectory().toPath());
            if (relativeProjectExtensionPath == null && this.getProjectExtensionFor(mavenModule) != null) {
                throw new MojoExecutionException("Maven project is marked as project extension but is not below the given project extensions path: " + projectExtensionsPath);
            }
            if (relativeProjectExtensionPath != null) {
                Path relativeNpmProjectExtensionsPath = Paths.get(this.relativeNpmProjectExtensionWorkspacePath, "extensions");
                Path packageFolderName = relativeProjectExtensionPath.getNameCount() > 1 ? relativeNpmProjectExtensionsPath.resolve(relativeProjectExtensionPath.subpath(0, relativeProjectExtensionPath.getNameCount() - 1)).resolve(packageName) : relativeNpmProjectExtensionsPath.resolve(relativeProjectExtensionPath);
                if (this.getRelativePathBelowRoot(relativeNpmProjectExtensionsPath, packageFolderName = Paths.get(this.getReplacedPackageFolderName(packageFolderName.toString()), new String[0])) == null) {
                    throw new MojoExecutionException(String.format("NPM package folder name has been replaced with %s. This path is not below the given project extensions path %s. The extensions workspace path can be configured using 'relativeNpmProjectExtensionWorkspacePath'", packageFolderName, projectExtensionsPath));
                }
                return packageFolderName.toString();
            }
            Path projectExtensionPointsPath = this.projectExtensionWorkspacePath.toPath().resolve(this.relativeProjectExtensionPointsPath);
            Path relativeProjectExtensionPointPath = this.getRelativePathBelowRoot(projectExtensionPointsPath, mavenModule.getDirectory().toPath());
            if (relativeProjectExtensionPointPath == null && this.getProjectExtensionPoint(mavenModule) != null) {
                throw new MojoExecutionException("Maven project is marked as project extension point but is not below the given project extension points path: " + projectExtensionPointsPath);
            }
            if (relativeProjectExtensionPointPath != null) {
                Path relativeNpmProjectExtensionPointsPath = Paths.get(this.relativeNpmProjectExtensionWorkspacePath, "extension-config");
                Path packageFolderName = relativeNpmProjectExtensionPointsPath.resolve(packageName);
                if (this.getRelativePathBelowRoot(relativeNpmProjectExtensionPointsPath, packageFolderName = Paths.get(this.getReplacedPackageFolderName(packageFolderName.toString()), new String[0])) == null) {
                    throw new MojoExecutionException(String.format("NPM package folder name has been replaced with %s. This path is not below the given project extension points path %s. The extensions workspace path can be configured using 'relativeNpmProjectExtensionWorkspacePath'.", packageFolderName, projectExtensionPointsPath));
                }
                return packageFolderName.toString();
            }
        }
        return this.getReplacedPackageFolderName(packageName);
    }

    private String getReplacedPackageFolderName(String packageFolderName) {
        for (SearchAndReplace searchAndReplace : this.resolvedNpmPackageFolderNameReplacers) {
            Matcher matcher = searchAndReplace.search.matcher(packageFolderName);
            if (!matcher.matches()) continue;
            return matcher.replaceAll(searchAndReplace.replace);
        }
        return packageFolderName;
    }

    private List<String> match(String glob, String location) {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(glob);
        final ArrayList<String> matchingFilePaths = new ArrayList<String>();
        try {
            Files.walkFileTree(Paths.get(location, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    if (pathMatcher.matches(path)) {
                        matchingFilePaths.add(path.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return matchingFilePaths;
    }

    private CopyFromMavenResult copyCodeFromMaven(String baseDirectory, String generatedExtModuleDirectory, List<String> ignoreFromSencha, String targetPackageDir) throws IOException {
        Path generatedSenchaSrc;
        Path jooUnitSourcePath;
        AtomicBoolean hasSourceTsFiles = new AtomicBoolean(false);
        AtomicBoolean hasJooUnitTsFiles = new AtomicBoolean(false);
        Path generatedSrc = Paths.get(baseDirectory, "target", "generated-sources", "joo");
        List generatedTsFiles = this.match("glob:/**/*.{as,mxml}", generatedSrc.toString()).stream().map(filePathStr -> filePathStr.replaceAll("[.](as|mxml)$", ".ts")).map(x$0 -> Paths.get(x$0, new String[0])).map(generatedSrc::relativize).filter(filePath -> {
            String filePathStr = filePath.toString();
            if (!filePathStr.endsWith("_properties.ts")) {
                return true;
            }
            String propertiesFile = filePathStr.replaceAll("_properties[.]ts$", ".properties");
            return !Paths.get(baseDirectory, "src", "main", "joo", propertiesFile).toFile().exists();
        }).map(filePath -> {
            if (!this.extNamespace.isEmpty()) {
                String slashedExtNamespaceWithTrailingSlash = this.extNamespace.concat(".").replaceAll("[.]", File.separator);
                return Paths.get(filePath.toString().replace(slashedExtNamespaceWithTrailingSlash, ""), new String[0]);
            }
            return filePath;
        }).collect(Collectors.toList());
        String srcFolderName = "src";
        String generatedFolderName = "generated";
        Path sourceDirPath = Paths.get(baseDirectory, generatedExtModuleDirectory, "src");
        if (sourceDirPath.toFile().exists() && sourceDirPath.toFile().isDirectory()) {
            Path targetDirPath = Paths.get(targetPackageDir, "sencha", "src");
            FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)targetDirPath.toFile(), pathname -> pathname.isDirectory() || !pathname.getName().endsWith(".ts"));
            targetDirPath = Paths.get(targetPackageDir, "src");
            FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)targetDirPath.toFile(), pathname -> {
                boolean isTsFile = pathname.getName().endsWith(".ts");
                if (isTsFile) {
                    hasSourceTsFiles.set(true);
                }
                return pathname.isDirectory() || isTsFile && !generatedTsFiles.contains(sourceDirPath.relativize(pathname.toPath()));
            });
            if (generatedTsFiles.size() > 0) {
                Path generatedTargetDirpath = Paths.get(targetPackageDir, "generated", "src");
                FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)generatedTargetDirpath.toFile(), pathname -> {
                    boolean isTsFile = pathname.getName().endsWith(".ts");
                    return pathname.isDirectory() || isTsFile && generatedTsFiles.contains(sourceDirPath.relativize(pathname.toPath()));
                });
            }
        }
        if ((jooUnitSourcePath = Paths.get(baseDirectory, "target", "test-classes", "src")).toFile().exists() && jooUnitSourcePath.toFile().isDirectory()) {
            Path jooUnitTargetDirPath = Paths.get(targetPackageDir, "joounit");
            FileUtils.copyDirectory((File)jooUnitSourcePath.toFile(), (File)jooUnitTargetDirPath.toFile(), pathname -> {
                boolean isTsFile;
                boolean bl = isTsFile = pathname.isFile() && pathname.getName().endsWith(".ts");
                if (isTsFile) {
                    hasJooUnitTsFiles.set(true);
                }
                return pathname.isDirectory() || isTsFile;
            });
        }
        ArrayList<String> fullIgnoreFromSrcMainSencha = new ArrayList<String>(ignoreFromSencha);
        for (String dir : Arrays.asList("sass/var", "sass/src")) {
            fullIgnoreFromSrcMainSencha.add(dir);
            Path sassDirPath = Paths.get(baseDirectory, generatedExtModuleDirectory, dir);
            if (!sassDirPath.toFile().exists() || !sassDirPath.toFile().isDirectory()) continue;
            Path targetDirPath = Paths.get(targetPackageDir, "sencha", dir);
            FileUtils.copyDirectory((File)sassDirPath.toFile(), (File)targetDirPath.toFile());
        }
        Path senchaSrc = Paths.get(baseDirectory, "src", "main", "sencha");
        if (senchaSrc.toFile().exists() && senchaSrc.toFile().isDirectory()) {
            FileUtils.copyDirectory((File)senchaSrc.toFile(), (File)Paths.get(targetPackageDir, "sencha").toFile(), pathname -> this.acceptFile(pathname, senchaSrc, fullIgnoreFromSrcMainSencha));
        }
        if ((generatedSenchaSrc = Paths.get(baseDirectory, "target", "generated-sencha")).toFile().exists() && generatedSenchaSrc.toFile().isDirectory()) {
            FileUtils.copyDirectory((File)generatedSenchaSrc.toFile(), (File)Paths.get(targetPackageDir, "generated", "sencha").toFile(), pathname -> this.acceptFile(pathname, generatedSenchaSrc, fullIgnoreFromSrcMainSencha));
        }
        return new CopyFromMavenResult(hasSourceTsFiles.get(), hasJooUnitTsFiles.get());
    }

    private boolean acceptFile(File file, Path srcMainSenchaPath, List<String> ignoreFromSrcMainSencha) {
        List collect = ignoreFromSrcMainSencha.stream().map(string -> Paths.get(srcMainSenchaPath.toString(), string)).collect(Collectors.toList());
        return collect.stream().noneMatch(path -> file.getPath().contains(path.toString()));
    }

    private Optional<Artifact> getDependencyArtifact(Dependency dependency) {
        return this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(dependency.getGroupId()) && artifact.getArtifactId().equals(dependency.getArtifactId())).findFirst();
    }

    private Package getDependencyPackageByRef(String ref) {
        Optional<Package> dependencyPackage;
        Dependency dependency = SenchaUtils.getDependencyByRef(this.project, ref);
        if (dependency != null && (dependencyPackage = this.getOrCreateDependencyPackage(dependency)).isPresent()) {
            return dependencyPackage.get();
        }
        if ("ext-classic".equals(ref)) {
            return this.packagesByOriginalName.get("@coremedia/sencha-ext-classic");
        }
        if ("charts".equals(ref)) {
            return this.packagesByOriginalName.get("@coremedia/sencha-ext-charts");
        }
        if (ref != null && ref.startsWith("theme-")) {
            return this.packagesByOriginalName.get("@coremedia/sencha-ext-classic-" + ref);
        }
        return null;
    }

    private Map.Entry<String, String> getOverriddenPackageNameAndDependencyVersion(Map.Entry<String, String> packageNameAndDependencyVersion) {
        String dependencyStr = packageNameAndDependencyVersion.getKey() + ":" + packageNameAndDependencyVersion.getValue();
        for (SearchAndReplace searchAndReplace : this.resolvedNpmDependencyOverrides) {
            Matcher matcher = searchAndReplace.search.matcher(dependencyStr);
            if (!matcher.matches()) continue;
            String dependencyStrReplacement = matcher.replaceAll(searchAndReplace.replace);
            String[] parts = dependencyStrReplacement.split(":");
            if (parts.length == 2) {
                String version = parts[1];
                Pattern DEPENDENCY_VERSION_PATTERN = Pattern.compile("^([^~]?)(.*)$");
                Matcher dependencyVersionMatcher = DEPENDENCY_VERSION_PATTERN.matcher(version);
                if (dependencyVersionMatcher.matches()) {
                    version = dependencyVersionMatcher.group(1) + ConversionUtils.normalizeNpmPackageVersion(dependencyVersionMatcher.group(2));
                }
                return new AbstractMap.SimpleEntry<String, String>(parts[0], version);
            }
            logger.warn(String.format("Ignoring invalid replacement for dependency: %s => %s", dependencyStr, dependencyStrReplacement));
            break;
        }
        return packageNameAndDependencyVersion;
    }

    private ConversionUtils.NpmPackageMetadata getNpmPackageMetadata(Artifact artifact) {
        Manifest manifest;
        String artifactType = artifact.getType();
        if (artifact.getFile() == null || !Type.JANGAROO_PACKAGING_TYPES.contains(artifactType) && !"jar".equals(artifactType)) {
            return null;
        }
        try {
            manifest = new JarFile(artifact.getFile()).getManifest();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)String.format("Artifact %s could not be read!", artifact));
            return null;
        }
        if (manifest == null) {
            return null;
        }
        HashMap<String, String> entries = new HashMap<String, String>();
        for (Map.Entry<Object, Object> mainAttribute : manifest.getMainAttributes().entrySet()) {
            entries.put(mainAttribute.getKey().toString(), mainAttribute.getValue().toString());
        }
        return ConversionUtils.getNpmPackageMetadataFromManifestEntries(entries);
    }

    private Optional<Package> getOrCreateDependencyPackage(Dependency dependency) {
        Optional<Artifact> optionalArtifact = this.getDependencyArtifact(dependency);
        if (!optionalArtifact.isPresent()) {
            return Optional.empty();
        }
        Model model = new Model();
        model.setGroupId(optionalArtifact.get().getGroupId());
        model.setArtifactId(optionalArtifact.get().getArtifactId());
        model.setVersion(optionalArtifact.get().getVersion());
        model.setPackaging(optionalArtifact.get().getArtifactHandler().getPackaging());
        model.setDependencies(this.project.getArtifacts().stream().filter(artifact -> this.inDependencyTrail(dependency, artifact.getDependencyTrail())).filter(artifact -> !artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId())).map(artifact -> {
            Dependency localDependency = new Dependency();
            localDependency.setArtifactId(artifact.getArtifactId());
            localDependency.setGroupId(artifact.getGroupId());
            localDependency.setScope(artifact.getScope());
            localDependency.setType(artifact.getType());
            localDependency.setVersion(artifact.getVersion());
            return localDependency;
        }).collect(Collectors.toList()));
        return Optional.of(this.readPackageFromMavenModule(new MavenModule("", model, optionalArtifact.get())));
    }

    private boolean inDependencyTrail(Dependency dependency, List<String> dependencyTrail) {
        return dependencyTrail.stream().map(dependencyPart -> dependencyPart.split(":")).filter(dependencySplit -> dependency.getGroupId().equals(dependencySplit[0])).anyMatch(dependencySplit -> dependency.getArtifactId().equals(dependencySplit[1]));
    }

    private Package readPackageFromMavenModule(MavenModule mavenModule) {
        String originalPackageName;
        Artifact artifact = mavenModule.getArtifact();
        ConversionUtils.NpmPackageMetadata npmPackageMetadata = this.getNpmPackageMetadata(artifact);
        String string = originalPackageName = npmPackageMetadata != null ? npmPackageMetadata.name : ConversionUtils.getNpmPackageName(mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId(), this.resolvedNpmPackageNameReplacers);
        if (this.packagesByOriginalName.containsKey(originalPackageName)) {
            return this.packagesByOriginalName.get(originalPackageName);
        }
        String packageVersion = npmPackageMetadata != null ? npmPackageMetadata.version : ConversionUtils.getNpmPackageVersion(mavenModule.getData().getVersion(), this.resolvedNpmPackageVersionReplacers);
        Map.Entry<String, String> overriddenPackageNameAndDependency = this.getOverriddenPackageNameAndDependencyVersion(new AbstractMap.SimpleEntry<String, String>(originalPackageName, packageVersion));
        String packageName = overriddenPackageNameAndDependency.getKey();
        String dependencyVersion = overriddenPackageNameAndDependency.getValue();
        ArrayList<Package> packageDependencies = new ArrayList<Package>();
        ArrayList<Package> packageDevDependencies = new ArrayList<Package>();
        List dependencies = mavenModule.getData().getDependencies().stream().filter(dependency -> !"test".equals(dependency.getScope())).filter(dependency -> !this.ignoreDependency((Dependency)dependency)).peek(dependency -> {
            if ("${project.groupId}".equals(dependency.getGroupId())) {
                dependency.setGroupId(mavenModule.getData().getGroupId());
            }
            if ("${project.version}".equals(dependency.getVersion())) {
                dependency.setVersion(mavenModule.getVersion());
            }
        }).collect(Collectors.toList());
        List testDependencies = mavenModule.getData().getDependencies().stream().filter(dependency -> "test".equals(dependency.getScope())).filter(dependency -> !this.ignoreDependency((Dependency)dependency)).peek(dependency -> {
            if ("$(project.groupid)".equals(dependency.getGroupId())) {
                dependency.setGroupId(mavenModule.getData().getGroupId());
            }
            if ("${project.version}".equals(dependency.getVersion())) {
                dependency.setVersion(mavenModule.getVersion());
            }
        }).collect(Collectors.toList());
        for (Dependency dependency2 : dependencies) {
            this.getOrCreateDependencyPackage(dependency2).ifPresent(dependencyPackage -> {
                if (Arrays.asList("swc", "jar").contains(dependency2.getType()) || this.isProjectExtensionPointDependency(dependency2)) {
                    packageDependencies.add((Package)dependencyPackage);
                } else {
                    packageDependencies.addAll(dependencyPackage.getDependencies());
                }
            });
        }
        for (Dependency dependency2 : testDependencies) {
            this.getOrCreateDependencyPackage(dependency2).ifPresent(dependencyPackage -> {
                if (Arrays.asList("swc", "jar").contains(dependency2.getType()) || this.isProjectExtensionPointDependency(dependency2)) {
                    packageDevDependencies.add((Package)dependencyPackage);
                } else {
                    packageDevDependencies.addAll(dependencyPackage.getDependencies());
                }
            });
        }
        Map<String, String> classMapping = this.readClassMapping(artifact);
        Package aPackage = new Package(packageName, packageVersion, dependencyVersion, packageDependencies, packageDevDependencies, classMapping);
        this.packagesByOriginalName.put(originalPackageName, aPackage);
        return aPackage;
    }

    private boolean ignoreDependency(Dependency dependency) {
        return "net.jangaroo__jangaroo-browser".contains(String.format("%s__%s", dependency.getGroupId(), dependency.getArtifactId()));
    }

    private String convertJangarooConfig(String jangarooConfig) {
        return jangarooConfig.replaceAll("\"([a-zA-Z_$][0-9a-zA-Z_$]*)\":", "$1:").replace("}", "},").replace("]", "],").replace("\"\n", "\",\n").replace(",,", ",").replace(",;", ";");
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        int length = version.length();
        return length != 0 && version.split("\\.").length >= 3;
    }

    private void addManagedDependency(Map<String, String> dependencies, String name) {
        Package aPackage = this.packagesByOriginalName.get(name);
        if (aPackage != null) {
            dependencies.put(aPackage.getName(), aPackage.getDependencyVersion());
        } else {
            logger.warn("Could not find package with name " + name);
        }
    }

    private static void addAutoLoadEntry(JangarooConfig jangarooConfig, String item) {
        if (jangarooConfig.getAutoLoad() == null) {
            jangarooConfig.setAutoLoad(Lists.newArrayList((Object[])new String[]{item}));
        } else {
            jangarooConfig.getAutoLoad().add(item);
        }
    }

    private static Object getCommandMapEntry(JangarooConfig jangarooConfig, String commandName, String entryName) {
        Map<String, Map<String, Object>> commandsByName = jangarooConfig.getCommand();
        if (commandsByName == null) {
            return null;
        }
        if (!commandsByName.containsKey(commandName)) {
            return null;
        }
        Map<String, Object> command = commandsByName.get(commandName);
        return command.getOrDefault(entryName, null);
    }

    private static void setCommandMapEntry(JangarooConfig jangarooConfig, String commandName, String entryName, Object entryValue) {
        Map<String, Map<String, Object>> commandsByName = jangarooConfig.getCommand();
        if (commandsByName == null) {
            commandsByName = new TreeMap<String, Map<String, Object>>();
            jangarooConfig.setCommand(commandsByName);
        }
        Map command = commandsByName.computeIfAbsent(commandName, k -> new LinkedHashMap());
        command.put(entryName, entryValue);
    }

    private Map<String, String> readClassMapping(Artifact artifact) {
        String artifactType = artifact.getType();
        boolean isCode = "swc".equals(artifactType);
        boolean isApp = "jangaroo-app".equals(artifactType);
        if (artifact.getFile() != null && (isCode || isApp)) {
            try {
                ZipEntry jsonEntry;
                ZipEntry inventoryEntry;
                Map classMapping;
                ZipEntry classMappingEntry;
                JarFile jarFile = new JarFile(artifact.getFile());
                ZipEntry zipEntry = classMappingEntry = isCode ? jarFile.getEntry("META-INF/pkg/classMapping.json") : jarFile.getEntry("META-INF/resources/classMapping.json");
                if (classMappingEntry != null && !(classMapping = (Map)this.jsonObjectMapper.readValue(jarFile.getInputStream(classMappingEntry), Map.class)).isEmpty()) {
                    return classMapping;
                }
                String inventoryFileName = SenchaUtils.getSenchaPackageName(artifact.getGroupId(), artifact.getArtifactId()) + ".json";
                ZipEntry zipEntry2 = inventoryEntry = isCode ? jarFile.getEntry("META-INF/pkg/" + inventoryFileName) : jarFile.getEntry("META-INF/resources/" + inventoryFileName);
                if (inventoryEntry != null && (jsonEntry = jarFile.getEntry(isCode ? "META-INF/pkg/package.json" : "META-INF/resources/app.json")) != null) {
                    Map json = (Map)this.jsonObjectMapper.readValue(jarFile.getInputStream(jsonEntry), Map.class);
                    String namespace = json.getOrDefault("namespace", "");
                    int namespaceLengthToRemove = namespace.isEmpty() ? 0 : namespace.length() + 1;
                    List inventoryList = (List)this.jsonObjectMapper.readValue(jarFile.getInputStream(inventoryEntry), List.class);
                    return inventoryList.stream().collect(Collectors.toMap(Function.identity(), fqn -> CompilerUtils.fileNameFromQName((String)fqn.substring(namespaceLengthToRemove), (char)'/', (String)".ts")));
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)String.format("Class Mapping could not be read from artifact %s!", artifact), (Throwable)e);
            }
        }
        return new HashMap<String, String>();
    }

    private String findClassImportInDependencies(Package pkg, String className, boolean includeDevDependencies) {
        ArrayList<Package> allDependencies = new ArrayList<Package>(pkg.getDependencies());
        if (includeDevDependencies) {
            allDependencies.addAll(pkg.getDependencies());
        }
        for (Package dependency : allDependencies) {
            if (!dependency.getClassMapping().containsKey(className)) continue;
            return dependency.getName() + "/" + dependency.getClassMapping().get(className);
        }
        this.getLog().warn((CharSequence)("Could not resolve ExtJS class: " + className));
        return null;
    }

    private static class CopyFromMavenResult {
        public final boolean hasSourceTsFiles;
        public final boolean hasJooUnitTsFiles;

        public CopyFromMavenResult(boolean hasSourceTsFiles, boolean hasJooUnitTsFiles) {
            this.hasSourceTsFiles = hasSourceTsFiles;
            this.hasJooUnitTsFiles = hasJooUnitTsFiles;
        }
    }
}

