/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jangaroo.jooc.mvnplugin.converter.PackageJson;

public class RootPackageJson {
    private PackageJson packageJson;
    private final String path;
    private final ObjectMapper objectMapper;

    public RootPackageJson(ObjectMapper objectMapper, String path) {
        this.objectMapper = objectMapper;
        this.path = path;
    }

    private PackageJson readPackageJson(RandomAccessFile randomAccessFile) throws IOException {
        this.packageJson = new PackageJson();
        File packageJsonFile = Paths.get(this.path, "/package.json").toFile();
        PackageJson parsedPackageJson = !packageJsonFile.exists() || randomAccessFile.length() < 1L ? (PackageJson)this.objectMapper.readValue(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/package.json"), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), PackageJson.class) : (PackageJson)this.objectMapper.readValue(packageJsonFile, PackageJson.class);
        if (parsedPackageJson != null) {
            this.packageJson = parsedPackageJson;
        }
        return this.packageJson;
    }

    public void writePackageJson(List<String> newWorkspaces, List<String> newProjectExtensionWorkspacePaths) throws IOException {
        File packageJsonFile = Paths.get(this.path + "/package.json", new String[0]).toFile();
        if (!packageJsonFile.exists()) {
            packageJsonFile.createNewFile();
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(packageJsonFile, "rw");){
            this.readPackageJson(randomAccessFile);
            newWorkspaces.forEach(this.packageJson::addWorkspace);
            if (this.packageJson.getWorkspaces() != null) {
                this.packageJson.getWorkspaces().sort(Comparator.naturalOrder());
            }
            if (!newProjectExtensionWorkspacePaths.isEmpty()) {
                ArrayList<String> projectExtensionWorkspacePaths;
                Map<String, Object> coremedia = this.packageJson.getCoremedia();
                if (coremedia == null) {
                    coremedia = new LinkedHashMap<String, Object>();
                }
                if ((projectExtensionWorkspacePaths = (ArrayList<String>)coremedia.get("projectExtensionWorkspacePaths")) == null) {
                    projectExtensionWorkspacePaths = new ArrayList<String>();
                }
                for (String newProjectExtensionWorkspacePath : newProjectExtensionWorkspacePaths) {
                    if (projectExtensionWorkspacePaths.contains(newProjectExtensionWorkspacePath)) continue;
                    projectExtensionWorkspacePaths.add(newProjectExtensionWorkspacePath);
                }
                projectExtensionWorkspacePaths.sort(Comparator.naturalOrder());
                coremedia.put("projectExtensionWorkspacePaths", projectExtensionWorkspacePaths);
                this.packageJson.setCoremedia(coremedia);
            }
            randomAccessFile.write(this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.packageJson).concat("\n").getBytes(StandardCharsets.UTF_8));
        }
    }
}

