/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jangaroo.apprunner.util.AppDeSerializer;
import net.jangaroo.apprunner.util.AppManifestDeSerializer;
import net.jangaroo.apprunner.util.DynamicPackagesDeSerializer;
import net.jangaroo.jooc.mvnplugin.AbstractLinkPackagesMojo;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="prepare-package-app-overlay", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PreparePackageAppOverlayMojo
extends AbstractLinkPackagesMojo {
    @Parameter(property="maven.compiler.migrateToTypeScript")
    private boolean migrateToTypeScript = false;
    @Parameter(defaultValue="${project.build.directory}/app", readonly=true)
    private File webResourcesOutputDirectory;

    public void execute() throws MojoExecutionException {
        if (!"jangaroo-app-overlay".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app-overlay\"");
        }
        this.packageAppOverlay(false);
    }

    void packageAppOverlay(boolean addOwnPackage) throws MojoExecutionException {
        File overlayPackagesDir = new File(this.webResourcesOutputDirectory, "packages");
        FileHelper.ensureDirectory(overlayPackagesDir);
        if (this.migrateToTypeScript) {
            return;
        }
        Path packagesPath = overlayPackagesDir.toPath().normalize();
        File remotePackagesDir = SenchaUtils.remotePackagesDir(this.session);
        AbstractSenchaMojo.JangarooAppOverlay jangarooAppOverlay = this.createJangarooAppOverlay(this.project);
        this.populatePackages(jangarooAppOverlay, this.project);
        Set<Artifact> ownDynamicPackages = jangarooAppOverlay.getOwnDynamicPackages();
        this.createSymbolicLinksForArtifacts(ownDynamicPackages, packagesPath, remotePackagesDir);
        Set<Artifact> allDynamicPackages = jangarooAppOverlay.getAllDynamicPackages();
        if (addOwnPackage) {
            allDynamicPackages.add(this.project.getArtifact());
            String senchaPackageName = SenchaUtils.getSenchaPackageName(this.project);
            File swcPackageDir = new File(this.project.getBuild().getDirectory(), SenchaUtils.getPackagesPath(this.project));
            Path swcPackagePath = swcPackageDir.toPath().normalize();
            this.createSymbolicLinkToPackage(overlayPackagesDir.toPath(), senchaPackageName, swcPackagePath);
        }
        Set<String> overlayPackageNames = allDynamicPackages.stream().map(artifact -> SenchaUtils.getSenchaPackageName(artifact.getGroupId(), artifact.getArtifactId())).collect(Collectors.toSet());
        this.writeDynamicPackagesJson(overlayPackageNames);
        AbstractSenchaMojo.JangarooApp rootBaseApp = jangarooAppOverlay.getRootBaseApp();
        if (rootBaseApp != null) {
            LinkedHashSet<String> locales;
            InputStream appJson = this.getInputStreamForDirOrJar(this.getArtifactFile(rootBaseApp.mavenProject), "app.json", "META-INF/resources/");
            try {
                locales = new LinkedHashSet<String>(AppDeSerializer.readLocales((InputStream)appJson));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not read locales", (Exception)e);
            }
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            AbstractSenchaMojo.JangarooApp current = jangarooAppOverlay;
            while (current != null) {
                artifacts.addAll(current.packages);
                if (current instanceof AbstractSenchaMojo.JangarooAppOverlay) {
                    current = current.baseApp;
                    continue;
                }
                current = null;
            }
            artifacts.add(this.getArtifact(rootBaseApp.mavenProject));
            this.writeAppManifestJsonByLocale(this.prepareAppManifestByLocale(locales, new ArrayList<Artifact>(artifacts)));
        }
    }

    private void populatePackages(AbstractSenchaMojo.JangarooApp jangarooApp, MavenProject project) throws MojoExecutionException {
        List dependencies = project.getDependencies();
        AbstractSenchaMojo.JangarooAppOverlay jangarooAppOverlay = jangarooApp instanceof AbstractSenchaMojo.JangarooAppOverlay ? (AbstractSenchaMojo.JangarooAppOverlay)jangarooApp : null;
        for (Dependency dependency : dependencies) {
            Artifact artifact = this.getArtifact(dependency);
            String scope = dependency.getScope();
            if (artifact != null) {
                scope = artifact.getScope();
            }
            if ("provided".equals(scope) || "test".equals(scope) || !SenchaUtils.isSenchaDependency(dependency) && !"pom".equals(dependency.getType()) && (!"jar".equals(dependency.getType()) || !"runtime".equals(scope))) continue;
            MavenProject mavenProject = this.getProjectFromDependency(project, dependency);
            if (jangarooAppOverlay != null && jangarooAppOverlay.baseApp != null && jangarooAppOverlay.baseApp.mavenProject.equals((Object)mavenProject)) {
                this.populatePackages(jangarooAppOverlay.baseApp, mavenProject);
                continue;
            }
            if (artifact != null && SenchaUtils.isSenchaDependency(dependency) && !jangarooApp.packages.add(artifact)) continue;
            this.populatePackages(jangarooApp, mavenProject);
        }
    }

    private void writeDynamicPackagesJson(Set<String> dynamicPackageNames) throws MojoExecutionException {
        File dynamicPackagesFile = this.prepareFile(new File(this.webResourcesOutputDirectory, "dynamic-packages.json"));
        try {
            DynamicPackagesDeSerializer.writeDynamicPackages((OutputStream)new FileOutputStream(dynamicPackagesFile), dynamicPackageNames);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create " + dynamicPackagesFile + " resource", (Exception)e);
        }
    }

    private void writeAppManifestJsonByLocale(Map<String, Map<String, Object>> appManifestByLocale) throws MojoExecutionException {
        for (String locale : appManifestByLocale.keySet()) {
            String appManifestFileName = this.getAppManifestFileNameForLocale(locale);
            File appManifestFile = this.prepareFile(new File(this.webResourcesOutputDirectory, appManifestFileName));
            try {
                AppManifestDeSerializer.writeAppManifest((OutputStream)new FileOutputStream(appManifestFile), appManifestByLocale.get(locale));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create " + appManifestFile + " resource", (Exception)e);
            }
        }
    }
}

