/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jangaroo.jooc.config.SearchAndReplace;
import net.jangaroo.jooc.mvnplugin.SearchAndReplaceConfiguration;
import net.jangaroo.jooc.mvnplugin.converter.AdditionalPackageJsonEntries;
import net.jangaroo.jooc.mvnplugin.converter.JangarooConfig;
import net.jangaroo.jooc.mvnplugin.converter.MavenModule;
import net.jangaroo.jooc.mvnplugin.converter.ModuleType;
import net.jangaroo.jooc.mvnplugin.converter.Package;
import net.jangaroo.jooc.mvnplugin.converter.PackageJson;
import net.jangaroo.jooc.mvnplugin.converter.PackageJsonPrettyPrinter;
import net.jangaroo.jooc.mvnplugin.converter.RootPackageJson;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.ConversionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="convert-workspace", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class WorkspaceConverterMojo
extends AbstractMojo {
    private static final Pattern EXTENSION_POINT_PATTERN = Pattern.compile("^(.+)-extension-dependencies$");
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceConverterMojo.class);
    @Parameter(property="convertedWorkspaceTarget", required=true)
    private String convertedWorkspaceTarget;
    @Parameter(property="npmPackageNameReplacers")
    private List<SearchAndReplaceConfiguration> npmPackageNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="npmPackageFolderNameReplacers")
    private List<SearchAndReplaceConfiguration> npmPackageFolderNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter(property="projectExtensionWorkspacePath")
    private File projectExtensionWorkspacePath;
    @Parameter(property="relativeProjectExtensionsPath", defaultValue="modules/extensions")
    private String relativeProjectExtensionsPath;
    @Parameter(property="relativeProjectExtensionPointsPath", defaultValue="modules/extension-config")
    private String relativeProjectExtensionPointsPath;
    @Parameter(property="relativeNpmProjectExtensionWorkspacePath", defaultValue="")
    private String relativeNpmProjectExtensionWorkspacePath;
    @Parameter(property="useTypesVersions")
    private boolean useTypesVersions = false;
    @Parameter
    private String packageType = "code";
    @Parameter
    private String theme;
    @Parameter
    private String applicationClass;
    @Parameter
    private String rootApp;
    @Parameter
    private String testSuite;
    @Parameter
    private Integer jooUnitTestExecutionTimeout;
    @Parameter
    private String extNamespace;
    @Parameter(property="extNamespaceRequired")
    private boolean extNamespaceRequired;
    @Parameter
    private String extSassNamespace;
    @Parameter
    private List<String> additionalLocales;
    @Parameter
    private List<String> additionalCssNonBundle;
    @Parameter
    private List<String> additionalJsNonBundle;
    @Parameter
    private List<String> additionalCssIncludeInBundle;
    @Parameter
    private List<String> additionalJsIncludeInBundle;
    @Parameter
    private Map<String, String> globalResourcesMap;
    private List<SearchAndReplace> resolvedNpmPackageNameReplacers;
    private List<SearchAndReplace> resolvedNpmPackageFolderNameReplacers;
    private ObjectMapper objectMapper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        Object scripts;
        TreeMap<String, String> devDependencies;
        Package dependencyPackage;
        if (this.extNamespace == null) {
            if (this.extNamespaceRequired && Arrays.asList("pkg", "swc", "jangaroo-app").contains(this.project.getPackaging())) {
                throw new MojoExecutionException("Flag 'extNamespaceRequired' was enabled but no 'extNamespace' was provided.");
            }
            this.extNamespace = "";
        }
        if (".".equals(this.extNamespace)) {
            this.extNamespace = "";
        }
        if (".".equals(this.extSassNamespace)) {
            this.extSassNamespace = "";
        }
        if (this.relativeNpmProjectExtensionWorkspacePath == null || ".".equals(this.relativeNpmProjectExtensionWorkspacePath)) {
            this.relativeNpmProjectExtensionWorkspacePath = "";
        }
        PackageJsonPrettyPrinter prettyPrinter = new PackageJsonPrettyPrinter();
        this.objectMapper = new ObjectMapper().setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.resolvedNpmPackageNameReplacers = this.npmPackageNameReplacers.stream().map(config -> new SearchAndReplace(Pattern.compile(config.getSearch()), config.getReplace())).collect(Collectors.toList());
        this.resolvedNpmPackageFolderNameReplacers = this.npmPackageFolderNameReplacers.stream().map(config -> new SearchAndReplace(Pattern.compile(config.getSearch()), config.getReplace())).collect(Collectors.toList());
        ArrayList<Package> packageRegistry = new ArrayList<Package>();
        packageRegistry.add(new Package("@coremedia/sencha-ext-charts", "7.2.0"));
        packageRegistry.add(new Package("@coremedia/sencha-ext", "7.2.0"));
        packageRegistry.add(new Package("@coremedia/sencha-ext-classic", "7.2.0"));
        packageRegistry.add(new Package("@coremedia/sencha-ext-classic-theme-triton", "7.2.0"));
        packageRegistry.add(new Package("@jangaroo/runtime", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/jangaroo-net", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/jooflash-core", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/jooflexframework", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/joounit", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/ext-ts", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/ckeditor4", "1.0.0"));
        ConversionUtils.NpmPackageMetadata npmPackageMetadata = this.getNpmPackageMetadata(this.project.getArtifact());
        String npmPackageName = npmPackageMetadata != null ? npmPackageMetadata.name : ConversionUtils.getNpmPackageName(this.project.getGroupId(), this.project.getArtifactId(), this.resolvedNpmPackageNameReplacers);
        TreeMap<String, MavenModule> modules = new TreeMap<String, MavenModule>();
        modules.put(npmPackageName, new MavenModule(this.project.getFile().getPath().replace("pom.xml", ""), this.project.getModel()));
        Optional<Package> optionalPackage = this.getOrCreatePackage(packageRegistry, npmPackageName, null, modules);
        if (!optionalPackage.isPresent()) {
            logger.info("Current Maven Project does not need to be converted.");
            return;
        }
        Package aPackage = optionalPackage.get();
        MavenModule mavenModule = (MavenModule)modules.get(aPackage.getName());
        if (mavenModule == null) {
            throw new MojoFailureException("An internal error occured during conversion.");
        }
        ModuleType moduleType = mavenModule.getModuleType();
        if (ModuleType.IGNORE.equals((Object)moduleType)) {
            logger.info("Skipping conversion of current Maven project as packaging cannot be handled.");
            return;
        }
        if (ModuleType.AGGREGATOR.equals((Object)moduleType) && this.getProjectExtensionPoint(mavenModule) == null) {
            logger.info("Skipping conversion of current Maven project as it is an aggregator. Dependencies of aggregators are moved to every package depending on the former aggregator as long as they are not marked as extension points.");
            return;
        }
        if (!new File(this.convertedWorkspaceTarget).exists()) {
            new File(this.convertedWorkspaceTarget).mkdirs();
        }
        String projectExtensionFor = this.getProjectExtensionFor(mavenModule);
        String projectExtensionPoint = this.getProjectExtensionPoint(mavenModule);
        String relativePackageFolderName = this.getPackageFolderName(aPackage.getName(), mavenModule);
        JangarooConfig jangarooConfig = new JangarooConfig();
        AdditionalPackageJsonEntries additionalJsonEntries = new AdditionalPackageJsonEntries();
        String targetPackageDir = this.convertedWorkspaceTarget + "/" + relativePackageFolderName;
        logger.info(String.format("Generating npm workspace for module %s to directory %s", mavenModule.getData().getArtifactId(), new File(targetPackageDir).getPath()));
        String targetPackageJson = targetPackageDir + "/package.json";
        if (moduleType == ModuleType.SWC) {
            jangarooConfig.setType(this.packageType);
            jangarooConfig.setExtName(String.format("%s__%s", mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId()));
            jangarooConfig.setExtNamespace(this.extNamespace);
            jangarooConfig.setExtSassNamespace(this.extSassNamespace);
            if (this.theme != null) {
                dependencyPackage = this.getDependencyPackageByRef(packageRegistry, this.theme);
                if (dependencyPackage == null) {
                    this.getLog().warn((CharSequence)String.format("Could not find theme dependency for %s which is configured in the jangaroo-maven-plugin configuration.", this.theme));
                } else {
                    jangarooConfig.setTheme(dependencyPackage.getName());
                }
            }
            jangarooConfig.setAdditionalCssIncludeInBundle(this.additionalCssIncludeInBundle);
            jangarooConfig.setAdditionalCssNonBundle(this.additionalCssNonBundle);
            jangarooConfig.setAdditionalJsIncludeInBundle(this.additionalJsIncludeInBundle);
            jangarooConfig.setAdditionalJsNonBundle(this.additionalJsNonBundle);
            jangarooConfig.setGlobalResourcesMap(this.globalResourcesMap);
            if (this.testSuite != null) {
                jangarooConfig.setTestSuite(this.testSuite);
                if (!this.extNamespace.isEmpty()) {
                    String extNamespaceWithTrailingDot = this.extNamespace.concat(".");
                    if (!jangarooConfig.getTestSuite().startsWith(extNamespaceWithTrailingDot)) {
                        logger.error(String.format("Invalid testSuite configuration \"jangarooConfig.testSuite\". When Using extNamespace \"%s\" the test suite cannot exist.", this.extNamespace));
                        return;
                    }
                    jangarooConfig.setTestSuite(jangarooConfig.getTestSuite().replace(extNamespaceWithTrailingDot, ""));
                }
            }
            if (this.jooUnitTestExecutionTimeout != null && this.jooUnitTestExecutionTimeout != 30000) {
                this.setCommandMapEntry(jangarooConfig, "joounit", "testExecutionTimeout", this.jooUnitTestExecutionTimeout);
            }
            if (new File(mavenModule.getDirectory().getPath() + "/package.json").exists()) {
                try {
                    jangarooConfig.setSencha(this.objectMapper.readValue(FileUtils.readFileToString((File)new File(mavenModule.getDirectory().getPath() + "/package.json")), Map.class));
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), e.getCause());
                }
            }
            TreeMap<String, String> testDependencies = new TreeMap<String, String>();
            LinkedHashMap<String, String> testScripts = new LinkedHashMap<String, String>();
            if (jangarooConfig.getTestSuite() != null) {
                testDependencies.put("@jangaroo/joounit", "^1.0.0-alpha");
                testDependencies.put("@coremedia/sencha-ext", "7.2.0");
                testDependencies.put("@coremedia/sencha-ext-classic", "7.2.0");
                testDependencies.put("@coremedia/sencha-ext-classic-locale", "7.2.0");
                testScripts.put("test", "jangaroo joounit");
            }
            TreeMap<String, String> dependencies = new TreeMap<String, String>();
            dependencies.put("@jangaroo/runtime", "^1.0.0-alpha");
            additionalJsonEntries.setDependencies(dependencies);
            TreeMap<String, String> devDependencies2 = new TreeMap<String, String>();
            devDependencies2.put("@jangaroo/core", "^1.0.0-alpha");
            devDependencies2.put("@jangaroo/build", "^1.0.0-alpha");
            devDependencies2.put("@jangaroo/publish", "^1.0.0-alpha");
            devDependencies2.putAll(testDependencies);
            devDependencies2.put("rimraf", "^3.0.2");
            additionalJsonEntries.setDevDependencies(devDependencies2);
            LinkedHashMap<String, String> scripts2 = new LinkedHashMap<String, String>();
            scripts2.put("clean", "rimraf ./dist && rimraf ./build");
            scripts2.put("build", "jangaroo build");
            scripts2.put("watch", "jangaroo watch");
            scripts2.put("publish", "jangaroo publish dist");
            scripts2.putAll(testScripts);
            additionalJsonEntries.setScripts(scripts2);
            if (this.useTypesVersions) {
                ArrayList<String> typesPaths = new ArrayList<String>();
                typesPaths.add("./src/*");
                HashMap<String, ArrayList<String>> allMapping = new HashMap<String, ArrayList<String>>();
                allMapping.put("*", typesPaths);
                HashMap<String, Object> typesVersions = new HashMap<String, Object>();
                typesVersions.put("*", allMapping);
                additionalJsonEntries.setTypesVersions(typesVersions);
            }
            ArrayList<String> ignoreFromSencha = new ArrayList<String>();
            ignoreFromSencha.add("package.json");
            CopyFromMavenResult copyFromMavenResult = null;
            try {
                copyFromMavenResult = this.copyCodeFromMaven(mavenModule.getDirectory().getPath(), Paths.get("target", "packages", String.format("%s__%s", mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId())).toString(), ignoreFromSencha, targetPackageDir);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
            if (copyFromMavenResult.hasSourceTsFiles || copyFromMavenResult.hasJooUnitTsFiles) {
                this.setCommandMapEntry(jangarooConfig, "build", "ignoreTypeErrors", true);
                devDependencies2.put("eslint", "7.27.0");
                ArrayList<String> eslintPatterns = new ArrayList<String>();
                if (copyFromMavenResult.hasSourceTsFiles) {
                    eslintPatterns.add("'src/**/*.ts'");
                }
                if (copyFromMavenResult.hasJooUnitTsFiles) {
                    eslintPatterns.add("'joounit/**/*.ts'");
                }
                scripts2.put("lint", "eslint --fix " + String.join((CharSequence)" ", eslintPatterns));
            }
            if (Paths.get(targetPackageDir, "src", "index.d.ts").toFile().exists()) {
                if (this.useTypesVersions) {
                    additionalJsonEntries.setTypes("index.d.ts");
                    additionalJsonEntries.addPublishOverride("types", "index.d.ts");
                } else {
                    additionalJsonEntries.setTypes("src/index.d.ts");
                    additionalJsonEntries.addPublishOverride("types", "src/index.d.ts");
                }
            }
            if (projectExtensionFor != null) {
                LinkedHashMap<String, Object> coremedia = new LinkedHashMap<String, Object>();
                coremedia.put("projectExtensionFor", this.renameLegacyProjectExtensionPoint(projectExtensionFor));
                additionalJsonEntries.setCoremedia(coremedia);
            }
        } else if (moduleType == ModuleType.JANGAROO_APP) {
            jangarooConfig.setType("app");
            this.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
            jangarooConfig.setExtNamespace(this.extNamespace);
            jangarooConfig.setExtSassNamespace(this.extSassNamespace);
            if (this.theme != null) {
                dependencyPackage = this.getDependencyPackageByRef(packageRegistry, this.theme);
                if (dependencyPackage == null) {
                    this.getLog().warn((CharSequence)String.format("Could not find theme dependency for %s which is configured in the jangaroo-maven-plugin configuration.", this.theme));
                } else {
                    jangarooConfig.setTheme(dependencyPackage.getName());
                }
            }
            jangarooConfig.setApplicationClass(this.applicationClass);
            jangarooConfig.setAdditionalLocales(this.additionalLocales);
            jangarooConfig.setAdditionalCssIncludeInBundle(this.additionalCssIncludeInBundle);
            jangarooConfig.setAdditionalCssNonBundle(this.additionalCssNonBundle);
            jangarooConfig.setAdditionalJsIncludeInBundle(this.additionalJsIncludeInBundle);
            jangarooConfig.setAdditionalJsNonBundle(this.additionalJsNonBundle);
            if (new File(mavenModule.getDirectory().getPath() + "/app.json").exists()) {
                try {
                    jangarooConfig.setSencha(this.objectMapper.readValue(FileUtils.readFileToString((File)new File(mavenModule.getDirectory().getPath() + "/app.json")), Map.class));
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), e.getCause());
                }
            }
            TreeMap<String, String> dependencies = new TreeMap<String, String>();
            dependencies.put("@coremedia/sencha-ext", "7.2.0");
            dependencies.put("@coremedia/sencha-ext-classic", "7.2.0");
            dependencies.put("@coremedia/sencha-ext-classic-locale", "7.2.0");
            dependencies.put("@jangaroo/runtime", "^1.0.0-alpha");
            additionalJsonEntries.setDependencies(dependencies);
            TreeMap<String, String> devDependencies3 = new TreeMap<String, String>();
            devDependencies3.put("@jangaroo/core", "^1.0.0-alpha");
            devDependencies3.put("@jangaroo/build", "^1.0.0-alpha");
            devDependencies3.put("@jangaroo/run", "^1.0.0-alpha");
            devDependencies3.put("rimraf", "^3.0.2");
            additionalJsonEntries.setDevDependencies(devDependencies3);
            LinkedHashMap<String, String> scripts3 = new LinkedHashMap<String, String>();
            scripts3.put("clean", "rimraf ./dist && rimraf ./build");
            scripts3.put("build", "jangaroo build");
            scripts3.put("watch", "jangaroo watch");
            scripts3.put("start", "jangaroo run");
            additionalJsonEntries.setScripts(scripts3);
            if (this.useTypesVersions) {
                ArrayList<String> typesPaths = new ArrayList<String>();
                typesPaths.add("./src/*");
                LinkedHashMap<String, ArrayList<String>> allMapping = new LinkedHashMap<String, ArrayList<String>>();
                allMapping.put("*", typesPaths);
                LinkedHashMap<String, Object> typesVersions = new LinkedHashMap<String, Object>();
                typesVersions.put("*", allMapping);
                additionalJsonEntries.setTypesVersions(typesVersions);
            }
            ArrayList<String> ignoreFromSencha = new ArrayList<String>();
            ignoreFromSencha.add("app.json");
            CopyFromMavenResult copyFromMavenResult = null;
            try {
                copyFromMavenResult = this.copyCodeFromMaven(mavenModule.getDirectory().getPath(), Paths.get("target", "app").toString(), ignoreFromSencha, targetPackageDir);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
            if (copyFromMavenResult.hasSourceTsFiles) {
                this.setCommandMapEntry(jangarooConfig, "build", "ignoreTypeErrors", true);
                devDependencies3.put("eslint", "^7.23.0");
                scripts3.put("lint", "eslint --fix 'src/**/*.ts'");
            }
        } else if (moduleType == ModuleType.JANGAROO_APP_OVERLAY) {
            jangarooConfig.setType("app-overlay");
            this.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
            devDependencies = new TreeMap<String, String>();
            devDependencies.put("@jangaroo/core", "^1.0.0-alpha");
            devDependencies.put("@jangaroo/build", "^1.0.0-alpha");
            devDependencies.put("@jangaroo/run", "^1.0.0-alpha");
            devDependencies.put("rimraf", "^3.0.2");
            additionalJsonEntries.setDevDependencies(devDependencies);
            scripts = new LinkedHashMap<String, String>();
            scripts.put("clean", "rimraf ./dist");
            scripts.put("build", "jangaroo build");
            scripts.put("watch", "jangaroo watch");
            scripts.put("start", "jangaroo run");
            additionalJsonEntries.setScripts((Map<String, String>)scripts);
        } else if (moduleType == ModuleType.JANGAROO_APPS) {
            jangarooConfig.setType("apps");
            this.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
            if (this.rootApp != null) {
                dependencyPackage = this.getDependencyPackageByRef(packageRegistry, this.rootApp);
                if (dependencyPackage == null) {
                    this.getLog().warn((CharSequence)String.format("Could not find rootApp dependency for %s which is configured in the jangaroo-maven-plugin configuration.", this.theme));
                } else {
                    jangarooConfig.setRootApp(dependencyPackage.getName());
                }
            }
            devDependencies = new TreeMap();
            devDependencies.put("@jangaroo/core", "^1.0.0-alpha");
            devDependencies.put("@jangaroo/build", "^1.0.0-alpha");
            devDependencies.put("@jangaroo/run", "^1.0.0-alpha");
            devDependencies.put("rimraf", "^3.0.2");
            additionalJsonEntries.setDevDependencies(devDependencies);
            scripts = new LinkedHashMap();
            scripts.put("clean", "rimraf ./dist");
            scripts.put("build", "jangaroo build");
            scripts.put("watch", "jangaroo watch");
            scripts.put((String)"start", (String)"jangaroo run");
            additionalJsonEntries.setScripts((Map<String, String>)scripts);
        } else if (moduleType == ModuleType.AGGREGATOR) {
            jangarooConfig.setType("code");
            devDependencies = new TreeMap();
            devDependencies.put("@jangaroo/core", "^1.0.0-alpha");
            devDependencies.put("@jangaroo/build", "^1.0.0-alpha");
            devDependencies.put("@jangaroo/publish", "^1.0.0-alpha");
            devDependencies.put("rimraf", "^3.0.2");
            additionalJsonEntries.setDevDependencies(devDependencies);
            scripts = new LinkedHashMap();
            scripts.put("clean", "rimraf ./dist && rimraf ./build");
            scripts.put("build", "jangaroo build");
            scripts.put("watch", "jangaroo watch");
            scripts.put("publish", "jangaroo publish dist");
            additionalJsonEntries.setScripts((Map<String, String>)scripts);
            if (projectExtensionPoint != null) {
                LinkedHashMap<String, Object> coremedia = new LinkedHashMap<String, Object>();
                coremedia.put("projectExtensionPoint", projectExtensionPoint);
                additionalJsonEntries.setCoremedia(coremedia);
            }
        } else {
            throw new MojoExecutionException("Unknown maven module type: " + (Object)((Object)moduleType));
        }
        List<String> appManifestPaths = this.match("glob:/**/app-manifest-fragment*.json", mavenModule.getDirectory().getPath());
        if (!appManifestPaths.isEmpty()) {
            for (String appManifestPath : appManifestPaths) {
                Matcher matcher;
                String fileName = new File(appManifestPath).getName();
                if ("app-manifest-fragment.json".equals(fileName)) {
                    fileName = "app-manifest-fragment-en.json";
                }
                if ((matcher = Pattern.compile("app-manifest-fragment-([^.]+).json").matcher(fileName)).find()) {
                    String locale = matcher.group(1);
                    try {
                        jangarooConfig.addAppManifest(locale, this.objectMapper.readValue(new File(appManifestPath), Map.class));
                    }
                    catch (IOException ioException) {
                        logger.error("error while reading manifest file: " + appManifestPath);
                    }
                    continue;
                }
                logger.error("Could not detect locale for manifest file: " + appManifestPath);
            }
        }
        try {
            String jangarooConfigDocument = "/** @type { import('@jangaroo/core').IJangarooConfig } */\nmodule.exports = ".concat(this.convertJangarooConfig(this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jangarooConfig).concat(";\n")));
            FileUtils.writeStringToFile((File)Paths.get(targetPackageDir, "jangaroo.config.js").toFile(), (String)jangarooConfigDocument);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
        if (jangarooConfig.getTheme() != null && !jangarooConfig.getTheme().isEmpty()) {
            Optional<Package> optionalThemeDependency = packageRegistry.stream().filter(somePackage -> somePackage.matches(jangarooConfig.getTheme(), null)).findFirst();
            optionalThemeDependency.ifPresent(value -> additionalJsonEntries.getDependencies().put(value.getName(), value.getVersion()));
        }
        PackageJson packageJson = new PackageJson(additionalJsonEntries);
        packageJson.setName(aPackage.getName());
        packageJson.setVersion(aPackage.getVersion());
        if (mavenModule.getData().getOrganization() != null) {
            packageJson.setAuthor(mavenModule.getData().getOrganization().getName());
        }
        packageJson.setLicense("MIT");
        packageJson.setPrivat(true);
        aPackage.getDependencies().stream().collect(Collectors.toMap(Package::getName, Package::getVersion)).forEach(packageJson::addDependency);
        aPackage.getDevDependencies().stream().collect(Collectors.toMap(Package::getName, Package::getVersion)).forEach(packageJson::addDevDependency);
        TreeMap<String, String> sortedDependencies = new TreeMap<String, String>();
        if (packageJson.getDependencies() != null) {
            packageJson.getDependencies().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                String cfr_ignored_0 = (String)sortedDependencies.put((String)entry.getKey(), (String)entry.getValue());
            });
        }
        packageJson.setDependencies(sortedDependencies);
        TreeMap<String, String> sortedDevDependencies = new TreeMap<String, String>();
        if (packageJson.getDevDependencies() != null) {
            packageJson.getDevDependencies().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                String cfr_ignored_0 = (String)sortedDevDependencies.put((String)entry.getKey(), (String)entry.getValue());
            });
        }
        packageJson.setDevDependencies(sortedDevDependencies);
        try {
            FileUtils.write((File)new File(targetPackageJson), (CharSequence)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)packageJson).concat("\n"));
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
        MavenExecutionRequest e = this.session.getRequest();
        synchronized (e) {
            RootPackageJson rootPackageJson = new RootPackageJson(this.objectMapper, this.convertedWorkspaceTarget);
            try {
                rootPackageJson.writePackageJson(Collections.singletonList(relativePackageFolderName), projectExtensionFor != null || projectExtensionPoint != null ? Collections.singletonList(this.relativeNpmProjectExtensionWorkspacePath) : Collections.emptyList());
            }
            catch (IOException e2) {
                throw new MojoFailureException(e2.getMessage(), e2.getCause());
            }
        }
        try {
            this.loadAndCopyResource("eslintrc.js", ".eslintrc.js");
            this.loadAndCopyResource("lerna.json", "lerna.json");
            this.loadAndCopyResource("gitignore", ".gitignore");
        }
        catch (IOException e2) {
            throw new MojoFailureException(e2.getMessage(), e2.getCause());
        }
    }

    private String getProjectExtensionPoint(MavenModule mavenModule) {
        String projectExtensionPoint;
        Matcher extensionPointMatcher = EXTENSION_POINT_PATTERN.matcher(mavenModule.getData().getArtifactId());
        String string = projectExtensionPoint = extensionPointMatcher.matches() ? extensionPointMatcher.group(1) : null;
        if (this.projectExtensionWorkspacePath == null && projectExtensionPoint != null) {
            logger.warn("Maven project is marked as extension point but projectExtensionWorkspacePath is missing. Ignoring marker...");
            return null;
        }
        return projectExtensionPoint;
    }

    private String getProjectExtensionFor(MavenModule mavenModule) {
        String projectExtensionFor = mavenModule.getData().getProperties().getProperty("coremedia.project.extension.for");
        if (this.projectExtensionWorkspacePath == null && projectExtensionFor != null) {
            logger.warn("Maven project is marked as extension but projectExtensionWorkspacePath is missing. Ignoring marker...");
            return null;
        }
        return projectExtensionFor;
    }

    private String renameLegacyProjectExtensionPoint(String projectExtensionPointName) {
        if ("studio".equals(projectExtensionPointName)) {
            return "studio-client";
        }
        if ("studio-dynamic".equals(projectExtensionPointName)) {
            return "studio-client-dynamic";
        }
        return projectExtensionPointName;
    }

    private boolean isProjectExtensionPointDependency(Dependency dependency) {
        boolean result;
        boolean bl = result = "pom".equals(dependency.getType()) && EXTENSION_POINT_PATTERN.matcher(dependency.getArtifactId()).matches();
        if (this.projectExtensionWorkspacePath == null && result) {
            logger.warn(String.format("Dependency %s is marked as project extension point but configuration 'projectExtensionWorkspacePath' is missing. Ignoring marker...", dependency));
            return false;
        }
        return result;
    }

    private Path getRelativePathBelowRoot(Path rootPath, Path absolutePathBelowRoot) {
        Path relativePath = rootPath.relativize(absolutePathBelowRoot).normalize();
        int depth = relativePath.getNameCount();
        if (depth >= 1 && !"..".equals(relativePath.getName(0).toString())) {
            return relativePath;
        }
        return null;
    }

    private void loadAndCopyResource(String resourceName, String fileName) throws IOException {
        Path filePath = Paths.get(this.convertedWorkspaceTarget, fileName);
        try (InputStream fileResource = ((Object)((Object)this)).getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/" + resourceName);){
            if (fileResource != null) {
                try {
                    Files.copy(fileResource, filePath, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
        }
    }

    private String getPackageFolderName(String packageName, MavenModule mavenModule) throws MojoExecutionException {
        if (this.projectExtensionWorkspacePath != null) {
            Path projectExtensionsPath = this.projectExtensionWorkspacePath.toPath().resolve(this.relativeProjectExtensionsPath);
            Path relativeProjectExtensionPath = this.getRelativePathBelowRoot(projectExtensionsPath, mavenModule.getDirectory().toPath());
            if (relativeProjectExtensionPath == null && this.getProjectExtensionFor(mavenModule) != null) {
                throw new MojoExecutionException("Maven project is marked as project extension but is not below the given project extensions path: " + projectExtensionsPath);
            }
            if (relativeProjectExtensionPath != null) {
                Path relativeNpmProjectExtensionsPath = Paths.get(this.relativeNpmProjectExtensionWorkspacePath, "extensions");
                Path packageFolderName = relativeProjectExtensionPath.getNameCount() > 1 ? relativeNpmProjectExtensionsPath.resolve(relativeProjectExtensionPath.subpath(0, relativeProjectExtensionPath.getNameCount() - 1)).resolve(packageName) : relativeNpmProjectExtensionsPath.resolve(relativeProjectExtensionPath);
                if (this.getRelativePathBelowRoot(relativeNpmProjectExtensionsPath, packageFolderName = Paths.get(this.getReplacedPackageFolderName(packageFolderName.toString()), new String[0])) == null) {
                    throw new MojoExecutionException(String.format("NPM package folder name has been replaced with %s. This path is not below the given project extensions path %s. The extensions workspace path can be configured using 'relativeNpmProjectExtensionWorkspacePath'", packageFolderName, projectExtensionsPath));
                }
                return packageFolderName.toString();
            }
            Path projectExtensionPointsPath = this.projectExtensionWorkspacePath.toPath().resolve(this.relativeProjectExtensionPointsPath);
            Path relativeProjectExtensionPointPath = this.getRelativePathBelowRoot(projectExtensionPointsPath, mavenModule.getDirectory().toPath());
            if (relativeProjectExtensionPointPath == null && this.getProjectExtensionPoint(mavenModule) != null) {
                throw new MojoExecutionException("Maven project is marked as project extension point but is not below the given project extension points path: " + projectExtensionPointsPath);
            }
            if (relativeProjectExtensionPointPath != null) {
                Path relativeNpmProjectExtensionPointsPath = Paths.get(this.relativeNpmProjectExtensionWorkspacePath, "extension-config");
                Path packageFolderName = relativeNpmProjectExtensionPointsPath.resolve(packageName);
                if (this.getRelativePathBelowRoot(relativeNpmProjectExtensionPointsPath, packageFolderName = Paths.get(this.getReplacedPackageFolderName(packageFolderName.toString()), new String[0])) == null) {
                    throw new MojoExecutionException(String.format("NPM package folder name has been replaced with %s. This path is not below the given project extension points path %s. The extensions workspace path can be configured using 'relativeNpmProjectExtensionWorkspacePath'.", packageFolderName, projectExtensionPointsPath));
                }
                return packageFolderName.toString();
            }
        }
        return this.getReplacedPackageFolderName(packageName);
    }

    private String getReplacedPackageFolderName(String packageFolderName) {
        for (SearchAndReplace searchAndReplace : this.resolvedNpmPackageFolderNameReplacers) {
            Matcher matcher = searchAndReplace.search.matcher(packageFolderName);
            if (!matcher.matches()) continue;
            return matcher.replaceAll(searchAndReplace.replace);
        }
        return packageFolderName;
    }

    private List<String> match(String glob, String location) {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(glob);
        final ArrayList<String> matchingFilePaths = new ArrayList<String>();
        try {
            Files.walkFileTree(Paths.get(location, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    if (pathMatcher.matches(path)) {
                        matchingFilePaths.add(path.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return matchingFilePaths;
    }

    private CopyFromMavenResult copyCodeFromMaven(String baseDirectory, String generatedExtModuleDirectory, List<String> ignoreFromSencha, String targetPackageDir) throws IOException {
        Path generatedSenchaSrc;
        Path jooUnitSourcePath;
        AtomicBoolean hasSourceTsFiles = new AtomicBoolean(false);
        AtomicBoolean hasJooUnitTsFiles = new AtomicBoolean(false);
        Path generatedSrc = Paths.get(baseDirectory, "target", "generated-sources", "joo");
        List generatedTsFiles = this.match("glob:/**/*.{as,mxml}", generatedSrc.toString()).stream().map(filePathStr -> filePathStr.replaceAll("[.](as|mxml)$", ".ts")).map(x$0 -> Paths.get(x$0, new String[0])).map(generatedSrc::relativize).filter(filePath -> {
            String filePathStr = filePath.toString();
            if (!filePathStr.endsWith("_properties.ts")) {
                return true;
            }
            String propertiesFile = filePathStr.replaceAll("_properties[.]ts$", ".properties");
            return !Paths.get(baseDirectory, "src", "main", "joo", propertiesFile).toFile().exists();
        }).map(filePath -> {
            if (!this.extNamespace.isEmpty()) {
                String slashedExtNamespaceWithTrailingSlash = this.extNamespace.concat(".").replaceAll("[.]", File.separator);
                return Paths.get(filePath.toString().replace(slashedExtNamespaceWithTrailingSlash, ""), new String[0]);
            }
            return filePath;
        }).collect(Collectors.toList());
        String srcFolderName = "src";
        String generatedFolderName = "generated";
        Path sourceDirPath = Paths.get(baseDirectory, generatedExtModuleDirectory, "src");
        if (sourceDirPath.toFile().exists() && sourceDirPath.toFile().isDirectory()) {
            Path targetDirPath = Paths.get(targetPackageDir, "sencha", "src");
            FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)targetDirPath.toFile(), pathname -> pathname.isDirectory() || !pathname.getName().endsWith(".ts"));
            targetDirPath = Paths.get(targetPackageDir, "src");
            FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)targetDirPath.toFile(), pathname -> {
                boolean isTsFile = pathname.getName().endsWith(".ts");
                if (isTsFile) {
                    hasSourceTsFiles.set(true);
                }
                return pathname.isDirectory() || isTsFile && !generatedTsFiles.contains(sourceDirPath.relativize(pathname.toPath()));
            });
            if (generatedTsFiles.size() > 0) {
                Path generatedTargetDirpath = Paths.get(targetPackageDir, "generated", "src");
                FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)generatedTargetDirpath.toFile(), pathname -> {
                    boolean isTsFile = pathname.getName().endsWith(".ts");
                    return pathname.isDirectory() || isTsFile && generatedTsFiles.contains(sourceDirPath.relativize(pathname.toPath()));
                });
            }
        }
        if ((jooUnitSourcePath = Paths.get(baseDirectory, "target", "test-classes", "src")).toFile().exists() && jooUnitSourcePath.toFile().isDirectory()) {
            Path jooUnitTargetDirPath = Paths.get(targetPackageDir, "joounit");
            FileUtils.copyDirectory((File)jooUnitSourcePath.toFile(), (File)jooUnitTargetDirPath.toFile(), pathname -> {
                boolean isTsFile;
                boolean bl = isTsFile = pathname.isFile() && pathname.getName().endsWith(".ts");
                if (isTsFile) {
                    hasJooUnitTsFiles.set(true);
                }
                return pathname.isDirectory() || isTsFile;
            });
        }
        ArrayList<String> fullIgnoreFromSrcMainSencha = new ArrayList<String>(ignoreFromSencha);
        for (String dir : Arrays.asList("sass/var", "sass/src")) {
            fullIgnoreFromSrcMainSencha.add(dir);
            Path sassDirPath = Paths.get(baseDirectory, generatedExtModuleDirectory, dir);
            if (!sassDirPath.toFile().exists() || !sassDirPath.toFile().isDirectory()) continue;
            Path targetDirPath = Paths.get(targetPackageDir, "sencha", dir);
            FileUtils.copyDirectory((File)sassDirPath.toFile(), (File)targetDirPath.toFile());
        }
        Path senchaSrc = Paths.get(baseDirectory, "src", "main", "sencha");
        if (senchaSrc.toFile().exists() && senchaSrc.toFile().isDirectory()) {
            FileUtils.copyDirectory((File)senchaSrc.toFile(), (File)Paths.get(targetPackageDir, "sencha").toFile(), pathname -> this.acceptFile(pathname, senchaSrc, fullIgnoreFromSrcMainSencha));
        }
        if ((generatedSenchaSrc = Paths.get(baseDirectory, "target", "generated-sencha")).toFile().exists() && generatedSenchaSrc.toFile().isDirectory()) {
            FileUtils.copyDirectory((File)generatedSenchaSrc.toFile(), (File)Paths.get(targetPackageDir, "generated", "sencha").toFile(), pathname -> this.acceptFile(pathname, generatedSenchaSrc, fullIgnoreFromSrcMainSencha));
        }
        return new CopyFromMavenResult(hasSourceTsFiles.get(), hasJooUnitTsFiles.get());
    }

    private boolean acceptFile(File file, Path srcMainSenchaPath, List<String> ignoreFromSrcMainSencha) {
        List collect = ignoreFromSrcMainSencha.stream().map(string -> Paths.get(srcMainSenchaPath.toString(), string)).collect(Collectors.toList());
        return collect.stream().noneMatch(path -> file.getPath().contains(path.toString()));
    }

    private Optional<Artifact> getDependencyArtifact(Dependency dependency) {
        return this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(dependency.getGroupId()) && artifact.getArtifactId().equals(dependency.getArtifactId())).findFirst();
    }

    private static Package findPackageInRegistry(List<Package> packageRegistry, String name) {
        return packageRegistry.stream().filter(pkg -> pkg.getName().equals(name)).findFirst().orElse(null);
    }

    private Package getDependencyPackageByRef(List<Package> packageRegistry, String ref) {
        Dependency dependency = SenchaUtils.getDependencyByRef(this.project, ref);
        if (dependency != null) {
            return this.getDependencyPackage(dependency);
        }
        if ("ext-classic".equals(ref)) {
            return WorkspaceConverterMojo.findPackageInRegistry(packageRegistry, "@coremedia/sencha-ext-classic");
        }
        if ("charts".equals(ref)) {
            return WorkspaceConverterMojo.findPackageInRegistry(packageRegistry, "@coremedia/sencha-ext-charts");
        }
        if (ref != null && ref.startsWith("theme-")) {
            return WorkspaceConverterMojo.findPackageInRegistry(packageRegistry, "@coremedia/sencha-ext-classic-" + ref);
        }
        return null;
    }

    private Package getDependencyPackage(Dependency dependency) {
        ConversionUtils.NpmPackageMetadata npmPackageMetadata = this.getNpmPackageMetadata(dependency);
        String dependencyPackageName = npmPackageMetadata != null ? npmPackageMetadata.name : ConversionUtils.getNpmPackageName(dependency.getGroupId(), dependency.getArtifactId(), this.resolvedNpmPackageNameReplacers);
        String dependencyPackageVersion = npmPackageMetadata != null ? npmPackageMetadata.version : ConversionUtils.getNpmPackageVersion(dependency.getVersion());
        return new Package(dependencyPackageName, WorkspaceConverterMojo.isJangarooDependency(dependency) ? "^1.0.0-alpha" : dependencyPackageVersion);
    }

    private ConversionUtils.NpmPackageMetadata getNpmPackageMetadata(Dependency dependency) {
        Optional<Artifact> optionalArtifact = this.getDependencyArtifact(dependency);
        return optionalArtifact.map(this::getNpmPackageMetadata).orElse(null);
    }

    private ConversionUtils.NpmPackageMetadata getNpmPackageMetadata(Artifact artifact) {
        Manifest manifest;
        if (artifact.getFile() == null) {
            return null;
        }
        try {
            manifest = new JarFile(artifact.getFile()).getManifest();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)String.format("Artifact %s could not be read!", artifact));
            return null;
        }
        if (manifest == null) {
            return null;
        }
        HashMap<String, String> entries = new HashMap<String, String>();
        for (Map.Entry<Object, Object> mainAttribute : manifest.getMainAttributes().entrySet()) {
            entries.put(mainAttribute.getKey().toString(), mainAttribute.getValue().toString());
        }
        return ConversionUtils.getNpmPackageMetadataFromManifestEntries(entries);
    }

    private Optional<Package> getOrCreateDependencyPackage(String name, Dependency dependency) {
        Optional<Artifact> optionalArtifact = this.getDependencyArtifact(dependency);
        if (!optionalArtifact.isPresent()) {
            return Optional.empty();
        }
        ModuleType moduleType = MavenModule.calculateModuleType(optionalArtifact.get().getArtifactHandler().getPackaging());
        if (moduleType == ModuleType.IGNORE) {
            return Optional.empty();
        }
        Model model = new Model();
        model.setGroupId(optionalArtifact.get().getGroupId());
        model.setArtifactId(optionalArtifact.get().getArtifactId());
        model.setPackaging(optionalArtifact.get().getArtifactHandler().getPackaging());
        model.setDependencies(this.project.getArtifacts().stream().filter(artifact -> this.inDependencyTrail(dependency, artifact.getDependencyTrail())).filter(artifact -> !artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId())).map(artifact -> {
            Dependency localDependency = new Dependency();
            localDependency.setArtifactId(artifact.getArtifactId());
            localDependency.setGroupId(artifact.getGroupId());
            localDependency.setScope(artifact.getScope());
            localDependency.setType(artifact.getType());
            localDependency.setVersion(artifact.getVersion());
            return localDependency;
        }).collect(Collectors.toList()));
        return Optional.of(this.handlePackageDependencies(name, new MavenModule("", model)));
    }

    private boolean inDependencyTrail(Dependency dependency, List<String> dependencyTrail) {
        return dependencyTrail.stream().map(dependencyPart -> dependencyPart.split(":")).filter(dependencySplit -> dependency.getGroupId().equals(dependencySplit[0])).anyMatch(dependencySplit -> dependency.getArtifactId().equals(dependencySplit[1]));
    }

    private Optional<Package> getOrCreatePackage(List<Package> packageRegistry, String packageName, String packageVersion, Map<String, MavenModule> moduleMappings) {
        Optional<Package> matchingPackage = packageRegistry.stream().filter(aPackage -> aPackage.matches(packageName, packageVersion)).findFirst();
        if (matchingPackage.isPresent()) {
            return matchingPackage;
        }
        MavenModule module = moduleMappings.get(packageName);
        if (module == null) {
            logger.error("could not find module {}", (Object)packageName);
            return Optional.empty();
        }
        if (module.getModuleType() == ModuleType.IGNORE) {
            return Optional.empty();
        }
        Package newPackage = this.handlePackageDependencies(packageName, module);
        packageRegistry.add(newPackage);
        return Optional.of(newPackage);
    }

    private Package handlePackageDependencies(String packageName, MavenModule mavenModule) {
        Package dependencyPackage;
        String newPackageVersion = ConversionUtils.getNpmPackageVersion(mavenModule.getVersion());
        ArrayList<Package> newDependencies = new ArrayList<Package>();
        ArrayList<Package> newDevDependencies = new ArrayList<Package>();
        List dependencies = mavenModule.getData().getDependencies().stream().filter(dependency -> !"test".equals(dependency.getScope())).filter(dependency -> !this.ignoreDependency((Dependency)dependency)).map(dependency -> {
            if ("${project.groupId}".equals(dependency.getGroupId())) {
                dependency.setGroupId(mavenModule.getData().getGroupId());
            }
            if ("${project.version}".equals(dependency.getVersion())) {
                dependency.setVersion(mavenModule.getVersion());
            }
            return dependency;
        }).collect(Collectors.toList());
        List testDependencies = mavenModule.getData().getDependencies().stream().filter(dependency -> "test".equals(dependency.getScope())).filter(dependency -> !this.ignoreDependency((Dependency)dependency)).map(dependency -> {
            if ("$(project.groupid)".equals(dependency.getGroupId())) {
                dependency.setGroupId(mavenModule.getData().getGroupId());
            }
            if ("${project.version}".equals(dependency.getVersion())) {
                dependency.setVersion(mavenModule.getVersion());
            }
            return dependency;
        }).collect(Collectors.toList());
        for (Dependency dependency2 : dependencies) {
            dependencyPackage = this.getDependencyPackage(dependency2);
            if (Arrays.asList("swc", "jar").contains(dependency2.getType()) || this.isProjectExtensionPointDependency(dependency2)) {
                newDependencies.add(dependencyPackage);
                continue;
            }
            if ((dependencyPackage = (Package)this.getOrCreateDependencyPackage(dependencyPackage.getName(), dependency2).orElse(null)) == null) continue;
            newDependencies.addAll(dependencyPackage.getDependencies());
        }
        for (Dependency dependency2 : testDependencies) {
            dependencyPackage = this.getDependencyPackage(dependency2);
            if (Arrays.asList("swc", "jar").contains(dependency2.getType())) {
                newDevDependencies.add(dependencyPackage);
                continue;
            }
            newDevDependencies.addAll(dependencyPackage.getDependencies());
        }
        return new Package(packageName, newPackageVersion, newDependencies, newDevDependencies);
    }

    private static boolean isJangarooDependency(Dependency dependency) {
        return Arrays.asList("net.jangaroo__jangaroo-browser", "net.jangaroo__ext-as", "net.jangaroo__jangaroo-net", "net.jangaroo__jangaroo-runtime", "net.jangaroo__jooflash-core", "net.jangaroo__jooflexframework", "net.jangaroo__joounit", "net.jangaroo__ckeditor4").contains(String.format("%s__%s", dependency.getGroupId(), dependency.getArtifactId()));
    }

    private boolean ignoreDependency(Dependency dependency) {
        return "net.jangaroo__jangaroo-browser".contains(String.format("%s__%s", dependency.getGroupId(), dependency.getArtifactId()));
    }

    private String convertJangarooConfig(String jangarooConfig) {
        return jangarooConfig.replaceAll("\"([a-zA-Z_$][0-9a-zA-Z_$]*)\":", "$1:").replace("}", "},").replace("]", "],").replace("\"\n", "\",\n").replace(",,", ",").replace(",;", ";");
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        int length = version.length();
        return length != 0 && version.split("\\.").length >= 3;
    }

    private void setCommandMapEntry(JangarooConfig jangarooConfig, String commandName, String entryName, Object entryValue) {
        Map<String, Map<String, Object>> commandsByName = jangarooConfig.getCommand();
        if (commandsByName == null) {
            commandsByName = new TreeMap<String, Map<String, Object>>();
            jangarooConfig.setCommand(commandsByName);
        }
        Map command = commandsByName.computeIfAbsent(commandName, k -> new LinkedHashMap());
        command.put(entryName, entryValue);
    }

    private static class CopyFromMavenResult {
        public final boolean hasSourceTsFiles;
        public final boolean hasJooUnitTsFiles;

        public CopyFromMavenResult(boolean hasSourceTsFiles, boolean hasJooUnitTsFiles) {
            this.hasSourceTsFiles = hasSourceTsFiles;
            this.hasJooUnitTsFiles = hasJooUnitTsFiles;
        }
    }
}

