/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package-apps", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageAppsMojo
extends AbstractSenchaMojo {
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AbstractSenchaMojo.JangarooApps jangarooApps = this.createJangarooApps(this.project);
        HashMap<String, List<File>> appNamesToDirsOrJars = new HashMap<String, List<File>>();
        for (AbstractSenchaMojo.JangarooApp jangarooApp : jangarooApps.apps) {
            String senchaAppName = SenchaUtils.getSenchaPackageName(jangarooApp.mavenProject);
            ArrayList<File> appReactorDirs = new ArrayList<File>();
            do {
                appReactorDirs.add(this.getAppDirOrJar(jangarooApp.mavenProject));
            } while ((jangarooApp = jangarooApp instanceof AbstractSenchaMojo.JangarooAppOverlay ? ((AbstractSenchaMojo.JangarooAppOverlay)jangarooApp).baseApp : null) != null);
            appNamesToDirsOrJars.put(senchaAppName, appReactorDirs);
        }
        Dependency rootApp = this.getRootApp();
        String rootAppName = rootApp == null ? null : SenchaUtils.getSenchaPackageName(rootApp.getGroupId(), rootApp.getArtifactId());
        FileHelper.createAppsJar(this.session, this.archiver, this.getManifestEntries(), this.artifactHandlerManager, null, null, appNamesToDirsOrJars, rootAppName);
    }
}

