/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import net.jangaroo.apprunner.util.AppManifestDeSerializer;
import net.jangaroo.jooc.config.SearchAndReplace;
import net.jangaroo.jooc.mvnplugin.SearchAndReplaceConfiguration;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.ConversionUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MergeHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

public abstract class AbstractSenchaMojo
extends AbstractMojo {
    protected static final MergeHelper.MergeOptions APP_MANIFEST_CROSS_MODULE_MERGE_STRATEGY = new MergeHelper.MergeOptions(MergeHelper.ListStrategy.APPEND, MergeHelper.MapStrategy.MERGE);
    protected static final MergeHelper.MergeOptions APP_MANIFEST_LOCALIZATION_MERGE_STRATEGY = new MergeHelper.MergeOptions(MergeHelper.ListStrategy.MERGE, MergeHelper.MapStrategy.MERGE);
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter
    private String toolkit = "classic";
    @Parameter(defaultValue="((net\\.jangaroo\\.com)|(com\\.coremedia))\\.sencha:ext-js(-pkg)?(-gpl)?")
    private String extFrameworkArtifactRegexp;
    @Parameter(property="senchaLogLevel")
    private String senchaLogLevel;
    @Parameter(property="senchaJvmArgs")
    private String senchaJvmArgs;
    @Parameter
    private String rootApp;
    @Parameter
    private List<SearchAndReplaceConfiguration> npmPackageNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    private volatile Pattern extFrameworkArtifactPattern;
    private Map<String, MavenProject> mavenProjectByDependencyCache = new HashMap<String, MavenProject>();
    private String npmPackageName;
    private String npmPackageVersion;

    public String getToolkit() {
        return this.toolkit;
    }

    public Pattern getExtFrameworkArtifactPattern() {
        if (this.extFrameworkArtifactPattern == null) {
            this.extFrameworkArtifactPattern = Pattern.compile(this.getExtFrameworkArtifactRegexp());
        }
        return this.extFrameworkArtifactPattern;
    }

    public String getExtFrameworkArtifactRegexp() {
        return this.extFrameworkArtifactRegexp;
    }

    public Dependency getRootApp() {
        if (this.rootApp == null || this.rootApp.isEmpty()) {
            return null;
        }
        return SenchaUtils.getDependencyByRef(this.project, this.rootApp);
    }

    private String getNpmPackageName() {
        if (this.npmPackageName == null) {
            List<SearchAndReplace> resolvedNpmPackageNameReplacers = ConversionUtils.getSearchAndReplace(this.npmPackageNameReplacers);
            this.npmPackageName = ConversionUtils.getNpmPackageName(this.project.getGroupId(), this.project.getArtifactId(), resolvedNpmPackageNameReplacers);
        }
        return this.npmPackageName;
    }

    private String getNpmPackageVersion() {
        if (this.npmPackageVersion == null) {
            this.npmPackageVersion = ConversionUtils.getNpmPackageVersion(this.project.getVersion());
        }
        return this.npmPackageVersion;
    }

    protected Map<String, String> getManifestEntries() {
        return ConversionUtils.getManifestEntries(this.getNpmPackageName(), this.getNpmPackageVersion());
    }

    public String getSenchaLogLevel() {
        return this.senchaLogLevel;
    }

    protected String getSenchaJvmArgs() {
        return this.senchaJvmArgs;
    }

    protected boolean isExtFrameworkArtifact(Artifact artifact) {
        return this.isExtFramework(artifact.getGroupId(), artifact.getArtifactId());
    }

    protected boolean isExtFrameworkDependency(Dependency dependency) {
        return this.isExtFramework(dependency.getGroupId(), dependency.getArtifactId());
    }

    private boolean isExtFramework(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        return this.getExtFrameworkArtifactPattern().matcher(key).matches();
    }

    @Nonnull
    MavenProject getProjectFromDependency(MavenProject project, Dependency dependency) throws MojoExecutionException {
        String key = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
        if (project.getProjectReferences().containsKey(key)) {
            return (MavenProject)project.getProjectReferences().get(key);
        }
        return this.createProjectFromDependency(dependency);
    }

    @Nonnull
    private MavenProject createProjectFromDependency(@Nonnull Dependency dependency) throws MojoExecutionException {
        String dependencyKey = dependency.toString();
        if (this.mavenProjectByDependencyCache.containsKey(dependencyKey)) {
            return this.mavenProjectByDependencyCache.get(dependencyKey);
        }
        this.getLog().debug((CharSequence)("createProjectFromDependency(" + dependency + ")"));
        Artifact artifactFromDependency = this.getArtifact(dependency);
        if (artifactFromDependency == null) {
            artifactFromDependency = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
        }
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        request.setValidationLevel(0);
        request.setProcessPlugins(false);
        request.setResolveDependencies(false);
        try {
            ProjectBuildingResult result = this.projectBuilder.build(artifactFromDependency, (ProjectBuildingRequest)request);
            MavenProject project = result.getProject();
            this.mavenProjectByDependencyCache.put(dependencyKey, project);
            return project;
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not resolve required dependencies of POM dependency " + artifactFromDependency, (Exception)((Object)e));
        }
    }

    Artifact getArtifact(Dependency dependency) {
        return this.getArtifact(dependency.getGroupId(), dependency.getArtifactId());
    }

    Artifact getArtifact(MavenProject mavenProject) {
        return this.getArtifact(mavenProject.getGroupId(), mavenProject.getArtifactId());
    }

    private Artifact getArtifact(String groupId, String artifactId) {
        String versionlessKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        return (Artifact)this.project.getArtifactMap().get(versionlessKey);
    }

    JangarooApp createJangarooApp(MavenProject project) throws MojoExecutionException {
        String packaging = project.getPackaging();
        if ("jangaroo-app".equals(packaging)) {
            return new JangarooApp(project);
        }
        if ("jangaroo-app-overlay".equals(packaging)) {
            return this.createJangarooAppOverlay(project);
        }
        return null;
    }

    JangarooAppOverlay createJangarooAppOverlay(MavenProject project) throws MojoExecutionException {
        List dependencies = project.getDependencies();
        for (Dependency dependency : dependencies) {
            MavenProject dependentProject;
            JangarooApp baseApp;
            if (!"jar".equals(dependency.getType()) || (baseApp = this.createJangarooApp(dependentProject = this.getProjectFromDependency(project, dependency))) == null) continue;
            return new JangarooAppOverlay(project, baseApp);
        }
        return new JangarooAppOverlay(project, null);
    }

    JangarooApps createJangarooApps(MavenProject project) throws MojoExecutionException {
        if ("jangaroo-apps".equals(project.getPackaging())) {
            LinkedHashSet<JangarooApp> apps = new LinkedHashSet<JangarooApp>();
            List dependencies = project.getDependencies();
            for (Dependency dependency : dependencies) {
                MavenProject dependentProject;
                JangarooApp baseApp;
                if (!"jar".equals(dependency.getType()) || (baseApp = this.createJangarooApp(dependentProject = this.getProjectFromDependency(project, dependency))) == null) continue;
                apps.add(baseApp);
            }
            return new JangarooApps(project, apps);
        }
        return null;
    }

    @Nonnull
    protected File getArtifactFile(MavenProject mavenProject) throws MojoExecutionException {
        Artifact appArtifact = this.getArtifact(mavenProject);
        if (appArtifact == null) {
            throw new MojoExecutionException("Artifact of app " + mavenProject + " not found in project dependencies.");
        }
        File appJarFile = appArtifact.getFile();
        if (appJarFile == null) {
            throw new MojoExecutionException("Artifact of app " + mavenProject + " has null file, cannot determine JAR location.");
        }
        if (appJarFile.isDirectory()) {
            throw new MojoExecutionException("Artifact of app " + mavenProject + " is a directory.");
        }
        return appJarFile;
    }

    @Nonnull
    protected File getAppDirOrJar(MavenProject mavenProject) throws MojoExecutionException {
        File appReactorDir = new File(mavenProject.getBuild().getDirectory() + "/app");
        if (appReactorDir.isDirectory()) {
            return appReactorDir;
        }
        return this.getArtifactFile(mavenProject);
    }

    protected InputStream getInputStreamForDirOrJar(File dirOrJar, String relativePathInsideDirOrJar, String jarPrefixPath) throws MojoExecutionException {
        if (dirOrJar.isDirectory()) {
            try {
                File file = dirOrJar.toPath().resolve(relativePathInsideDirOrJar).toFile();
                if (!file.exists()) {
                    return null;
                }
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        try {
            JarFile jarFile = new JarFile(dirOrJar);
            ZipEntry entry = jarFile.getEntry(jarPrefixPath + relativePathInsideDirOrJar);
            if (entry == null) {
                return null;
            }
            return jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading " + dirOrJar, (Exception)e);
        }
    }

    protected Map<String, Map<String, Object>> prepareAppManifestByLocale(Set<String> locales, List<Artifact> artifacts) throws MojoExecutionException {
        HashMap rawAppManifestByLocaleByArtifact = new HashMap();
        for (String locale : locales) {
            String appManifestFileName = this.getAppManifestFragmentFileNameForLocale(locale);
            for (Artifact artifact : artifacts) {
                Map localeAppManifest;
                String jarPrefixPath;
                String string = jarPrefixPath = "swc".equals(artifact.getType()) ? "META-INF/pkg/" : "META-INF/resources/";
                InputStream manifestInputStream = this.getInputStreamForDirOrJar(artifact.getFile(), appManifestFileName, jarPrefixPath);
                if (manifestInputStream == null) continue;
                try {
                    localeAppManifest = AppManifestDeSerializer.readAppManifest((InputStream)manifestInputStream);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not read app manifest", (Exception)e);
                }
                if (!rawAppManifestByLocaleByArtifact.containsKey(locale)) {
                    rawAppManifestByLocaleByArtifact.put(locale, new HashMap());
                }
                ((Map)rawAppManifestByLocaleByArtifact.get(locale)).put(artifact, localeAppManifest);
            }
        }
        HashMap<String, Map<String, Object>> appManifestByLocale = new HashMap<String, Map<String, Object>>();
        for (String locale : locales) {
            HashMap appManifest = new HashMap();
            for (Artifact artifact : artifacts) {
                HashMap localizedAppManifest = new HashMap();
                if (!"en".equals(locale) && rawAppManifestByLocaleByArtifact.containsKey("en") && ((Map)rawAppManifestByLocaleByArtifact.get("en")).containsKey(artifact)) {
                    MergeHelper.mergeMapIntoBaseMap(localizedAppManifest, (Map)((Map)rawAppManifestByLocaleByArtifact.get("en")).get(artifact), APP_MANIFEST_LOCALIZATION_MERGE_STRATEGY);
                }
                if (rawAppManifestByLocaleByArtifact.containsKey(locale) && ((Map)rawAppManifestByLocaleByArtifact.get(locale)).containsKey(artifact)) {
                    MergeHelper.mergeMapIntoBaseMap(localizedAppManifest, (Map)((Map)rawAppManifestByLocaleByArtifact.get(locale)).get(artifact), APP_MANIFEST_LOCALIZATION_MERGE_STRATEGY);
                }
                MergeHelper.mergeMapIntoBaseMap(appManifest, localizedAppManifest, APP_MANIFEST_CROSS_MODULE_MERGE_STRATEGY);
            }
            appManifestByLocale.put(locale, appManifest);
        }
        return appManifestByLocale;
    }

    protected File prepareFile(File file) throws MojoExecutionException {
        Path relativeFilePath = this.project.getBasedir().toPath().relativize(file.toPath());
        this.getLog().info((CharSequence)String.format("Writing %s for module %s.", relativeFilePath, this.project.getName()));
        if (!file.exists()) {
            FileHelper.ensureDirectory(file.getParentFile());
        } else {
            this.getLog().debug((CharSequence)(relativeFilePath + " for module already exists, deleting..."));
            if (!file.delete()) {
                throw new MojoExecutionException("Could not delete " + relativeFilePath + " file for module");
            }
        }
        return file;
    }

    @Nonnull
    protected String getAppManifestFileNameForLocale(String locale) {
        String appManifestFileName = "app-manifest.json";
        if (!"en".equals(locale)) {
            appManifestFileName = appManifestFileName.replace(".json", "-" + locale + ".json");
        }
        return appManifestFileName;
    }

    protected String getAppManifestFragmentFileNameForLocale(String locale) {
        String appManifestFileName = "app-manifest-fragment.json";
        if (!"en".equals(locale)) {
            appManifestFileName = appManifestFileName.replace(".json", "-" + locale + ".json");
        }
        return appManifestFileName;
    }

    static class JangarooApps {
        final MavenProject mavenProject;
        final Set<JangarooApp> apps;

        JangarooApps(MavenProject mavenProject, Set<JangarooApp> apps) {
            this.mavenProject = mavenProject;
            this.apps = apps;
        }
    }

    static class JangarooAppOverlay
    extends JangarooApp {
        final JangarooApp baseApp;

        JangarooAppOverlay(MavenProject mavenProject, JangarooApp baseApp) {
            super(mavenProject);
            this.baseApp = baseApp;
        }

        @Override
        JangarooApp getRootBaseApp() {
            return this.baseApp == null ? null : this.baseApp.getRootBaseApp();
        }

        Set<Artifact> getOwnDynamicPackages() {
            LinkedHashSet<Artifact> ownDynamicPackages = new LinkedHashSet<Artifact>(this.packages);
            if (this.baseApp != null) {
                ownDynamicPackages.removeAll(this.baseApp.packages);
            }
            return ownDynamicPackages;
        }

        Set<Artifact> getAllDynamicPackages() {
            LinkedHashSet<Artifact> allDynamicPackages = new LinkedHashSet<Artifact>(this.packages);
            JangarooApp rootBaseApp = this.getRootBaseApp();
            if (rootBaseApp != null) {
                allDynamicPackages.removeAll(rootBaseApp.packages);
            }
            return allDynamicPackages;
        }
    }

    static class JangarooApp {
        final MavenProject mavenProject;
        Set<Artifact> packages = new LinkedHashSet<Artifact>();

        JangarooApp(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
        }

        JangarooApp getRootBaseApp() {
            return this;
        }
    }
}

