/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.MavenPluginHelper;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project.build.directory}")
    private File targetDir;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    private File defaultManifestFile;
    @Parameter(defaultValue="${jar.useDefaultManifestFile}")
    private boolean useDefaultManifestFile;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Create the jangaroo archive and attach it to the project");
        boolean packageSwc = this.project.getPackaging().equals("swc");
        String extension = packageSwc ? "swc" : "pkg";
        File zipFile = new File(this.targetDir, this.finalName + '.' + extension);
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(this.archiver);
        mavenArchiver.configureReproducible(this.project.getProperties().getProperty("project.build.outputTimestamp"));
        mavenArchiver.setOutputFile(zipFile);
        try {
            if (this.archive.getManifestFile() == null) {
                if (this.useDefaultManifestFile && this.defaultManifestFile.exists()) {
                    this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
                    this.archive.setManifestFile(this.defaultManifestFile);
                } else {
                    this.archive.setManifestFile(MavenPluginHelper.createDefaultManifest(this.project));
                }
            }
            if (this.outputDirectory.exists()) {
                this.archiver.addDirectory(this.outputDirectory);
            }
            this.archiver.addFile(this.project.getFile(), "META-INF/maven/" + this.project.getGroupId() + "/" + this.project.getArtifactId() + "/pom.xml");
            DefaultFileSet fileSet = DefaultFileSet.fileSet((File)new File(this.targetDir + SenchaUtils.getPackagesPath(this.project)));
            if (packageSwc) {
                fileSet = (DefaultFileSet)fileSet.prefixed("META-INF/pkg/");
            }
            this.archiver.addFileSet((FileSet)fileSet);
            mavenArchiver.createArchive(this.mavenSession, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        Artifact mainArtifact = this.project.getArtifact();
        mainArtifact.setFile(zipFile);
        mainArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(extension));
    }
}

