/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.mvnplugin.util.PropertiesSourceMapping;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class MavenPluginHelper {
    public static final String META_INF_RESOURCES = "META-INF/resources/";
    public static final String META_INF_PKG = "META-INF/pkg/";
    private MavenProject project;
    private Log log;

    public MavenPluginHelper(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    @Nonnull
    public static File createDefaultManifest(MavenProject project) throws ManifestException, IOException, ArchiverException {
        Manifest manifest = new Manifest();
        Manifest.Attribute attr = new Manifest.Attribute("Created-By", "Apache Maven");
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Title", project.getName());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Vendor-Id", project.getGroupId());
        manifest.addConfiguredAttribute(attr);
        if (project.getOrganization() != null) {
            String vendor = project.getOrganization().getName();
            attr = new Manifest.Attribute("Implementation-Vendor", vendor);
            manifest.addConfiguredAttribute(attr);
        }
        attr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Class-Path", MavenPluginHelper.jangarooDependencies(project));
        manifest.addConfiguredAttribute(attr);
        File mf = File.createTempFile("maven", ".mf");
        mf.deleteOnExit();
        try (PrintWriter writer = new PrintWriter(new FileWriter(mf));){
            manifest.write(writer);
        }
        return mf;
    }

    private static String jangarooDependencies(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            if (!"swc".equals(artifact.getType())) continue;
            sb.append(artifact.getArtifactId()).append('-').append(artifact.getVersion()).append('.').append("swc").append(' ');
        }
        return sb.toString();
    }

    public List<File> computeStaleSources(List<File> compileSourceRoots, Set<String> includes, Set<String> excludes, File outputDirectory, String inputFileSuffix, String outputFileSuffix, int staleMillis) throws MojoExecutionException {
        return this.computeStaleSources(compileSourceRoots, includes, excludes, outputDirectory, inputFileSuffix, (SourceMapping)new SuffixMapping(inputFileSuffix, outputFileSuffix), staleMillis);
    }

    public List<File> computeStalePropertiesSources(List<File> compileSourceRoots, Set<String> includes, Set<String> excludes, File outputDirectory, int staleMillis) throws MojoExecutionException {
        return this.computeStaleSources(compileSourceRoots, includes, excludes, outputDirectory, ".properties", PropertiesSourceMapping.getInstance(), staleMillis);
    }

    private List<File> computeStaleSources(List<File> compileSourceRoots, Set<String> includes, Set<String> excludes, File outputDirectory, String inputFileSuffix, SourceMapping sourceMapping, int staleMillis) throws MojoExecutionException {
        SourceInclusionScanner scanner = this.createSourceInclusionScanner(includes, excludes, inputFileSuffix, staleMillis);
        scanner.addSourceMapping(sourceMapping);
        this.log.debug((CharSequence)"Searching for");
        LinkedHashSet staleSources = new LinkedHashSet();
        for (File rootFile : compileSourceRoots) {
            if (!rootFile.isDirectory()) continue;
            try {
                this.log.debug((CharSequence)("scanner.getIncludedSources(" + rootFile + ", " + outputDirectory + ")"));
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + rootFile.getAbsolutePath() + "' for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return Collections.unmodifiableList(new ArrayList(staleSources));
    }

    private SourceInclusionScanner createSourceInclusionScanner(Set<String> includes, Set<String> excludes, String inputFileSuffix, int staleMillis) {
        Set<String> includesOrDefaults = includes.isEmpty() ? Collections.singleton("**/*" + inputFileSuffix) : includes;
        StaleSourceScanner scanner = staleMillis >= 0 ? new StaleSourceScanner((long)staleMillis, includesOrDefaults, excludes) : new SimpleSourceInclusionScanner(includesOrDefaults, excludes);
        this.log.debug((CharSequence)("Using source inclusion scanner " + scanner));
        return scanner;
    }

    public List<File> getActionScriptClassPath(boolean includeTestScope) {
        ArrayList<File> classPath = new ArrayList<File>();
        Set dependencies = this.project.getArtifacts();
        for (Artifact dependency : dependencies) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " type: " + dependency.getType()));
            }
            if (dependency.isOptional() || !"compile".equals(dependency.getScope()) && !"provided".equals(dependency.getScope()) && (!includeTestScope || !"test".equals(dependency.getScope())) || !"swc".equals(dependency.getType())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("adding to classpath: compile dependency [" + dependency.toString() + "]"));
            }
            classPath.add(dependency.getFile());
        }
        File jooApiDir = new File(this.project.getBasedir(), "src/main/joo-api");
        if (jooApiDir.exists()) {
            classPath.add(0, jooApiDir);
        }
        return classPath;
    }

    private Artifact dependencyToArtifact(Dependency dependency) {
        return this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(dependency.getGroupId())).filter(artifact -> artifact.getArtifactId().equals(dependency.getArtifactId())).findFirst().orElse(null);
    }

    public List<File> getActionScriptCompilePath(boolean includeInTestScope) {
        return this.project.getDependencies().stream().map(this::dependencyToArtifact).filter(Objects::nonNull).filter(artifact -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Dependency: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " type: " + artifact.getType()));
            }
            if (!artifact.isOptional() && ("compile".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || includeInTestScope && "test".equals(artifact.getScope())) && "swc".equals(artifact.getType())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("adding to compile path: compile artifact [" + artifact.toString() + "]"));
                }
                return true;
            }
            return false;
        }).map(Artifact::getFile).collect(Collectors.toList());
    }

    public static void extractFileTemplate(File targetDirectory, File templateFile, String[] includes, String[] excludes, ArchiverManager archiverManager) throws MojoExecutionException {
        UnArchiver unArchiver;
        try {
            unArchiver = archiverManager.getUnArchiver("zip");
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No ZIP UnArchiver?!", (Exception)((Object)e));
        }
        unArchiver.setSourceFile(templateFile);
        unArchiver.setDestDirectory(targetDirectory);
        if (includes != null || excludes != null) {
            IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
            fileSelector.setIncludes(includes);
            fileSelector.setExcludes(excludes);
            unArchiver.setFileSelectors(new FileSelector[]{fileSelector});
        }
        unArchiver.extract();
    }

    @Nullable
    public static Artifact getArtifact(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactResolver artifactResolver, RepositorySystem repositorySystem, String groupId, String artifactId, String version, String scope, String type) throws MojoExecutionException {
        Artifact templateArtifact = repositorySystem.createArtifact(groupId, artifactId, version, scope, type);
        return MavenPluginHelper.getRealArtifact(localRepository, remoteRepositories, artifactResolver, templateArtifact);
    }

    @Nullable
    private static Artifact getRealArtifact(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactResolver artifactResolver, Artifact artifact) {
        ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
        artifactResolutionRequest.setArtifact(artifact);
        artifactResolutionRequest.setLocalRepository(localRepository);
        artifactResolutionRequest.setRemoteRepositories(remoteRepositories);
        ArtifactResolutionResult result = artifactResolver.resolve(artifactResolutionRequest);
        Set artifacts = result.getArtifacts();
        return artifacts.isEmpty() ? null : (Artifact)artifacts.iterator().next();
    }
}

