/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Package {
    private String name;
    private String version;
    private List<Package> dependencies;
    private List<Package> devDependencies;

    public Package(String name, String version, List<Package> dependencies, List<Package> devDependencies) {
        this.name = name;
        this.version = version;
        this.dependencies = dependencies;
        this.devDependencies = devDependencies;
    }

    public Package(String name, String version) {
        this.name = name;
        this.version = version;
        this.dependencies = new ArrayList<Package>();
        this.devDependencies = new ArrayList<Package>();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Package> getDependencies() {
        return this.dependencies;
    }

    public List<Package> getDevDependencies() {
        return this.devDependencies;
    }

    public void addAllDependencies(List<Package> newDependencies) {
        this.dependencies.addAll(newDependencies);
    }

    public void addDependency(Package newDependency) {
        this.dependencies.add(newDependency);
    }

    public void setDevDependencies(List<Package> devDependencies) {
        this.devDependencies = devDependencies;
    }

    public void addDevDependencie(Package devDependency) {
        this.dependencies.add(devDependency);
    }

    public Optional<Package> findDependency(String name, String version) {
        return this.dependencies.stream().filter(aPackage -> name.equals(aPackage.getName())).filter(aPackage -> version.equals(aPackage.getVersion())).findFirst();
    }

    public Optional<Package> findDevDependency(String name, String version) {
        return this.devDependencies.stream().filter(aPackage -> name.equals(aPackage.getName())).filter(aPackage -> version.equals(aPackage.getVersion())).findFirst();
    }

    public void removeDependency(@Nonnull String name, @Nonnull String version) {
        List<Package> matchingDependencies = this.dependencies.stream().filter(aPackage -> name.equals(aPackage.getName())).filter(aPackage -> version.equals(aPackage.getVersion())).collect(Collectors.toList());
        matchingDependencies.forEach(this.dependencies::remove);
    }

    public void removeDevDependency(@Nonnull String name, @Nonnull String version) {
        List<Package> matchingDependencies = this.devDependencies.stream().filter(aPackage -> name.equals(aPackage.getName())).filter(aPackage -> version.equals(aPackage.getVersion())).collect(Collectors.toList());
        matchingDependencies.forEach(this.dependencies::remove);
    }

    public boolean matches(String name, String version) {
        if (version != null) {
            return this.name.equals(name) && this.version.equals(version);
        }
        return this.name.equals(name);
    }
}

