/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jangaroo.jooc.config.SearchAndReplace;
import net.jangaroo.jooc.mvnplugin.SearchAndReplaceConfiguration;
import net.jangaroo.jooc.mvnplugin.converter.AdditionalPackageJsonEntries;
import net.jangaroo.jooc.mvnplugin.converter.JangarooConfig;
import net.jangaroo.jooc.mvnplugin.converter.MavenModule;
import net.jangaroo.jooc.mvnplugin.converter.ModuleType;
import net.jangaroo.jooc.mvnplugin.converter.Package;
import net.jangaroo.jooc.mvnplugin.converter.PackageJson;
import net.jangaroo.jooc.mvnplugin.converter.PackageJsonPrettyPrinter;
import net.jangaroo.jooc.mvnplugin.converter.RootPackageJson;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="convert-workspace", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class WorkspaceConverterMojo
extends AbstractMojo {
    private static final Pattern EXTENSION_POINT_PATTERN = Pattern.compile("^(.+)-extension-dependencies$");
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceConverterMojo.class);
    @Parameter(property="convertedWorkspaceTarget", required=true)
    private String convertedWorkspaceTarget;
    @Parameter
    private List<SearchAndReplaceConfiguration> npmPackageNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter
    private List<SearchAndReplaceConfiguration> npmPackageFolderNameReplacers = new ArrayList<SearchAndReplaceConfiguration>();
    @Parameter
    private boolean useTypesVersions = false;
    @Parameter
    private String packageType = "code";
    @Parameter
    private String theme;
    @Parameter
    private String applicationClass;
    @Parameter
    private String rootApp;
    @Parameter
    private String testSuite;
    @Parameter
    private Integer jooUnitTestExecutionTimeout;
    @Parameter
    private String extNamespace;
    @Parameter(property="extNamespaceRequired")
    private boolean extNamespaceRequired;
    @Parameter
    private String extSassNamespace;
    @Parameter
    private List<String> additionalLocales;
    @Parameter
    private List<String> additionalCssNonBundle;
    @Parameter
    private List<String> additionalJsNonBundle;
    @Parameter
    private List<String> additionalCssIncludeInBundle;
    @Parameter
    private List<String> additionalJsIncludeInBundle;
    @Parameter
    private Map<String, String> globalResourcesMap;
    private List<SearchAndReplace> resolvedNpmPackageNameReplacers;
    private List<SearchAndReplace> resolvedNpmPackageFolderNameReplacers;
    private ObjectMapper objectMapper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.extNamespace == null) {
            if (this.extNamespaceRequired && Arrays.asList("pkg", "swc", "jangaroo-app").contains(this.project.getPackaging())) {
                throw new MojoExecutionException("Flag 'extNamespaceRequired' was enabled but no 'extNamespace' was provided.");
            }
            this.extNamespace = "";
        }
        if (".".equals(this.extNamespace)) {
            this.extNamespace = "";
        }
        if (".".equals(this.extSassNamespace)) {
            this.extSassNamespace = "";
        }
        PackageJsonPrettyPrinter prettyPrinter = new PackageJsonPrettyPrinter();
        this.objectMapper = new ObjectMapper().setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.resolvedNpmPackageNameReplacers = this.npmPackageNameReplacers.stream().map(config -> new SearchAndReplace(Pattern.compile(config.getSearch()), config.getReplace())).collect(Collectors.toList());
        this.resolvedNpmPackageFolderNameReplacers = this.npmPackageFolderNameReplacers.stream().map(config -> new SearchAndReplace(Pattern.compile(config.getSearch()), config.getReplace())).collect(Collectors.toList());
        ArrayList<Package> packageRegistry = new ArrayList<Package>();
        packageRegistry.add(new Package("@coremedia/sencha-ext-charts", "7.2.0"));
        packageRegistry.add(new Package("@coremedia/sencha-ext", "7.2.0"));
        packageRegistry.add(new Package("@coremedia/sencha-ext-classic", "7.2.0"));
        packageRegistry.add(new Package("@coremedia/sencha-ext-classic-theme-triton", "7.2.0"));
        packageRegistry.add(new Package("@jangaroo/runtime", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/jangaroo-net", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/jooflash-core", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/jooflexframework", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/joounit", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/ext-ts", "1.0.0"));
        packageRegistry.add(new Package("@jangaroo/ckeditor4", "1.0.0"));
        Map<String, MavenModule> moduleMappings = this.loadMavenModule(this.project.getFile().getPath().replace("pom.xml", ""));
        Optional<Package> optionalPackage = this.getOrCreatePackage(packageRegistry, this.findPackageNameByReference(String.format("%s:%s", this.project.getGroupId(), this.project.getArtifactId()), moduleMappings), null, moduleMappings);
        if (!new File(this.convertedWorkspaceTarget).exists()) {
            new File(this.convertedWorkspaceTarget).mkdirs();
        }
        MavenExecutionRequest mavenExecutionRequest = this.session.getRequest();
        synchronized (mavenExecutionRequest) {
            RootPackageJson rootPackageJson = new RootPackageJson(this.objectMapper, this.convertedWorkspaceTarget);
            List<String> workspaces = moduleMappings.entrySet().stream().map(entry -> {
                if (ModuleType.IGNORE == ((MavenModule)entry.getValue()).getModuleType()) {
                    return null;
                }
                if (ModuleType.AGGREGATOR == ((MavenModule)entry.getValue()).getModuleType() && !this.isAggregatorToConvert(((MavenModule)entry.getValue()).getData())) {
                    return null;
                }
                return this.getPackageFolderName((String)entry.getKey());
            }).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                rootPackageJson.writePackageJson(workspaces);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
        }
        try {
            this.loadAndCopyResource("eslintrc.js", ".eslintrc.js");
            this.loadAndCopyResource("lerna.json", "lerna.json");
            this.loadAndCopyResource("gitignore", ".gitignore");
            this.loadAndCopyResource("npmrc", ".npmrc");
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
        ArrayList<String> excludePaths = new ArrayList<String>();
        if (!optionalPackage.isPresent()) {
            logger.warn("Package was null");
            return;
        }
        Package aPackage = optionalPackage.get();
        MavenModule mavenModule = moduleMappings.get(aPackage.getName());
        if (mavenModule != null && !ModuleType.IGNORE.equals((Object)mavenModule.getModuleType())) {
            Object scripts;
            TreeMap<String, String> devDependencies;
            String themePackageName;
            String packageFolderName = this.getPackageFolderName(aPackage.getName());
            String targetPackageDir = this.convertedWorkspaceTarget + "/" + packageFolderName;
            logger.info(String.format("Generating npm workspace for module %s to directory %s", mavenModule.getData().getArtifactId(), new File(targetPackageDir).getPath()));
            String targetPackageJson = targetPackageDir + "/package.json";
            excludePaths.add(targetPackageDir + "/dist");
            JangarooConfig jangarooConfig = new JangarooConfig();
            AdditionalPackageJsonEntries additionalJsonEntries = new AdditionalPackageJsonEntries();
            if (mavenModule.getModuleType() == ModuleType.SWC) {
                String projectExtensionFor;
                jangarooConfig.setType(this.packageType);
                jangarooConfig.setExtName(String.format("%s__%s", mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId()));
                jangarooConfig.setExtNamespace(this.extNamespace);
                jangarooConfig.setExtSassNamespace(this.extSassNamespace);
                if (this.theme != null) {
                    themePackageName = this.findPackageNameByReference(this.theme, moduleMappings);
                    jangarooConfig.setTheme(themePackageName);
                }
                jangarooConfig.setAdditionalCssIncludeInBundle(this.additionalCssIncludeInBundle);
                jangarooConfig.setAdditionalCssNonBundle(this.additionalCssNonBundle);
                jangarooConfig.setAdditionalJsIncludeInBundle(this.additionalJsIncludeInBundle);
                jangarooConfig.setAdditionalJsNonBundle(this.additionalJsNonBundle);
                jangarooConfig.setGlobalResourcesMap(this.globalResourcesMap);
                if (this.testSuite != null) {
                    jangarooConfig.setTestSuite(this.testSuite);
                    if (!this.extNamespace.isEmpty()) {
                        String extNamespaceWithTrailingDot = this.extNamespace.concat(".");
                        if (!jangarooConfig.getTestSuite().startsWith(extNamespaceWithTrailingDot)) {
                            logger.error(String.format("Invalid testSuite configuration \"jangarooConfig.testSuite\". When Using extNamespace \"%s\" the test suite cannot exist.", this.extNamespace));
                            return;
                        }
                        jangarooConfig.setTestSuite(jangarooConfig.getTestSuite().replace(extNamespaceWithTrailingDot, ""));
                    }
                }
                if (this.jooUnitTestExecutionTimeout != null) {
                    this.setCommandMapEntry(jangarooConfig, "joounit", "testExecutionTimeout", this.jooUnitTestExecutionTimeout);
                }
                if (new File(mavenModule.getDirectory().getPath() + "/package.json").exists()) {
                    try {
                        jangarooConfig.setSencha(this.objectMapper.readValue(FileUtils.readFileToString((File)new File(mavenModule.getDirectory().getPath() + "/package.json")), Map.class));
                    }
                    catch (IOException e) {
                        throw new MojoFailureException(e.getMessage(), e.getCause());
                    }
                }
                TreeMap<String, String> testDependencies = new TreeMap<String, String>();
                LinkedHashMap<String, String> testScripts = new LinkedHashMap<String, String>();
                if (jangarooConfig.getTestSuite() != null) {
                    excludePaths.add(targetPackageDir + "/build");
                    testDependencies.put("@jangaroo/joounit", "^1.0.0-alpha");
                    testDependencies.put("@coremedia/sencha-ext", "7.2.0");
                    testDependencies.put("@coremedia/sencha-ext-classic", "7.2.0");
                    testDependencies.put("@coremedia/sencha-ext-classic-locale", "7.2.0");
                    testScripts.put("test", "jangaroo joounit");
                }
                TreeMap<String, String> dependencies = new TreeMap<String, String>();
                dependencies.put("@jangaroo/runtime", "^1.0.0-alpha");
                additionalJsonEntries.setDependencies(dependencies);
                TreeMap<String, String> devDependencies2 = new TreeMap<String, String>();
                devDependencies2.put("@jangaroo/core", "^1.0.0-alpha");
                devDependencies2.put("@jangaroo/build", "^1.0.0-alpha");
                devDependencies2.put("@jangaroo/publish", "^1.0.0-alpha");
                devDependencies2.putAll(testDependencies);
                devDependencies2.put("rimraf", "^3.0.2");
                additionalJsonEntries.setDevDependencies(devDependencies2);
                LinkedHashMap<String, String> scripts2 = new LinkedHashMap<String, String>();
                scripts2.put("clean", "rimraf ./dist && rimraf ./build");
                scripts2.put("build", "jangaroo build");
                scripts2.put("watch", "jangaroo watch");
                scripts2.put("publish", "jangaroo publish dist");
                scripts2.putAll(testScripts);
                additionalJsonEntries.setScripts(scripts2);
                if (this.useTypesVersions) {
                    ArrayList<String> typesPaths = new ArrayList<String>();
                    typesPaths.add("./src/*");
                    HashMap<String, ArrayList<String>> allMapping = new HashMap<String, ArrayList<String>>();
                    allMapping.put("*", typesPaths);
                    HashMap<String, Object> typesVersions = new HashMap<String, Object>();
                    typesVersions.put("*", allMapping);
                    additionalJsonEntries.setTypesVersions(typesVersions);
                }
                ArrayList<String> ignoreFromSencha = new ArrayList<String>();
                ignoreFromSencha.add("package.json");
                CopyFromMavenResult copyFromMavenResult = null;
                try {
                    copyFromMavenResult = this.copyCodeFromMaven(mavenModule.getDirectory().getPath(), Paths.get("target", "packages", String.format("%s__%s", mavenModule.getData().getGroupId(), mavenModule.getData().getArtifactId())).toString(), ignoreFromSencha, targetPackageDir);
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), e.getCause());
                }
                if (copyFromMavenResult.hasSourceTsFiles || copyFromMavenResult.hasJooUnitTsFiles) {
                    devDependencies2.put("eslint", "^7.23.0");
                    ArrayList<String> eslintPatterns = new ArrayList<String>();
                    if (copyFromMavenResult.hasSourceTsFiles) {
                        eslintPatterns.add("'src/**/*.ts'");
                    }
                    if (copyFromMavenResult.hasJooUnitTsFiles) {
                        eslintPatterns.add("'joounit/**/*.ts'");
                    }
                    scripts2.put("lint", "eslint --fix " + String.join((CharSequence)" ", eslintPatterns));
                }
                if (Paths.get(targetPackageDir, "src", "index.d.ts").toFile().exists()) {
                    if (this.useTypesVersions) {
                        additionalJsonEntries.setTypes("index.d.ts");
                        additionalJsonEntries.addPublishOverride("types", "index.d.ts");
                    } else {
                        additionalJsonEntries.setTypes("src/index.d.ts");
                        additionalJsonEntries.addPublishOverride("types", "src/index.d.ts");
                    }
                }
                if ((projectExtensionFor = mavenModule.getData().getProperties().getProperty("coremedia.project.extension.for")) != null) {
                    LinkedHashMap<String, Object> coremedia = new LinkedHashMap<String, Object>();
                    coremedia.put("projectExtensionFor", this.renameLegacyExtensionPoint(projectExtensionFor));
                    additionalJsonEntries.setCoremedia(coremedia);
                }
            } else if (mavenModule.getModuleType() == ModuleType.JANGAROO_APP) {
                excludePaths.add(targetPackageDir + "/build");
                jangarooConfig.setType("app");
                this.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
                jangarooConfig.setExtNamespace(this.extNamespace);
                jangarooConfig.setExtSassNamespace(this.extSassNamespace);
                if (this.theme != null) {
                    themePackageName = this.findPackageNameByReference(this.theme, moduleMappings);
                    jangarooConfig.setTheme(themePackageName);
                }
                jangarooConfig.setApplicationClass(this.applicationClass);
                jangarooConfig.setAdditionalLocales(this.additionalLocales);
                jangarooConfig.setAdditionalCssIncludeInBundle(this.additionalCssIncludeInBundle);
                jangarooConfig.setAdditionalCssNonBundle(this.additionalCssNonBundle);
                jangarooConfig.setAdditionalJsIncludeInBundle(this.additionalJsIncludeInBundle);
                jangarooConfig.setAdditionalJsNonBundle(this.additionalJsNonBundle);
                if (new File(mavenModule.getDirectory().getPath() + "/app.json").exists()) {
                    try {
                        jangarooConfig.setSencha(this.objectMapper.readValue(FileUtils.readFileToString((File)new File(mavenModule.getDirectory().getPath() + "/app.json")), Map.class));
                    }
                    catch (IOException e) {
                        throw new MojoFailureException(e.getMessage(), e.getCause());
                    }
                }
                TreeMap<String, String> dependencies = new TreeMap<String, String>();
                dependencies.put("@coremedia/sencha-ext", "7.2.0");
                dependencies.put("@coremedia/sencha-ext-classic", "7.2.0");
                dependencies.put("@coremedia/sencha-ext-classic-locale", "7.2.0");
                dependencies.put("@jangaroo/runtime", "^1.0.0-alpha");
                additionalJsonEntries.setDependencies(dependencies);
                TreeMap<String, String> devDependencies3 = new TreeMap<String, String>();
                devDependencies3.put("@jangaroo/core", "^1.0.0-alpha");
                devDependencies3.put("@jangaroo/build", "^1.0.0-alpha");
                devDependencies3.put("@jangaroo/run", "^1.0.0-alpha");
                devDependencies3.put("rimraf", "^3.0.2");
                additionalJsonEntries.setDevDependencies(devDependencies3);
                LinkedHashMap<String, String> scripts3 = new LinkedHashMap<String, String>();
                scripts3.put("clean", "rimraf ./dist && rimraf ./build");
                scripts3.put("build", "jangaroo build");
                scripts3.put("watch", "jangaroo watch");
                scripts3.put("start", "jangaroo run");
                additionalJsonEntries.setScripts(scripts3);
                if (this.useTypesVersions) {
                    ArrayList<String> typesPaths = new ArrayList<String>();
                    typesPaths.add("./src/*");
                    LinkedHashMap<String, ArrayList<String>> allMapping = new LinkedHashMap<String, ArrayList<String>>();
                    allMapping.put("*", typesPaths);
                    LinkedHashMap<String, Object> typesVersions = new LinkedHashMap<String, Object>();
                    typesVersions.put("*", allMapping);
                    additionalJsonEntries.setTypesVersions(typesVersions);
                }
                ArrayList<String> ignoreFromSencha = new ArrayList<String>();
                ignoreFromSencha.add("app.json");
                CopyFromMavenResult copyFromMavenResult = null;
                try {
                    copyFromMavenResult = this.copyCodeFromMaven(mavenModule.getDirectory().getPath(), Paths.get("target", "app").toString(), ignoreFromSencha, targetPackageDir);
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), e.getCause());
                }
                if (copyFromMavenResult.hasSourceTsFiles) {
                    devDependencies3.put("eslint", "^7.23.0");
                    scripts3.put("lint", "eslint --fix 'src/**/*.ts'");
                }
            } else if (mavenModule.getModuleType() == ModuleType.JANGAROO_APP_OVERLAY) {
                excludePaths.add(targetPackageDir + "/build");
                jangarooConfig.setType("app-overlay");
                this.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
                devDependencies = new TreeMap();
                devDependencies.put("@jangaroo/core", "^1.0.0-alpha");
                devDependencies.put("@jangaroo/build", "^1.0.0-alpha");
                devDependencies.put("@jangaroo/run", "^1.0.0-alpha");
                devDependencies.put("rimraf", "^3.0.2");
                additionalJsonEntries.setDevDependencies(devDependencies);
                scripts = new LinkedHashMap();
                scripts.put("clean", "rimraf ./dist");
                scripts.put("build", "jangaroo build");
                scripts.put("watch", "jangaroo watch");
                scripts.put("start", "jangaroo run");
                additionalJsonEntries.setScripts((Map<String, String>)scripts);
            } else if (mavenModule.getModuleType() == ModuleType.JANGAROO_APPS) {
                String[] splitName;
                excludePaths.add(targetPackageDir + "/build");
                jangarooConfig.setType("apps");
                this.setCommandMapEntry(jangarooConfig, "run", "proxyPathSpec", "/rest/");
                if (this.rootApp != null && !this.rootApp.isEmpty() && (splitName = this.rootApp.split(":")).length == 2) {
                    jangarooConfig.setRootApp(this.calculateMavenName(splitName[0], splitName[1]));
                }
                devDependencies = new TreeMap();
                devDependencies.put("@jangaroo/core", "^1.0.0-alpha");
                devDependencies.put("@jangaroo/build", "^1.0.0-alpha");
                devDependencies.put("@jangaroo/run", "^1.0.0-alpha");
                devDependencies.put("rimraf", "^3.0.2");
                additionalJsonEntries.setDevDependencies(devDependencies);
                scripts = new LinkedHashMap();
                scripts.put("clean", "rimraf ./dist");
                scripts.put("build", "jangaroo build");
                scripts.put((String)"watch", (String)"jangaroo watch");
                scripts.put((String)"start", (String)"jangaroo run");
                additionalJsonEntries.setScripts((Map<String, String>)scripts);
            } else if (mavenModule.getModuleType() == ModuleType.AGGREGATOR && this.isAggregatorToConvert(mavenModule.getData())) {
                jangarooConfig.setType("code");
                devDependencies = new TreeMap<String, String>();
                devDependencies.put("@jangaroo/core", "^1.0.0-alpha");
                devDependencies.put("@jangaroo/build", "^1.0.0-alpha");
                devDependencies.put("@jangaroo/publish", "^1.0.0-alpha");
                devDependencies.put("rimraf", "^3.0.2");
                additionalJsonEntries.setDevDependencies(devDependencies);
                scripts = new LinkedHashMap<String, String>();
                scripts.put("clean", "rimraf ./dist && rimraf ./build");
                scripts.put("build", "jangaroo build");
                scripts.put("watch", "jangaroo watch");
                scripts.put("publish", "jangaroo publish dist");
                additionalJsonEntries.setScripts((Map<String, String>)scripts);
                Matcher matcher = EXTENSION_POINT_PATTERN.matcher(mavenModule.getData().getArtifactId());
                if (matcher.matches()) {
                    LinkedHashMap<String, Object> coremedia = new LinkedHashMap<String, Object>();
                    coremedia.put("projectExtensionPoint", matcher.group(1));
                    additionalJsonEntries.setCoremedia(coremedia);
                }
            } else {
                return;
            }
            List<String> appManifestPaths = this.match("glob:/**/app-manifest-fragment*.json", mavenModule.getDirectory().getPath());
            if (!appManifestPaths.isEmpty()) {
                for (String appManifestPath : appManifestPaths) {
                    Matcher matcher;
                    String fileName = new File(appManifestPath).getName();
                    if ("app-manifest-fragment.json".equals(fileName)) {
                        fileName = "app-manifest-fragment-en.json";
                    }
                    if ((matcher = Pattern.compile("app-manifest-fragment-([^.]+).json").matcher(fileName)).find()) {
                        String locale = matcher.group(1);
                        try {
                            jangarooConfig.addAppManifest(locale, this.objectMapper.readValue(new File(appManifestPath), Map.class));
                        }
                        catch (IOException ioException) {
                            logger.error("error while reading manifest file: " + appManifestPath);
                        }
                        continue;
                    }
                    logger.error("Could not detect locale for manifest file: " + appManifestPath);
                }
            }
            try {
                String jangarooConfigDocument = "/** @type { import('@jangaroo/core').IJangarooConfig } */\nmodule.exports = ".concat(this.convertJangarooConfig(this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jangarooConfig).concat(";\n")));
                FileUtils.writeStringToFile((File)Paths.get(targetPackageDir, "jangaroo.config.js").toFile(), (String)jangarooConfigDocument);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
            if (jangarooConfig.getTheme() != null && !jangarooConfig.getTheme().isEmpty()) {
                Optional<Package> optionalThemeDependency = packageRegistry.stream().filter(somePackage -> somePackage.matches(jangarooConfig.getTheme(), null)).findFirst();
                optionalThemeDependency.ifPresent(value -> additionalJsonEntries.getDependencies().put(value.getName(), value.getVersion()));
            }
            PackageJson packageJson = new PackageJson(additionalJsonEntries);
            packageJson.setName(aPackage.getName());
            packageJson.setVersion(aPackage.getVersion());
            if (mavenModule.getData().getOrganization() != null) {
                packageJson.setAuthor(mavenModule.getData().getOrganization().getName());
            }
            packageJson.setLicense("MIT");
            packageJson.setPrivat(true);
            aPackage.getDependencies().stream().collect(Collectors.toMap(Package::getName, Package::getVersion)).forEach(packageJson::addDependency);
            aPackage.getDevDependencies().stream().collect(Collectors.toMap(Package::getName, Package::getVersion)).forEach(packageJson::addDevDependency);
            TreeMap<String, String> sortedDependencies = new TreeMap<String, String>();
            if (packageJson.getDependencies() != null) {
                packageJson.getDependencies().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    String cfr_ignored_0 = (String)sortedDependencies.put((String)entry.getKey(), (String)entry.getValue());
                });
            }
            packageJson.setDependencies(sortedDependencies);
            TreeMap<String, String> sortedDevDependencies = new TreeMap<String, String>();
            if (packageJson.getDevDependencies() != null) {
                packageJson.getDevDependencies().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    String cfr_ignored_0 = (String)sortedDevDependencies.put((String)entry.getKey(), (String)entry.getValue());
                });
            }
            packageJson.setDevDependencies(sortedDevDependencies);
            try {
                FileUtils.write((File)new File(targetPackageJson), (CharSequence)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)packageJson).concat("\n"));
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), e.getCause());
            }
        }
    }

    private void loadAndCopyResource(String resourceName, String fileName) throws IOException {
        Path filePath = Paths.get(this.convertedWorkspaceTarget, fileName);
        try (InputStream fileResource = ((Object)((Object)this)).getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/" + resourceName);){
            if (fileResource != null) {
                try {
                    Files.copy(fileResource, filePath, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
        }
    }

    private String getPackageFolderName(String packageName) {
        String packageFolderName = packageName;
        for (SearchAndReplace searchAndReplace : this.resolvedNpmPackageFolderNameReplacers) {
            Matcher matcher = searchAndReplace.search.matcher(packageFolderName);
            if (!matcher.matches()) continue;
            packageFolderName = matcher.replaceAll(searchAndReplace.replace);
            break;
        }
        return packageFolderName;
    }

    private List<String> match(String glob, String location) {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(glob);
        final ArrayList<String> matchingFilePaths = new ArrayList<String>();
        try {
            Files.walkFileTree(Paths.get(location, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    if (pathMatcher.matches(path)) {
                        matchingFilePaths.add(path.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return matchingFilePaths;
    }

    private CopyFromMavenResult copyCodeFromMaven(String baseDirectory, String generatedExtModuleDirectory, List<String> ignoreFromSencha, String targetPackageDir) throws IOException {
        Path generatedSenchaSrc;
        Path jooUnitSourcePath;
        AtomicBoolean hasSourceTsFiles = new AtomicBoolean(false);
        AtomicBoolean hasJooUnitTsFiles = new AtomicBoolean(false);
        Path generatedSrc = Paths.get(baseDirectory, "target", "generated-sources", "joo");
        List generatedTsFiles = this.match("glob:/**/*.{as,mxml}", generatedSrc.toString()).stream().map(filePathStr -> filePathStr.replaceAll("[.](as|mxml)$", ".ts")).map(x$0 -> Paths.get(x$0, new String[0])).map(generatedSrc::relativize).filter(filePath -> {
            String filePathStr = filePath.toString();
            if (!filePathStr.endsWith("_properties.ts")) {
                return true;
            }
            String propertiesFile = filePathStr.replaceAll("_properties[.]ts$", ".properties");
            return !Paths.get(baseDirectory, "src", "main", "joo", propertiesFile).toFile().exists();
        }).map(filePath -> {
            if (!this.extNamespace.isEmpty()) {
                String slashedExtNamespaceWithTrailingSlash = this.extNamespace.concat(".").replaceAll("[.]", File.separator);
                return Paths.get(filePath.toString().replace(slashedExtNamespaceWithTrailingSlash, ""), new String[0]);
            }
            return filePath;
        }).collect(Collectors.toList());
        String srcFolderName = "src";
        String generatedFolderName = "generated";
        Path sourceDirPath = Paths.get(baseDirectory, generatedExtModuleDirectory, "src");
        if (sourceDirPath.toFile().exists() && sourceDirPath.toFile().isDirectory()) {
            Path targetDirPath = Paths.get(targetPackageDir, "sencha", "src");
            FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)targetDirPath.toFile(), pathname -> pathname.isDirectory() || !pathname.getName().endsWith(".ts"));
            targetDirPath = Paths.get(targetPackageDir, "src");
            FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)targetDirPath.toFile(), pathname -> {
                boolean isTsFile = pathname.getName().endsWith(".ts");
                if (isTsFile) {
                    hasSourceTsFiles.set(true);
                }
                return pathname.isDirectory() || isTsFile && !generatedTsFiles.contains(sourceDirPath.relativize(pathname.toPath()));
            });
            if (generatedTsFiles.size() > 0) {
                Path generatedTargetDirpath = Paths.get(targetPackageDir, "generated", "src");
                FileUtils.copyDirectory((File)sourceDirPath.toFile(), (File)generatedTargetDirpath.toFile(), pathname -> {
                    boolean isTsFile = pathname.getName().endsWith(".ts");
                    return pathname.isDirectory() || isTsFile && generatedTsFiles.contains(sourceDirPath.relativize(pathname.toPath()));
                });
            }
        }
        if ((jooUnitSourcePath = Paths.get(baseDirectory, "target", "test-classes", "src")).toFile().exists() && jooUnitSourcePath.toFile().isDirectory()) {
            Path jooUnitTargetDirPath = Paths.get(targetPackageDir, "joounit");
            FileUtils.copyDirectory((File)jooUnitSourcePath.toFile(), (File)jooUnitTargetDirPath.toFile(), pathname -> {
                boolean isTsFile;
                boolean bl = isTsFile = pathname.isFile() && pathname.getName().endsWith(".ts");
                if (isTsFile) {
                    hasJooUnitTsFiles.set(true);
                }
                return pathname.isDirectory() || isTsFile;
            });
        }
        ArrayList<String> fullIgnoreFromSrcMainSencha = new ArrayList<String>(ignoreFromSencha);
        for (String dir : Arrays.asList("sass/var", "sass/src")) {
            fullIgnoreFromSrcMainSencha.add(dir);
            Path sassDirPath = Paths.get(baseDirectory, generatedExtModuleDirectory, dir);
            if (!sassDirPath.toFile().exists() || !sassDirPath.toFile().isDirectory()) continue;
            Path targetDirPath = Paths.get(targetPackageDir, "sencha", dir);
            FileUtils.copyDirectory((File)sassDirPath.toFile(), (File)targetDirPath.toFile());
        }
        Path senchaSrc = Paths.get(baseDirectory, "src", "main", "sencha");
        if (senchaSrc.toFile().exists() && senchaSrc.toFile().isDirectory()) {
            FileUtils.copyDirectory((File)senchaSrc.toFile(), (File)Paths.get(targetPackageDir, "sencha").toFile(), pathname -> this.acceptFile(pathname, senchaSrc, fullIgnoreFromSrcMainSencha));
        }
        if ((generatedSenchaSrc = Paths.get(baseDirectory, "target", "generated-sencha")).toFile().exists() && generatedSenchaSrc.toFile().isDirectory()) {
            FileUtils.copyDirectory((File)generatedSenchaSrc.toFile(), (File)Paths.get(targetPackageDir, "generated", "sencha").toFile(), pathname -> this.acceptFile(pathname, generatedSenchaSrc, fullIgnoreFromSrcMainSencha));
        }
        return new CopyFromMavenResult(hasSourceTsFiles.get(), hasJooUnitTsFiles.get());
    }

    private boolean acceptFile(File file, Path srcMainSenchaPath, List<String> ignoreFromSrcMainSencha) {
        List collect = ignoreFromSrcMainSencha.stream().map(string -> Paths.get(srcMainSenchaPath.toString(), string)).collect(Collectors.toList());
        return collect.stream().noneMatch(path -> file.getPath().contains(path.toString()));
    }

    private Optional<Package> getOrCreateDependencyPackage(String name, Dependency dependency) {
        Optional<Artifact> optionalArtifact = this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(dependency.getGroupId()) && artifact.getArtifactId().equals(dependency.getArtifactId())).findFirst();
        if (!optionalArtifact.isPresent()) {
            return Optional.empty();
        }
        ModuleType moduleType = MavenModule.calculateModuleType(optionalArtifact.get().getArtifactHandler().getPackaging());
        if (moduleType == ModuleType.IGNORE) {
            return Optional.empty();
        }
        Model model = new Model();
        model.setGroupId(optionalArtifact.get().getGroupId());
        model.setArtifactId(optionalArtifact.get().getArtifactId());
        model.setPackaging(optionalArtifact.get().getArtifactHandler().getPackaging());
        model.setDependencies(this.project.getArtifacts().stream().filter(artifact -> this.inDependencyTrail(dependency, artifact.getDependencyTrail())).filter(artifact -> !artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId())).map(artifact -> {
            Dependency localDependency = new Dependency();
            localDependency.setArtifactId(artifact.getArtifactId());
            localDependency.setGroupId(artifact.getGroupId());
            localDependency.setScope(artifact.getScope());
            localDependency.setType(artifact.getType());
            localDependency.setVersion(artifact.getVersion());
            return localDependency;
        }).collect(Collectors.toList()));
        return Optional.of(this.handlePackageDependencies(name, new MavenModule("", model)));
    }

    private boolean inDependencyTrail(Dependency dependency, List<String> dependencyTrail) {
        return dependencyTrail.stream().map(dependencyPart -> dependencyPart.split(":")).filter(dependencySplit -> dependency.getGroupId().equals(dependencySplit[0])).anyMatch(dependencySplit -> dependency.getArtifactId().equals(dependencySplit[1]));
    }

    private Optional<Package> getOrCreatePackage(List<Package> packageRegistry, String packageName, String packageVersion, Map<String, MavenModule> moduleMappings) {
        Optional<Package> matchingPackage = packageRegistry.stream().filter(aPackage -> aPackage.matches(packageName, packageVersion)).findFirst();
        if (matchingPackage.isPresent()) {
            return matchingPackage;
        }
        MavenModule module = moduleMappings.get(packageName);
        if (module == null) {
            logger.error("could not find module {}", (Object)packageName);
            return Optional.empty();
        }
        if (module.getModuleType() == ModuleType.IGNORE) {
            return Optional.empty();
        }
        Package newPackage = this.handlePackageDependencies(packageName, module);
        packageRegistry.add(newPackage);
        return Optional.of(newPackage);
    }

    private Package handlePackageDependencies(String packageName, MavenModule mavenModule) {
        Package createdPackage;
        String newPackageVersion = this.isValidVersion(mavenModule.getVersion()) ? mavenModule.getVersion() : "1.0.0-SNAPSHOT";
        ArrayList<Package> newDependencies = new ArrayList<Package>();
        ArrayList<Package> newDevDependencies = new ArrayList<Package>();
        List dependencies = mavenModule.getData().getDependencies().stream().filter(dependency -> !"test".equals(dependency.getScope())).filter(dependency -> !this.ignoreDependency((Dependency)dependency)).map(dependency -> {
            if ("${project.groupId}".equals(dependency.getGroupId())) {
                dependency.setGroupId(mavenModule.getData().getGroupId());
            }
            if ("${project.version}".equals(dependency.getVersion())) {
                dependency.setVersion(mavenModule.getVersion());
            }
            return dependency;
        }).collect(Collectors.toList());
        List testDependencies = mavenModule.getData().getDependencies().stream().filter(dependency -> "test".equals(dependency.getScope())).filter(dependency -> !this.ignoreDependency((Dependency)dependency)).map(dependency -> {
            if ("$(project.groupid)".equals(dependency.getGroupId())) {
                dependency.setGroupId(mavenModule.getData().getGroupId());
            }
            if ("${project.version}".equals(dependency.getVersion())) {
                dependency.setVersion(mavenModule.getVersion());
            }
            return dependency;
        }).collect(Collectors.toList());
        for (Dependency dependency2 : dependencies) {
            createdPackage = new Package(this.mapJangarooName(dependency2.getGroupId(), dependency2.getArtifactId()), this.isValidVersion(dependency2.getVersion()) ? dependency2.getVersion() : "1.0.0-SNAPSHOT");
            if (this.isJangarooDependency(dependency2)) {
                createdPackage = new Package(this.mapJangarooName(dependency2.getGroupId(), dependency2.getArtifactId()), "^1.0.0-alpha");
            }
            if (Arrays.asList("swc", "jar").contains(dependency2.getType()) || this.isAggregatorToConvert(dependency2)) {
                newDependencies.add(createdPackage);
                continue;
            }
            createdPackage = this.getOrCreateDependencyPackage(this.mapJangarooName(dependency2.getGroupId(), dependency2.getArtifactId()), dependency2).orElse(null);
            if (createdPackage == null) continue;
            newDependencies.addAll(createdPackage.getDependencies());
        }
        for (Dependency dependency2 : testDependencies) {
            createdPackage = new Package(this.mapJangarooName(dependency2.getGroupId(), dependency2.getArtifactId()), this.isValidVersion(dependency2.getVersion()) ? dependency2.getVersion() : "1.0.0-SNAPSHOT");
            if (this.isJangarooDependency(dependency2)) {
                createdPackage = new Package(this.mapJangarooName(dependency2.getGroupId(), dependency2.getArtifactId()), "^1.0.0-alpha");
            }
            if (Arrays.asList("swc", "jar").contains(dependency2.getType())) {
                newDevDependencies.add(createdPackage);
                continue;
            }
            newDevDependencies.addAll(createdPackage.getDependencies());
        }
        return new Package(packageName, newPackageVersion, newDependencies, newDevDependencies);
    }

    private String mapJangarooName(String groupId, String artifactId) {
        if (Objects.equals(artifactId, "ext")) {
            return "@coremedia/sencha-ext";
        }
        if (Objects.equals(artifactId, "ext-classic")) {
            return "@coremedia/sencha-ext-classic";
        }
        if (Objects.equals(artifactId, "charts")) {
            return "@coremedia/sencha-ext-charts";
        }
        if (artifactId.startsWith("theme-")) {
            return "@coremedia/sencha-ext-classic-" + artifactId;
        }
        if (groupId != null && groupId.startsWith("net.jangaroo")) {
            if (Objects.equals(artifactId, "jangaroo-net")) {
                return "@jangaroo/jangaroo-net";
            }
            if (Objects.equals(artifactId, "jangaroo-runtime")) {
                return "@jangaroo/runtime";
            }
            if (Objects.equals(artifactId, "jooflash-core")) {
                return "@jangaroo/jooflash-core";
            }
            if (Objects.equals(artifactId, "jooflexframework")) {
                return "@jangaroo/jooflexframework";
            }
            if (Objects.equals(artifactId, "joounit")) {
                return "@jangaroo/joounit";
            }
            if (Objects.equals(artifactId, "ext-as")) {
                return "@jangaroo/ext-ts";
            }
            if (Objects.equals(artifactId, "ckeditor4")) {
                return "@jangaroo/ckeditor4";
            }
        }
        return this.calculateMavenName(groupId, artifactId);
    }

    private boolean isJangarooDependency(Dependency dependency) {
        return Arrays.asList("net.jangaroo__jangaroo-browser", "net.jangaroo__ext-as", "net.jangaroo__jangaroo-net", "net.jangaroo__jangaroo-runtime", "net.jangaroo__jooflash-core", "net.jangaroo__jooflexframework", "net.jangaroo__joounit", "net.jangaroo__ckeditor4").contains(String.format("%s__%s", dependency.getGroupId(), dependency.getArtifactId()));
    }

    private boolean ignoreDependency(Dependency dependency) {
        return "net.jangaroo__jangaroo-browser".contains(String.format("%s__%s", dependency.getGroupId(), dependency.getArtifactId()));
    }

    public String findPackageNameByReference(String reference, Map<String, MavenModule> moduleMappings) {
        Optional<String> packageName;
        if (reference == null) {
            return null;
        }
        String[] splitName = reference.split(":");
        if (splitName.length == 2 && splitName[0] != null && splitName[1] != null) {
            packageName = Optional.of(this.calculateMavenName(splitName[0], splitName[1]));
        } else {
            if (reference.startsWith("theme-")) {
                return "@coremedia/sencha-ext-classic-theme-" + reference.substring("theme-".length());
            }
            packageName = moduleMappings.entrySet().stream().map(moduleEntry -> {
                if (ModuleType.IGNORE.equals((Object)((MavenModule)moduleEntry.getValue()).getModuleType())) {
                    return new AbstractMap.SimpleEntry(moduleEntry.getKey(), ((MavenModule)moduleEntry.getValue()).getData().getName());
                }
                return new AbstractMap.SimpleEntry(moduleEntry.getKey(), this.calculateMavenName(((MavenModule)moduleEntry.getValue()).getData()));
            }).filter(entry -> reference.equals(entry.getValue())).map(Map.Entry::getKey).findFirst();
        }
        if (!packageName.isPresent()) {
            logger.error(String.format("Could not resolve reference %s. No suitable module was found.", reference));
            return null;
        }
        for (SearchAndReplace searchAndReplace : this.resolvedNpmPackageNameReplacers) {
            Matcher matcher = searchAndReplace.search.matcher(packageName.get());
            if (!matcher.matches()) continue;
            return matcher.replaceAll(searchAndReplace.replace);
        }
        return packageName.get();
    }

    private Map<String, MavenModule> loadMavenModule(String modulePath) {
        TreeMap<String, MavenModule> modules = new TreeMap<String, MavenModule>();
        modules.put(this.calculateMavenName(this.project.getModel()), new MavenModule(modulePath, this.project.getModel()));
        return modules;
    }

    private String calculateMavenName(Model model) {
        return this.calculateMavenName(model.getGroupId(), model.getArtifactId());
    }

    private String calculateMavenName(String groupId, String artifactId) {
        String mavenName = "com.coremedia.sencha".equals(groupId) && "ext-js-pkg".equals(artifactId) || "net.jangaroo.com.sencha".equals(groupId) && "ext-js-pkg-gpl".equals(artifactId) ? "ext" : groupId + "__" + artifactId;
        for (SearchAndReplace searchAndReplace : this.resolvedNpmPackageNameReplacers) {
            Matcher matcher = searchAndReplace.search.matcher(mavenName);
            if (!matcher.matches()) continue;
            return matcher.replaceAll(searchAndReplace.replace);
        }
        return mavenName;
    }

    private String convertJangarooConfig(String jangarooConfig) {
        return jangarooConfig.replaceAll("\"([a-zA-Z_$][0-9a-zA-Z_$]*)\":", "$1:").replace("}", "},").replace("]", "],").replace("\"\n", "\",\n").replace(",,", ",").replace(",;", ";");
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        int length = version.length();
        return length != 0 && version.split("\\.").length >= 3;
    }

    private void setCommandMapEntry(JangarooConfig jangarooConfig, String commandName, String entryName, Object entryValue) {
        Map<String, Map<String, Object>> commandsByName = jangarooConfig.getCommand();
        if (commandsByName == null) {
            commandsByName = new LinkedHashMap<String, Map<String, Object>>();
            jangarooConfig.setCommand(commandsByName);
        }
        Map command = commandsByName.computeIfAbsent(commandName, k -> new LinkedHashMap());
        command.put(entryName, entryValue);
    }

    private String renameLegacyExtensionPoint(String extensionPoint) {
        if ("studio".equals(extensionPoint)) {
            return "studio-client";
        }
        if ("studio-dynamic".equals(extensionPoint)) {
            return "studio-client-dynamic";
        }
        return extensionPoint;
    }

    private boolean isAggregatorToConvert(Model mavenProject) {
        return "pom".equals(mavenProject.getPackaging()) && EXTENSION_POINT_PATTERN.matcher(mavenProject.getArtifactId()).matches();
    }

    private boolean isAggregatorToConvert(Dependency dependency) {
        return "pom".equals(dependency.getType()) && EXTENSION_POINT_PATTERN.matcher(dependency.getArtifactId()).matches();
    }

    private static class CopyFromMavenResult {
        public final boolean hasSourceTsFiles;
        public final boolean hasJooUnitTsFiles;

        public CopyFromMavenResult(boolean hasSourceTsFiles, boolean hasJooUnitTsFiles) {
            this.hasSourceTsFiles = hasSourceTsFiles;
            this.hasJooUnitTsFiles = hasJooUnitTsFiles;
        }
    }
}

