/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.lifecycle;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.jangaroo.jooc.mvnplugin.Type;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="JangarooResourcesExtension")
public class JangarooResourcesExtension
extends AbstractMavenLifecycleParticipant {
    private static final String DEFAULT_SOURCE_DIRECTORY = "src" + File.separator + "main" + File.separator + "java";
    private static final String DEFAULT_TEST_SOURCE_DIRECTORY = "src" + File.separator + "test" + File.separator + "java";
    private static final String DEFAULT_JOO_SOURCE_DIR = "src/main/joo";
    private static final String DEFAULT_JOO_TEST_SOURCE_DIR = "src/test/joo";
    private static final String DEFAULT_SENCHA_RESOURCES_DIR = "src/main/sencha";
    private static final String DEFAULT_SENCHA_TEST_RESOURCES_DIR = "src/test/sencha";

    public void afterProjectsRead(MavenSession session) {
        for (MavenProject project : session.getProjects()) {
            String testSourceDirectory;
            if (!Type.containsJangarooSources(project)) continue;
            Resource resource = new Resource();
            resource.setDirectory(DEFAULT_SENCHA_RESOURCES_DIR);
            String outDir = project.getBuild().getOutputDirectory();
            String buildDir = project.getBuild().getDirectory();
            String targetPath = "jangaroo-app".equals(project.getPackaging()) ? this.relativizePath(buildDir + "/app", outDir) : this.relativizePath(buildDir + SenchaUtils.getPackagesPath(project), outDir);
            resource.setTargetPath(targetPath);
            resource.setFiltering(false);
            project.addResource(resource);
            Resource testResource = new Resource();
            testResource.setDirectory(DEFAULT_SENCHA_TEST_RESOURCES_DIR);
            testResource.setFiltering(false);
            project.addTestResource(testResource);
            String sourceDirectory = project.getBuild().getSourceDirectory();
            if (this.isDefaultSourceDirectory(sourceDirectory)) {
                project.getBuild().setSourceDirectory(DEFAULT_JOO_SOURCE_DIR);
                project.addCompileSourceRoot(DEFAULT_JOO_SOURCE_DIR);
            }
            if (!this.isDefaultTestSourceDirectory(testSourceDirectory = project.getBuild().getTestSourceDirectory())) continue;
            project.getBuild().setTestSourceDirectory(DEFAULT_JOO_TEST_SOURCE_DIR);
            project.addTestCompileSourceRoot(DEFAULT_JOO_TEST_SOURCE_DIR);
        }
    }

    private boolean isDefaultSourceDirectory(String sourceDirectory) {
        return sourceDirectory == null || sourceDirectory.endsWith(DEFAULT_SOURCE_DIRECTORY);
    }

    private boolean isDefaultTestSourceDirectory(String testSourceDirectory) {
        return testSourceDirectory == null || testSourceDirectory.endsWith(DEFAULT_TEST_SOURCE_DIRECTORY);
    }

    private String relativizePath(String target, String base) {
        Path basePath = Paths.get(base, new String[0]).normalize();
        Path targetPath = Paths.get(target, new String[0]).normalize();
        return basePath.relativize(targetPath).toString();
    }
}

