/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SenchaUtils {
    public static final String SEPARATOR = "/";
    public static final String APP_DIRECTORY_NAME = "app";
    public static final String TEST_APP_DIRECTORY_NAME = "test-classes";
    public static final String EXT_DIRECTORY_NAME = "ext";
    public static final String PACKAGES_DIRECTORY_NAME = "packages";
    public static final String APPS_DIRECTORY_NAME = "apps";
    public static final String LOCAL_PACKAGES_PATH = "/packages/";
    public static final String LOCAL_APPS_PATH = "/apps/";
    public static final String APP_TARGET_DIRECTORY = "/app";
    public static final String APPS_TARGET_DIRECTORY = "/apps";
    public static final String SENCHA_LOCALE_PATH = "locale";
    public static final String DEFAULT_LOCALE = "en";
    public static final String SENCHA_RESOURCES_PATH = "resources";
    public static final String SENCHA_BUNDLED_RESOURCES_PATH = "bundledResources";
    public static final String PRODUCTION_PROFILE = "production";
    public static final String TESTING_PROFILE = "testing";
    public static final String DEVELOPMENT_PROFILE = "development";
    public static final String TOOLKIT_CLASSIC = "classic";
    private static final String SENCHA_CFG = "sencha.cfg";
    public static final String SENCHA_DIRECTORYNAME = ".sencha";
    public static final String SENCHA_WORKSPACE_CONFIG = ".sencha/workspace/sencha.cfg";
    public static final String SENCHA_PACKAGE_CONFIG = ".sencha/packages/sencha.cfg";
    private static final String SENCHA_APP_CONFIG = ".sencha/app/sencha.cfg";
    public static final String SENCHA_WORKSPACE_FILENAME = "workspace.json";
    public static final String SENCHA_PACKAGE_FILENAME = "package.json";
    public static final String SENCHA_APP_FILENAME = "app.json";
    public static final String PACKAGE_CONFIG_FILENAME = "packageConfig.js";
    public static final String REQUIRED_CLASSES_FILENAME = "requiredClasses.js";
    public static final String DYNAMIC_PACKAGES_FILENAME = "dynamic-packages.json";
    public static final String ADDITIONAL_PACKAGES_PATH = "/additional-packages/*";
    public static final String APP_MANIFEST_FILENAME = "app-manifest.json";
    public static final String APP_MANIFEST_FRAGMENT_FILENAME = "app-manifest-fragment.json";
    public static final String APPS_FILENAME = "apps.json";
    public static final String SENCHA_TEST_APP_TEMPLATE_ARTIFACT_ID = "sencha-test-app-template";
    public static final String SENCHA_APP_TEMPLATE_ARTIFACT_ID = "sencha-app-template";
    public static final String SENCHA_APP_TEMPLATE_GROUP_ID = "net.jangaroo";
    private static final Pattern INTEGER_VERSION_PATTERN = Pattern.compile("[0-9]+");
    public static final String AUTO_CONTENT_COMMENT = "DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin";
    public static final Map<String, String> PLACEHOLDERS = ImmutableMap.of((Object)"app", (Object)"${app.dir}", (Object)"code", (Object)"${package.dir}", (Object)"theme", (Object)"${package.dir}", (Object)"workspace", (Object)"${workspace.dir}");
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DOT_SWC_EXTENSION = ".swc";
    private static final String REMOTE_PACKAGES_DIR = ".remote-packages";

    private SenchaUtils() {
    }

    public static String getSenchaPackageName(String groupId, String artifactId) {
        return groupId + "__" + artifactId;
    }

    public static String getSenchaPackageName(@Nonnull MavenProject project) {
        return SenchaUtils.getSenchaPackageName(project.getGroupId(), project.getArtifactId());
    }

    public static String getSenchaVersionForMavenVersion(String version) {
        StringBuilder senchaVersion = new StringBuilder();
        Matcher matcher = INTEGER_VERSION_PATTERN.matcher(version);
        for (int i = 0; i < 4 && matcher.find(); ++i) {
            if (i > 0) {
                senchaVersion.append(".");
            }
            senchaVersion.append(matcher.group());
        }
        return senchaVersion.length() == 0 ? null : senchaVersion.toString();
    }

    @Nullable
    public static Dependency getThemeDependency(@Nullable String theme, @Nonnull MavenProject project) {
        Dependency themeDependency = MavenDependencyHelper.fromKey(theme);
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            Dependency artifactDependency = MavenDependencyHelper.fromArtifact(artifact);
            if (!MavenDependencyHelper.equalsGroupIdAndArtifactId(artifactDependency, themeDependency)) continue;
            return artifactDependency;
        }
        return null;
    }

    public static String absolutizeToModuleWithPlaceholder(String packageType, String relativePath) {
        return SenchaUtils.absolutizeWithPlaceholder(PLACEHOLDERS.get(packageType), relativePath);
    }

    public static String absolutizeWithPlaceholder(String placeholder, String relativePath) {
        String normalizedRelativePath = FilenameUtils.separatorsToUnix((String)relativePath);
        String result = placeholder;
        if (StringUtils.isNotEmpty((CharSequence)normalizedRelativePath) && !normalizedRelativePath.startsWith(SEPARATOR)) {
            result = result + SEPARATOR + normalizedRelativePath;
        }
        return result;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static boolean isRequiredSenchaDependency(@Nonnull Dependency dependency, boolean includeTestDependencies) {
        return SenchaUtils.isRequiredSenchaDependency(dependency, includeTestDependencies, false);
    }

    public static boolean isRequiredSenchaDependency(@Nonnull Dependency dependency, boolean includeTestDependencies, boolean includeProvidedDependencies) {
        return !(!SenchaUtils.isSenchaDependency(dependency) || !includeProvidedDependencies && "provided".equals(dependency.getScope()) || !includeTestDependencies && "test".equals(dependency.getScope()));
    }

    public static boolean isSenchaDependency(@Nonnull Dependency dependency) {
        return SenchaUtils.isSenchaDependency(dependency.getType());
    }

    public static boolean isSenchaDependency(@Nonnull String type) {
        return "swc".equals(type) || "pkg".equals(type);
    }

    public static boolean doesSenchaAppExist(File directory) {
        File senchaCfg = new File(directory, SENCHA_APP_CONFIG);
        return senchaCfg.exists();
    }

    public static String getPackagesPath(MavenProject project) {
        return LOCAL_PACKAGES_PATH + SenchaUtils.getSenchaPackageName(project);
    }

    public static void generateSenchaAppFromTemplate(File workingDirectory, String appName, String applicationClass, String toolkit, Log log, String logLevel, String senchaJvmArgs) throws MojoExecutionException {
        String templateName = SenchaUtils.getSenchaPackageName(SENCHA_APP_TEMPLATE_GROUP_ID, SENCHA_APP_TEMPLATE_ARTIFACT_ID) + "/tpl";
        ImmutableMap properties = ImmutableMap.of((Object)"appName", (Object)appName, (Object)"applicationClass", (Object)applicationClass);
        SenchaUtils.generateSenchaAppFromTemplate(workingDirectory, appName, toolkit, templateName, (Map<String, String>)properties, log, logLevel, senchaJvmArgs);
    }

    public static void generateSenchaTestAppFromTemplate(File workingDirectory, MavenProject project, String appName, String testSuite, String toolkit, Log log, String logLevel, String senchaJvmArgs) throws MojoExecutionException {
        String templateName = SenchaUtils.getSenchaPackageName(SENCHA_APP_TEMPLATE_GROUP_ID, SENCHA_TEST_APP_TEMPLATE_ARTIFACT_ID) + "/tpl";
        ImmutableMap properties = ImmutableMap.of((Object)"moduleName", (Object)SenchaUtils.getSenchaPackageName(project), (Object)"testSuite", (Object)testSuite);
        SenchaUtils.generateSenchaAppFromTemplate(workingDirectory, appName, toolkit, templateName, (Map<String, String>)properties, log, logLevel, senchaJvmArgs);
    }

    private static void generateSenchaAppFromTemplate(File workingDirectory, String appName, String toolkit, String templateName, Map<String, String> properties, Log log, String logLevel, String senchaJvmArgs) throws MojoExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("generate app");
        arguments.add("-ext " + toolkit);
        arguments.add("--template " + templateName);
        arguments.add("--path=\".\"");
        arguments.add("--refresh=false");
        SenchaUtils.addSwitchFullIfCmd6_5(arguments);
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                arguments.add(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        arguments.add(appName);
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(workingDirectory, StringUtils.join(arguments, (char)' '), senchaJvmArgs, log, logLevel);
        senchaCmdExecutor.execute();
    }

    public static void addSwitchFullIfCmd6_5(List<String> arguments) throws MojoExecutionException {
        try {
            int[] cmdVersion = SenchaCmdExecutor.queryVersion();
            if (cmdVersion == null) {
                throw new MojoExecutionException("No version information found in output of 'sencha switch -l'.");
            }
            if (cmdVersion[0] > 6 || cmdVersion[0] == 6 && cmdVersion[1] >= 5) {
                arguments.add("--full");
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not run 'sencha'. Please install Sencha Cmd >= 6.2.1 or check your PATH environment variable.", (Exception)ioe);
        }
    }

    public static void createSenchaCfg(Path senchaCfgSource, Path senchaCfgTarget, Map<String, Object> properties) throws MojoExecutionException {
        if (Files.exists(senchaCfgSource, new LinkOption[0])) {
            try {
                List<String> senchaCfgTmpContent = Files.readAllLines(senchaCfgSource, Charset.forName("UTF-8"));
                List<String> updatedSenchaCfgContent = SenchaUtils.updateSenchaCfgContent(senchaCfgTmpContent, properties);
                Files.write(senchaCfgTarget, updatedSenchaCfgContent, Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Modifying sencha.cfg file failed", (Exception)e);
            }
        } else {
            throw new MojoExecutionException("Could not find sencha.cfg file in " + senchaCfgSource);
        }
    }

    private static List<String> updateSenchaCfgContent(@Nonnull List<String> currentContent, Map<String, Object> properties) {
        if (currentContent.get(0).startsWith("#")) {
            currentContent.remove(0);
        }
        ArrayList<String> newSenchaCfg = new ArrayList<String>(currentContent.size());
        newSenchaCfg.add("#");
        newSenchaCfg.add("# DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin");
        newSenchaCfg.add("#");
        newSenchaCfg.add("");
        newSenchaCfg.addAll(currentContent);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            newSenchaCfg.add(String.format("%s=%s", property.getKey(), property.getValue()));
        }
        return newSenchaCfg;
    }

    public static void configureDefaults(SenchaConfigBuilder configBuilder, String defaultsFileName) throws MojoExecutionException {
        try {
            configBuilder.defaults(defaultsFileName);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load " + defaultsFileName, (Exception)e);
        }
    }

    public static void writeFile(@Nonnull SenchaConfigBuilder configBuilder, @Nonnull String destinationFileDir, @Nonnull String destinationFileName, @Nullable String comment, Log log) throws MojoExecutionException {
        String tmpDestFileName = destinationFileName + ".tmp";
        File tmpDestFile = new File(destinationFileDir, tmpDestFileName);
        File destFile = new File(destinationFileDir, destinationFileName);
        configBuilder.destFile(tmpDestFile);
        if (comment != null) {
            configBuilder.destFileComment(comment);
        }
        try {
            configBuilder.buildFile();
        }
        catch (IOException io) {
            try {
                Files.delete(tmpDestFile.toPath());
            }
            catch (IOException e) {
                log.warn((CharSequence)("Unable to delete temporary file " + tmpDestFile.getAbsolutePath()), (Throwable)e);
            }
            throw new MojoExecutionException(String.format("Writing %s failed", tmpDestFile.getName()), (Exception)io);
        }
        try {
            Files.move(tmpDestFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Moving %s to %s failed", tmpDestFile.getName(), destFile.getAbsolutePath()), (Exception)e);
        }
    }

    public static void extractPkg(File archive, File targetDir) throws MojoExecutionException {
        try (ZipFile zipFile = new ZipFile(archive);){
            boolean isSwc = archive.getName().endsWith(DOT_SWC_EXTENSION);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                boolean isSwcPkgFile;
                ZipEntry entry = entries.nextElement();
                String targetName = entry.getName();
                boolean bl = isSwcPkgFile = isSwc && targetName.startsWith("META-INF/pkg/");
                if (!isSwcPkgFile && (isSwc || targetName.startsWith("META-INF/"))) continue;
                if (isSwcPkgFile) {
                    targetName = targetName.substring("META-INF/pkg/".length());
                }
                File target = new File(targetDir, targetName);
                if (entry.isDirectory()) {
                    FileHelper.ensureDirectory(target);
                    continue;
                }
                FileHelper.ensureDirectory(target.getParentFile());
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(target);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO Error while extracting archive", (Exception)e);
        }
    }

    public static File baseDir(MavenSession mavenSession) {
        File baseDir = mavenSession.getRequest().getMultiModuleProjectDirectory();
        if (baseDir == null) {
            baseDir = new File(mavenSession.getRequest().getBaseDirectory());
        }
        return baseDir;
    }

    public static File remotePackagesDir(MavenSession mavenSession) {
        File currentBaseDir = SenchaUtils.baseDir(mavenSession);
        while (true) {
            File remotePackagesDir = new File(currentBaseDir, REMOTE_PACKAGES_DIR);
            File baseParent = currentBaseDir.getParentFile();
            if (remotePackagesDir.exists() || baseParent == null) {
                return remotePackagesDir;
            }
            File pom = new File(baseParent, "pom.xml");
            if (!pom.exists()) {
                return remotePackagesDir;
            }
            currentBaseDir = baseParent;
        }
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

