/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.jangaroo.apprunner.proxy.AddDynamicPackagesServlet;
import net.jangaroo.apprunner.util.JettyWrapper;
import net.jangaroo.apprunner.util.ProxyServletConfig;
import net.jangaroo.apprunner.util.StaticResourcesServletConfig;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
public class RunMojo
extends AbstractSenchaMojo {
    @Parameter(property="jooJettyHost")
    private String jooJettyHost = "localhost";
    @Parameter(property="jooJettyPort")
    private int jooJettyPort = 8080;
    @Parameter(property="jooProxyTargetUri")
    private String jooProxyTargetUri;
    @Parameter(property="jooProxyPathSpec")
    private String jooProxyPathSpec;
    @Parameter
    private List<StaticResourcesServletConfig> jooStaticResourcesServletConfigs = Collections.emptyList();
    @Parameter
    private List<ProxyServletConfig> jooProxyServletConfigs;

    public void setJooProxyTargetUri(String jooProxyTargetUri) {
        this.jooProxyTargetUri = jooProxyTargetUri.endsWith("/") ? jooProxyTargetUri : jooProxyTargetUri + "/";
    }

    public void execute() throws MojoExecutionException {
        File baseDir;
        boolean isSwcPackaging = "swc".equals(this.project.getPackaging());
        boolean isAppPackaging = "jangaroo-app".equals(this.project.getPackaging());
        boolean isAppOverlayPackaging = "jangaroo-app-overlay".equals(this.project.getPackaging());
        boolean isAppsPackaging = "jangaroo-apps".equals(this.project.getPackaging());
        boolean isProxyRootPath = "/*".equals(this.jooProxyPathSpec);
        File file = isAppPackaging || isAppOverlayPackaging || isSwcPackaging && isProxyRootPath ? new File(this.project.getBuild().getDirectory(), "app") : (isSwcPackaging ? new File(this.project.getBuild().getTestOutputDirectory()) : (baseDir = isAppsPackaging ? new File(this.project.getBuild().getDirectory(), "apps") : null));
        if (baseDir == null) {
            this.getLog().info((CharSequence)String.format("jangaroo:run does not support packaging '%s' (module %s:%s).", this.project.getPackaging(), this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        StaticLoggerBinder.getSingleton().setLog(this.getLog());
        JettyWrapper jettyWrapper = new JettyWrapper(new Path[]{baseDir.toPath()});
        jettyWrapper.setWebAppContextClass(JettyWebAppContext.class);
        ArrayList<StaticResourcesServletConfig> staticResourcesServletConfigs = new ArrayList<StaticResourcesServletConfig>(this.jooStaticResourcesServletConfigs);
        String senchaPackageName = null;
        if (isSwcPackaging) {
            senchaPackageName = SenchaUtils.getSenchaPackageName(this.project);
            staticResourcesServletConfigs.add(new StaticResourcesServletConfig("/packages/" + senchaPackageName + "/" + "*"));
        }
        if ((isAppOverlayPackaging || isSwcPackaging) && isProxyRootPath) {
            File[] packageDirs = new File(baseDir, "packages").listFiles(File::isDirectory);
            if (packageDirs != null) {
                List packageNames = Arrays.stream(packageDirs).map(File::getName).collect(Collectors.toList());
                for (String packageName : packageNames) {
                    if (packageName.equals(senchaPackageName)) continue;
                    staticResourcesServletConfigs.add(new StaticResourcesServletConfig("/packages/" + packageName + "/" + "*", "/"));
                }
                jettyWrapper.setAdditionalServlets(Collections.singletonMap("/dynamic-packages.json", new AddDynamicPackagesServlet(this.jooProxyTargetUri + "dynamic-packages.json", packageNames)));
            }
        } else if (isAppOverlayPackaging) {
            AbstractSenchaMojo.JangarooApp jangarooApp = this.createJangarooApp(this.project);
            while (jangarooApp instanceof AbstractSenchaMojo.JangarooAppOverlay) {
                jangarooApp = ((AbstractSenchaMojo.JangarooAppOverlay)jangarooApp).baseApp;
                if (jangarooApp == null) continue;
                this.addAppToResources(jettyWrapper, jangarooApp.mavenProject, "/", "");
            }
            staticResourcesServletConfigs.add(new StaticResourcesServletConfig("/*", "/"));
        } else if (isAppsPackaging) {
            AbstractSenchaMojo.JangarooApps jangarooApps = this.createJangarooApps(this.project);
            if (isProxyRootPath) {
                throw new MojoExecutionException("Not supported yet!");
            }
            Dependency rootApp = this.getRootApp();
            for (AbstractSenchaMojo.JangarooApp jangarooApp : jangarooApps.apps) {
                String appPath;
                boolean isRootApp = rootApp != null && jangarooApp.mavenProject.getGroupId().equals(rootApp.getGroupId()) && jangarooApp.mavenProject.getArtifactId().equals(rootApp.getArtifactId());
                String senchaAppName = SenchaUtils.getSenchaPackageName(jangarooApp.mavenProject);
                String string = appPath = isRootApp ? "/" : "/apps/" + senchaAppName;
                if (!isRootApp) {
                    jettyWrapper.addBaseDir(new File(baseDir, "apps/" + senchaAppName).toPath(), appPath);
                }
                do {
                    this.addAppToResources(jettyWrapper, jangarooApp.mavenProject, appPath, "");
                    this.addAppToResources(jettyWrapper, jangarooApp.mavenProject, "/ext", "ext/");
                    this.addAppToResources(jettyWrapper, jangarooApp.mavenProject, "/packages", "packages/");
                } while ((jangarooApp = jangarooApp instanceof AbstractSenchaMojo.JangarooAppOverlay ? ((AbstractSenchaMojo.JangarooAppOverlay)jangarooApp).baseApp : null) != null);
            }
            jettyWrapper.setStaticResourcesServletConfigs(Collections.singletonList(new StaticResourcesServletConfig("/*", "/")), "/ext");
            jettyWrapper.setStaticResourcesServletConfigs(Collections.singletonList(new StaticResourcesServletConfig("/*", "/")), "/packages");
        }
        jettyWrapper.setStaticResourcesServletConfigs(staticResourcesServletConfigs);
        if (this.jooProxyServletConfigs != null && !this.jooProxyServletConfigs.isEmpty()) {
            jettyWrapper.setProxyServletConfigs(this.jooProxyServletConfigs);
        } else if (this.jooProxyTargetUri != null && this.jooProxyPathSpec != null) {
            jettyWrapper.setProxyServletConfigs(Collections.singletonList(new ProxyServletConfig(this.jooProxyTargetUri, this.jooProxyPathSpec)));
        } else if (this.jooProxyTargetUri != null) {
            this.getLog().warn((CharSequence)"Ignoring 'jooProxyTargetUri' since there is no 'jooProxyPathSpec'.");
        } else if (this.jooProxyPathSpec != null) {
            this.getLog().warn((CharSequence)"Ignoring 'jooProxyPathSpec' since there is no 'jooProxyTargetUri'.");
        }
        try {
            jettyWrapper.start(this.jooJettyHost, this.jooJettyPort);
            this.getLog().info((CharSequence)("Started Jetty server at: " + jettyWrapper.getUri()));
            this.logJangarooAppUrl(baseDir, jettyWrapper, this.project);
            jettyWrapper.blockUntilInterrupted();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not start Jetty", e);
        }
        finally {
            jettyWrapper.stop();
        }
    }

    private void addAppToResources(JettyWrapper jettyWrapper, MavenProject baseAppProject, String appPath, String subDirectory) throws MojoExecutionException {
        File appDirOrJar = this.getAppDirOrJar(baseAppProject);
        if (appDirOrJar.isDirectory()) {
            File appResourceDir;
            File file = appResourceDir = subDirectory.isEmpty() ? appDirOrJar : new File(appDirOrJar, subDirectory);
            if (appResourceDir.exists()) {
                this.getLog().info((CharSequence)String.format("Adding base app resource directory %s for handler with context path %s", appResourceDir.getAbsolutePath(), appPath));
                jettyWrapper.addBaseDir(appResourceDir.toPath(), appPath);
            }
        } else {
            this.getLog().info((CharSequence)String.format("Adding base app JAR %s for handler with context path %s", appDirOrJar.getAbsolutePath(), appPath));
            jettyWrapper.addBaseDirInResourceJar(appDirOrJar, "META-INF/resources/" + subDirectory, appPath);
        }
    }

    private void logJangarooAppUrl(File baseDir, JettyWrapper jettyWrapper, MavenProject project) {
        if (baseDir.exists()) {
            this.getLog().info((CharSequence)("Found " + project.getPackaging() + " at: " + jettyWrapper.getUri()));
        }
    }
}

