/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha.configbuilder;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaPackageOrAppConfigBuilder;

public class SenchaPackageConfigBuilder
extends SenchaPackageOrAppConfigBuilder<SenchaPackageConfigBuilder> {
    static final String EXTEND = "extend";

    public SenchaPackageConfigBuilder extend(String theme) {
        return (SenchaPackageConfigBuilder)this.nameValue(EXTEND, theme);
    }

    @Override
    @Nonnull
    public Map<String, Object> build() {
        if ("code".equals(this.config.get("type")) || "theme".equals(this.config.get("type"))) {
            this.updateResourcesForWorkaround("js");
            this.updateResourcesForWorkaround("css");
        }
        return super.build();
    }

    private void updateResourcesForWorkaround(String resourceType) {
        List<Map<String, Object>> resourcesForWorkaround;
        List resources = (List)this.config.get(resourceType);
        if (resources != null && !(resourcesForWorkaround = SenchaPackageConfigBuilder.getResourcesForWorkaround(resources)).isEmpty()) {
            ArrayList updatedResources = Lists.newArrayList((Iterable)Iterables.filter((Iterable)resources, (Predicate)Predicates.not((Predicate)Predicates.in(resourcesForWorkaround))));
            this.config.put(resourceType, updatedResources);
            this.addToProfile("development", resourceType, resourcesForWorkaround);
            this.addToProfile("testing", resourceType, resourcesForWorkaround);
            this.addToProfile("production", resourceType, SenchaPackageConfigBuilder.getConvertedResourcesForProduction(resourcesForWorkaround));
        }
    }

    private static List<Map<String, Object>> getResourcesForWorkaround(List<Map<String, Object>> jsResources) {
        ArrayList<Map<String, Object>> resourcesForWorkaround = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> resourcesEntity : jsResources) {
            if (!SenchaPackageConfigBuilder.useForSenchaWorkaround(resourcesEntity)) continue;
            resourcesForWorkaround.add(resourcesEntity);
        }
        return resourcesForWorkaround;
    }

    private void addToProfile(String profile, String type, List<Map<String, Object>> resources) {
        if (resources != null && !resources.isEmpty()) {
            this.profile(profile, (Map<String, Object>)ImmutableMap.of((Object)type, resources));
        }
    }

    private static List<Map<String, Object>> getConvertedResourcesForProduction(List<Map<String, Object>> resources) {
        ArrayList<Map<String, Object>> convertedResources = new ArrayList<Map<String, Object>>(resources.size());
        for (Map<String, Object> resourcesEntity : resources) {
            String path = (String)resourcesEntity.get("path");
            String modifiedPath = path.replaceAll("^resources/", "resources/\\${package.name}/");
            HashMap<String, Object> modifiedResourcesEntitiy = new HashMap<String, Object>();
            modifiedResourcesEntitiy.putAll(resourcesEntity);
            modifiedResourcesEntitiy.put("path", modifiedPath);
            convertedResources.add(modifiedResourcesEntitiy);
        }
        return convertedResources;
    }

    private static boolean useForSenchaWorkaround(Map<String, Object> resourceEntity) {
        boolean includeInBundle = SenchaPackageConfigBuilder.getAsBoolean(resourceEntity.get("includeInBundle"));
        boolean bundle = SenchaPackageConfigBuilder.getAsBoolean(resourceEntity.get("bundle"));
        return !includeInBundle && !bundle;
    }

    private static boolean getAsBoolean(Object value) {
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

