/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.jangaroo.jooc.mvnplugin.AbstractLinkPackagesMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaWorkspaceConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenPluginHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="generate-ws", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class SenchaGenerateWsMojo
extends AbstractLinkPackagesMojo {
    @Parameter
    private String testSuite = null;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException {
        File workspaceDir;
        String packaging = this.project.getPackaging();
        if (!("pkg".equals(packaging) || "swc".equals(packaging) || "jangaroo-app".equals(packaging))) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"pkg\", \"swc\" or \"jangaroo-app\"");
        }
        boolean isAppPackaging = "jangaroo-app".equals(this.project.getPackaging());
        if ((isAppPackaging || this.testSuite != null) && !new File(workspaceDir = new File(this.project.getBuild().getDirectory(), isAppPackaging ? "app" : "test-classes"), "workspace.json").exists()) {
            this.generateWorkspace(workspaceDir);
        }
    }

    private void generateWorkspace(File workspaceDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Generating Sencha workspace in %s", workspaceDir.getPath()));
        FileHelper.ensureDirectory(workspaceDir);
        SenchaWorkspaceConfigBuilder configBuilder = new SenchaWorkspaceConfigBuilder();
        SenchaUtils.configureDefaults(configBuilder, "default.workspace.json");
        File remotePackagesDir = SenchaUtils.remotePackagesDir(this.session);
        boolean isAppPackaging = "jangaroo-app".equals(this.project.getPackaging());
        this.configureSenchaAppTemplatePackage(configBuilder, workspaceDir, remotePackagesDir, !isAppPackaging);
        this.configurePackages(workspaceDir, remotePackagesDir, isAppPackaging);
        this.callSenchaGenerateWorkspace(workspaceDir, remotePackagesDir);
        SenchaUtils.writeFile(configBuilder, workspaceDir.getPath(), "workspace.json", "DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin", this.getLog());
    }

    private void callSenchaGenerateWorkspace(File workspaceDir, File remotePackagesDir) throws MojoExecutionException {
        Path senchaCfg = Paths.get(workspaceDir.getAbsolutePath(), ".sencha/workspace/sencha.cfg");
        try {
            Files.deleteIfExists(senchaCfg);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not delete existing sencha.cfg file in " + senchaCfg, (Exception)ioe);
        }
        this.getLog().info((CharSequence)"Generating Sencha workspace module");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("generate workspace");
        SenchaUtils.addSwitchFullIfCmd6_5(arguments);
        arguments.add(".");
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(workspaceDir, StringUtils.join(arguments, (char)' '), this.getSenchaJvmArgs(), this.getLog(), this.getSenchaLogLevel());
        senchaCmdExecutor.execute();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("ext.dir", SenchaUtils.absolutizeToModuleWithPlaceholder("workspace", "ext"));
        SenchaUtils.createSenchaCfg(senchaCfg, senchaCfg, properties);
    }

    private String absolutizeUsingWorkspace(File workspaceDir, File file) {
        String relativePath = file.isAbsolute() ? FileHelper.relativize(workspaceDir, file) : FilenameUtils.separatorsToUnix((String)file.toString());
        return SenchaUtils.absolutizeToModuleWithPlaceholder("workspace", relativePath);
    }

    private void configurePackages(File workspaceDir, File remotePackagesDir, boolean isAppPackaging) throws MojoExecutionException {
        File packagesDir = new File(workspaceDir, "packages");
        FileHelper.ensureDirectory(packagesDir);
        Path packagesPath = packagesDir.toPath().normalize();
        this.createSymbolicLinksForPackages(workspaceDir, packagesPath, remotePackagesDir, isAppPackaging);
    }

    private String reactorProjectId(MavenProject project) {
        return this.reactorProjectId(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private String reactorProjectId(String groupId, String artifactId, String version) {
        return groupId + ':' + artifactId + ':' + version;
    }

    private void createSymbolicLinksForPackages(File workspaceDir, Path packagesPath, File remotePackagesDir, boolean isAppPackaging) throws MojoExecutionException {
        Map<Artifact, Path> reactorProjectPackagePaths = SenchaGenerateWsMojo.findReactorProjectPackages(this.project);
        Set artifacts = this.project.getArtifacts();
        Optional<Artifact> extFrameworkArtifact = artifacts.stream().filter(this::isExtFrameworkArtifact).findFirst();
        if (extFrameworkArtifact.isPresent()) {
            this.createSymbolicLinkToPackage(workspaceDir.toPath(), "ext", this.getPkgDir(extFrameworkArtifact.get(), remotePackagesDir, reactorProjectPackagePaths));
        } else {
            this.getLog().warn((CharSequence)"no Ext framework dependency found");
        }
        Set<Artifact> dependencyArtifacts = this.onlyRequiredSenchaDependencies(artifacts, !isAppPackaging);
        this.createSymbolicLinksForArtifacts(dependencyArtifacts, packagesPath, remotePackagesDir);
        if (!isAppPackaging) {
            String senchaPackageName = SenchaUtils.getSenchaPackageName(this.project);
            File packageDir = new File(workspaceDir.getParentFile(), "packages/" + senchaPackageName);
            FileHelper.ensureDirectory(packageDir);
            this.createSymbolicLinkToPackage(packagesPath, senchaPackageName, packageDir.toPath());
        }
    }

    private void configureSenchaAppTemplatePackage(SenchaWorkspaceConfigBuilder configBuilder, File workspaceDir, File remotePackagesDir, boolean isTestApp) throws MojoExecutionException {
        String senchaAppTemplateArtifactId;
        List remoteRepositories;
        String myVersion = ((Artifact)this.project.getPluginArtifactMap().get("net.jangaroo:jangaroo-maven-plugin")).getVersion();
        ArtifactRepository localRepository = this.session.getLocalRepository();
        Artifact artifactFromHelper = MavenPluginHelper.getArtifact(localRepository, remoteRepositories = this.project.getRemoteArtifactRepositories(), this.artifactResolver, this.repositorySystem, "net.jangaroo", senchaAppTemplateArtifactId = isTestApp ? "sencha-test-app-template" : "sencha-app-template", myVersion, "runtime", "pkg");
        if (artifactFromHelper == null) {
            throw new MojoExecutionException("Cannot find Sencha App template net.jangaroo:" + senchaAppTemplateArtifactId);
        }
        File appTemplate = this.unpackPkg(artifactFromHelper, remotePackagesDir);
        String relativeAppTemplatePath = this.absolutizeUsingWorkspace(workspaceDir, appTemplate);
        configBuilder.packagesDirs(Collections.singletonList(relativeAppTemplatePath));
    }

    private String relativizeToRemotePackagesPlaceholder(File remotePackagesDir, File pkgDir) {
        String relativePath = FileHelper.relativize(remotePackagesDir, pkgDir);
        return SenchaUtils.absolutizeWithPlaceholder("${remotePackages}", relativePath);
    }

    private String relativize(MavenProject project, @Nonnull String path) {
        return FileHelper.relativize(project.getBasedir().toPath(), path);
    }

    private File relativePathForProject(File workspaceDir, MavenProject project) throws MojoExecutionException {
        String localPathToSrc = "jangaroo-app".equals(project.getPackaging()) ? "/app" : "/packages/" + SenchaUtils.getSenchaPackageName(project);
        return SenchaGenerateWsMojo.relativePathForProject(workspaceDir, project, localPathToSrc);
    }

    private static File relativePathForProject(File workspaceDir, MavenProject project, String localPathToSrc) throws MojoExecutionException {
        Path path;
        Path rootPath = workspaceDir.toPath().normalize();
        Path relativePath = rootPath.relativize(path = Paths.get(project.getBuild().getDirectory() + localPathToSrc, new String[0]));
        String relativePathString = FilenameUtils.separatorsToUnix((String)relativePath.toString());
        if (relativePathString.isEmpty()) {
            throw new MojoExecutionException("Cannot handle project because not relative path to root workspace could be build");
        }
        return new File(relativePathString);
    }
}

