/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jangaroo.apprunner.util.AppsDeSerializer;
import net.jangaroo.jooc.mvnplugin.AbstractLinkPackagesMojo;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="prepare-package-apps", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PreparePackageAppsMojo
extends AbstractLinkPackagesMojo {
    @Parameter(defaultValue="${project.build.directory}/apps", readonly=true)
    private File webResourcesOutputDirectory;

    public void execute() throws MojoExecutionException {
        if (!"jangaroo-apps".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-apps\"");
        }
        this.packageApps();
    }

    private void packageApps() throws MojoExecutionException {
        Path rootPath = this.webResourcesOutputDirectory.toPath().normalize();
        Path appsPath = rootPath.resolve("apps").normalize();
        FileHelper.ensureDirectory(appsPath.toFile());
        AbstractSenchaMojo.JangarooApps jangarooApps = this.createJangarooApps(this.project);
        Dependency rootApp = this.getRootApp();
        ArrayList<AppsDeSerializer.AppInfo> appInfoList = new ArrayList<AppsDeSerializer.AppInfo>();
        for (AbstractSenchaMojo.JangarooApp jangarooApp : jangarooApps.apps) {
            List locales;
            String senchaAppName = SenchaUtils.getSenchaPackageName(jangarooApp.mavenProject);
            boolean isRootApp = rootApp != null && rootApp.getGroupId().equals(jangarooApp.mavenProject.getGroupId()) && rootApp.getArtifactId().equals(jangarooApp.mavenProject.getArtifactId());
            Path appPath = isRootApp ? rootPath : appsPath.resolve(senchaAppName);
            appInfoList.add(new AppsDeSerializer.AppInfo(senchaAppName, rootPath.relativize(appPath).toString().replace('\\', '/')));
            if (isRootApp) continue;
            File appDirOrJar = this.getAppDirOrJar(jangarooApp.mavenProject);
            try {
                locales = AppsDeSerializer.readLocales((InputStream)this.getInputStreamForDirOrJar(appDirOrJar, "app.json"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not read app.json", (Exception)e);
            }
            for (String locale : locales) {
                FileHelper.ensureDirectory(appPath.toFile());
                try {
                    String pathToRoot = appPath.relativize(rootPath).toString().replace('\\', '/');
                    if (!pathToRoot.isEmpty() && !pathToRoot.endsWith("/")) {
                        pathToRoot = pathToRoot + "/";
                    }
                    AppsDeSerializer.rewriteBootstrapJsonPaths((InputStream)this.getInputStreamForDirOrJar(appDirOrJar, locale + ".json"), (OutputStream)new FileOutputStream(new File(appPath.toFile(), locale + ".json")), (Map)ImmutableMap.of((Object)"ext/", (Object)(pathToRoot + "ext" + "/"), (Object)"packages/", (Object)(pathToRoot + "packages" + "/")));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not rewrite bootstrap paths", (Exception)e);
                }
            }
        }
        for (AppsDeSerializer.AppInfo appInfo : appInfoList) {
            this.writeAppsJson(this.webResourcesOutputDirectory.toPath().resolve(appInfo.path).toFile(), appInfoList);
        }
    }

    private void writeAppsJson(File folder, List<AppsDeSerializer.AppInfo> appNames) throws MojoExecutionException {
        File appsFile = this.prepareFile(new File(folder, "apps.json"));
        try {
            AppsDeSerializer.writeApps((OutputStream)new FileOutputStream(appsFile), appNames);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create " + appsFile + " resource", (Exception)e);
        }
    }

    private InputStream getInputStreamForDirOrJar(File dirOrJar, String relativePathInsideDirOrJar) throws MojoExecutionException {
        URL inputURL;
        if (dirOrJar.isDirectory()) {
            try {
                return new FileInputStream(dirOrJar.toPath().resolve(relativePathInsideDirOrJar).toFile());
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        try {
            String urlString = "jar:" + dirOrJar.toURI().toURL().toString() + "!/" + "META-INF/resources/" + relativePathInsideDirOrJar;
            inputURL = new URL(urlString);
        }
        catch (MalformedURLException ignored) {
            return null;
        }
        try {
            JarURLConnection urlConnection = (JarURLConnection)inputURL.openConnection();
            if (urlConnection.getJarEntry() == null) {
                return null;
            }
            return urlConnection.getInputStream();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading " + inputURL, (Exception)e);
        }
    }
}

