/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomManipulator {
    private static final String PROJECT_QUERY = "/project";
    private static final String DEPENDENCIES_QUERY = "/project/dependencies";

    private PomManipulator() {
    }

    public static void addDependency(@Nonnull MavenProject project, @Nonnull Dependency dependency, @Nonnull Log log) throws MojoExecutionException {
        PomManipulator.addDependencies(project, Collections.singletonList(dependency), log);
    }

    public static void addDependencies(@Nonnull MavenProject project, List<Dependency> dependencies, Log log) throws MojoExecutionException {
        Document doc = PomManipulator.initDocument(project.getFile());
        PomManipulator.addDependencies(doc, dependencies, log);
        PomManipulator.writeUpdatedPom(project.getFile(), doc);
    }

    private static void writeUpdatedPom(File pom, Document doc) throws MojoExecutionException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(pom);
            transformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Cannot write updated pom", (Exception)e);
        }
    }

    @Nonnull
    private static Node getDependenciesNode(Document doc) throws MojoExecutionException {
        NodeList dependenciesNodeList = PomManipulator.performXPathQuery(doc, DEPENDENCIES_QUERY);
        return dependenciesNodeList == null || dependenciesNodeList.getLength() == 0 ? PomManipulator.createDependenciesNode(doc) : dependenciesNodeList.item(0);
    }

    private static Node getProjectNode(Document document) throws MojoExecutionException {
        NodeList projectNodeList = PomManipulator.performXPathQuery(document, PROJECT_QUERY);
        return projectNodeList.item(0);
    }

    private static NodeList performXPathQuery(Document doc, String query) throws MojoExecutionException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            return (NodeList)xpath.evaluate(query, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new MojoExecutionException("Cannot parse pom", (Exception)e);
        }
    }

    private static Document initDocument(File pom) throws MojoExecutionException {
        try {
            String xml = FileUtils.readFileToString((File)pom);
            DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
            xmlFact.setNamespaceAware(false);
            DocumentBuilder builder = xmlFact.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8"))));
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Cannot read pom because of parser exception", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot read pom because of xml errors", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read pom because of IO", (Exception)e);
        }
    }

    private static void addDependencies(Document document, List<Dependency> dependencies, Log log) throws MojoExecutionException {
        Node dependenciesNode = PomManipulator.getDependenciesNode(document);
        for (Dependency dependency : dependencies) {
            Node dependencyNode = PomManipulator.createDependencyNode(document, dependency);
            dependenciesNode.appendChild(dependencyNode);
            log.info((CharSequence)("Append dependency to dependency management: " + dependency));
        }
    }

    private static Node createDependencyNode(Document document, Dependency dependency) {
        return PomManipulator.createDependencyNode(document, dependency.getArtifactId(), dependency.getGroupId(), dependency.getVersion(), dependency.getType(), dependency.getScope());
    }

    private static Node createDependencyNode(Document document, String artifactId, String groupId, String version, String type, String scope) {
        Element dependencyNode = PomManipulator.createElement(document, "dependency", null);
        Element groupIdTag = PomManipulator.createElement(document, "groupId", groupId);
        Element artifactIdTag = PomManipulator.createElement(document, "artifactId", artifactId);
        dependencyNode.appendChild(groupIdTag);
        dependencyNode.appendChild(artifactIdTag);
        if (version != null) {
            Element versionTag = PomManipulator.createElement(document, "version", version);
            dependencyNode.appendChild(versionTag);
        }
        if (type != null) {
            Element typeTag = PomManipulator.createElement(document, "type", type);
            dependencyNode.appendChild(typeTag);
        }
        if (scope != null) {
            Element scopeTag = PomManipulator.createElement(document, "scope", scope);
            dependencyNode.appendChild(scopeTag);
        }
        return dependencyNode;
    }

    private static Node createDependenciesNode(Document document) throws MojoExecutionException {
        Node projectNode = PomManipulator.getProjectNode(document);
        Element dependencies = PomManipulator.createElement(document, "dependencies", null);
        projectNode.appendChild(dependencies);
        return dependencies;
    }

    private static Element createElement(Document document, String tagname, String textContent) {
        Element element = document.createElement(tagname);
        element.setTextContent(textContent);
        return element;
    }
}

