/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.MavenPluginHelper;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.PlexusArchiverZipFileResourceCollection;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;

public final class FileHelper {
    private FileHelper() {
    }

    public static void copyFiles(File srcDir, File targetDir) throws MojoExecutionException {
        if (srcDir.exists()) {
            try {
                FileUtils.copyDirectory((File)srcDir, (File)targetDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Copying sencha sources from %s to %s failed.", srcDir, targetDir), (Exception)e);
            }
        }
    }

    public static void copyDirectory(@Nonnull File srcDir, @Nonnull File targetDir) throws MojoExecutionException {
        if (srcDir.exists()) {
            try {
                FileUtils.copyDirectoryToDirectory((File)srcDir, (File)targetDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Copying sencha sources from %s to %s failed.", srcDir, targetDir), (Exception)e);
            }
        }
    }

    public static void ensureDirectory(File dir) throws MojoExecutionException {
        if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
            throw new MojoExecutionException("could not create folder for directory " + dir);
        }
    }

    public static void copyFilesToDirectory(@Nonnull File source, @Nonnull File target, String matchPattern) throws MojoExecutionException {
        File[] files = source.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        Pattern pattern = null;
        if (matchPattern != null) {
            pattern = Pattern.compile(matchPattern);
        }
        for (File file : files) {
            if (!file.isFile() || pattern != null && !pattern.matcher(file.getName()).matches()) continue;
            FileHelper.doCopyFile(file, target);
        }
    }

    private static void doCopyFile(@Nonnull File source, @Nonnull File target) throws MojoExecutionException {
        try {
            Files.copy(source.toPath(), target.toPath().resolve(source.getName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy files to janagaroo dir", (Exception)e);
        }
    }

    public static void copyDirectories(@Nonnull File source, @Nonnull File target, Set<String> excludeDirectories) throws MojoExecutionException {
        File[] files = source.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory() || excludeDirectories != null && excludeDirectories.contains(file.getName())) continue;
            FileHelper.copyDirectory(file, target);
        }
    }

    public static String relativize(@Nonnull Path base, @Nonnull String path) {
        Path normalizedPath = Paths.get(path, new String[0]).normalize();
        return FilenameUtils.separatorsToUnix((String)base.relativize(normalizedPath).toString());
    }

    public static String relativize(@Nonnull Path base, @Nonnull File path) {
        Path normalizedPath = path.toPath().normalize();
        return FilenameUtils.separatorsToUnix((String)base.relativize(normalizedPath).toString());
    }

    public static String relativize(@Nonnull File base, @Nonnull File path) {
        return FileHelper.relativize(base.toPath(), path);
    }

    public static void createSymbolicLink(Path link, Path target) throws IOException {
        if (!SystemUtils.IS_OS_WINDOWS) {
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
        } else {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(link.toFile().getParentFile());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null));
            CommandLine mkLinkCommand = new CommandLine("CMD");
            mkLinkCommand.addArgument("/C");
            mkLinkCommand.addArgument("MKLINK");
            mkLinkCommand.addArgument("/J");
            mkLinkCommand.addArgument(link.getFileName().toString());
            mkLinkCommand.addArgument(target.toString());
            try {
                executor.execute(mkLinkCommand);
            }
            catch (IOException e) {
                throw new IOException("Error while invoking " + mkLinkCommand.toString(), e);
            }
        }
    }

    public static void createAppOrAppOverlayJar(MavenSession session, JarArchiver archiver, ArtifactHandlerManager artifactHandlerManager) throws MojoExecutionException {
        FileHelper.createAppOrAppOverlayJar(session, archiver, artifactHandlerManager, null);
    }

    public static void createAppOrAppOverlayJar(MavenSession session, JarArchiver archiver, ArtifactHandlerManager artifactHandlerManager, String senchaAppBuild) throws MojoExecutionException {
        FileHelper.createAppOrAppOverlayJar(session, archiver, artifactHandlerManager, senchaAppBuild, null);
    }

    public static void createAppOrAppOverlayJar(MavenSession session, JarArchiver archiver, ArtifactHandlerManager artifactHandlerManager, String senchaAppBuild, File appDir) throws MojoExecutionException {
        MavenProject project = session.getCurrentProject();
        appDir = appDir != null ? appDir : new File(project.getBuild().getDirectory() + "/app");
        File jarFile = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + ".jar");
        if (senchaAppBuild == null || "development".equals(senchaAppBuild)) {
            DefaultFileSet fileSet = (DefaultFileSet)DefaultFileSet.fileSet((File)appDir).prefixed("META-INF/resources/");
            fileSet.setExcludes(new String[]{"**/build/temp/**", "**/packages/" + SenchaUtils.getSenchaPackageName("net.jangaroo", "sencha-app-template") + "/**", "packages/" + SenchaUtils.getSenchaPackageName("net.jangaroo", "sencha-test-app-template") + "/**", "**/*-timestamp"});
            fileSet.setIncludingEmptyDirectories(false);
            FileHelper.addFileSetFollowingSymLinks((AbstractArchiver)archiver, (FileSet)fileSet);
        }
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(archiver);
        mavenArchiver.setOutputFile(jarFile);
        try {
            MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
            archive.setManifestFile(MavenPluginHelper.createDefaultManifest(project));
            mavenArchiver.createArchive(session, project, archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        Artifact mainArtifact = project.getArtifact();
        mainArtifact.setFile(jarFile);
        mainArtifact.setArtifactHandler(artifactHandlerManager.getArtifactHandler("jar"));
    }

    public static void createAppsJar(MavenSession session, JarArchiver archiver, ArtifactHandlerManager artifactHandlerManager, String senchaAppBuild, File appsDir, Map<String, List<File>> appNamesToDirsOrJars, String rootAppName) throws MojoExecutionException {
        if (senchaAppBuild != null && !"development".equals(senchaAppBuild)) {
            throw new MojoExecutionException("Apps jar is only supported for developer mode");
        }
        MavenProject project = session.getCurrentProject();
        appsDir = appsDir != null ? appsDir : new File(project.getBuild().getDirectory() + "/apps");
        File jarFile = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + ".jar");
        DefaultFileSet fileSet = (DefaultFileSet)DefaultFileSet.fileSet((File)appsDir).prefixed("META-INF/resources/");
        fileSet.setIncludingEmptyDirectories(false);
        FileHelper.addFileSetFollowingSymLinks((AbstractArchiver)archiver, (FileSet)fileSet);
        appNamesToDirsOrJars.forEach((appName, appDirsOrJars) -> appDirsOrJars.forEach(appDirOrJar -> {
            boolean isRootApp = appName.equals(rootAppName);
            String appPath = isRootApp ? "" : "apps/" + appName + "/";
            boolean isDirectory = appDirOrJar.isDirectory();
            String sourcePrefix = isDirectory ? "" : "META-INF/resources/";
            DefaultFileSet appFileSet = isDirectory ? DefaultFileSet.fileSet((File)appDirOrJar) : DefaultArchivedFileSet.archivedFileSet((File)appDirOrJar);
            appFileSet.prefixed("META-INF/resources/" + appPath);
            appFileSet.setExcludes(new String[]{"**/build/temp/**", "**/*-timestamp", sourcePrefix + "ext" + "/" + "**", sourcePrefix + "packages" + "/" + "**"});
            appFileSet.setIncludingEmptyDirectories(false);
            if (isDirectory) {
                FileHelper.addFileSetFollowingSymLinks((AbstractArchiver)archiver, (FileSet)appFileSet);
            } else {
                FileHelper.addArchivedFileSetRemovingPrefixFromSource((AbstractArchiver)archiver, (ArchivedFileSet)appFileSet, "META-INF/resources/");
            }
            DefaultFileSet packagesFileSet = isDirectory ? DefaultFileSet.fileSet((File)appDirOrJar) : DefaultArchivedFileSet.archivedFileSet((File)appDirOrJar);
            packagesFileSet.prefixed("META-INF/resources/");
            packagesFileSet.setIncludes(new String[]{sourcePrefix + "ext" + "/" + "**", sourcePrefix + "packages" + "/" + "**"});
            packagesFileSet.setExcludes(new String[]{sourcePrefix + "packages" + "/" + SenchaUtils.getSenchaPackageName("net.jangaroo", "sencha-test-app-template") + "/**"});
            packagesFileSet.setIncludingEmptyDirectories(false);
            if (isDirectory) {
                FileHelper.addFileSetFollowingSymLinks((AbstractArchiver)archiver, (FileSet)packagesFileSet);
            } else {
                FileHelper.addArchivedFileSetRemovingPrefixFromSource((AbstractArchiver)archiver, (ArchivedFileSet)packagesFileSet, "META-INF/resources/");
            }
        }));
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(archiver);
        mavenArchiver.setOutputFile(jarFile);
        try {
            MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
            archive.setManifestFile(MavenPluginHelper.createDefaultManifest(project));
            mavenArchiver.createArchive(session, project, archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        Artifact mainArtifact = project.getArtifact();
        mainArtifact.setFile(jarFile);
        mainArtifact.setArtifactHandler(artifactHandlerManager.getArtifactHandler("jar"));
    }

    private static void addFileSetFollowingSymLinks(@Nonnull AbstractArchiver archiver, @Nonnull FileSet fileSet) throws ArchiverException {
        File directory = fileSet.getDirectory();
        PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection();
        collection.setFollowingSymLinks(true);
        collection.setIncludes(fileSet.getIncludes());
        collection.setExcludes(fileSet.getExcludes());
        collection.setBaseDir(directory);
        collection.setFileSelectors(fileSet.getFileSelectors());
        collection.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        collection.setPrefix(fileSet.getPrefix());
        collection.setCaseSensitive(fileSet.isCaseSensitive());
        collection.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        collection.setStreamTransformer(fileSet.getStreamTransformer());
        if (archiver.getOverrideDirectoryMode() > -1 || archiver.getOverrideFileMode() > -1) {
            collection.setOverrideAttributes(-1, null, -1, null, archiver.getOverrideFileMode(), archiver.getOverrideDirectoryMode());
        }
        if (archiver.getDefaultDirectoryMode() > -1 || archiver.getDefaultFileMode() > -1) {
            collection.setDefaultAttributes(-1, null, -1, null, archiver.getDefaultFileMode(), archiver.getDefaultDirectoryMode());
        }
        archiver.addResources((PlexusIoResourceCollection)collection);
    }

    private static void addArchivedFileSetRemovingPrefixFromSource(@Nonnull AbstractArchiver archiver, @Nonnull ArchivedFileSet fileSet, String prefix) throws ArchiverException {
        File archive = fileSet.getArchive();
        PlexusArchiverZipFileResourceCollection collection = new PlexusArchiverZipFileResourceCollection();
        collection.setFile(archive);
        collection.setIncludes(fileSet.getIncludes());
        collection.setExcludes(fileSet.getExcludes());
        collection.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        collection.setPrefix(fileSet.getPrefix());
        collection.setCaseSensitive(fileSet.isCaseSensitive());
        collection.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        collection.setStreamTransformer(fileSet.getStreamTransformer());
        FileSelector[] fileSelectors = fileSet.getFileSelectors();
        List<Object> fileSelectorsList = fileSelectors == null ? new ArrayList() : Arrays.asList(fileSelectors);
        fileSelectorsList.add(0, fileInfo -> !prefix.equals(fileInfo.getName()) && fileInfo.getName().startsWith(prefix));
        if (fileSet.getIncludes() != null || fileSet.getExcludes() != null) {
            IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
            includeExcludeFileSelector.setIncludes(fileSet.getIncludes());
            includeExcludeFileSelector.setExcludes(fileSet.getExcludes());
            fileSelectorsList.add(includeExcludeFileSelector);
        }
        collection.setFileSelectors(fileSelectorsList.toArray(new FileSelector[0]));
        collection.setFileMappers(new FileMapper[]{s -> s.replaceFirst("^" + prefix, "")});
        archiver.addResources((PlexusIoResourceCollection)collection);
    }
}

