/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.jangaroo.jooc.AbstractCompileLog;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.mvnplugin.AbstractJangarooMojo;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractCompilerMojo
extends AbstractJangarooMojo {
    private static final String JANGAROO_GROUP_ID = "net.jangaroo";
    private static final String EXML_MAVEN_PLUGIN_ARTIFACT_ID = "exml-maven-plugin";
    @Parameter(property="maven.compiler.failOnError")
    private boolean failOnError = true;
    @Parameter(property="maven.compile.ea")
    private boolean enableAssertions;
    @Parameter(property="maven.compiler.allowDuplicateLocalVariables")
    private boolean allowDuplicateLocalVariables;
    @Parameter(property="maven.compiler.publicApiViolations")
    private String publicApiViolations = PublicApiViolationsMode.WARN.toString().toLowerCase();
    @Parameter(property="maven.compiler.excludeClassByDefault")
    private boolean excludeClassByDefault;
    @Parameter(property="maven.compiler.generateSourceMaps")
    private boolean generateSourceMaps;
    @Parameter(property="maven.compiler.verbose")
    private boolean verbose;
    @Parameter(property="lastModGranularityMs")
    private int staleMillis;
    @Parameter(property="maven.compiler.debuglevel")
    private String debuglevel = DebugMode.SOURCE.toString().toLowerCase();
    @Parameter(property="maven.compiler.autoSemicolon")
    private String autoSemicolon = SemicolonInsertionMode.WARN.toString().toLowerCase();
    @Parameter(defaultValue="${project.build.directory}/generated-sources/joo")
    private File generatedSourcesDirectory;
    @Parameter
    private File keepGeneratedActionScriptDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File catalogOutputDirectory;

    protected abstract List<File> getCompileSourceRoots();

    protected abstract File getOutputDirectory();

    protected File getClassesOutputDirectory() {
        return new File(this.getOutputDirectory(), "jangaroo-app".equals(this.getProject().getPackaging()) ? "app" : "src");
    }

    private File getLocalizedOutputDirectory() {
        return new File(this.getOutputDirectory(), "locale");
    }

    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    @Nullable
    protected abstract File getApiOutputDirectory();

    protected File getCatalogOutputDirectory() {
        return this.catalogOutputDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        final Log log = this.getLog();
        if (this.getCompileSourceRoots().isEmpty()) {
            log.info((CharSequence)"No sources to compile");
            return;
        }
        JoocConfiguration configuration = this.createJoocConfiguration(log);
        if (configuration == null) {
            return;
        }
        Jooc jooc = new Jooc(configuration, (CompileLog)new AbstractCompileLog(){

            protected void doLogError(String msg) {
                log.error((CharSequence)msg);
            }

            public void warning(String msg) {
                log.warn((CharSequence)msg);
            }
        });
        int result = this.compile(jooc);
        if (result != 0 && this.failOnError) {
            log.info((CharSequence)"-------------------------------------------------------------");
            if (result == 1) {
                log.error((CharSequence)"There were compile errors (see log above).");
            } else {
                log.error((CharSequence)("Internal Jangaroo compiler error: " + result + "\nSee log for error details."));
            }
            log.info((CharSequence)"-------------------------------------------------------------");
            throw new MojoFailureException("Compilation failed");
        }
    }

    protected JoocConfiguration createJoocConfiguration(Log log) throws MojoExecutionException, MojoFailureException {
        String configClassPackage;
        JoocConfiguration configuration = new JoocConfiguration();
        configuration.setEnableAssertions(this.enableAssertions);
        configuration.setAllowDuplicateLocalVariables(this.allowDuplicateLocalVariables);
        configuration.setVerbose(this.verbose);
        configuration.setExcludeClassByDefault(this.excludeClassByDefault);
        configuration.setGenerateSourceMaps(this.generateSourceMaps);
        configuration.setKeepGeneratedActionScriptDirectory(this.keepGeneratedActionScriptDirectory);
        if (StringUtils.isNotEmpty((String)this.debuglevel)) {
            try {
                configuration.setDebugMode(DebugMode.valueOf((String)this.debuglevel.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified debug level: '" + this.debuglevel + "' is unsupported. Legal values are 'none', 'lines', and 'source'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.autoSemicolon)) {
            try {
                configuration.setSemicolonInsertionMode(SemicolonInsertionMode.valueOf((String)this.autoSemicolon.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified semicolon insertion mode: '" + this.autoSemicolon + "' is unsupported. Legal values are 'error', 'warn', and 'quirks'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.publicApiViolations)) {
            try {
                configuration.setPublicApiViolationsMode(PublicApiViolationsMode.valueOf((String)this.publicApiViolations.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified public API violations mode: '" + this.publicApiViolations + "' is unsupported. Legal values are 'error', 'warn', and 'allow'.");
            }
        }
        HashSet<File> sources = new HashSet<File>();
        log.debug((CharSequence)"starting source inclusion scanner");
        sources.addAll(this.computeStaleSources(this.staleMillis));
        if (sources.isEmpty()) {
            log.info((CharSequence)"Nothing to compile - all classes are up to date");
            return null;
        }
        configuration.setSourceFiles(new ArrayList(sources));
        try {
            configuration.setSourcePath(this.getCompileSourceRoots());
        }
        catch (IOException e) {
            throw new MojoFailureException("could not canonicalize source paths: " + this.getCompileSourceRoots(), (Throwable)e);
        }
        configuration.setClassPath(this.getActionScriptClassPath());
        configuration.setOutputDirectory(this.getClassesOutputDirectory());
        configuration.setLocalizedOutputDirectory(this.getLocalizedOutputDirectory());
        configuration.setApiOutputDirectory(this.getApiOutputDirectory());
        ArrayList<NamespaceConfiguration> allNamespaces = new ArrayList<NamespaceConfiguration>();
        if (this.getNamespaces() != null) {
            allNamespaces.addAll(Arrays.asList(this.getNamespaces()));
        }
        if ((configClassPackage = this.findConfigClassPackageInExmlPluginConfiguration()) != null) {
            String namespace = "exml:" + configClassPackage;
            this.getLog().info((CharSequence)String.format("Adding namespace %s derived from %s configuration.", namespace, EXML_MAVEN_PLUGIN_ARTIFACT_ID));
            allNamespaces.add(new NamespaceConfiguration(namespace, null));
        }
        configuration.setNamespaces(allNamespaces);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Source path: " + configuration.getSourcePath().toString().replace(',', '\n')));
            log.debug((CharSequence)("Class path: " + configuration.getClassPath().toString().replace(',', '\n')));
            log.debug((CharSequence)("Output directory: " + configuration.getOutputDirectory()));
            if (configuration.getApiOutputDirectory() != null) {
                log.debug((CharSequence)("API output directory: " + configuration.getApiOutputDirectory()));
            }
        }
        return configuration;
    }

    private String findConfigClassPackageInExmlPluginConfiguration() {
        Xpp3Dom configClassPackageElement;
        Object exmlPluginConfiguration;
        Plugin plugin;
        String configClassPackage = null;
        List plugins = this.getProject().getBuildPlugins();
        Iterator iterator = plugins.iterator();
        while (!(!iterator.hasNext() || JANGAROO_GROUP_ID.equals((plugin = (Plugin)iterator.next()).getGroupId()) && EXML_MAVEN_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId()) && (exmlPluginConfiguration = plugin.getConfiguration()) instanceof Xpp3Dom && (configClassPackageElement = ((Xpp3Dom)exmlPluginConfiguration).getChild("configClassPackage")) != null && (configClassPackage = configClassPackageElement.getValue()) != null && !(configClassPackage = configClassPackage.trim()).isEmpty())) {
        }
        return configClassPackage;
    }

    protected abstract List<File> getActionScriptClassPath();

    private int compile(Jooc jooc) throws MojoExecutionException {
        File outputDirectory = jooc.getConfig().getOutputDirectory();
        FileHelper.ensureDirectory(outputDirectory);
        File apiOutputDirectory = this.getApiOutputDirectory();
        if (apiOutputDirectory != null) {
            FileHelper.ensureDirectory(apiOutputDirectory);
        }
        List sources = jooc.getConfig().getSourceFiles();
        Log log = this.getLog();
        log.info((CharSequence)("Compiling " + sources.size() + " joo source file" + (sources.size() == 1 ? "" : "s") + " to " + outputDirectory));
        return jooc.run().getResultCode();
    }

    private List<File> computeStaleSources(int staleMillis) throws MojoExecutionException {
        File outputDirectory = this.getApiOutputDirectory();
        String outputFileSuffix = ".as";
        if (outputDirectory == null) {
            outputDirectory = this.getClassesOutputDirectory();
            outputFileSuffix = ".js";
        }
        List<File> compileSourceRoots = this.getCompileSourceRoots();
        ArrayList<File> staleFiles = new ArrayList<File>();
        staleFiles.addAll(this.getMavenPluginHelper().computeStaleSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), outputDirectory, ".as", outputFileSuffix, staleMillis));
        staleFiles.addAll(this.getMavenPluginHelper().computeStaleSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), outputDirectory, ".mxml", outputFileSuffix, staleMillis));
        staleFiles.addAll(this.getMavenPluginHelper().computeStalePropertiesSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), this.getLocalizedOutputDirectory(), staleMillis));
        return staleFiles;
    }

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();
}

