/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha.configbuilder;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaConfigBuilder;

public class SenchaPackageOrAppConfigBuilder<T extends SenchaPackageOrAppConfigBuilder>
extends SenchaConfigBuilder<T> {
    public static final String CSS = "css";
    public static final String JS = "js";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String CREATOR = "creator";
    private static final String SUMMARY = "summary";
    protected static final String TYPE = "type";
    private static final String TOOLKIT = "toolkit";
    private static final String THEME = "theme";
    private static final String REQUIRES = "requires";
    private static final String RESOURCES = "resources";
    private static final String RESOURCE_PATH = "path";
    static final String PATH = "path";
    static final String BUNDLE = "bundle";
    static final String INCLUDE_IN_BUNDLE = "includeInBundle";
    static final String BUILD_OUT_CSS_PATH = "${build.out.css.path}";
    static final String EXCLUDE = "exclude";
    static final String FASHION = "fashion";

    public T name(String name) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(NAME, name));
    }

    public T version(String version) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(VERSION, version));
    }

    public T creator(String creator) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(CREATOR, creator));
    }

    public T summary(String summary) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(SUMMARY, summary));
    }

    public T type(String type) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(TYPE, type));
    }

    public T toolkit(String toolkit) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(TOOLKIT, toolkit));
    }

    public T theme(String theme) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(THEME, theme));
    }

    public T require(String require) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.addToList(ImmutableMap.of((Object)NAME, (Object)require), REQUIRES));
    }

    public T profile(String profile, Map<String, Object> configuration) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.nameValue(profile, configuration));
    }

    public T resource(String path) {
        LinkedHashMap<String, String> resource = new LinkedHashMap<String, String>();
        this.fillResource(path, resource);
        return (T)((SenchaPackageOrAppConfigBuilder)this.addToList(resource, RESOURCES));
    }

    void fillResource(String path, Map<String, String> resource) {
        resource.put("path", path);
    }

    public T css(String path, boolean bundle, boolean includeInBundle) {
        return this.cssOrJs(CSS, path, bundle, includeInBundle);
    }

    public T js(String path, boolean bundle, boolean includeInBundle) {
        return this.cssOrJs(JS, path, bundle, includeInBundle);
    }

    public T cssOrJs(String cssOrJs, String path, boolean bundle, boolean includeInBundle) {
        return (T)((SenchaPackageOrAppConfigBuilder)this.addToList(SenchaPackageOrAppConfigBuilder.getResourceEntry(path, bundle, includeInBundle), cssOrJs));
    }

    private static Map<String, Object> getResourceEntry(String path, boolean bundle, boolean includeInBundle) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("path", path);
        result.put(BUNDLE, bundle);
        result.put(INCLUDE_IN_BUNDLE, includeInBundle);
        if (BUILD_OUT_CSS_PATH.equals(path)) {
            result.put(EXCLUDE, Collections.singletonList(FASHION));
        }
        return Collections.unmodifiableMap(result);
    }
}

