/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaAppConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generateTestApp", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class JooGenerateTestAppMojo
extends AbstractSenchaMojo {
    private static final String DEFAULT_TEST_APP_JSON = "default.test.app.json";
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testOutputDirectory;
    @Parameter
    private String toolkit = "classic";
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(property="skipJooUnitTests")
    private boolean skipJooUnitTests;
    @Parameter
    private String testSuite = null;

    public void execute() throws MojoExecutionException {
        boolean doSkip;
        boolean bl = doSkip = this.skip || this.skipTests || this.skipJooUnitTests;
        if (doSkip || this.testSuite == null) {
            this.getLog().info((CharSequence)("Skipping generation of Jangaroo test app: " + (doSkip ? "tests skipped." : "no tests found.")));
        } else {
            this.getLog().info((CharSequence)("Creating Jangaroo test app below " + this.testOutputDirectory));
            this.createWebApp(this.testOutputDirectory);
            new SenchaCmdExecutor(this.testOutputDirectory, "config -prop skip.sass=1 -prop skip.resources=1 then app refresh", this.getLog(), this.getSenchaLogLevel()).execute();
        }
    }

    private void createWebApp(File webappDirectory) throws MojoExecutionException {
        if (SenchaUtils.doesSenchaAppExist(webappDirectory)) {
            this.getLog().info((CharSequence)"Sencha app already exists, skip generating one");
            return;
        }
        this.getLog().info((CharSequence)String.format("Generating Sencha App %s for unit tests...", webappDirectory));
        FileHelper.ensureDirectory(webappDirectory);
        SenchaUtils.generateSenchaTestAppFromTemplate(webappDirectory, this.project, SenchaUtils.getSenchaPackageName(this.project), this.testSuite, this.toolkit, this.getLog(), this.getSenchaLogLevel());
        this.createAppJson();
    }

    private boolean isTestDependency(Dependency dependency) {
        return "test".equals(dependency.getScope()) && SenchaUtils.isSenchaDependency(dependency) && !this.isExtFrameworkDependency(dependency);
    }

    private void createAppJson() throws MojoExecutionException {
        File appJsonFile = new File(this.project.getBuild().getTestOutputDirectory(), "app.json");
        this.getLog().info((CharSequence)String.format("Generating Sencha App %s for unit tests...", appJsonFile.getPath()));
        SenchaAppConfigBuilder configBuilder = new SenchaAppConfigBuilder();
        try {
            configBuilder.destFile(appJsonFile);
            configBuilder.defaults(DEFAULT_TEST_APP_JSON);
            configBuilder.destFileComment("Auto-generated test application configuration. DO NOT EDIT!");
            configBuilder.require(SenchaUtils.getSenchaPackageName(this.project));
            List projectDependencies = this.project.getDependencies();
            for (Dependency dependency : projectDependencies) {
                if (!this.isTestDependency(dependency)) continue;
                configBuilder.require(SenchaUtils.getSenchaPackageName(dependency.getGroupId(), dependency.getArtifactId()));
            }
            configBuilder.buildFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not build test app.json", (Exception)e);
        }
    }

    void skip() {
        this.skip = true;
    }

    void skipTests() {
        this.skipTests = true;
    }
}

