/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.proxy;

import java.net.HttpCookie;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jangaroo.jooc.mvnplugin.proxy.HttpClientUtil;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.mitre.dsmiley.httpproxy.ProxyServlet;

public class JangarooProxyServlet
extends ProxyServlet {
    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        int fragIdx;
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri(servletRequest));
        String servletPath = servletRequest.getServletPath();
        String relativeRequestUri = servletRequest.getRequestURI().replaceFirst(servletPath, "");
        uri.append(JangarooProxyServlet.encodeUriQuery((CharSequence)relativeRequestUri));
        String queryString = servletRequest.getQueryString();
        String fragment = null;
        if (queryString != null && (fragIdx = queryString.indexOf(35)) >= 0) {
            fragment = queryString.substring(fragIdx + 1);
            queryString = queryString.substring(0, fragIdx);
        }
        if ((queryString = this.rewriteQueryStringFromRequest(servletRequest, queryString)) != null && queryString.length() > 0) {
            uri.append('?');
            uri.append(JangarooProxyServlet.encodeUriQuery((CharSequence)queryString));
        }
        if (this.doSendUrlFragment && fragment != null) {
            uri.append('#');
            uri.append(JangarooProxyServlet.encodeUriQuery((CharSequence)fragment));
        }
        return uri.toString();
    }

    protected HttpClient createHttpClient(RequestConfig requestConfig) {
        return HttpClientUtil.createHttpsAwareHttpClientBuilder().setDefaultRequestConfig(requestConfig).build();
    }

    protected void copyProxyCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String headerValue) {
        List<HttpCookie> cookies = HttpCookie.parse(headerValue);
        String path = servletRequest.getContextPath();
        if ((path = path + servletRequest.getServletPath()).isEmpty()) {
            path = "/";
        }
        for (HttpCookie cookie : cookies) {
            String proxyCookieName = this.doPreserveCookies ? cookie.getName() : this.getCookieNamePrefix(cookie.getName()) + cookie.getName();
            Cookie servletCookie = new Cookie(proxyCookieName, cookie.getValue());
            servletCookie.setComment(cookie.getComment());
            servletCookie.setMaxAge((int)cookie.getMaxAge());
            servletCookie.setPath(path);
            servletCookie.setHttpOnly(cookie.isHttpOnly());
            servletCookie.setSecure("https".equals(servletRequest.getScheme()) && cookie.getSecure());
            servletCookie.setVersion(cookie.getVersion());
            servletResponse.addCookie(servletCookie);
        }
    }
}

