/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaPackageOrAppMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaAppConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package-app", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SenchaPackageAppMojo
extends AbstractSenchaPackageOrAppMojo<SenchaAppConfigBuilder> {
    private static final String DEFAULT_LOCALE = "en";
    private static final String APP_JSON_FILENAME = "/app.json";
    @Parameter
    private List<String> additionalLocales = Collections.emptyList();
    @Parameter(property="senchaAppBuild")
    private String senchaAppBuild = "development";
    @Parameter(defaultValue="${project.build.directory}/app", readonly=true)
    private File senchaAppDirectory;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter
    private String applicationClass;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;

    @Override
    public String getType() {
        return "app";
    }

    @Override
    public String getJsonConfigFileName() {
        return "app.json";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"jangaroo-app".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app\"");
        }
        if (StringUtils.isEmpty((CharSequence)this.senchaAppBuild)) {
            this.senchaAppBuild = "development";
        }
        if (!("production".equals(this.senchaAppBuild) || "development".equals(this.senchaAppBuild) || "testing".equals(this.senchaAppBuild))) {
            throw new MojoExecutionException("'senchaAppBuild' must be one of 'production', 'testing' or 'development'.");
        }
        this.prepareModule();
        this.packageModule();
        FileHelper.createAppOrAppOverlayJar(this.session, this.archiver, this.artifactHandlerManager, this.senchaAppBuild);
    }

    private void prepareModule() throws MojoExecutionException {
        FileHelper.ensureDirectory(this.senchaAppDirectory);
        this.getLog().info((CharSequence)String.format("Copy files from %s to %s", this.getSenchaSrcDir().getPath(), this.senchaAppDirectory.getPath()));
        FileHelper.copyFiles(this.getSenchaSrcDir(), this.senchaAppDirectory);
        SenchaAppConfigBuilder senchaConfigBuilder = this.createSenchaConfigBuilder();
        this.configure(senchaConfigBuilder);
        SenchaUtils.writeFile(senchaConfigBuilder, this.senchaAppDirectory.getPath(), APP_JSON_FILENAME, null, this.getLog());
    }

    private void configure(SenchaAppConfigBuilder configBuilder) throws MojoExecutionException {
        SenchaUtils.configureDefaults(configBuilder, "default.app.json");
        super.configure(configBuilder);
        configBuilder.id(this.generateSenchaAppId());
        this.configureLocales(configBuilder);
    }

    private void configureLocales(SenchaAppConfigBuilder configBuilder) {
        configBuilder.locale(DEFAULT_LOCALE);
        for (String locale : this.additionalLocales) {
            configBuilder.locale(locale);
        }
        if (!this.additionalLocales.isEmpty()) {
            configBuilder.require("locale");
        }
    }

    private void packageModule() throws MojoExecutionException {
        if (!this.senchaAppDirectory.exists()) {
            throw new MojoExecutionException("Sencha package directory does not exist: " + this.senchaAppDirectory.getPath());
        }
        this.buildSenchaApp(this.senchaAppDirectory, this.senchaAppBuild);
    }

    private String generateSenchaAppId() {
        String appIdString = SenchaUtils.getSenchaPackageName(this.project) + SenchaUtils.getSenchaVersionForMavenVersion(this.project.getVersion());
        return UUID.nameUUIDFromBytes(appIdString.getBytes()).toString();
    }

    private void buildSenchaApp(File senchaAppDirectory, String buildEnvironment) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Building Sencha app module for build environment '" + buildEnvironment + "'."));
        StringBuilder args = new StringBuilder();
        args.append("app build").append(" --").append(buildEnvironment).append(" --locale en");
        if (!this.additionalLocales.isEmpty()) {
            args.append(" then config -prop skip.sass=1 -prop skip.resources=1");
            for (String locale : this.additionalLocales) {
                args.append(" then app build").append(" --").append(buildEnvironment).append(" --locale ").append(locale);
            }
        }
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(senchaAppDirectory, args.toString(), this.getLog(), this.getSenchaLogLevel());
        senchaCmdExecutor.execute();
    }

    @Override
    protected SenchaAppConfigBuilder createSenchaConfigBuilder() {
        return new SenchaAppConfigBuilder();
    }
}

