/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-app", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class SenchaGenerateAppMojo
extends AbstractSenchaMojo {
    @Parameter
    private String applicationClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"jangaroo-app".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app\"");
        }
        if (StringUtils.isBlank((CharSequence)this.applicationClass)) {
            throw new MojoExecutionException("\"applicationClass\" is missing. This configuration is mandatory for \"jangaroo-app\" packaging.");
        }
        File appDir = new File(this.project.getBuild().getDirectory() + "/app");
        FileHelper.ensureDirectory(appDir);
        if (SenchaUtils.doesSenchaAppExist(appDir)) {
            this.getLog().info((CharSequence)"Sencha app already exists, skip generating one");
            return;
        }
        String senchaAppName = SenchaUtils.getSenchaPackageName(this.project);
        SenchaUtils.generateSenchaAppFromTemplate(appDir, senchaAppName, this.applicationClass, this.getToolkit(), this.getLog(), this.getSenchaLogLevel());
    }
}

