/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.proxy.AddDynamicPackagesServlet;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.JettyWrapper;
import net.jangaroo.jooc.mvnplugin.util.ProxyServletConfig;
import net.jangaroo.jooc.mvnplugin.util.StaticResourcesServletConfig;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
public class RunMojo
extends AbstractSenchaMojo {
    @Parameter(property="jooJettyHost")
    private String jooJettyHost = "localhost";
    @Parameter(property="jooJettyPort")
    private int jooJettyPort = 8080;
    @Parameter(property="jooProxyTargetUri")
    private String jooProxyTargetUri;
    @Parameter(property="jooProxyPathSpec")
    private String jooProxyPathSpec;
    @Parameter
    private List<StaticResourcesServletConfig> jooStaticResourcesServletConfigs = Collections.emptyList();
    @Parameter
    private List<ProxyServletConfig> jooProxyServletConfigs;

    public void setJooProxyTargetUri(String jooProxyTargetUri) {
        this.jooProxyTargetUri = jooProxyTargetUri.endsWith("/") ? jooProxyTargetUri : jooProxyTargetUri + "/";
    }

    public void execute() throws MojoExecutionException {
        File baseDir;
        boolean isSwcPackaging = "swc".equals(this.project.getPackaging());
        boolean isAppPackaging = "jangaroo-app".equals(this.project.getPackaging());
        boolean isAppOverlayPackaging = "jangaroo-app-overlay".equals(this.project.getPackaging());
        File file = isAppPackaging || isAppOverlayPackaging ? new File(this.project.getBuild().getDirectory(), "app") : (baseDir = isSwcPackaging ? new File(this.project.getBuild().getTestOutputDirectory()) : null);
        if (baseDir == null) {
            this.getLog().info((CharSequence)String.format("jangaroo:run does not support packaging '%s' (module %s:%s).", this.project.getPackaging(), this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        JettyWrapper jettyWrapper = new JettyWrapper(this.getLog(), baseDir);
        ArrayList<StaticResourcesServletConfig> staticResourcesServletConfigs = new ArrayList<StaticResourcesServletConfig>(this.jooStaticResourcesServletConfigs);
        if (isSwcPackaging) {
            String senchaPackageName = SenchaUtils.getSenchaPackageName(this.project);
            staticResourcesServletConfigs.add(new StaticResourcesServletConfig("/packages/" + senchaPackageName + "/" + "*"));
        } else if (isAppOverlayPackaging) {
            if ("/*".equals(this.jooProxyPathSpec)) {
                File[] packageDirs = new File(baseDir, "packages").listFiles(File::isDirectory);
                if (packageDirs != null) {
                    List<String> packageNames = Arrays.stream(packageDirs).map(File::getName).collect(Collectors.toList());
                    for (String packageName : packageNames) {
                        staticResourcesServletConfigs.add(new StaticResourcesServletConfig("/packages/" + packageName + "/" + "*", "/"));
                    }
                    jettyWrapper.setAdditionalServlets(Collections.singletonMap("/dynamic-packages.json", new AddDynamicPackagesServlet(this.jooProxyTargetUri + "dynamic-packages.json", packageNames)));
                }
            } else {
                AbstractSenchaMojo.JangarooApp jangarooApp = this.createJangarooApp(this.project);
                while (jangarooApp instanceof AbstractSenchaMojo.JangarooAppOverlay) {
                    jangarooApp = ((AbstractSenchaMojo.JangarooAppOverlay)jangarooApp).baseApp;
                    this.addAppToResources(jettyWrapper, jangarooApp.mavenProject);
                }
                staticResourcesServletConfigs.add(new StaticResourcesServletConfig("/*", "/"));
            }
        }
        jettyWrapper.setStaticResourcesServletConfigs(staticResourcesServletConfigs);
        if (this.jooProxyServletConfigs != null && !this.jooProxyServletConfigs.isEmpty()) {
            jettyWrapper.setProxyServletConfigs(this.jooProxyServletConfigs);
        } else if (this.jooProxyTargetUri != null && this.jooProxyPathSpec != null) {
            jettyWrapper.setProxyServletConfigs(Collections.singletonList(new ProxyServletConfig(this.jooProxyTargetUri, this.jooProxyPathSpec)));
        } else if (this.jooProxyTargetUri != null) {
            this.getLog().warn((CharSequence)"Ignoring 'jooProxyTargetUri' since there is no 'jooProxyPathSpec'.");
        } else if (this.jooProxyPathSpec != null) {
            this.getLog().warn((CharSequence)"Ignoring 'jooProxyPathSpec' since there is no 'jooProxyTargetUri'.");
        }
        try {
            jettyWrapper.start(this.jooJettyHost, this.jooJettyPort);
            this.getLog().info((CharSequence)("Started Jetty server at: " + jettyWrapper.getUri()));
            this.logJangarooAppUrl(baseDir, jettyWrapper, this.project);
            jettyWrapper.blockUntilInterrupted();
        }
        catch (JettyWrapper.JettyWrapperException e) {
            throw new MojoExecutionException("Could not start Jetty", (Exception)e);
        }
        finally {
            jettyWrapper.stop();
        }
    }

    private void addAppToResources(JettyWrapper jettyWrapper, MavenProject baseAppProject) throws MojoExecutionException {
        if (baseAppProject.getBuild().getDirectory() != null && new File(baseAppProject.getBuild().getDirectory()).isDirectory()) {
            File appResourceDir = new File(baseAppProject.getBuild().getDirectory(), "app");
            jettyWrapper.addBaseDir(appResourceDir);
            this.getLog().info((CharSequence)("Adding base app resource directory " + appResourceDir.getAbsolutePath()));
        } else {
            Artifact baseAppArtifact = this.getArtifact(baseAppProject);
            if (baseAppArtifact == null) {
                throw new MojoExecutionException("Artifact of base app " + baseAppProject + " not found in project dependencies.");
            }
            File baseAppResourceJar = baseAppArtifact.getFile();
            if (baseAppResourceJar == null) {
                throw new MojoExecutionException("Artifact of base app " + baseAppProject + " has null file, cannot determine JAR location.");
            }
            this.getLog().info((CharSequence)("Adding base app JAR " + baseAppResourceJar.getAbsolutePath()));
            jettyWrapper.addResourceJar(baseAppResourceJar);
        }
    }

    private void logJangarooAppUrl(File baseDir, JettyWrapper jettyWrapper, MavenProject project) {
        if (baseDir.exists()) {
            this.getLog().info((CharSequence)("Found " + project.getPackaging() + " at: " + jettyWrapper.getUri()));
        }
    }
}

