/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="pre-clean", defaultPhase=LifecyclePhase.PRE_CLEAN, threadSafe=true)
public class PreCleanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDirectory;

    public void execute() throws MojoFailureException {
        if (SystemUtils.IS_OS_WINDOWS) {
            LinkedList<Path> toScan = new LinkedList<Path>();
            LinkedList<Path> toRemove = new LinkedList<Path>();
            if (this.targetDirectory.exists() && this.targetDirectory.isDirectory()) {
                toScan.add(this.targetDirectory.toPath());
            }
            while (!toScan.isEmpty()) {
                try {
                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream((Path)toScan.poll());
                    Throwable throwable = null;
                    try {
                        for (Path path : directoryStream) {
                            BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                            if (!attributes.isDirectory()) continue;
                            boolean isJunction = attributes.isOther();
                            (isJunction ? toRemove : toScan).add(path);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (directoryStream == null) continue;
                        if (throwable != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        directoryStream.close();
                    }
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Unable to enumerate target directory " + this.targetDirectory.getPath(), (Throwable)ex);
                }
            }
            this.getLog().info((CharSequence)String.format("Removing %d directory junctions...", toRemove.size()));
            for (Path path : toRemove) {
                try {
                    this.getLog().debug((CharSequence)("  Removing directory junction " + path));
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    throw new MojoFailureException("Unable to remove directory junction " + path, (Throwable)e);
                }
            }
        }
    }
}

