/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

public abstract class AbstractSenchaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter
    private String toolkit = "classic";
    @Parameter(defaultValue="((net\\.jangaroo\\.com)|(com\\.coremedia))\\.sencha:ext-js(-pkg)?(-gpl)?")
    private String extFrameworkArtifactRegexp;
    @Parameter(property="senchaLogLevel")
    private String senchaLogLevel;
    private volatile Pattern extFrameworkArtifactPattern;
    private Map<String, MavenProject> mavenProjectByDependencyCache = new HashMap<String, MavenProject>();

    public String getToolkit() {
        return this.toolkit;
    }

    public Pattern getExtFrameworkArtifactPattern() {
        if (this.extFrameworkArtifactPattern == null) {
            this.extFrameworkArtifactPattern = Pattern.compile(this.getExtFrameworkArtifactRegexp());
        }
        return this.extFrameworkArtifactPattern;
    }

    public String getExtFrameworkArtifactRegexp() {
        return this.extFrameworkArtifactRegexp;
    }

    public String getSenchaLogLevel() {
        return this.senchaLogLevel;
    }

    protected boolean isExtFrameworkArtifact(Artifact artifact) {
        return this.isExtFramework(artifact.getGroupId(), artifact.getArtifactId());
    }

    protected boolean isExtFrameworkDependency(Dependency dependency) {
        return this.isExtFramework(dependency.getGroupId(), dependency.getArtifactId());
    }

    private boolean isExtFramework(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        return this.getExtFrameworkArtifactPattern().matcher(key).matches();
    }

    @Nonnull
    MavenProject getProjectFromDependency(MavenProject project, Dependency dependency) throws MojoExecutionException {
        String key = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
        if (project.getProjectReferences().containsKey(key)) {
            return (MavenProject)project.getProjectReferences().get(key);
        }
        return this.createProjectFromDependency(dependency);
    }

    @Nonnull
    private MavenProject createProjectFromDependency(@Nonnull Dependency dependency) throws MojoExecutionException {
        String dependencyKey = dependency.toString();
        if (this.mavenProjectByDependencyCache.containsKey(dependencyKey)) {
            return this.mavenProjectByDependencyCache.get(dependencyKey);
        }
        this.getLog().debug((CharSequence)("createProjectFromDependency(" + dependency + ")"));
        Artifact artifactFromDependency = this.getArtifact(dependency);
        if (artifactFromDependency == null) {
            artifactFromDependency = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
        }
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        request.setValidationLevel(0);
        request.setProcessPlugins(false);
        request.setResolveDependencies(false);
        try {
            ProjectBuildingResult result = this.projectBuilder.build(artifactFromDependency, (ProjectBuildingRequest)request);
            MavenProject project = result.getProject();
            this.mavenProjectByDependencyCache.put(dependencyKey, project);
            return project;
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not resolve required dependencies of POM dependency " + artifactFromDependency, (Exception)((Object)e));
        }
    }

    Artifact getArtifact(Dependency dependency) {
        return this.getArtifact(dependency.getGroupId(), dependency.getArtifactId());
    }

    Artifact getArtifact(MavenProject mavenProject) {
        return this.getArtifact(mavenProject.getGroupId(), mavenProject.getArtifactId());
    }

    private Artifact getArtifact(String groupId, String artifactId) {
        String versionlessKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        return (Artifact)this.project.getArtifactMap().get(versionlessKey);
    }

    JangarooApp createJangarooApp(MavenProject project) throws MojoExecutionException {
        String packaging = project.getPackaging();
        if ("jangaroo-app".equals(packaging)) {
            return new JangarooApp(project);
        }
        if ("jangaroo-app-overlay".equals(packaging)) {
            return this.createJangarooAppOverlay(project);
        }
        return null;
    }

    JangarooAppOverlay createJangarooAppOverlay(MavenProject project) throws MojoExecutionException {
        List dependencies = project.getDependencies();
        for (Dependency dependency : dependencies) {
            MavenProject dependentProject;
            JangarooApp baseApp;
            if (!"jar".equals(dependency.getType()) || (baseApp = this.createJangarooApp(dependentProject = this.getProjectFromDependency(project, dependency))) == null) continue;
            return new JangarooAppOverlay(project, baseApp);
        }
        throw new MojoExecutionException("Module of type jangaroo-app-overlay must have a dependency on a module of type jangaroo-app or jangaroo-app-overlay.");
    }

    static class JangarooAppOverlay
    extends JangarooApp {
        final JangarooApp baseApp;

        JangarooAppOverlay(MavenProject mavenProject, JangarooApp baseApp) {
            super(mavenProject);
            this.baseApp = baseApp;
        }

        @Override
        JangarooApp getRootBaseApp() {
            return this.baseApp.getRootBaseApp();
        }

        Set<Artifact> getOwnDynamicPackages() {
            LinkedHashSet<Artifact> ownDynamicPackages = new LinkedHashSet<Artifact>(this.packages);
            ownDynamicPackages.removeAll(this.baseApp.packages);
            return ownDynamicPackages;
        }

        Set<Artifact> getAllDynamicPackages() {
            LinkedHashSet<Artifact> allDynamicPackages = new LinkedHashSet<Artifact>(this.packages);
            allDynamicPackages.removeAll(this.getRootBaseApp().packages);
            return allDynamicPackages;
        }
    }

    static class JangarooApp {
        final MavenProject mavenProject;
        Set<Artifact> packages = new LinkedHashSet<Artifact>();

        JangarooApp(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
        }

        JangarooApp getRootBaseApp() {
            return this;
        }
    }
}

