/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.jangaroo.jooc.mvnplugin.AbstractLinkPackagesMojo;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.DynamicPackagesDeSerializer;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="prepare-package-app-overlay", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PreparePackageAppOverlayMojo
extends AbstractLinkPackagesMojo {
    @Parameter(defaultValue="${project.build.directory}/app", readonly=true)
    private File webResourcesOutputDirectory;

    public void execute() throws MojoExecutionException {
        if (!"jangaroo-app-overlay".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app-overlay\"");
        }
        this.packageAppOverlay();
    }

    private void packageAppOverlay() throws MojoExecutionException {
        File overlayPackagesDir = new File(this.webResourcesOutputDirectory, "packages");
        FileHelper.ensureDirectory(overlayPackagesDir);
        Path packagesPath = overlayPackagesDir.toPath().normalize();
        File remotePackagesDir = SenchaUtils.remotePackagesDir(this.session);
        AbstractSenchaMojo.JangarooAppOverlay jangarooAppOverlay = this.createJangarooAppOverlay(this.project);
        this.populatePackages(jangarooAppOverlay, this.project);
        Set<Artifact> ownDynamicPackages = jangarooAppOverlay.getOwnDynamicPackages();
        this.createSymbolicLinksForArtifacts(ownDynamicPackages, packagesPath, remotePackagesDir);
        Set<Artifact> allDynamicPackages = jangarooAppOverlay.getAllDynamicPackages();
        Set<String> overlayPackageNames = allDynamicPackages.stream().map(artifact -> SenchaUtils.getSenchaPackageName(artifact.getGroupId(), artifact.getArtifactId())).collect(Collectors.toSet());
        this.writeDynamicPackagesJson(overlayPackageNames);
    }

    private void populatePackages(AbstractSenchaMojo.JangarooApp jangarooApp, MavenProject project) throws MojoExecutionException {
        List dependencies = project.getDependencies();
        AbstractSenchaMojo.JangarooAppOverlay jangarooAppOverlay = jangarooApp instanceof AbstractSenchaMojo.JangarooAppOverlay ? (AbstractSenchaMojo.JangarooAppOverlay)jangarooApp : null;
        for (Dependency dependency : dependencies) {
            if (!SenchaUtils.isRequiredSenchaDependency(dependency, false) && !"pom".equals(dependency.getType()) && (!"jar".equals(dependency.getType()) || !"runtime".equals(dependency.getScope()))) continue;
            MavenProject mavenProject = this.getProjectFromDependency(project, dependency);
            if (jangarooAppOverlay != null && jangarooAppOverlay.baseApp.mavenProject.equals((Object)mavenProject)) {
                this.populatePackages(jangarooAppOverlay.baseApp, mavenProject);
                continue;
            }
            if (SenchaUtils.isSenchaDependency(dependency.getType()) && !jangarooApp.packages.add(this.getArtifact(dependency))) continue;
            this.populatePackages(jangarooApp, mavenProject);
        }
    }

    private void writeDynamicPackagesJson(Set<String> dynamicPackageNames) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Writing %s for module %s.", "dynamic-packages.json", this.project.getName()));
        File dynamicPackagesFile = new File(this.webResourcesOutputDirectory, "dynamic-packages.json");
        if (!dynamicPackagesFile.exists()) {
            FileHelper.ensureDirectory(dynamicPackagesFile.getParentFile());
        } else {
            this.getLog().debug((CharSequence)"dynamic-packages.json for module already exists, deleting...");
            if (!dynamicPackagesFile.delete()) {
                throw new MojoExecutionException("Could not delete dynamic-packages.json file for module");
            }
        }
        try {
            DynamicPackagesDeSerializer.writeDynamicPackages(new FileOutputStream(dynamicPackagesFile), dynamicPackageNames);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create dynamic-packages.json resource", (Exception)e);
        }
    }
}

