/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import net.jangaroo.jooc.mvnplugin.proxy.JangarooProxyServlet;
import net.jangaroo.jooc.mvnplugin.util.ProxyServletConfig;
import net.jangaroo.jooc.mvnplugin.util.StaticResourcesServletConfig;
import org.apache.commons.lang3.Range;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class JettyWrapper {
    private static final long WAIT_TIME_MILLIS = 1000L;
    private static final StaticResourcesServletConfig DEFAULT_RESOURCES_SERVLET_CONFIG = new StaticResourcesServletConfig("/*", "/");
    private final Log log;
    private List<File> baseDirs = new ArrayList<File>();
    private List<StaticResourcesServletConfig> staticResourcesServletConfigs;
    private List<ProxyServletConfig> proxyServletConfigs;
    private Map<String, Servlet> additionalServlets;
    private Server server;
    private List<File> resourceJars = new ArrayList<File>();

    public JettyWrapper(Log log, File baseDir) {
        this.log = log;
        this.baseDirs.add(baseDir);
    }

    public void addBaseDir(File baseDir) {
        this.baseDirs.add(baseDir);
    }

    public void setStaticResourcesServletConfigs(List<StaticResourcesServletConfig> staticResourcesServletConfigs) {
        this.staticResourcesServletConfigs = staticResourcesServletConfigs;
    }

    public void addResourceJar(File resourceJar) {
        this.resourceJars.add(resourceJar);
    }

    public void setProxyServletConfigs(List<ProxyServletConfig> proxyServletConfigs) {
        this.proxyServletConfigs = proxyServletConfigs;
    }

    public void setAdditionalServlets(Map<String, Servlet> additionalServlets) {
        this.additionalServlets = additionalServlets;
    }

    public void start(String host, int port) throws JettyWrapperException {
        this.start(host, (Range<Integer>)Range.is((Comparable)Integer.valueOf(port)));
    }

    public void start(String host, Range<Integer> portRange) throws JettyWrapperException {
        if (this.server != null) {
            this.stop();
        }
        Exception lastException = null;
        JettyWebAppContext handler = this.createHandler();
        List<Integer> shuffledPorts = this.shufflePortRange(portRange);
        for (Integer port : shuffledPorts) {
            try {
                this.server = null;
                this.server = this.createServer(host, port, (Handler)handler);
                this.server.start();
                break;
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)"Could not start server", (Throwable)e);
                lastException = e;
            }
        }
        if (this.server == null || !this.server.isRunning()) {
            throw new JettyWrapperException("Could not start server", lastException);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Could not stop server", (Throwable)e);
            }
        }
    }

    public URI getUri() {
        return this.server.getURI();
    }

    public void waitUntilStarted(int timeoutMillis) throws JettyWrapperException {
        if (this.server == null) {
            throw new JettyWrapperException("Server not started");
        }
        this.getLog().info((CharSequence)String.format("Waiting for Server startup (timeout = %d ms)", timeoutMillis));
        int waitedMillis = 0;
        try {
            while (waitedMillis < timeoutMillis && !this.server.isStarted()) {
                this.getLog().debug((CharSequence)"Server not ready yet. Waiting ...");
                Thread.sleep(1000L);
                waitedMillis = (int)((long)waitedMillis + 1000L);
            }
        }
        catch (InterruptedException e) {
            this.getLog().warn((CharSequence)"Interrupted while waiting for startup", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.server.isStarted()) {
            throw new JettyWrapperException(String.format("Server did not start within %d ms", timeoutMillis));
        }
    }

    public void blockUntilInterrupted() {
        try {
            this.server.join();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    private Server createServer(String host, int port, Handler handler) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.getLog().info((CharSequence)("Creating Jetty server at " + address));
        Server server = new Server(address);
        server.setHandler(handler);
        return server;
    }

    private JettyWebAppContext createHandler() throws JettyWrapperException {
        try {
            JettyWebAppContext handler = new JettyWebAppContext();
            handler.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            List<Resource> baseResources = this.baseDirs.stream().map(Resource::newResource).collect(Collectors.toList());
            baseResources = new ArrayList(baseResources);
            if (this.resourceJars != null && !this.resourceJars.isEmpty()) {
                for (File file : this.resourceJars) {
                    baseResources.add(Resource.newResource((String)("jar:" + Resource.toURL((File)file).toString() + "!/META-INF/resources")));
                }
            }
            handler.setBaseResource((Resource)new ResourceCollection(baseResources.toArray(new Resource[0])));
            this.getLog().info((CharSequence)("Using base resources " + baseResources));
            if (this.staticResourcesServletConfigs != null && !this.staticResourcesServletConfigs.isEmpty()) {
                for (StaticResourcesServletConfig staticResourcesServletConfig : this.staticResourcesServletConfigs) {
                    this.addDefaultServlet(handler, staticResourcesServletConfig);
                }
            } else {
                this.addDefaultServlet(handler, DEFAULT_RESOURCES_SERVLET_CONFIG);
            }
            if (this.proxyServletConfigs != null && !this.proxyServletConfigs.isEmpty()) {
                for (ProxyServletConfig proxyServletConfig : this.proxyServletConfigs) {
                    this.addProxyServlet(handler, proxyServletConfig);
                }
            }
            if (this.additionalServlets != null && !this.additionalServlets.isEmpty()) {
                for (Map.Entry entry : this.additionalServlets.entrySet()) {
                    handler.addServlet(new ServletHolder((Servlet)entry.getValue()), (String)entry.getKey());
                }
            }
            return handler;
        }
        catch (Exception e) {
            throw new JettyWrapperException(e);
        }
    }

    private void addDefaultServlet(JettyWebAppContext webAppContext, StaticResourcesServletConfig config) {
        ServletHolder servletHolder = new ServletHolder(DefaultServlet.class);
        servletHolder.setInitParameter("relativeResourceBase", config.getRelativeResourceBase());
        servletHolder.setInitParameter("cacheControl", "no-store, no-cache, must-revalidate, max-age=0");
        webAppContext.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        webAppContext.addServlet(servletHolder, config.getPathSpec());
        this.getLog().info((CharSequence)String.format("Serving static resources: %s -> %s", config.getPathSpec(), config.getRelativeResourceBase()));
    }

    private void addProxyServlet(JettyWebAppContext webAppContext, ProxyServletConfig config) {
        String name = config.getPathSpec();
        ServletHolder servletHolder = new ServletHolder(name, JangarooProxyServlet.class);
        servletHolder.setInitParameter("targetUri", config.getTargetUri().replaceAll("/$", ""));
        servletHolder.setInitParameter("forwardip", String.valueOf(config.isForwardedHeaderEnabled()));
        servletHolder.setInitParameter("log", String.valueOf(config.isLoggingEnabled()));
        servletHolder.setInitParameter("preserveCookies", "true");
        webAppContext.addServlet(servletHolder, config.getPathSpec());
        this.getLog().info((CharSequence)String.format("Proxy requests: %s -> %s", config.getPathSpec(), config.getTargetUri()));
    }

    private List<Integer> shufflePortRange(Range<Integer> portRange) {
        ArrayList<Integer> shuffledPorts = new ArrayList<Integer>();
        for (int i = ((Integer)portRange.getMinimum()).intValue(); i <= (Integer)portRange.getMaximum(); ++i) {
            shuffledPorts.add(i);
        }
        Collections.shuffle(shuffledPorts);
        return shuffledPorts;
    }

    protected Log getLog() {
        return this.log;
    }

    static {
        Resource.setDefaultUseCaches((boolean)false);
    }

    public static final class JettyWrapperException
    extends Exception {
        JettyWrapperException(String message) {
            super(message);
        }

        JettyWrapperException(String message, Throwable cause) {
            super(message, cause);
        }

        JettyWrapperException(Throwable cause) {
            super(cause);
        }
    }
}

