/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.test.PhantomJsTestRunner;
import net.jangaroo.jooc.mvnplugin.util.JettyWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Range;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class JooTestMojo
extends AbstractSenchaMojo {
    private static final int JETTY_START_TIMEOUT_MILLIS = 30000;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testOutputDirectory;
    @Parameter(property="jooUnitJettyPortUpperBound")
    private int jooUnitJettyPortUpperBound = 10200;
    @Parameter(property="jooUnitJettyPortLowerBound")
    private int jooUnitJettyPortLowerBound = 10100;
    @Parameter(property="jooUnitJettyHost")
    private String jooUnitJettyHost = "localhost";
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(property="skipJooUnitTests")
    private boolean skipJooUnitTests;
    @Parameter(property="interactiveJooUnitTests")
    private boolean interactiveJooUnitTests;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    private File testResultOutputDirectory;
    @Parameter
    private String testResultFileName;
    @Parameter(property="jooUnitTestExecutionTimeout")
    private int jooUnitTestExecutionTimeout = 30000;
    @Parameter(property="jooUnitMaxRetriesOnCrashes")
    private int jooUnitMaxRetriesOnCrashes = 5;
    @Parameter(property="jooUnitWebDriverBrowser")
    private String jooUnitWebDriverBrowser = "";
    @Parameter(property="jooUnitRemoteWebDriverUri")
    private String jooUnitRemoteWebDriverUri = "";
    @Parameter
    private String testSuite = null;
    @Parameter(property="maven.test.failure.ignore")
    private boolean testFailureIgnore;
    @Parameter(property="phantomjs.bin")
    private String phantomBin = "phantomjs";
    @Parameter(property="jooUnitResourceTimeout")
    private int jooUnitResourceTimeout = 10000;
    @Parameter(property="phantomjsDebug")
    private boolean phantomjsDebug;
    @Parameter(property="phantomjsWebSecurity")
    private boolean phantomjsWebSecurity = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean doSkip;
        boolean bl = doSkip = this.skip || this.skipTests || this.skipJooUnitTests;
        if (!doSkip && this.testSuite != null) {
            if (!this.jooUnitRemoteWebDriverUri.isEmpty()) {
                try {
                    this.jooUnitJettyHost = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    throw new MojoExecutionException("I just don't know my own hostname ... ", (Exception)e);
                }
            }
            File baseDir = new File(this.project.getBuild().getDirectory(), "test-classes");
            JettyWrapper jettyWrapper = new JettyWrapper(this.getLog(), baseDir);
            Range portRange = this.interactiveJooUnitTests ? Range.is((Comparable)Integer.valueOf(this.jooUnitJettyPortLowerBound)) : Range.between((Comparable)Integer.valueOf(this.jooUnitJettyPortLowerBound), (Comparable)Integer.valueOf(this.jooUnitJettyPortUpperBound));
            try {
                jettyWrapper.start(this.jooUnitJettyHost, (Range<Integer>)portRange);
                String url = this.getTestUrl(jettyWrapper.getUri(), baseDir);
                this.getLog().info((CharSequence)("Test-URL: " + url));
                if (this.interactiveJooUnitTests) {
                    jettyWrapper.blockUntilInterrupted();
                } else {
                    jettyWrapper.waitUntilStarted(30000);
                    this.runTests(url);
                }
            }
            catch (JettyWrapper.JettyWrapperException e) {
                throw new MojoExecutionException("Could not start Jetty", (Exception)e);
            }
            finally {
                jettyWrapper.stop();
            }
        }
    }

    private void runTests(String url) throws MojoFailureException, MojoExecutionException {
        if (this.jooUnitWebDriverBrowser.isEmpty() && this.jooUnitRemoteWebDriverUri.isEmpty()) {
            try {
                File testResultOutputFile = new File(this.testResultOutputDirectory, this.getTestResultFileName());
                File phantomTestRunner = new File(this.testResultOutputDirectory, "phantomjs-joounit-page-runner.js");
                FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/phantomjs-joounit-page-runner.js"), (File)phantomTestRunner);
                PhantomJsTestRunner phantomJsTestRunner = new PhantomJsTestRunner(this.phantomBin, url, testResultOutputFile.getPath(), phantomTestRunner.getPath(), this.jooUnitTestExecutionTimeout, this.jooUnitMaxRetriesOnCrashes, this.jooUnitResourceTimeout, this.phantomjsDebug, this.phantomjsWebSecurity, this.getLog());
                if (phantomJsTestRunner.canRun()) {
                    this.executePhantomJs(testResultOutputFile, phantomJsTestRunner);
                    return;
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create local copy of phantomjs-joounit-page-runner.js", (Exception)e);
            }
        }
        this.executeSelenium(url);
    }

    private void executePhantomJs(File testResultOutputFile, PhantomJsTestRunner phantomJsTestRunner) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("running phantomjs: " + phantomJsTestRunner.toString()));
        try {
            boolean exitCode = phantomJsTestRunner.execute();
            if (exitCode) {
                this.evalTestOutput(new FileReader(testResultOutputFile));
            } else {
                JooTestMojo.signalError();
            }
        }
        catch (IOException | ParserConfigurationException | CommandLineException | SAXException e) {
            throw this.wrap((Exception)e);
        }
    }

    private MojoExecutionException wrap(Exception e) {
        return new MojoExecutionException(e.toString(), e);
    }

    private String getTestUrl(URI serverUri, File workspaceDir) {
        String path = workspaceDir.toURI().relativize(this.testOutputDirectory.toURI()).getPath();
        String serverUriString = serverUri.toString();
        if (!serverUriString.endsWith("/")) {
            serverUriString = serverUriString + "/";
        }
        return serverUriString + path + "?cache";
    }

    private void executeSelenium(String testsHtmlUrl) throws MojoExecutionException, MojoFailureException {
        WebDriver driver;
        this.getLog().info((CharSequence)("JooTest report directory: " + this.testResultOutputDirectory.getAbsolutePath()));
        try {
            driver = this.createWebDriver();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Unknown jooUnitWebDriverBrowser configuration value '" + this.jooUnitWebDriverBrowser + "'.");
        }
        catch (WebDriverManagerException e) {
            throw new MojoExecutionException("Failed to set up WebDriver.", (Exception)((Object)e));
        }
        try {
            this.getLog().debug((CharSequence)("Opening " + testsHtmlUrl));
            driver.get(testsHtmlUrl);
            this.getLog().debug((CharSequence)("Waiting for test results for " + this.jooUnitTestExecutionTimeout + "ms ..."));
            final JavascriptExecutor javascriptExecutor = (JavascriptExecutor)driver;
            new WebDriverWait(driver, (long)(this.jooUnitTestExecutionTimeout / 1000)).until((Function)new Function<WebDriver, Boolean>(){

                @Override
                @Nullable
                public Boolean apply(@Nullable WebDriver webDriver) {
                    return (Boolean)javascriptExecutor.executeScript("return window.result != null || window.classLoadingError != null", new Object[0]);
                }
            });
            String classLoadingError = (String)javascriptExecutor.executeScript("return window.classLoadingError", new Object[0]);
            if (classLoadingError != null && !classLoadingError.equals("null")) {
                throw new MojoExecutionException(classLoadingError);
            }
            String testResultXml = (String)javascriptExecutor.executeScript("return window.result", new Object[0]);
            this.writeResultToFile(testResultXml);
            this.evalTestOutput(new StringReader(testResultXml));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write test results to file", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Cannot create a simple XML Builder", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse test result", (Exception)e);
        }
        catch (WebDriverException e) {
            throw new MojoExecutionException("WebDriver exception during test execution.", (Exception)((Object)e));
        }
        finally {
            driver.quit();
        }
    }

    private WebDriver createWebDriver() throws IllegalArgumentException, WebDriverManagerException {
        String webDriverBrowser = this.jooUnitWebDriverBrowser;
        if (webDriverBrowser.isEmpty()) {
            webDriverBrowser = "chrome";
        }
        if (!this.jooUnitRemoteWebDriverUri.isEmpty()) {
            try {
                DesiredCapabilities capabilities = new DesiredCapabilities();
                capabilities.setBrowserName(webDriverBrowser);
                return new RemoteWebDriver(new URL(this.jooUnitRemoteWebDriverUri), (Capabilities)capabilities);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("jooUnitRemoteWebDriverUri contains an invalid URI.", e);
            }
        }
        DriverManagerType driverManagerType = DriverManagerType.valueOf((String)webDriverBrowser.toUpperCase());
        this.getLog().info((CharSequence)("Setting up WebDriver for " + webDriverBrowser + "."));
        WebDriverManager.getInstance((DriverManagerType)driverManagerType).setup();
        switch (driverManagerType) {
            case CHROME: {
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setHeadless(true);
                return new ChromeDriver(chromeOptions);
            }
            case FIREFOX: {
                FirefoxOptions firefoxOptions = new FirefoxOptions();
                firefoxOptions.setHeadless(true);
                return new FirefoxDriver(firefoxOptions);
            }
            case EDGE: {
                return new EdgeDriver();
            }
            case IEXPLORER: {
                return new InternetExplorerDriver();
            }
            case OPERA: {
                return new OperaDriver();
            }
        }
        throw new IllegalArgumentException();
    }

    private void writeResultToFile(String testResultXml) throws IOException {
        File result = new File(this.testResultOutputDirectory, this.getTestResultFileName());
        FileUtils.writeStringToFile((File)result, (String)testResultXml);
        if (!result.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)("could not set modification time of file " + result));
        }
    }

    private String getTestResultFileName() {
        return this.testResultFileName != null ? this.testResultFileName : "TEST-" + this.project.getArtifactId() + ".xml";
    }

    void evalTestOutput(Reader inStream) throws ParserConfigurationException, IOException, SAXException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inSource = new InputSource(inStream);
        Document d = dBuilder.parse(inSource);
        NodeList nl = d.getChildNodes();
        NamedNodeMap namedNodeMap = nl.item(0).getAttributes();
        String failures = namedNodeMap.getNamedItem("failures").getNodeValue();
        String errors = namedNodeMap.getNamedItem("errors").getNodeValue();
        String tests = namedNodeMap.getNamedItem("tests").getNodeValue();
        String time = namedNodeMap.getNamedItem("time").getNodeValue();
        String name = namedNodeMap.getNamedItem("name").getNodeValue();
        this.getLog().info((CharSequence)(name + " tests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + ", time: " + time + " ms"));
        if (Integer.parseInt(errors) > 0 || Integer.parseInt(failures) > 0) {
            this.signalFailure();
        }
    }

    private static void signalError() throws MojoExecutionException {
        throw new MojoExecutionException("There are errors");
    }

    private void signalFailure() throws MojoFailureException {
        if (!this.testFailureIgnore) {
            throw new MojoFailureException("There are test failures");
        }
    }

    void skip() {
        this.skip = true;
    }

    void skipTests() {
        this.skipTests = true;
    }

    void testFailureIgnore() {
        this.testFailureIgnore = true;
    }
}

