/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.jangaroo.jooc.mvnplugin.AbstractLinkPackagesMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.DynamicPackagesDeSerializer;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="prepare-package-app-overlay", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PreparePackageAppOverlayMojo
extends AbstractLinkPackagesMojo {
    @Parameter(defaultValue="${project.build.directory}/app", readonly=true)
    private File webResourcesOutputDirectory;

    public void execute() throws MojoExecutionException {
        if (!"jangaroo-app-overlay".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app-overlay\"");
        }
        this.packageAppOverlay();
    }

    private void packageAppOverlay() throws MojoExecutionException {
        Dependency jangarooAppDependency = this.findRequiredJangarooAppDependency(this.project);
        File overlayPackagesDir = new File(this.webResourcesOutputDirectory, "packages");
        FileHelper.ensureDirectory(overlayPackagesDir);
        Path packagesPath = overlayPackagesDir.toPath().normalize();
        File remotePackagesDir = SenchaUtils.remotePackagesDir(this.session);
        HashSet<Artifact> applicationArtifacts = new HashSet<Artifact>();
        this.addSenchaDependencyArtifacts(jangarooAppDependency, applicationArtifacts);
        Set<Artifact> overlayArtifacts = this.onlyRequiredSenchaDependencies(this.project.getArtifacts(), false);
        overlayArtifacts.removeIf(artifact -> this.containsSimilarArtifact((Set<Artifact>)applicationArtifacts, (Artifact)artifact));
        this.createSymbolicLinksForArtifacts(overlayArtifacts, packagesPath, remotePackagesDir);
        Set<String> overlayPackageNames = overlayArtifacts.stream().map(artifact -> SenchaUtils.getSenchaPackageName(artifact.getGroupId(), artifact.getArtifactId())).collect(Collectors.toSet());
        this.writeDynamicPackagesJson(jangarooAppDependency, overlayPackageNames);
    }

    private boolean containsSimilarArtifact(Set<Artifact> artifacts, Artifact artifact) {
        return artifacts.stream().anyMatch(artifact1 -> !this.project.getDependencyArtifacts().contains(artifact) && artifact.getGroupId().equals(artifact1.getGroupId()) && artifact.getArtifactId().equals(artifact1.getArtifactId()) && artifact.getType().equals(artifact1.getType()));
    }

    private void addSenchaDependencyArtifacts(Dependency dependency, Set<Artifact> artifacts) throws MojoExecutionException {
        MavenProject projectFromDependency = this.createProjectFromDependency(dependency);
        if (artifacts.add(projectFromDependency.getArtifact())) {
            List dependencies = projectFromDependency.getDependencies();
            for (Dependency transitiveDependency : dependencies) {
                if (!SenchaUtils.isRequiredSenchaDependency(transitiveDependency, false) && !"pom".equals(transitiveDependency.getType()) && (!"jar".equals(transitiveDependency.getType()) || !"runtime".equals(transitiveDependency.getScope()))) continue;
                this.addSenchaDependencyArtifacts(transitiveDependency, artifacts);
            }
        }
    }

    private void writeDynamicPackagesJson(Dependency jangarooAppDependency, Set<String> overlayPackageNames) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Writing %s for module %s.", "dynamic-packages.json", this.project.getName()));
        File dynamicPackagesFile = new File(this.webResourcesOutputDirectory, "dynamic-packages.json");
        if (!dynamicPackagesFile.exists()) {
            FileHelper.ensureDirectory(dynamicPackagesFile.getParentFile());
        } else {
            this.getLog().debug((CharSequence)"dynamic-packages.json for module already exists, deleting...");
            if (!dynamicPackagesFile.delete()) {
                throw new MojoExecutionException("Could not delete dynamic-packages.json file for module");
            }
        }
        try {
            Set<String> dynamicPackages;
            MavenProject jangarooAppProject = this.createProjectFromDependency(jangarooAppDependency);
            if ("jangaroo-app-overlay".equals(jangarooAppProject.getPackaging())) {
                MavenProject baseAppProject = this.getReferencedMavenProject(jangarooAppDependency);
                if (baseAppProject != null) {
                    File appResourceDir = new File(baseAppProject.getBuild().getDirectory(), "app");
                    File overlayDynamicPackagesFile = new File(appResourceDir.getPath(), "dynamic-packages.json");
                    dynamicPackages = new LinkedHashSet<String>(DynamicPackagesDeSerializer.readDynamicPackages(new FileInputStream(overlayDynamicPackagesFile)));
                } else {
                    File overlayArtifactFile = this.getArtifact(jangarooAppDependency).getFile();
                    if (overlayArtifactFile == null) {
                        throw new MojoExecutionException("Overlay artifact " + jangarooAppDependency + " does not exist.");
                    }
                    if (!overlayArtifactFile.exists()) {
                        throw new MojoExecutionException("Overlay artifact " + overlayArtifactFile.getAbsolutePath() + " does not exist.");
                    }
                    JarFile overlayAppJarFile = new JarFile(overlayArtifactFile);
                    dynamicPackages = new LinkedHashSet<String>(DynamicPackagesDeSerializer.readDynamicPackages(overlayAppJarFile.getInputStream(overlayAppJarFile.getEntry("META-INF/resources/dynamic-packages.json"))));
                }
                dynamicPackages.addAll(overlayPackageNames);
            } else {
                dynamicPackages = overlayPackageNames;
            }
            DynamicPackagesDeSerializer.writeDynamicPackages(new FileOutputStream(dynamicPackagesFile), dynamicPackages);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create dynamic-packages.json resource", (Exception)e);
        }
    }
}

