/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

public abstract class AbstractSenchaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter
    private String toolkit = "classic";
    @Parameter(defaultValue="((net\\.jangaroo\\.com)|(com\\.coremedia))\\.sencha:ext-js(-pkg)?(-gpl)?")
    private String extFrameworkArtifactRegexp;
    @Parameter(property="senchaLogLevel")
    private String senchaLogLevel;
    private volatile Pattern extFrameworkArtifactPattern;
    private Map<String, MavenProject> mavenProjectByDependencyCache = new HashMap<String, MavenProject>();

    public String getToolkit() {
        return this.toolkit;
    }

    public Pattern getExtFrameworkArtifactPattern() {
        if (this.extFrameworkArtifactPattern == null) {
            this.extFrameworkArtifactPattern = Pattern.compile(this.getExtFrameworkArtifactRegexp());
        }
        return this.extFrameworkArtifactPattern;
    }

    public String getExtFrameworkArtifactRegexp() {
        return this.extFrameworkArtifactRegexp;
    }

    public String getSenchaLogLevel() {
        return this.senchaLogLevel;
    }

    protected boolean isExtFrameworkArtifact(Artifact artifact) {
        return this.isExtFramework(artifact.getGroupId(), artifact.getArtifactId());
    }

    protected boolean isExtFrameworkDependency(Dependency dependency) {
        return this.isExtFramework(dependency.getGroupId(), dependency.getArtifactId());
    }

    private boolean isExtFramework(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        return this.getExtFrameworkArtifactPattern().matcher(key).matches();
    }

    @Nonnull
    MavenProject createProjectFromDependency(@Nonnull Dependency dependency) throws MojoExecutionException {
        String dependencyKey = dependency.toString();
        if (this.mavenProjectByDependencyCache.containsKey(dependencyKey)) {
            return this.mavenProjectByDependencyCache.get(dependencyKey);
        }
        this.getLog().debug((CharSequence)("createProjectFromDependency(" + dependency + ")"));
        DefaultArtifact artifactFromDependency = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        request.setValidationLevel(0);
        request.setProcessPlugins(false);
        request.setResolveDependencies(false);
        try {
            ProjectBuildingResult result = this.projectBuilder.build((Artifact)artifactFromDependency, (ProjectBuildingRequest)request);
            MavenProject project = result.getProject();
            this.mavenProjectByDependencyCache.put(dependencyKey, project);
            return project;
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not resolve required dependencies of POM dependency " + artifactFromDependency, (Exception)((Object)e));
        }
    }

    Dependency findRequiredJangarooAppDependency(MavenProject project) throws MojoExecutionException {
        return project.getDependencies().stream().filter(dependency -> {
            if ("jar".equals(dependency.getType())) {
                try {
                    MavenProject mavenProject = this.createProjectFromDependency((Dependency)dependency);
                    String packaging = mavenProject.getPackaging();
                    if ("jangaroo-app".equals(packaging) || "jangaroo-app-overlay".equals(packaging)) {
                        return true;
                    }
                }
                catch (MojoExecutionException mojoExecutionException) {
                    // empty catch block
                }
            }
            return false;
        }).findFirst().orElseThrow(() -> new MojoExecutionException("Module of type jangaroo-app-overlay must have exactly one dependency on a module of type jangaroo-app."));
    }

    Artifact getArtifact(Dependency dependency) {
        String versionlessKey = ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId());
        return (Artifact)this.project.getArtifactMap().get(versionlessKey);
    }

    MavenProject getReferencedMavenProject(Dependency dependency) {
        String versionKey = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
        return (MavenProject)this.project.getProjectReferences().get(versionKey);
    }
}

