/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.JettyWrapper;
import net.jangaroo.jooc.mvnplugin.util.ProxyServletConfig;
import net.jangaroo.jooc.mvnplugin.util.StaticResourcesServletConfig;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="run")
public class RunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="jooJettyHost")
    private String jooJettyHost = "localhost";
    @Parameter(property="jooJettyPort")
    private int jooJettyPort = 8080;
    @Parameter(property="jooProxyTargetUri")
    private String jooProxyTargetUri;
    @Parameter(property="jooProxyPathSpec")
    private String jooProxyPathSpec;
    @Parameter
    private List<StaticResourcesServletConfig> jooStaticResourcesServletConfigs;
    @Parameter
    private List<ProxyServletConfig> jooProxyServletConfigs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File baseDir = SenchaUtils.remotePackagesDir(this.session).getParentFile();
        JettyWrapper jettyWrapper = new JettyWrapper(this.getLog(), baseDir);
        jettyWrapper.setStaticResourcesServletConfigs(this.jooStaticResourcesServletConfigs);
        if (this.jooProxyServletConfigs != null && !this.jooProxyServletConfigs.isEmpty()) {
            jettyWrapper.setProxyServletConfigs(this.jooProxyServletConfigs);
        } else if (this.jooProxyTargetUri != null && this.jooProxyPathSpec != null) {
            jettyWrapper.setProxyServletConfigs(Collections.singletonList(new ProxyServletConfig(this.jooProxyTargetUri, this.jooProxyPathSpec)));
        } else if (this.jooProxyTargetUri != null) {
            this.getLog().warn((CharSequence)"Ignoring 'jooProxyTargetUri' since there is no 'jooProxyPathSpec'.");
        } else if (this.jooProxyPathSpec != null) {
            this.getLog().warn((CharSequence)"Ignoring 'jooProxyPathSpec' since there is no 'jooProxyTargetUri'.");
        }
        try {
            jettyWrapper.start(this.jooJettyHost, this.jooJettyPort);
            this.getLog().info((CharSequence)("Started Jetty server at: " + jettyWrapper.getUri()));
            this.session.getProjects().forEach(project -> this.logJangarooAppUrl(baseDir, jettyWrapper, (MavenProject)project));
            jettyWrapper.blockUntilInterrupted();
        }
        catch (JettyWrapper.JettyWrapperException e) {
            throw new MojoExecutionException("Could not start Jetty", (Exception)e);
        }
        finally {
            jettyWrapper.stop();
        }
    }

    private void logJangarooAppUrl(File baseDir, JettyWrapper jettyWrapper, MavenProject project) {
        String packaging = project.getPackaging();
        if ("jangaroo-app".equals(packaging) || "swc".equals(packaging)) {
            String modulePath = baseDir.toURI().relativize(project.getBasedir().toURI()).getPath();
            if ("jangaroo-app".equals(packaging)) {
                String appPath = modulePath + "target/app/index.html";
                if (new File(baseDir, appPath).exists()) {
                    this.getLog().info((CharSequence)("Found Jangaroo app at: " + jettyWrapper.getUri() + appPath));
                }
            } else {
                String testAppPath = modulePath + "target/test-classes/index.html";
                if (new File(baseDir, testAppPath).exists()) {
                    this.getLog().info((CharSequence)("Found Jangaroo test app at: " + jettyWrapper.getUri() + testAppPath));
                }
            }
        }
    }
}

