/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaAppConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.test.PhantomJsTestRunner;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.JettyWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Range;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class JooTestMojo
extends AbstractSenchaMojo {
    private static final int JETTY_START_TIMEOUT_MILLIS = 30000;
    private static final String DEFAULT_TEST_APP_JSON = "default.test.app.json";
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testOutputDirectory;
    @Parameter(defaultValue="${project.testResources}")
    protected List<Resource> testResources;
    @Parameter(property="jooUnitJettyPortUpperBound")
    private int jooUnitJettyPortUpperBound = 10200;
    @Parameter(property="jooUnitJettyPortLowerBound")
    private int jooUnitJettyPortLowerBound = 10100;
    @Parameter(property="jooUnitJettyHost")
    private String jooUnitJettyHost = "localhost";
    @Parameter
    private String toolkit = "classic";
    @Inject
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(property="skipJooUnitTests")
    private boolean skipJooUnitTests;
    @Parameter(property="interactiveJooUnitTests")
    private boolean interactiveJooUnitTests;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    private File testResultOutputDirectory;
    @Parameter
    private String testResultFileName;
    @Parameter(property="jooUnitTestExecutionTimeout")
    private int jooUnitTestExecutionTimeout = 30000;
    @Parameter(property="jooUnitMaxRetriesOnCrashes")
    private int jooUnitMaxRetriesOnCrashes = 5;
    @Parameter(property="jooUnitSeleniumRCHost")
    private String jooUnitSeleniumRCHost = "localhost";
    @Parameter
    private String testSuite = null;
    @Parameter(property="jooUnitSeleniumRCPort")
    private int jooUnitSeleniumRCPort = 4444;
    @Parameter(property="jooUnitSeleniumBrowserStartCommand")
    private String jooUnitSeleniumBrowserStartCommand = "*firefox";
    @Parameter(property="maven.test.failure.ignore")
    private boolean testFailureIgnore;
    @Parameter(property="phantomjs.bin")
    private String phantomBin = "phantomjs";
    @Parameter(property="jooUnitResourceTimeout")
    private int jooUnitResourceTimeout = 10000;
    @Parameter(property="phantomjsDebug")
    private boolean phantomjsDebug;
    @Parameter(property="phantomjsWebSecurity")
    private boolean phantomjsWebSecurity = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean doSkip;
        boolean bl = doSkip = this.skip || this.skipTests || this.skipJooUnitTests;
        if (doSkip || this.testSuite == null) {
            this.getLog().info((CharSequence)("Skipping generation of Jangaroo test app: " + (doSkip ? "tests skipped." : "no tests found.")));
        } else {
            this.getLog().info((CharSequence)("Creating Jangaroo test app below " + this.testOutputDirectory));
            this.createWebApp(this.testOutputDirectory);
            new SenchaCmdExecutor(this.testOutputDirectory, "config -prop skip.sass=1 -prop skip.resources=1 then app refresh", this.getLog(), this.getSenchaLogLevel()).execute();
            File baseDir = SenchaUtils.baseDir(this.session);
            JettyWrapper jettyWrapper = new JettyWrapper(this.getLog(), baseDir);
            Range portRange = this.interactiveJooUnitTests ? Range.is((Comparable)Integer.valueOf(this.jooUnitJettyPortLowerBound)) : Range.between((Comparable)Integer.valueOf(this.jooUnitJettyPortLowerBound), (Comparable)Integer.valueOf(this.jooUnitJettyPortUpperBound));
            try {
                jettyWrapper.start(this.jooUnitJettyHost, (Range<Integer>)portRange);
                String url = this.getTestUrl(jettyWrapper.getUri(), baseDir);
                this.getLog().info((CharSequence)("Test-URL: " + url));
                if (this.interactiveJooUnitTests) {
                    jettyWrapper.blockUntilInterrupted();
                } else {
                    jettyWrapper.waitUntilStarted(30000);
                    this.runTests(url);
                }
            }
            catch (JettyWrapper.JettyWrapperException e) {
                throw new MojoExecutionException("Could not start Jetty", (Exception)e);
            }
            finally {
                jettyWrapper.stop();
            }
        }
    }

    private void runTests(String url) throws MojoFailureException, MojoExecutionException {
        try {
            File testResultOutputFile = new File(this.testResultOutputDirectory, this.getTestResultFileName());
            File phantomTestRunner = new File(this.testResultOutputDirectory, "phantomjs-joounit-page-runner.js");
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/phantomjs-joounit-page-runner.js"), (File)phantomTestRunner);
            PhantomJsTestRunner phantomJsTestRunner = new PhantomJsTestRunner(this.phantomBin, url, testResultOutputFile.getPath(), phantomTestRunner.getPath(), this.jooUnitTestExecutionTimeout, this.jooUnitMaxRetriesOnCrashes, this.jooUnitResourceTimeout, this.phantomjsDebug, this.phantomjsWebSecurity, this.getLog());
            if (phantomJsTestRunner.canRun()) {
                this.executePhantomJs(testResultOutputFile, phantomJsTestRunner);
            } else {
                this.executeSelenium(url);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create local copy of phantomjs-joounit-page-runner.js", (Exception)e);
        }
    }

    private void executePhantomJs(File testResultOutputFile, PhantomJsTestRunner phantomJsTestRunner) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("running phantomjs: " + phantomJsTestRunner.toString()));
        try {
            boolean exitCode = phantomJsTestRunner.execute();
            if (exitCode) {
                this.evalTestOutput(new FileReader(testResultOutputFile));
            } else {
                JooTestMojo.signalError();
            }
        }
        catch (IOException | ParserConfigurationException | CommandLineException | SAXException e) {
            throw this.wrap((Exception)e);
        }
    }

    protected void createWebApp(File webappDirectory) throws MojoExecutionException {
        if (SenchaUtils.doesSenchaAppExist(webappDirectory)) {
            this.getLog().info((CharSequence)"Sencha app already exists, skip generating one");
            return;
        }
        this.getLog().info((CharSequence)String.format("Generating Sencha App %s for unit tests...", webappDirectory));
        FileHelper.ensureDirectory(webappDirectory);
        SenchaUtils.generateSenchaTestAppFromTemplate(webappDirectory, this.project, SenchaUtils.getSenchaPackageName(this.project), this.testSuite, this.toolkit, this.getLog(), this.getSenchaLogLevel());
        this.createAppJson();
    }

    private boolean isTestDependency(Dependency dependency) {
        return "test".equals(dependency.getScope()) && SenchaUtils.isSenchaDependency(dependency) && !this.isExtFrameworkDependency(dependency);
    }

    private void createAppJson() throws MojoExecutionException {
        File appJsonFile = new File(this.project.getBuild().getTestOutputDirectory(), "app.json");
        this.getLog().info((CharSequence)String.format("Generating Sencha App %s for unit tests...", appJsonFile.getPath()));
        SenchaAppConfigBuilder configBuilder = new SenchaAppConfigBuilder();
        try {
            configBuilder.destFile(appJsonFile);
            configBuilder.defaults(DEFAULT_TEST_APP_JSON);
            configBuilder.destFileComment("Auto-generated test application configuration. DO NOT EDIT!");
            configBuilder.require(SenchaUtils.getSenchaPackageName(this.project));
            List projectDependencies = this.project.getDependencies();
            for (Dependency dependency : projectDependencies) {
                if (!this.isTestDependency(dependency)) continue;
                configBuilder.require(SenchaUtils.getSenchaPackageName(dependency.getGroupId(), dependency.getArtifactId()));
            }
            configBuilder.buildFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not build test app.json", (Exception)e);
        }
    }

    protected MojoExecutionException wrap(Exception e) {
        return new MojoExecutionException(e.toString(), e);
    }

    protected String getTestUrl(URI serverUri, File workspaceDir) throws MojoExecutionException {
        String path = workspaceDir.toURI().relativize(this.testOutputDirectory.toURI()).getPath();
        String serverUriString = serverUri.toString();
        if (!serverUriString.endsWith("/")) {
            serverUriString = serverUriString + "/";
        }
        return serverUriString + path + "?cache";
    }

    void executeSelenium(String testsHtmlUrl) throws MojoExecutionException, MojoFailureException {
        this.jooUnitSeleniumRCHost = System.getProperty("SELENIUM_RC_HOST", this.jooUnitSeleniumRCHost);
        try {
            InetAddress.getAllByName(this.jooUnitSeleniumRCHost);
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Cannot resolve host " + this.jooUnitSeleniumRCHost + ". Please specify a host running the selenium remote control or skip tests by -DskipTests", (Exception)e);
        }
        this.getLog().info((CharSequence)("JooTest report directory: " + this.testResultOutputDirectory.getAbsolutePath()));
        DefaultSelenium selenium = new DefaultSelenium(this.jooUnitSeleniumRCHost, this.jooUnitSeleniumRCPort, this.jooUnitSeleniumBrowserStartCommand, testsHtmlUrl);
        try {
            selenium.start();
            this.getLog().debug((CharSequence)("Opening " + testsHtmlUrl));
            selenium.open(testsHtmlUrl);
            this.getLog().debug((CharSequence)("Waiting for test results for " + this.jooUnitTestExecutionTimeout + "ms ..."));
            selenium.waitForCondition("selenium.browserbot.getCurrentWindow().result != null || selenium.browserbot.getCurrentWindow().classLoadingError != null", Integer.toString(this.jooUnitTestExecutionTimeout));
            String classLoadingError = selenium.getEval("selenium.browserbot.getCurrentWindow().classLoadingError");
            if (classLoadingError != null && !classLoadingError.equals("null")) {
                throw new MojoExecutionException(classLoadingError);
            }
            String testResultXml = selenium.getEval("selenium.browserbot.getCurrentWindow().result");
            this.writeResultToFile(testResultXml);
            this.evalTestOutput(new StringReader(testResultXml));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write test results to file", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Cannot create a simple XML Builder", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse test result", (Exception)e);
        }
        catch (SeleniumException e) {
            throw new MojoExecutionException("Selenium setup exception", (Exception)((Object)e));
        }
        finally {
            selenium.stop();
        }
    }

    File writeResultToFile(String testResultXml) throws IOException {
        File result = new File(this.testResultOutputDirectory, this.getTestResultFileName());
        FileUtils.writeStringToFile((File)result, (String)testResultXml);
        if (!result.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)("could not set modification time of file " + result));
        }
        return result;
    }

    private String getTestResultFileName() {
        return this.testResultFileName != null ? this.testResultFileName : "TEST-" + this.project.getArtifactId() + ".xml";
    }

    void evalTestOutput(Reader inStream) throws ParserConfigurationException, IOException, SAXException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inSource = new InputSource(inStream);
        Document d = dBuilder.parse(inSource);
        NodeList nl = d.getChildNodes();
        NamedNodeMap namedNodeMap = nl.item(0).getAttributes();
        String failures = namedNodeMap.getNamedItem("failures").getNodeValue();
        String errors = namedNodeMap.getNamedItem("errors").getNodeValue();
        String tests = namedNodeMap.getNamedItem("tests").getNodeValue();
        String time = namedNodeMap.getNamedItem("time").getNodeValue();
        String name = namedNodeMap.getNamedItem("name").getNodeValue();
        this.getLog().info((CharSequence)(name + " tests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + ", time: " + time + " ms"));
        if (Integer.parseInt(errors) > 0 || Integer.parseInt(failures) > 0) {
            this.signalFailure();
        }
    }

    private static void signalError() throws MojoExecutionException {
        throw new MojoExecutionException("There are errors");
    }

    private void signalFailure() throws MojoFailureException {
        if (!this.testFailureIgnore) {
            throw new MojoFailureException("There are test failures");
        }
    }

    public void setSkip(boolean b) {
        this.skip = b;
    }

    public void setSkipTests(boolean b) {
        this.skipTests = b;
    }

    public void setTestSourceDirectory(File f) {
        this.testSourceDirectory = f;
    }

    public void setTestResources(List<Resource> resources) {
        this.testResources = resources;
    }

    public void setTestFailureIgnore(boolean b) {
        this.testFailureIgnore = b;
    }
}

