/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractSenchaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter
    private String toolkit = "classic";
    @Parameter(defaultValue="((net\\.jangaroo\\.com)|(com\\.coremedia))\\.sencha:ext-js(-pkg)?(-gpl)?")
    private String extFrameworkArtifactRegexp;
    @Parameter(property="senchaLogLevel")
    private String senchaLogLevel;
    private volatile Pattern extFrameworkArtifactPattern;

    public String getToolkit() {
        return this.toolkit;
    }

    public Pattern getExtFrameworkArtifactPattern() {
        if (this.extFrameworkArtifactPattern == null) {
            this.extFrameworkArtifactPattern = Pattern.compile(this.getExtFrameworkArtifactRegexp());
        }
        return this.extFrameworkArtifactPattern;
    }

    public String getExtFrameworkArtifactRegexp() {
        return this.extFrameworkArtifactRegexp;
    }

    public String getSenchaLogLevel() {
        return this.senchaLogLevel;
    }

    protected boolean isExtFrameworkArtifact(Artifact artifact) {
        return this.isExtFramework(artifact.getGroupId(), artifact.getArtifactId());
    }

    protected boolean isExtFrameworkDependency(Dependency dependency) {
        return this.isExtFramework(dependency.getGroupId(), dependency.getArtifactId());
    }

    private boolean isExtFramework(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        return this.getExtFrameworkArtifactPattern().matcher(key).matches();
    }
}

