/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.jangaroo.jooc.CompressorImpl;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="package-ext", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class PackageExtMojo
extends AbstractMojo {
    private static final String FILE_LIST_FILE_NAME = "filenames.txt";
    @Inject
    private MavenProjectHelper helper;
    @Parameter(defaultValue="${project.build.directory}/unzip", readonly=true)
    private File extFrameworkDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Execute sencha package Ext mojo");
        this.packageExtAll();
        this.packageTheme("theme-neptune");
        this.packageTheme("theme-triton");
    }

    private void packageExtAll() throws MojoExecutionException {
        File classicPackageDir = new File(this.extFrameworkDir, "classic/classic");
        File fileList = new File(classicPackageDir, FILE_LIST_FILE_NAME);
        File extBuildDirectory = new File(this.extFrameworkDir, "build");
        File extPackageFile = new File(extBuildDirectory, "ext-all-rtl-debug-sourcemap.js");
        String arguments = "compile meta -filenames -tpl \"{0}\"  -out filenames.txt";
        this.getLog().info((CharSequence)"Generating Ext classic file list");
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(classicPackageDir, arguments, this.getLog(), null);
        senchaCmdExecutor.execute();
        this.getLog().info((CharSequence)String.format("Compressing Ext to %s", extPackageFile.getPath()));
        this.compressJsFiles(fileList, extPackageFile);
    }

    private void packageTheme(String theme) throws MojoExecutionException {
        File themeDir = new File(this.extFrameworkDir, "classic/" + theme);
        File overridesDir = new File(themeDir, "overrides");
        File overridesSrcDir = new File(themeDir, "overrides-src");
        File packageFile = new File(overridesDir, theme + "-overrides.js");
        if (!overridesDir.renameTo(overridesSrcDir)) {
            throw new MojoExecutionException("cannot rename " + overridesDir + " to " + overridesSrcDir);
        }
        if (!overridesDir.mkdir()) {
            throw new MojoExecutionException("cannot create directory " + overridesDir);
        }
        ArrayList<File> sources = new ArrayList<File>();
        this.scanSources(overridesSrcDir, sources);
        this.getLog().info((CharSequence)String.format("Compressing %s to %s", overridesSrcDir.getPath(), packageFile.getPath()));
        try {
            new CompressorImpl().compress(sources, packageFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while packaging JavaScript sources", (Exception)e);
        }
    }

    private void compressJsFiles(File fileList, File packageFile) throws MojoExecutionException {
        try {
            new CompressorImpl().compressFileList(fileList, packageFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while packaging JavaScript sources", (Exception)e);
        }
    }

    private void scanSources(File dir, List<File> sources) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.scanSources(child, sources);
                    continue;
                }
                if (!child.getName().endsWith(".js")) continue;
                sources.add(child);
            }
        }
    }
}

