/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha.executor;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdLogOutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class SenchaCmdExecutor {
    private static final long MAX_EXECUTION_TIME = -1L;
    private static final Pattern SENCHA_CMD_VERSION_PATTERN = Pattern.compile("[0-9]+(\\.[0-9]+){2,3}");
    private File workingDirectory;
    private String arguments;
    private final Log log;
    private String senchaLogLevel;

    @Nonnull
    public static int[] queryVersion() throws IOException {
        final String[] versionStringVar = new String[1];
        SenchaCmdExecutor.internalExecute(CommandLine.parse((String)"sencha switch -l"), (OutputStream)new LogOutputStream(){
            private boolean parseNext = true;

            protected void processLine(String line, int level) {
                if (this.parseNext) {
                    this.parseNext = false;
                    versionStringVar[0] = line;
                } else if (line.toLowerCase().contains("current version")) {
                    this.parseNext = true;
                }
            }
        }, null);
        String versionString = versionStringVar[0];
        if (versionString == null) {
            throw new IOException("No 'Current version' found in output of 'sencha switch -l'.");
        }
        return SenchaCmdExecutor.parseVersion(versionString);
    }

    static int[] parseVersion(String versionString) throws IOException {
        Matcher matcher = SENCHA_CMD_VERSION_PATTERN.matcher(versionString);
        int[] versions = null;
        if (matcher.find()) {
            try {
                versions = Arrays.stream(StringUtils.split((String)matcher.group(), (String)".")).mapToInt(Integer::parseInt).toArray();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (versions == null) {
            throw new IOException("Incorrect Sencha Cmd version format: " + versionString);
        }
        return versions;
    }

    public SenchaCmdExecutor(File workingDirectory, String arguments, Log log, String senchaLogLevel) {
        this.workingDirectory = workingDirectory;
        this.arguments = arguments;
        this.log = log;
        this.senchaLogLevel = senchaLogLevel;
    }

    public void execute() throws MojoExecutionException {
        String line = "sencha --time " + this.getSenchaLogLevelCmd();
        if (!StringUtils.isEmpty((String)this.arguments)) {
            line = line + " " + this.arguments;
        }
        try {
            CommandLine cmdLine = SenchaCmdExecutor.getCommandLine(line);
            this.log.info((CharSequence)String.format("Executing Sencha Cmd '%s' in directory '%s'", line, this.workingDirectory));
            SenchaCmdExecutor.internalExecute(cmdLine, (OutputStream)((Object)new SenchaCmdLogOutputStream(this.log)), this.workingDirectory);
            this.log.debug((CharSequence)"Executed Sencha Cmd successfully");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Execution of Sencha Cmd failed.", (Exception)e);
        }
    }

    private static void internalExecute(CommandLine cmdLine, OutputStream outputStream, File workingDirectory) throws IOException {
        Executor executor = SenchaCmdExecutor.getExecutor();
        ExecuteWatchdog watchdog = SenchaCmdExecutor.getExecuteWatchdog();
        executor.setWatchdog(watchdog);
        if (workingDirectory != null) {
            executor.setWorkingDirectory(workingDirectory);
        }
        executor.setExitValue(0);
        PumpStreamHandler psh = new PumpStreamHandler(outputStream);
        executor.setStreamHandler((ExecuteStreamHandler)psh);
        executor.execute(cmdLine);
        if (watchdog.killedProcess()) {
            throw new ExecuteException(String.format("Watchdog killed Sencha Cmd process after %s ms.", -1L), 0);
        }
    }

    private String getSenchaLogLevelCmd() {
        String logLevelToUse = this.senchaLogLevel != null ? this.senchaLogLevel : this.getMavenLogLevel();
        String result = "--info";
        if ("debug".equalsIgnoreCase(logLevelToUse)) {
            result = "--debug";
        } else if ("trace".equalsIgnoreCase(logLevelToUse)) {
            result = "--trace";
        } else if ("warn".equalsIgnoreCase(logLevelToUse)) {
            result = "--quiet";
        }
        return result;
    }

    private String getMavenLogLevel() {
        String result = "error";
        if (this.log.isDebugEnabled()) {
            result = "debug";
        } else if (this.log.isInfoEnabled()) {
            result = "info";
        } else if (this.log.isWarnEnabled()) {
            result = "warn";
        }
        return result;
    }

    private static CommandLine getCommandLine(String line) {
        return CommandLine.parse((String)line);
    }

    private static Executor getExecutor() {
        return new DefaultExecutor();
    }

    private static ExecuteWatchdog getExecuteWatchdog() {
        return new ExecuteWatchdog(-1L);
    }
}

