/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.proxy;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.JettyWrapper;
import net.jangaroo.jooc.mvnplugin.util.ProxyServletConfig;
import net.jangaroo.jooc.mvnplugin.util.StaticResourcesServletConfig;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run")
public class RunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="jooJettyHost")
    private String jooJettyHost = "localhost";
    @Parameter(property="jooJettyPort")
    private int jooJettyPort = 8080;
    @Parameter(property="jooProxyTargetUri")
    private String jooProxyTargetUri;
    @Parameter(property="jooProxyPathSpec")
    private String jooProxyPathSpec;
    @Parameter
    private List<StaticResourcesServletConfig> jooStaticResourcesServletConfigs;
    @Parameter
    private List<ProxyServletConfig> jooProxyServletConfigs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File baseDir = SenchaUtils.remotePackagesDir(this.session).getParentFile();
        JettyWrapper jettyWrapper = new JettyWrapper(this.getLog(), baseDir);
        jettyWrapper.setStaticResourcesServletConfigs(this.jooStaticResourcesServletConfigs);
        if (this.jooProxyTargetUri != null && this.jooProxyPathSpec != null) {
            jettyWrapper.setProxyServletConfigs(Collections.singletonList(new ProxyServletConfig(this.jooProxyTargetUri, this.jooProxyPathSpec)));
        } else {
            jettyWrapper.setProxyServletConfigs(this.jooProxyServletConfigs);
        }
        try {
            jettyWrapper.start(this.jooJettyHost, this.jooJettyPort);
            jettyWrapper.blockUntilInterrupted();
        }
        catch (JettyWrapper.JettyWrapperException e) {
            throw new MojoExecutionException("Could not start Jetty", (Exception)e);
        }
        finally {
            jettyWrapper.stop();
        }
    }
}

