/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.proxy;

import java.net.HttpCookie;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClients;
import org.mitre.dsmiley.httpproxy.ProxyServlet;

public class JangarooProxyServlet
extends ProxyServlet {
    private static final X509TrustManager TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        int fragIdx;
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri(servletRequest));
        String servletPath = servletRequest.getServletPath();
        String relativeRequestUri = servletRequest.getRequestURI().replaceFirst(servletPath, "");
        uri.append(JangarooProxyServlet.encodeUriQuery((CharSequence)relativeRequestUri));
        String queryString = servletRequest.getQueryString();
        String fragment = null;
        if (queryString != null && (fragIdx = queryString.indexOf(35)) >= 0) {
            fragment = queryString.substring(fragIdx + 1);
            queryString = queryString.substring(0, fragIdx);
        }
        if ((queryString = this.rewriteQueryStringFromRequest(servletRequest, queryString)) != null && queryString.length() > 0) {
            uri.append('?');
            uri.append(JangarooProxyServlet.encodeUriQuery((CharSequence)queryString));
        }
        if (this.doSendUrlFragment && fragment != null) {
            uri.append('#');
            uri.append(JangarooProxyServlet.encodeUriQuery((CharSequence)fragment));
        }
        return uri.toString();
    }

    protected HttpClient createHttpClient(RequestConfig requestConfig) {
        SSLContext ctx;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{TRUST_MANAGER}, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return HttpClients.custom().useSystemProperties().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(ctx)).setDefaultRequestConfig(requestConfig).build();
    }

    protected void copyProxyCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String headerValue) {
        List<HttpCookie> cookies = HttpCookie.parse(headerValue);
        String path = servletRequest.getContextPath();
        if ((path = path + servletRequest.getServletPath()).isEmpty()) {
            path = "/";
        }
        for (HttpCookie cookie : cookies) {
            String proxyCookieName = this.doPreserveCookies ? cookie.getName() : this.getCookieNamePrefix(cookie.getName()) + cookie.getName();
            Cookie servletCookie = new Cookie(proxyCookieName, cookie.getValue());
            servletCookie.setComment(cookie.getComment());
            servletCookie.setMaxAge((int)cookie.getMaxAge());
            servletCookie.setPath(path);
            servletCookie.setHttpOnly(cookie.isHttpOnly());
            servletCookie.setSecure("https".equals(servletRequest.getScheme()) && cookie.getSecure());
            servletCookie.setVersion(cookie.getVersion());
            servletResponse.addCookie(servletCookie);
        }
    }
}

