/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaWorkspaceConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenPluginHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="generate-ws", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class SenchaGenerateWsMojo
extends AbstractSenchaMojo {
    @Parameter
    private String testSuite = null;
    private static final Object lock = new Object();
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String packaging = this.project.getPackaging();
        if (!("pkg".equals(packaging) || "swc".equals(packaging) || "jangaroo-app".equals(packaging))) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"pkg\", \"swc\" or \"jangaroo-app\"");
        }
        if ("jangaroo-app".equals(this.project.getPackaging()) || this.testSuite != null) {
            File workspaceDir = new File(this.project.getBuild().getDirectory());
            this.generateWorkspace(workspaceDir);
        }
    }

    private void generateWorkspace(File workspaceDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Generating Sencha workspace in %s", workspaceDir.getPath()));
        FileHelper.ensureDirectory(workspaceDir);
        SenchaWorkspaceConfigBuilder configBuilder = new SenchaWorkspaceConfigBuilder();
        SenchaUtils.configureDefaults(configBuilder, "default.workspace.json");
        File remotePackagesDir = SenchaUtils.remotePackagesDir(this.session);
        File extDirectory = this.configurePackages(this.project, workspaceDir, remotePackagesDir, configBuilder);
        this.callSenchaGenerateWorkspace(workspaceDir, extDirectory, this.webRootDir(), remotePackagesDir);
        SenchaUtils.writeFile(configBuilder, workspaceDir.getPath(), "workspace.json", "DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin", this.getLog());
    }

    private void callSenchaGenerateWorkspace(File workspaceDir, File extDirectory, File webRootDir, File remotePackagesDir) throws MojoExecutionException {
        Path senchaCfg = Paths.get(workspaceDir.getAbsolutePath(), ".sencha/workspace/sencha.cfg");
        try {
            Files.deleteIfExists(senchaCfg);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not delete existing sencha.cfg file in " + senchaCfg, (Exception)ioe);
        }
        this.getLog().info((CharSequence)"Generating Sencha workspace module");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("generate workspace");
        try {
            int[] cmdVersion = SenchaCmdExecutor.queryVersion();
            if (cmdVersion[0] > 6 || cmdVersion[0] == 6 && cmdVersion[1] >= 5) {
                arguments.add("--full");
            }
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Could not determine Sencha Cmd version, assuming it is < 6.5.", (Throwable)ioe);
        }
        arguments.add(".");
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(workspaceDir, StringUtils.join(arguments, (char)' '), this.getLog(), this.getSenchaLogLevel());
        senchaCmdExecutor.execute();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (extDirectory != null) {
            properties.put("ext.dir", this.absolutizeUsingWorkspace(workspaceDir, extDirectory));
        }
        properties.put("build.web.root", this.absolutizeUsingWorkspace(workspaceDir, webRootDir));
        properties.put("remotePackages", this.absolutizeUsingWorkspace(workspaceDir, remotePackagesDir));
        SenchaUtils.createSenchaCfg(senchaCfg, senchaCfg, properties);
    }

    private String absolutizeUsingWorkspace(File workspaceDir, File file) {
        String relativePath = file.isAbsolute() ? FileHelper.relativize(workspaceDir, file) : FilenameUtils.separatorsToUnix((String)file.toString());
        return SenchaUtils.absolutizeToModuleWithPlaceholder("workspace", relativePath);
    }

    private File configurePackages(MavenProject project, File workspaceDir, File remotePackagesDir, SenchaWorkspaceConfigBuilder configBuilder) throws MojoExecutionException {
        ArrayList<String> packagePaths = new ArrayList<String>();
        packagePaths.add(SenchaUtils.PLACEHOLDERS.get("workspace"));
        HashSet<String> reactorProjectPackagesIds = new HashSet<String>();
        this.addReactorProjectPackages(project, workspaceDir, packagePaths, reactorProjectPackagesIds);
        File extDir = this.addRemotePackages(project, packagePaths, remotePackagesDir, reactorProjectPackagesIds);
        Collections.sort(packagePaths);
        configBuilder.packagesDirs(packagePaths);
        return extDir;
    }

    private void addReactorProjectPackages(MavenProject project, File workspaceDir, List<String> packagePaths, Set<String> reactorProjectPackagesIds) throws MojoExecutionException {
        HashSet<MavenProject> referencedProjects = new HashSet<MavenProject>();
        this.collectReferencedProjects(project, referencedProjects);
        for (MavenProject projectInReactor : referencedProjects) {
            String packageType = projectInReactor.getPackaging();
            if (!"swc".equals(packageType) && !"pkg".equals(packageType)) continue;
            packagePaths.add(this.absolutizeUsingWorkspace(workspaceDir, this.relativePathForProject(workspaceDir, projectInReactor)));
            reactorProjectPackagesIds.add(this.reactorProjectId(projectInReactor));
        }
    }

    private String reactorProjectId(MavenProject project) {
        return this.reactorProjectId(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private String reactorProjectId(String groupId, String artifactId, String version) {
        return groupId + ':' + artifactId + ':' + version;
    }

    private void collectReferencedProjects(MavenProject project, Set<MavenProject> referencedProjects) {
        if (!referencedProjects.contains(project)) {
            referencedProjects.add(project);
            for (MavenProject referencedProject : project.getProjectReferences().values()) {
                this.collectReferencedProjects(referencedProject, referencedProjects);
            }
        }
    }

    private File addRemotePackages(MavenProject project, List<String> packagePaths, File remotePackagesDir, Set<String> reactorProjectPackagesIds) throws MojoExecutionException {
        File extDir = null;
        Set dependencyArtifacts = project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            Dependency dependency = MavenDependencyHelper.fromArtifact(artifact);
            boolean isExtFramework = this.isExtFrameworkArtifact(artifact);
            if (!isExtFramework && !SenchaUtils.isRequiredSenchaDependency(dependency, true)) continue;
            String reactorProjectId = this.reactorProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            boolean isReactorProject = reactorProjectPackagesIds.contains(reactorProjectId);
            if (isReactorProject) {
                this.getLog().info((CharSequence)String.format("%s contained in reactor, excluding from remote packages list", reactorProjectId));
                continue;
            }
            File pkgDir = this.unpackPkg(artifact, remotePackagesDir);
            if (isExtFramework) {
                extDir = pkgDir;
                continue;
            }
            packagePaths.add(this.relativizeToRemotePackagesPlaceholder(remotePackagesDir, pkgDir));
        }
        if (extDir == null) {
            this.getLog().warn((CharSequence)"no Ext framework dependency found");
        }
        String myVersion = ((Artifact)project.getPluginArtifactMap().get("net.jangaroo:jangaroo-maven-plugin")).getVersion();
        ArtifactRepository localRepository = this.session.getLocalRepository();
        List remoteRepositories = project.getRemoteArtifactRepositories();
        Artifact artifactFromHelper = MavenPluginHelper.getArtifact(localRepository, remoteRepositories, this.artifactResolver, this.repositorySystem, "net.jangaroo", "sencha-app-template", myVersion, "runtime", "pkg");
        File appTemplate = this.unpackPkg(artifactFromHelper, remotePackagesDir);
        packagePaths.add(this.relativizeToRemotePackagesPlaceholder(remotePackagesDir, appTemplate));
        Artifact testArtifactFromHelper = MavenPluginHelper.getArtifact(localRepository, remoteRepositories, this.artifactResolver, this.repositorySystem, "net.jangaroo", "sencha-test-app-template", myVersion, "runtime", "pkg");
        File testAppTemplate = this.unpackPkg(testArtifactFromHelper, remotePackagesDir);
        packagePaths.add(this.relativizeToRemotePackagesPlaceholder(remotePackagesDir, testAppTemplate));
        return extDir;
    }

    private String relativizeToRemotePackagesPlaceholder(File remotePackagesDir, File pkgDir) {
        String relativePath = FileHelper.relativize(remotePackagesDir, pkgDir);
        return SenchaUtils.absolutizeWithPlaceholder("${remotePackages}", relativePath);
    }

    private File webRootDir() {
        return this.session.getRequest().getMultiModuleProjectDirectory();
    }

    private File unpackPkg(Artifact artifact, File remotePackagesDir) throws MojoExecutionException {
        File jarFile = artifact.getFile();
        String fileName = jarFile.getName();
        String targetDirName = String.format("%s__%s__%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        File targetDir = new File(remotePackagesDir, targetDirName);
        this.unpackPkg(jarFile.exists() ? jarFile : jarFile, artifact, targetDir);
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPkg(File pkgFile, Artifact artifact, File targetDir) throws MojoExecutionException {
        Object object = lock;
        synchronized (object) {
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            String version = artifact.getVersion();
            File mavenStampFile = this.mavenStampFile(targetDir, groupId, artifactId, version);
            long artifactLastModified = pkgFile.lastModified();
            if (mavenStampFile.exists() && mavenStampFile.lastModified() == artifactLastModified) {
                this.getLog().info((CharSequence)String.format("Already unpacked %s to %s, skipping", artifact, targetDir.getName()));
                return;
            }
            if (targetDir.exists()) {
                this.getLog().info((CharSequence)String.format("Cleaning %s", targetDir));
                this.clean(targetDir);
            }
            this.getLog().info((CharSequence)String.format("Extracting %s to %s", artifact, targetDir));
            SenchaUtils.extractPkg(pkgFile, targetDir);
            this.touch(mavenStampFile, artifactLastModified);
        }
    }

    private void clean(File dir) throws MojoExecutionException {
        try {
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to clean directory " + dir.getAbsolutePath(), (Exception)e);
        }
    }

    private void touch(File file, long timestamp) throws MojoExecutionException {
        try {
            FileUtils.touch((File)file);
            if (!file.setLastModified(timestamp)) {
                throw new MojoExecutionException("unable to set last-modified on timestamp file " + file.getPath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to create timestamp file " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private File mavenStampFile(File packageTargetDir, String groupId, String artifactId, String version) {
        String fileName = "." + groupId + '_' + artifactId + '_' + version + "-timestamp";
        return new File(packageTargetDir, fileName);
    }

    private String relativize(MavenProject project, @Nonnull String path) throws MojoExecutionException {
        return FileHelper.relativize(project.getBasedir().toPath(), path);
    }

    private File relativePathForProject(File workspaceDir, MavenProject project) throws MojoExecutionException {
        String localPathToSrc = "jangaroo-app".equals(project.getPackaging()) ? "/app" : "/packages/";
        return SenchaGenerateWsMojo.relativePathForProject(workspaceDir, project, localPathToSrc);
    }

    private static File relativePathForProject(File workspaceDir, MavenProject project, String localPathToSrc) throws MojoExecutionException {
        Path path;
        Path rootPath = workspaceDir.toPath().normalize();
        Path relativePath = rootPath.relativize(path = Paths.get(project.getBuild().getDirectory() + localPathToSrc, new String[0]));
        String relativePathString = FilenameUtils.separatorsToUnix((String)relativePath.toString());
        if (relativePathString.isEmpty()) {
            throw new MojoExecutionException("Cannot handle project because not relative path to root workspace could be build");
        }
        return new File(relativePathString);
    }
}

