/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaPackageOrAppMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaAppConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaWorkspaceConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenPluginHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

@Mojo(name="package-app", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SenchaPackageAppMojo
extends AbstractSenchaPackageOrAppMojo<SenchaAppConfigBuilder> {
    private static final String DEFAULT_LOCALE = "en";
    private static final String APP_JSON_FILENAME = "/app.json";
    private static final String PACKAGES_PATH_NAME = "packages";
    private static final String JANGAROO_APP_DIRECTORY = "build/jangaroo-app";
    private static final String EXT_TARGET_DIRECTORY = "ext";
    @Parameter
    private List<String> additionalLocales = Collections.emptyList();
    @Parameter(property="senchaAppBuild")
    private String senchaAppBuild = "development";
    @Parameter(property="skipJangarooApp")
    private boolean skipJangarooApp;
    @Parameter(defaultValue="${project.build.directory}/app", readonly=true)
    private File senchaAppDirectory;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter
    private String applicationClass;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;

    @Override
    public String getType() {
        return "app";
    }

    @Override
    public String getJsonConfigFileName() {
        return "app.json";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"jangaroo-app".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app\"");
        }
        if (StringUtils.isEmpty((CharSequence)this.senchaAppBuild)) {
            this.senchaAppBuild = "development";
        }
        if (!("production".equals(this.senchaAppBuild) || "development".equals(this.senchaAppBuild) || "testing".equals(this.senchaAppBuild))) {
            throw new MojoExecutionException("'senchaAppBuild' must be one of 'production', 'testing' or 'development'.");
        }
        this.prepareModule();
        this.packageModule();
        if (!this.skipJangarooApp && "development".equals(this.senchaAppBuild)) {
            File workingDirectory = this.generateJangarooApp();
            new SenchaCmdExecutor(workingDirectory, "config -prop skip.sass=1 -prop skip.resources=1 then app refresh", this.getLog(), this.getSenchaLogLevel()).execute();
        }
        this.createJar();
    }

    private File generateJangarooApp() throws MojoExecutionException {
        File workingDirectory = new File(this.senchaAppDirectory, JANGAROO_APP_DIRECTORY);
        FileHelper.ensureDirectory(workingDirectory);
        this.generateJangarooAppWorkspace(workingDirectory);
        this.extractPackagesDirs(workingDirectory);
        this.copyFilesFromDevelopmentBuild(workingDirectory);
        this.fixAppJson(workingDirectory);
        SenchaUtils.refreshApp(workingDirectory, this.getLog(), this.getSenchaLogLevel());
        return workingDirectory;
    }

    private void copyFilesFromDevelopmentBuild(@Nonnull File workingDirectory) throws MojoExecutionException {
        FileHelper.copyDirectories(this.senchaAppDirectory, workingDirectory, (Set<String>)ImmutableSet.of((Object)"build"));
        FileHelper.copyDirectory(new File(this.senchaAppDirectory, "build/development/resources"), workingDirectory);
        FileHelper.copyFilesToDirectory(this.senchaAppDirectory, workingDirectory, "app.*|build.*|.*\\.html|.*\\.ico");
    }

    private void generateJangarooAppWorkspace(@Nonnull File newWorkspaceDirectory) throws MojoExecutionException {
        File workspaceDirectory = SenchaUtils.findClosestSenchaWorkspaceDir(this.senchaAppDirectory);
        if (workspaceDirectory == null) {
            throw new MojoExecutionException("Could not find any workspace");
        }
        File workspaceJson = new File(newWorkspaceDirectory, "workspace.json");
        FileHelper.copyDirectory(new File(workspaceDirectory, ".sencha/workspace"), new File(newWorkspaceDirectory, ".sencha"));
        Path senchaCfg = Paths.get(workspaceDirectory.getAbsolutePath(), ".sencha/workspace/sencha.cfg");
        Path newSenchaCfg = Paths.get(newWorkspaceDirectory.getAbsolutePath(), ".sencha/workspace/sencha.cfg");
        SenchaUtils.createSenchaCfgWithExtDirectory(senchaCfg, newSenchaCfg, new File(EXT_TARGET_DIRECTORY));
        SenchaWorkspaceConfigBuilder configBuilder = new SenchaWorkspaceConfigBuilder();
        configBuilder.packagesDirs((List<String>)ImmutableList.of((Object)PACKAGES_PATH_NAME));
        configBuilder.destFile(workspaceJson);
        try {
            configBuilder.buildFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create workspace.json file", (Exception)e);
        }
    }

    private void extractPackagesDirs(File targetDir) throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            switch (artifact.getType()) {
                case "swc": 
                case "pkg": {
                    try {
                        String senchaPackageName = SenchaUtils.getSenchaPackageName(artifact.getGroupId(), artifact.getArtifactId());
                        File pkgTargetDir = new File(targetDir, this.isExtFrameworkArtifact(artifact) ? EXT_TARGET_DIRECTORY : "packages/" + senchaPackageName);
                        this.extractPackageForProduction(artifact, pkgTargetDir);
                        break;
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void extractPackageForProduction(Artifact artifact, File targetDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Extracting package %s to %s", artifact, targetDir));
        SenchaUtils.extractPkg(artifact.getFile(), targetDir);
    }

    private void createJar() throws MojoExecutionException {
        File appProductionBuildDir = new File(this.senchaAppDirectory, JANGAROO_APP_DIRECTORY);
        File jarFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar");
        if (!this.skipJangarooApp && "development".equals(this.senchaAppBuild)) {
            this.archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)appProductionBuildDir).prefixed("META-INF/resources/"));
        }
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(this.archiver);
        mavenArchiver.setOutputFile(jarFile);
        try {
            MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
            archive.setManifestFile(MavenPluginHelper.createDefaultManifest(this.project));
            mavenArchiver.createArchive(this.session, this.project, archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        Artifact mainArtifact = this.project.getArtifact();
        mainArtifact.setFile(jarFile);
        mainArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
    }

    private void prepareModule() throws MojoExecutionException {
        FileHelper.ensureDirectory(this.senchaAppDirectory);
        this.getLog().info((CharSequence)String.format("Copy files from %s to %s", this.getSenchaSrcDir().getPath(), this.senchaAppDirectory.getPath()));
        FileHelper.copyFiles(this.getSenchaSrcDir(), this.senchaAppDirectory);
        SenchaAppConfigBuilder senchaConfigBuilder = this.createSenchaConfigBuilder();
        this.configure(senchaConfigBuilder);
        SenchaUtils.writeFile(senchaConfigBuilder, this.senchaAppDirectory.getPath(), APP_JSON_FILENAME, null, this.getLog());
    }

    private void configure(SenchaAppConfigBuilder configBuilder) throws MojoExecutionException {
        SenchaUtils.configureDefaults(configBuilder, "default.app.json");
        super.configure(configBuilder);
        configBuilder.id(this.generateSenchaAppId());
        this.configureLocales(configBuilder);
    }

    private void configureLocales(SenchaAppConfigBuilder configBuilder) {
        configBuilder.locale(DEFAULT_LOCALE);
        for (String locale : this.additionalLocales) {
            configBuilder.locale(locale);
        }
        if (!this.additionalLocales.isEmpty()) {
            configBuilder.require("locale");
        }
    }

    private void packageModule() throws MojoExecutionException {
        if (!this.senchaAppDirectory.exists()) {
            throw new MojoExecutionException("Sencha package directory does not exist: " + this.senchaAppDirectory.getPath());
        }
        this.buildSenchaApp(this.senchaAppDirectory, this.senchaAppBuild);
    }

    private String generateSenchaAppId() {
        String appIdString = SenchaUtils.getSenchaPackageName(this.project) + SenchaUtils.getSenchaVersionForMavenVersion(this.project.getVersion());
        return UUID.nameUUIDFromBytes(appIdString.getBytes()).toString();
    }

    private void buildSenchaApp(File senchaAppDirectory, String buildEnvironment) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Building Sencha app module for build environment '" + buildEnvironment + "'."));
        StringBuilder args = new StringBuilder();
        args.append("app build").append(" --").append(buildEnvironment).append(" --locale en");
        if (!this.additionalLocales.isEmpty()) {
            args.append(" then config -prop skip.sass=1 -prop skip.resources=1");
            for (String locale : this.additionalLocales) {
                args.append(" then app build").append(" --").append(buildEnvironment).append(" --locale ").append(locale);
            }
        }
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(senchaAppDirectory, args.toString(), this.getLog(), this.getSenchaLogLevel());
        senchaCmdExecutor.execute();
    }

    @Override
    protected SenchaAppConfigBuilder createSenchaConfigBuilder() {
        return new SenchaAppConfigBuilder();
    }

    private Map<String, Object> readJson(File jsonFile) throws IOException {
        return (Map)SenchaUtils.getObjectMapper().readValue(jsonFile, Map.class);
    }

    private void fixAppJson(File workingDirectory) throws MojoExecutionException {
        try {
            File jangarooAppJsonFile = new File(workingDirectory, "app.json");
            Map<String, Object> appJson = this.readJson(jangarooAppJsonFile);
            Map outputMap = (Map)appJson.get("output");
            outputMap.put("base", "${app.dir}");
            SenchaUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValue(jangarooAppJsonFile, appJson);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not configure app.json", (Exception)e);
        }
    }
}

