/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SenchaUtils {
    public static final String SEPARATOR = "/";
    public static final String LOCAL_PACKAGES_PATH = "/packages/";
    private static final String BUILD_PATH = "build/";
    public static final String APP_TARGET_DIRECTORY = "/app";
    public static final String SENCHA_OVERRIDES_PATH = "overrides";
    public static final String SENCHA_LOCALE_PATH = "locale";
    public static final String SENCHA_RESOURCES_PATH = "resources";
    public static final String SENCHA_BUNDLED_RESOURCES_PATH = "bundledResources";
    public static final String PRODUCTION_PROFILE = "production";
    public static final String TESTING_PROFILE = "testing";
    public static final String DEVELOPMENT_PROFILE = "development";
    public static final String TOOLKIT_CLASSIC = "classic";
    private static final String SENCHA_CFG = "sencha.cfg";
    public static final String SENCHA_DIRECTORYNAME = ".sencha";
    public static final String SENCHA_WORKSPACE_CONFIG = ".sencha/workspace/sencha.cfg";
    public static final String SENCHA_PACKAGE_CONFIG = ".sencha/package/sencha.cfg";
    public static final String SENCHA_APP_CONFIG = ".sencha/app/sencha.cfg";
    public static final String SENCHA_WORKSPACE_FILENAME = "workspace.json";
    public static final String SENCHA_PACKAGE_FILENAME = "package.json";
    public static final String SENCHA_APP_FILENAME = "app.json";
    public static final String SENCHA_PKG_EXTENSION = ".pkg";
    public static final String SENCHA_PKG_TMP_EXTENSION = ".pkg.tmp";
    public static final String PACKAGE_CONFIG_FILENAME = "packageConfig.js";
    public static final String REQUIRED_CLASSES_FILENAME = "requiredClasses.js";
    public static final String SENCHA_TEST_APP_TEMPLATE_ARTIFACT_ID = "sencha-test-app-template";
    public static final String SENCHA_APP_TEMPLATE_ARTIFACT_ID = "sencha-app-template";
    public static final String SENCHA_APP_TEMPLATE_GROUP_ID = "net.jangaroo";
    private static final Pattern SENCHA_VERSION_PATTERN = Pattern.compile("^[0-9]+(\\.[0-9]+){0,3}$");
    public static final String AUTO_CONTENT_COMMENT = "DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin and it will be overwritten by the next call of the plugin's goal \"generate-workspace\".";
    public static final Map<String, String> PLACEHOLDERS = ImmutableMap.of((Object)"app", (Object)"${app.dir}", (Object)"code", (Object)"${package.dir}", (Object)"theme", (Object)"${package.dir}", (Object)"workspace", (Object)"${workspace.dir}");
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private SenchaUtils() {
    }

    public static String getSenchaPackageName(String groupId, String artifactId) {
        return groupId + "__" + artifactId;
    }

    public static String getSenchaPackageName(@Nonnull MavenProject project) {
        return SenchaUtils.getSenchaPackageName(project.getGroupId(), project.getArtifactId());
    }

    public static String getSenchaVersionForMavenVersion(String version) {
        String senchaVersion = version.replaceAll("[^0-9.-]", "").replace("-", ".").replaceAll("[.]+", ".").replaceAll("[.]+$", "");
        if (SENCHA_VERSION_PATTERN.matcher(senchaVersion).matches()) {
            return senchaVersion;
        }
        return null;
    }

    @Nullable
    public static Dependency getThemeDependency(@Nullable String theme, @Nonnull MavenProject project) {
        Dependency themeDependency = MavenDependencyHelper.fromKey(theme);
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            Dependency artifactDependency = MavenDependencyHelper.fromArtifact(artifact);
            if (!MavenDependencyHelper.equalsGroupIdAndArtifactId(artifactDependency, themeDependency)) continue;
            return artifactDependency;
        }
        return null;
    }

    public static File findClosestSenchaWorkspaceDir(File dir) {
        String[] list;
        File result;
        try {
        }
        catch (IOException e) {
            return null;
        }
        for (result = dir.getCanonicalFile(); null != result && (null == (list = result.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return SenchaUtils.SENCHA_WORKSPACE_FILENAME.equals(name);
            }
        })) || list.length <= 0); result = result.getParentFile()) {
        }
        return result;
    }

    public static String generateAbsolutePathUsingPlaceholder(String packageType, String relativePath) {
        String normalizedRelativePath = FilenameUtils.separatorsToUnix((String)relativePath);
        String result = PLACEHOLDERS.get(packageType);
        if (StringUtils.isNotEmpty((CharSequence)normalizedRelativePath) && !normalizedRelativePath.startsWith(SEPARATOR)) {
            result = result + SEPARATOR + normalizedRelativePath;
        }
        return result;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static Path getRelativePathFromWorkspaceToWorkingDir(File workingDirectory) throws MojoExecutionException {
        File closestSenchaWorkspaceDir = SenchaUtils.findClosestSenchaWorkspaceDir(workingDirectory);
        if (null == closestSenchaWorkspaceDir) {
            throw new MojoExecutionException("could not find Sencha workspace above workingDirectory");
        }
        Path workspacePath = closestSenchaWorkspaceDir.toPath().normalize();
        Path workingDirectoryPath = workingDirectory.toPath().normalize();
        if (workspacePath.getRoot() == null || !workspacePath.getRoot().equals(workingDirectoryPath.getRoot())) {
            throw new MojoExecutionException("cannot find a relative path from workspace directory to working directory");
        }
        return workspacePath.relativize(workingDirectoryPath);
    }

    public static boolean isRequiredSenchaDependency(@Nonnull Dependency dependency, @Nonnull Dependency remotePackageDependency) {
        return !MavenDependencyHelper.equalsGroupIdAndArtifactId(dependency, remotePackageDependency) && "jar".equals(dependency.getType()) && !"provided".equals(dependency.getScope()) && !"test".equals(dependency.getScope());
    }

    public static String generateSenchaAppId(MavenProject project) {
        String appIdString = SenchaUtils.getSenchaPackageName(project) + SenchaUtils.getSenchaVersionForMavenVersion(project.getVersion());
        return UUID.nameUUIDFromBytes(appIdString.getBytes()).toString();
    }

    public static boolean doesSenchaAppExist(File directory) {
        File senchaCfg = new File(directory, SENCHA_APP_CONFIG);
        return senchaCfg.exists();
    }

    public static String getPackagesPath(MavenProject project) {
        return LOCAL_PACKAGES_PATH + SenchaUtils.getSenchaPackageName(project);
    }

    public static String getPackagesBuildPath(MavenProject project) {
        return SenchaUtils.getPackagesPath(project) + SEPARATOR + BUILD_PATH;
    }

    public static void generateSenchaWorkspace(File workingDirectory, String extDirectory, Log log, String logLevel) throws MojoExecutionException {
        Path senchaCfg = Paths.get(workingDirectory.getAbsolutePath(), SENCHA_WORKSPACE_CONFIG);
        try {
            Files.deleteIfExists(senchaCfg);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not delete existing sencha.cfg file in " + senchaCfg, (Exception)ioe);
        }
        log.info((CharSequence)"Generating Sencha workspace module");
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(workingDirectory, "generate workspace .", log, logLevel);
        senchaCmdExecutor.execute();
        SenchaUtils.updateSenchaCfgWithExtDirectory(senchaCfg, extDirectory);
    }

    public static void generateSenchaAppFromTemplate(File workingDirectory, String appName, String applicationClass, String toolkit, Log log, String logLevel) throws MojoExecutionException {
        String templateName = SenchaUtils.getSenchaPackageName(SENCHA_APP_TEMPLATE_GROUP_ID, SENCHA_APP_TEMPLATE_ARTIFACT_ID) + "/tpl";
        ImmutableMap properties = ImmutableMap.of((Object)"appName", (Object)appName, (Object)"applicationClass", (Object)applicationClass);
        SenchaUtils.generateSenchaAppFromTemplate(workingDirectory, appName, toolkit, templateName, (Map<String, String>)properties, log, logLevel);
    }

    public static void generateSenchaTestAppFromTemplate(File workingDirectory, MavenProject project, String appName, String testSuite, String toolkit, Log log, String logLevel) throws MojoExecutionException {
        String templateName = SenchaUtils.getSenchaPackageName(SENCHA_APP_TEMPLATE_GROUP_ID, SENCHA_TEST_APP_TEMPLATE_ARTIFACT_ID) + "/tpl";
        ImmutableMap properties = ImmutableMap.of((Object)"moduleName", (Object)SenchaUtils.getSenchaPackageName(project), (Object)"testSuite", (Object)testSuite);
        SenchaUtils.generateSenchaAppFromTemplate(workingDirectory, appName, toolkit, templateName, (Map<String, String>)properties, log, logLevel);
    }

    public static void generateSenchaAppFromTemplate(File workingDirectory, String appName, String toolkit, String templateName, Map<String, String> properties, Log log, String logLevel) throws MojoExecutionException {
        StringBuilder arguments = new StringBuilder("generate app").append(" -ext ").append(toolkit).append(" --template ").append(templateName).append(" --path=\"\"").append(" --refresh=false");
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                arguments.append(String.format(" -D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        arguments.append(" ").append(appName);
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(workingDirectory, arguments.toString(), log, logLevel);
        senchaCmdExecutor.execute();
    }

    public static void refreshApp(File dir, Log log, String logLevel) throws MojoExecutionException {
        SenchaCmdExecutor senchaCmdExecutor = new SenchaCmdExecutor(dir, "app refresh", log, logLevel);
        senchaCmdExecutor.execute();
    }

    private static void updateSenchaCfgWithExtDirectory(Path senchaCfg, String extDirectory) throws MojoExecutionException {
        SenchaUtils.createSenchaCfgWithExtDirectory(senchaCfg, senchaCfg, extDirectory);
    }

    public static void createSenchaCfgWithExtDirectory(Path senchaCfgSource, Path senchaCfgTarget, String extDirectory) throws MojoExecutionException {
        if (Files.exists(senchaCfgSource, new LinkOption[0])) {
            try {
                List<String> senchaCfgTmpContent = Files.readAllLines(senchaCfgSource, Charset.forName("UTF-8"));
                Files.write(senchaCfgTarget, SenchaUtils.getSenchaCfgContent(senchaCfgTmpContent, extDirectory), Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Modifying sencha.cfg file failed", (Exception)e);
            }
        } else {
            throw new MojoExecutionException("Could not find sencha.cfg file in " + senchaCfgSource);
        }
    }

    private static List<String> getSenchaCfgContent(@Nonnull List<String> currentContent, String extDirectory) {
        if (currentContent.get(0).startsWith("#")) {
            currentContent.remove(0);
        }
        ArrayList<String> newSenchaCfg = new ArrayList<String>(currentContent.size());
        newSenchaCfg.add("#");
        newSenchaCfg.add("# DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin and it will be overwritten by the next call of the plugin's goal \"generate-workspace\".");
        newSenchaCfg.add("#");
        newSenchaCfg.add("");
        newSenchaCfg.addAll(currentContent);
        newSenchaCfg.add("ext.dir=" + extDirectory);
        return newSenchaCfg;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

