/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.jangaroo.jooc.PackagerImpl;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaPackageOrAppMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaProfileConfiguration;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaPackageConfigBuilder;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.utils.CompilerUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

@Mojo(name="package-pkg", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class SenchaPackageMojo
extends AbstractSenchaPackageOrAppMojo<SenchaPackageConfigBuilder> {
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    @Inject
    private MavenProjectHelper helper;
    @Parameter(property="skipJangarooApp")
    private boolean skipJangarooApp;
    @Parameter(defaultValue="code")
    private String packageType;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private String buildDirectoryPath;
    private File senchaPackageDirectory;
    @Parameter
    private Map<String, String> globalResourcesMap;

    @Override
    public String getType() {
        if ("code".equals(this.packageType) || "theme".equals(this.packageType)) {
            return this.packageType;
        }
        this.getLog().error((CharSequence)String.format("%s is not a valid packaging packageType. Using \"code\" instead.", this.packageType));
        this.packageType = "code";
        return this.packageType;
    }

    @Override
    public String getJsonConfigFileName() {
        return "package.json";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"jangaroo-pkg".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-pkg\"");
        }
        this.getLog().info((CharSequence)"Execute sencha packaging mojo");
        FileHelper.ensureDirectory(new File(this.getSenchaPackageDirectory().getPath()));
        SenchaPackageConfigBuilder configBuilder = this.createSenchaConfigBuilder();
        this.configure(configBuilder);
        this.prepareModule(configBuilder);
        if (!this.skipJangarooApp) {
            File pkg = this.packageModule();
            this.helper.attachArtifact(this.project, "pkg", pkg);
        }
    }

    public void prepareModule(SenchaPackageConfigBuilder configBuilder) throws MojoExecutionException {
        this.writePackageConfig();
        this.writePackageJson(configBuilder);
        this.compileJavaScriptSources(this.getSenchaPackageDirectory());
        this.writeSenchaCfgFile();
    }

    private void writeSenchaCfgFile() throws MojoExecutionException {
        File senchaCfg = new File(this.getSenchaPackageDirectory().getPath(), ".sencha/package/sencha.cfg");
        this.getLog().info((CharSequence)"Write .sencha/package/sencha.cfg");
        try {
            Files.createParentDirs((File)senchaCfg);
            Files.touch((File)senchaCfg);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create " + senchaCfg.getAbsolutePath(), (Exception)e);
        }
    }

    private void compileJavaScriptSources(File dir) throws MojoExecutionException {
        try {
            new PackagerImpl().doPackage(new File(dir, "src"), new File(dir, "overrides"), new File(dir, "locale"), dir, SenchaUtils.getSenchaPackageName(this.project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("exception while packaging JavaScript sources", (Exception)e);
        }
    }

    private void writePackageJson(SenchaPackageConfigBuilder configBuilder) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Write package.json file");
        this.writeFile(configBuilder, this.getSenchaPackageDirectory().getPath(), "package.json", null);
    }

    @Nonnull
    public File packageModule() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Building Sencha module package");
        File pkg = new File(this.buildDirectoryPath + SenchaUtils.getPackagesBuildPath(this.project), SenchaUtils.getSenchaPackageName(this.project) + ".pkg");
        if (!this.getSenchaPackageDirectory().exists()) {
            throw new MojoExecutionException("Sencha package directory does not exist: " + this.getSenchaPackageDirectory().getPath());
        }
        this.zipArchiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)new File(this.buildDirectoryPath + SenchaUtils.getPackagesPath(this.project))));
        this.zipArchiver.setDestFile(pkg);
        try {
            this.zipArchiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create module package archive", e);
        }
        if (!pkg.exists()) {
            throw new MojoExecutionException("Could not find .pkg for Sencha package " + SenchaUtils.getSenchaPackageName(this.project));
        }
        return pkg;
    }

    protected void configure(SenchaPackageConfigBuilder configBuilder) throws MojoExecutionException {
        SenchaPackageMojo.configureDefaults(configBuilder, "default.package.json");
        super.configure(configBuilder);
        configBuilder.type("theme".equals(this.getType()) ? "theme" : "code");
        this.addRequiredClasses(configBuilder, null, this.getRequiredClasses());
        this.addRequiredClasses(configBuilder, "production", SenchaPackageMojo.getRequiredClassesFromConfiguration(this.getProduction()));
        this.addRequiredClasses(configBuilder, "testing", SenchaPackageMojo.getRequiredClassesFromConfiguration(this.getTesting()));
        this.addRequiredClasses(configBuilder, "development", SenchaPackageMojo.getRequiredClassesFromConfiguration(this.getDevelopment()));
    }

    @Nonnull
    private static List<String> getRequiredClassesFromConfiguration(@Nullable SenchaProfileConfiguration configuration) {
        return configuration == null ? Collections.emptyList() : configuration.getRequiredClasses();
    }

    protected void addRequiredClasses(@Nonnull SenchaPackageConfigBuilder configBuilder, @Nullable String profile, @Nonnull List<String> requiredClassesForProfile) throws MojoExecutionException {
        if (requiredClassesForProfile.isEmpty()) {
            return;
        }
        File requireResourceFile = new File(SenchaPackageMojo.getRequiredClassesFileName(profile, this.getSenchaPackageDirectory().getPath(), File.separator));
        if (requireResourceFile.exists()) {
            this.getLog().info((CharSequence)"requireResourceFile file for require editor plugins already exists, deleting...");
            if (!requireResourceFile.delete()) {
                throw new MojoExecutionException("Could not delete requireResourceFile file for require editor plugins");
            }
        }
        this.writeRequireResourceFile(requireResourceFile, requiredClassesForProfile);
        if (profile == null) {
            configBuilder.js(SenchaPackageMojo.getRequiredClassesFileName(null, null, "/"), false, true);
        } else {
            SenchaPackageConfigBuilder requiredCLassesConfigBuilder = new SenchaPackageConfigBuilder();
            requiredCLassesConfigBuilder.js(SenchaPackageMojo.getRequiredClassesFileName(profile, null, "/"), false, true);
            configBuilder.profile(profile, requiredCLassesConfigBuilder.build());
        }
    }

    @Nonnull
    private static String getRequiredClassesFileName(@Nullable String profile, String baseDir, String separator) {
        StringBuilder nameBuilder = new StringBuilder();
        if (baseDir != null) {
            nameBuilder.append(baseDir).append(separator);
        }
        nameBuilder.append("bundledResources").append(separator);
        if (profile != null) {
            nameBuilder.append(profile).append(separator);
        }
        nameBuilder.append("requiredClasses.js");
        return nameBuilder.toString();
    }

    private void writeRequireResourceFile(File requireResourceFile, List<String> requiredClasses) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Write %s for module", requireResourceFile.getPath()));
        FileHelper.ensureDirectory(requireResourceFile.getParentFile());
        try (PrintWriter pw = new PrintWriter(new FileWriter(requireResourceFile, true));){
            for (String requiredClass : requiredClasses) {
                pw.printf("Ext.require(%s);%n", CompilerUtils.quote((String)requiredClass));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write require resource file", (Exception)e);
        }
    }

    private void writePackageConfig() throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Write %s for module", "packageConfig.js"));
        String senchaPackageBuildOutputDirectoryPath = this.buildDirectoryPath + SenchaUtils.getPackagesPath(this.project);
        File packageConfigJsFile = new File(senchaPackageBuildOutputDirectoryPath + "/" + "bundledResources" + "/" + "packageConfig.js");
        FileHelper.ensureDirectory(packageConfigJsFile.getParentFile());
        if (packageConfigJsFile.exists()) {
            this.getLog().debug((CharSequence)"packageConfig.js for module already exists, deleting...");
            if (!packageConfigJsFile.delete()) {
                throw new MojoExecutionException("Could not delete packageConfig.js file for module");
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(packageConfigJsFile, true));){
            pw.println("(function(){");
            this.writePackageDependencyOrderJs(pw);
            this.writeGlobalResourceMapJs(pw);
            pw.println("}());");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create packageConfig.js resource", (Exception)e);
        }
    }

    private void writePackageDependencyOrderJs(PrintWriter pw) throws MojoExecutionException {
        pw.printf("// START - Registering package dependency order%nExt.manifest.packageDependencyOrder.push('%s');%n// END - Registering package dependency order%n", SenchaUtils.getSenchaPackageName(this.project));
    }

    private void writeGlobalResourceMapJs(PrintWriter pw) throws MojoExecutionException {
        if (this.globalResourcesMap != null && !this.globalResourcesMap.isEmpty()) {
            String senchaPackageName = SenchaUtils.getSenchaPackageName(this.project);
            this.getLog().info((CharSequence)"Write global resource map JavaScript for packageConfig.js");
            pw.printf("// START - Adding global resources to ext manifest%n", new Object[0]);
            pw.printf("function resolveAbsolutePath(packageName, resourcePath) {%n  var resolvedPath = Ext.resolveResource('<@' + packageName + '>' + resourcePath);%n  if (resolvedPath.indexOf('/') !== 0) {%n    var pathname = window.location.pathname;%n    resolvedPath = pathname.substring(0, pathname.lastIndexOf('/') + 1) + resolvedPath;%n  }%n  return resolvedPath;%n};%nExt.apply(Ext.manifest.globalResources, {%n", new Object[0]);
            Iterator<Map.Entry<String, String>> globalResourceIterator = this.globalResourcesMap.entrySet().iterator();
            while (globalResourceIterator.hasNext()) {
                Map.Entry<String, String> globalResource = globalResourceIterator.next();
                pw.printf("  '%s': resolveAbsolutePath('%s', '%s')", globalResource.getKey(), senchaPackageName, globalResource.getValue());
                if (!globalResourceIterator.hasNext()) continue;
                pw.printf(",%n", new Object[0]);
            }
            pw.printf("%n});%n", new Object[0]);
            pw.println("// END - Adding global resources to ext manifest");
        }
    }

    public File getSenchaPackageDirectory() {
        if (this.senchaPackageDirectory == null) {
            this.senchaPackageDirectory = new File(this.buildDirectoryPath + SenchaUtils.getPackagesPath(this.project));
        }
        return this.senchaPackageDirectory;
    }

    @Override
    protected SenchaPackageConfigBuilder createSenchaConfigBuilder() {
        return new SenchaPackageConfigBuilder();
    }
}

